; NOTE: Assertions have been autogenerated by utils/update_analyze_test_checks.py
; RUN: opt < %s -mtriple=x86_64-unknown-linux-gnu -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mattr=-popcnt,+sse2 | FileCheck %s -check-prefixes=SSE2,NOPOPCNT
; RUN: opt < %s -mtriple=x86_64-unknown-linux-gnu -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mattr=+popcnt,+sse2 | FileCheck %s -check-prefixes=SSE2,POPCNT
; RUN: opt < %s -mtriple=x86_64-unknown-linux-gnu -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mattr=+popcnt,+sse4.2 | FileCheck %s -check-prefixes=POPCNT,SSE42
; RUN: opt < %s -mtriple=x86_64-unknown-linux-gnu -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mattr=+popcnt,+avx | FileCheck %s -check-prefixes=POPCNT,AVX1
; RUN: opt < %s -mtriple=x86_64-unknown-linux-gnu -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mattr=+popcnt,+avx2 | FileCheck %s -check-prefixes=POPCNT,AVX2
; RUN: opt < %s -mtriple=x86_64-unknown-linux-gnu -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mattr=+popcnt,+avx512f | FileCheck %s -check-prefixes=POPCNT,AVX512F
; RUN: opt < %s -mtriple=x86_64-unknown-linux-gnu -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mattr=+popcnt,+avx512vl,+avx512bw,+avx512dq | FileCheck %s -check-prefixes=POPCNT,AVX512BW
; RUN: opt < %s -mtriple=x86_64-unknown-linux-gnu -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mattr=+popcnt,+avx512vl,+avx512vpopcntdq | FileCheck %s -check-prefixes=POPCNT,AVX512VPOPCNT
; RUN: opt < %s -mtriple=x86_64-unknown-linux-gnu -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mattr=+popcnt,+avx512vl,+avx512bitalg | FileCheck %s -check-prefixes=POPCNT,AVX512BITALG

; Verify the cost of scalar population count instructions.

declare i64 @llvm.ctpop.i64(i64)
declare i32 @llvm.ctpop.i32(i32)
declare i16 @llvm.ctpop.i16(i16)
declare  i8 @llvm.ctpop.i8(i8)

define i64 @var_ctpop_i64(i64 %a) {
; NOPOPCNT-LABEL: 'var_ctpop_i64'
; NOPOPCNT-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:19 Lat:6 SizeLat:19 for: %ctpop = call i64 @llvm.ctpop.i64(i64 %a)
; NOPOPCNT-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i64 %ctpop
;
; POPCNT-LABEL: 'var_ctpop_i64'
; POPCNT-NEXT:  Cost Model: Found costs of 1 for: %ctpop = call i64 @llvm.ctpop.i64(i64 %a)
; POPCNT-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i64 %ctpop
;
  %ctpop = call i64 @llvm.ctpop.i64(i64 %a)
  ret i64 %ctpop
}

define i32 @var_ctpop_i32(i32 %a) {
; NOPOPCNT-LABEL: 'var_ctpop_i32'
; NOPOPCNT-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:15 Lat:7 SizeLat:15 for: %ctpop = call i32 @llvm.ctpop.i32(i32 %a)
; NOPOPCNT-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 %ctpop
;
; POPCNT-LABEL: 'var_ctpop_i32'
; POPCNT-NEXT:  Cost Model: Found costs of 1 for: %ctpop = call i32 @llvm.ctpop.i32(i32 %a)
; POPCNT-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 %ctpop
;
  %ctpop = call i32 @llvm.ctpop.i32(i32 %a)
  ret i32 %ctpop
}

define i16 @var_ctpop_i16(i16 %a) {
; NOPOPCNT-LABEL: 'var_ctpop_i16'
; NOPOPCNT-NEXT:  Cost Model: Found costs of RThru:9 CodeSize:17 Lat:8 SizeLat:17 for: %ctpop = call i16 @llvm.ctpop.i16(i16 %a)
; NOPOPCNT-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i16 %ctpop
;
; POPCNT-LABEL: 'var_ctpop_i16'
; POPCNT-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:2 Lat:1 SizeLat:2 for: %ctpop = call i16 @llvm.ctpop.i16(i16 %a)
; POPCNT-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i16 %ctpop
;
  %ctpop = call i16 @llvm.ctpop.i16(i16 %a)
  ret i16 %ctpop
}

define i8 @var_ctpop_i8(i8 %a) {
; NOPOPCNT-LABEL: 'var_ctpop_i8'
; NOPOPCNT-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:6 Lat:6 SizeLat:6 for: %ctpop = call i8 @llvm.ctpop.i8(i8 %a)
; NOPOPCNT-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i8 %ctpop
;
; POPCNT-LABEL: 'var_ctpop_i8'
; POPCNT-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:2 Lat:1 SizeLat:2 for: %ctpop = call i8 @llvm.ctpop.i8(i8 %a)
; POPCNT-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i8 %ctpop
;
  %ctpop = call i8 @llvm.ctpop.i8(i8 %a)
  ret i8 %ctpop
}

; Verify the cost of vector population count instructions.

declare <2 x i64> @llvm.ctpop.v2i64(<2 x i64>)
declare <4 x i32> @llvm.ctpop.v4i32(<4 x i32>)
declare <8 x i16> @llvm.ctpop.v8i16(<8 x i16>)
declare <16 x i8> @llvm.ctpop.v16i8(<16 x i8>)

declare <4 x i64> @llvm.ctpop.v4i64(<4 x i64>)
declare <8 x i32> @llvm.ctpop.v8i32(<8 x i32>)
declare <16 x i16> @llvm.ctpop.v16i16(<16 x i16>)
declare <32 x i8> @llvm.ctpop.v32i8(<32 x i8>)

declare <8 x i64> @llvm.ctpop.v8i64(<8 x i64>)
declare <16 x i32> @llvm.ctpop.v16i32(<16 x i32>)
declare <32 x i16> @llvm.ctpop.v32i16(<32 x i16>)
declare <64 x i8> @llvm.ctpop.v64i8(<64 x i8>)

define <2 x i64> @var_ctpop_v2i64(<2 x i64> %a) {
; SSE2-LABEL: 'var_ctpop_v2i64'
; SSE2-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:16 Lat:26 SizeLat:18 for: %ctpop = call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %a)
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <2 x i64> %ctpop
;
; SSE42-LABEL: 'var_ctpop_v2i64'
; SSE42-NEXT:  Cost Model: Found costs of RThru:13 CodeSize:12 Lat:19 SizeLat:18 for: %ctpop = call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %a)
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <2 x i64> %ctpop
;
; AVX1-LABEL: 'var_ctpop_v2i64'
; AVX1-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:10 Lat:14 SizeLat:14 for: %ctpop = call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %a)
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <2 x i64> %ctpop
;
; AVX2-LABEL: 'var_ctpop_v2i64'
; AVX2-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:10 Lat:9 SizeLat:10 for: %ctpop = call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %a)
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <2 x i64> %ctpop
;
; AVX512F-LABEL: 'var_ctpop_v2i64'
; AVX512F-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:10 Lat:9 SizeLat:10 for: %ctpop = call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %a)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <2 x i64> %ctpop
;
; AVX512BW-LABEL: 'var_ctpop_v2i64'
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:10 Lat:7 SizeLat:10 for: %ctpop = call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %a)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <2 x i64> %ctpop
;
; AVX512VPOPCNT-LABEL: 'var_ctpop_v2i64'
; AVX512VPOPCNT-NEXT:  Cost Model: Found costs of 1 for: %ctpop = call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %a)
; AVX512VPOPCNT-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <2 x i64> %ctpop
;
; AVX512BITALG-LABEL: 'var_ctpop_v2i64'
; AVX512BITALG-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:10 Lat:7 SizeLat:10 for: %ctpop = call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %a)
; AVX512BITALG-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <2 x i64> %ctpop
;
  %ctpop = call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %a)
  ret <2 x i64> %ctpop
}

define <4 x i64> @var_ctpop_v4i64(<4 x i64> %a) {
; SSE2-LABEL: 'var_ctpop_v4i64'
; SSE2-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:32 Lat:52 SizeLat:36 for: %ctpop = call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %a)
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <4 x i64> %ctpop
;
; SSE42-LABEL: 'var_ctpop_v4i64'
; SSE42-NEXT:  Cost Model: Found costs of RThru:26 CodeSize:24 Lat:38 SizeLat:36 for: %ctpop = call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %a)
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <4 x i64> %ctpop
;
; AVX1-LABEL: 'var_ctpop_v4i64'
; AVX1-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:19 Lat:18 SizeLat:28 for: %ctpop = call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %a)
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <4 x i64> %ctpop
;
; AVX2-LABEL: 'var_ctpop_v4i64'
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:10 Lat:9 SizeLat:14 for: %ctpop = call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %a)
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <4 x i64> %ctpop
;
; AVX512F-LABEL: 'var_ctpop_v4i64'
; AVX512F-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:10 Lat:9 SizeLat:14 for: %ctpop = call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %a)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <4 x i64> %ctpop
;
; AVX512BW-LABEL: 'var_ctpop_v4i64'
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:10 Lat:7 SizeLat:10 for: %ctpop = call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %a)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <4 x i64> %ctpop
;
; AVX512VPOPCNT-LABEL: 'var_ctpop_v4i64'
; AVX512VPOPCNT-NEXT:  Cost Model: Found costs of 1 for: %ctpop = call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %a)
; AVX512VPOPCNT-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <4 x i64> %ctpop
;
; AVX512BITALG-LABEL: 'var_ctpop_v4i64'
; AVX512BITALG-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:10 Lat:7 SizeLat:10 for: %ctpop = call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %a)
; AVX512BITALG-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <4 x i64> %ctpop
;
  %ctpop = call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %a)
  ret <4 x i64> %ctpop
}

define <8 x i64> @var_ctpop_v8i64(<8 x i64> %a) {
; SSE2-LABEL: 'var_ctpop_v8i64'
; SSE2-NEXT:  Cost Model: Found costs of RThru:48 CodeSize:64 Lat:104 SizeLat:72 for: %ctpop = call <8 x i64> @llvm.ctpop.v8i64(<8 x i64> %a)
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <8 x i64> %ctpop
;
; SSE42-LABEL: 'var_ctpop_v8i64'
; SSE42-NEXT:  Cost Model: Found costs of RThru:52 CodeSize:48 Lat:76 SizeLat:72 for: %ctpop = call <8 x i64> @llvm.ctpop.v8i64(<8 x i64> %a)
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <8 x i64> %ctpop
;
; AVX1-LABEL: 'var_ctpop_v8i64'
; AVX1-NEXT:  Cost Model: Found costs of RThru:28 CodeSize:38 Lat:36 SizeLat:56 for: %ctpop = call <8 x i64> @llvm.ctpop.v8i64(<8 x i64> %a)
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <8 x i64> %ctpop
;
; AVX2-LABEL: 'var_ctpop_v8i64'
; AVX2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:20 Lat:18 SizeLat:28 for: %ctpop = call <8 x i64> @llvm.ctpop.v8i64(<8 x i64> %a)
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <8 x i64> %ctpop
;
; AVX512F-LABEL: 'var_ctpop_v8i64'
; AVX512F-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:19 Lat:16 SizeLat:19 for: %ctpop = call <8 x i64> @llvm.ctpop.v8i64(<8 x i64> %a)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <8 x i64> %ctpop
;
; AVX512BW-LABEL: 'var_ctpop_v8i64'
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:10 Lat:8 SizeLat:12 for: %ctpop = call <8 x i64> @llvm.ctpop.v8i64(<8 x i64> %a)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <8 x i64> %ctpop
;
; AVX512VPOPCNT-LABEL: 'var_ctpop_v8i64'
; AVX512VPOPCNT-NEXT:  Cost Model: Found costs of 1 for: %ctpop = call <8 x i64> @llvm.ctpop.v8i64(<8 x i64> %a)
; AVX512VPOPCNT-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <8 x i64> %ctpop
;
; AVX512BITALG-LABEL: 'var_ctpop_v8i64'
; AVX512BITALG-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:10 Lat:8 SizeLat:12 for: %ctpop = call <8 x i64> @llvm.ctpop.v8i64(<8 x i64> %a)
; AVX512BITALG-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <8 x i64> %ctpop
;
  %ctpop = call <8 x i64> @llvm.ctpop.v8i64(<8 x i64> %a)
  ret <8 x i64> %ctpop
}

define <4 x i32> @var_ctpop_v4i32(<4 x i32> %a) {
; SSE2-LABEL: 'var_ctpop_v4i32'
; SSE2-NEXT:  Cost Model: Found costs of RThru:15 CodeSize:21 Lat:29 SizeLat:23 for: %ctpop = call <4 x i32> @llvm.ctpop.v4i32(<4 x i32> %a)
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <4 x i32> %ctpop
;
; SSE42-LABEL: 'var_ctpop_v4i32'
; SSE42-NEXT:  Cost Model: Found costs of RThru:18 CodeSize:16 Lat:24 SizeLat:22 for: %ctpop = call <4 x i32> @llvm.ctpop.v4i32(<4 x i32> %a)
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <4 x i32> %ctpop
;
; AVX1-LABEL: 'var_ctpop_v4i32'
; AVX1-NEXT:  Cost Model: Found costs of RThru:9 CodeSize:14 Lat:20 SizeLat:18 for: %ctpop = call <4 x i32> @llvm.ctpop.v4i32(<4 x i32> %a)
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <4 x i32> %ctpop
;
; AVX2-LABEL: 'var_ctpop_v4i32'
; AVX2-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:14 Lat:12 SizeLat:14 for: %ctpop = call <4 x i32> @llvm.ctpop.v4i32(<4 x i32> %a)
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <4 x i32> %ctpop
;
; AVX512F-LABEL: 'var_ctpop_v4i32'
; AVX512F-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:14 Lat:12 SizeLat:14 for: %ctpop = call <4 x i32> @llvm.ctpop.v4i32(<4 x i32> %a)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <4 x i32> %ctpop
;
; AVX512BW-LABEL: 'var_ctpop_v4i32'
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:14 Lat:11 SizeLat:14 for: %ctpop = call <4 x i32> @llvm.ctpop.v4i32(<4 x i32> %a)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <4 x i32> %ctpop
;
; AVX512VPOPCNT-LABEL: 'var_ctpop_v4i32'
; AVX512VPOPCNT-NEXT:  Cost Model: Found costs of 1 for: %ctpop = call <4 x i32> @llvm.ctpop.v4i32(<4 x i32> %a)
; AVX512VPOPCNT-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <4 x i32> %ctpop
;
; AVX512BITALG-LABEL: 'var_ctpop_v4i32'
; AVX512BITALG-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:14 Lat:11 SizeLat:14 for: %ctpop = call <4 x i32> @llvm.ctpop.v4i32(<4 x i32> %a)
; AVX512BITALG-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <4 x i32> %ctpop
;
  %ctpop = call <4 x i32> @llvm.ctpop.v4i32(<4 x i32> %a)
  ret <4 x i32> %ctpop
}

define <8 x i32> @var_ctpop_v8i32(<8 x i32> %a) {
; SSE2-LABEL: 'var_ctpop_v8i32'
; SSE2-NEXT:  Cost Model: Found costs of RThru:30 CodeSize:42 Lat:58 SizeLat:46 for: %ctpop = call <8 x i32> @llvm.ctpop.v8i32(<8 x i32> %a)
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <8 x i32> %ctpop
;
; SSE42-LABEL: 'var_ctpop_v8i32'
; SSE42-NEXT:  Cost Model: Found costs of RThru:36 CodeSize:32 Lat:48 SizeLat:44 for: %ctpop = call <8 x i32> @llvm.ctpop.v8i32(<8 x i32> %a)
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <8 x i32> %ctpop
;
; AVX1-LABEL: 'var_ctpop_v8i32'
; AVX1-NEXT:  Cost Model: Found costs of RThru:18 CodeSize:27 Lat:24 SizeLat:36 for: %ctpop = call <8 x i32> @llvm.ctpop.v8i32(<8 x i32> %a)
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <8 x i32> %ctpop
;
; AVX2-LABEL: 'var_ctpop_v8i32'
; AVX2-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:14 Lat:12 SizeLat:18 for: %ctpop = call <8 x i32> @llvm.ctpop.v8i32(<8 x i32> %a)
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <8 x i32> %ctpop
;
; AVX512F-LABEL: 'var_ctpop_v8i32'
; AVX512F-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:14 Lat:12 SizeLat:18 for: %ctpop = call <8 x i32> @llvm.ctpop.v8i32(<8 x i32> %a)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <8 x i32> %ctpop
;
; AVX512BW-LABEL: 'var_ctpop_v8i32'
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:14 Lat:11 SizeLat:14 for: %ctpop = call <8 x i32> @llvm.ctpop.v8i32(<8 x i32> %a)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <8 x i32> %ctpop
;
; AVX512VPOPCNT-LABEL: 'var_ctpop_v8i32'
; AVX512VPOPCNT-NEXT:  Cost Model: Found costs of 1 for: %ctpop = call <8 x i32> @llvm.ctpop.v8i32(<8 x i32> %a)
; AVX512VPOPCNT-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <8 x i32> %ctpop
;
; AVX512BITALG-LABEL: 'var_ctpop_v8i32'
; AVX512BITALG-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:14 Lat:11 SizeLat:14 for: %ctpop = call <8 x i32> @llvm.ctpop.v8i32(<8 x i32> %a)
; AVX512BITALG-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <8 x i32> %ctpop
;
  %ctpop = call <8 x i32> @llvm.ctpop.v8i32(<8 x i32> %a)
  ret <8 x i32> %ctpop
}

define <16 x i32> @var_ctpop_v16i32(<16 x i32> %a) {
; SSE2-LABEL: 'var_ctpop_v16i32'
; SSE2-NEXT:  Cost Model: Found costs of RThru:60 CodeSize:84 Lat:116 SizeLat:92 for: %ctpop = call <16 x i32> @llvm.ctpop.v16i32(<16 x i32> %a)
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <16 x i32> %ctpop
;
; SSE42-LABEL: 'var_ctpop_v16i32'
; SSE42-NEXT:  Cost Model: Found costs of RThru:72 CodeSize:64 Lat:96 SizeLat:88 for: %ctpop = call <16 x i32> @llvm.ctpop.v16i32(<16 x i32> %a)
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <16 x i32> %ctpop
;
; AVX1-LABEL: 'var_ctpop_v16i32'
; AVX1-NEXT:  Cost Model: Found costs of RThru:36 CodeSize:54 Lat:48 SizeLat:72 for: %ctpop = call <16 x i32> @llvm.ctpop.v16i32(<16 x i32> %a)
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <16 x i32> %ctpop
;
; AVX2-LABEL: 'var_ctpop_v16i32'
; AVX2-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:28 Lat:24 SizeLat:36 for: %ctpop = call <16 x i32> @llvm.ctpop.v16i32(<16 x i32> %a)
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <16 x i32> %ctpop
;
; AVX512F-LABEL: 'var_ctpop_v16i32'
; AVX512F-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:27 Lat:19 SizeLat:27 for: %ctpop = call <16 x i32> @llvm.ctpop.v16i32(<16 x i32> %a)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <16 x i32> %ctpop
;
; AVX512BW-LABEL: 'var_ctpop_v16i32'
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:14 Lat:12 SizeLat:16 for: %ctpop = call <16 x i32> @llvm.ctpop.v16i32(<16 x i32> %a)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <16 x i32> %ctpop
;
; AVX512VPOPCNT-LABEL: 'var_ctpop_v16i32'
; AVX512VPOPCNT-NEXT:  Cost Model: Found costs of 1 for: %ctpop = call <16 x i32> @llvm.ctpop.v16i32(<16 x i32> %a)
; AVX512VPOPCNT-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <16 x i32> %ctpop
;
; AVX512BITALG-LABEL: 'var_ctpop_v16i32'
; AVX512BITALG-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:14 Lat:12 SizeLat:16 for: %ctpop = call <16 x i32> @llvm.ctpop.v16i32(<16 x i32> %a)
; AVX512BITALG-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <16 x i32> %ctpop
;
  %ctpop = call <16 x i32> @llvm.ctpop.v16i32(<16 x i32> %a)
  ret <16 x i32> %ctpop
}

define <8 x i16> @var_ctpop_v8i16(<8 x i16> %a) {
; SSE2-LABEL: 'var_ctpop_v8i16'
; SSE2-NEXT:  Cost Model: Found costs of RThru:13 CodeSize:18 Lat:25 SizeLat:20 for: %ctpop = call <8 x i16> @llvm.ctpop.v8i16(<8 x i16> %a)
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <8 x i16> %ctpop
;
; SSE42-LABEL: 'var_ctpop_v8i16'
; SSE42-NEXT:  Cost Model: Found costs of RThru:13 CodeSize:14 Lat:18 SizeLat:20 for: %ctpop = call <8 x i16> @llvm.ctpop.v8i16(<8 x i16> %a)
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <8 x i16> %ctpop
;
; AVX1-LABEL: 'var_ctpop_v8i16'
; AVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:11 Lat:18 SizeLat:15 for: %ctpop = call <8 x i16> @llvm.ctpop.v8i16(<8 x i16> %a)
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <8 x i16> %ctpop
;
; AVX2-LABEL: 'var_ctpop_v8i16'
; AVX2-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:11 Lat:7 SizeLat:11 for: %ctpop = call <8 x i16> @llvm.ctpop.v8i16(<8 x i16> %a)
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <8 x i16> %ctpop
;
; AVX512F-LABEL: 'var_ctpop_v8i16'
; AVX512F-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:11 Lat:7 SizeLat:11 for: %ctpop = call <8 x i16> @llvm.ctpop.v8i16(<8 x i16> %a)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <8 x i16> %ctpop
;
; AVX512BW-LABEL: 'var_ctpop_v8i16'
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:11 Lat:7 SizeLat:11 for: %ctpop = call <8 x i16> @llvm.ctpop.v8i16(<8 x i16> %a)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <8 x i16> %ctpop
;
; AVX512VPOPCNT-LABEL: 'var_ctpop_v8i16'
; AVX512VPOPCNT-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:11 Lat:7 SizeLat:11 for: %ctpop = call <8 x i16> @llvm.ctpop.v8i16(<8 x i16> %a)
; AVX512VPOPCNT-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <8 x i16> %ctpop
;
; AVX512BITALG-LABEL: 'var_ctpop_v8i16'
; AVX512BITALG-NEXT:  Cost Model: Found costs of 1 for: %ctpop = call <8 x i16> @llvm.ctpop.v8i16(<8 x i16> %a)
; AVX512BITALG-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <8 x i16> %ctpop
;
  %ctpop = call <8 x i16> @llvm.ctpop.v8i16(<8 x i16> %a)
  ret <8 x i16> %ctpop
}

define <16 x i16> @var_ctpop_v16i16(<16 x i16> %a) {
; SSE2-LABEL: 'var_ctpop_v16i16'
; SSE2-NEXT:  Cost Model: Found costs of RThru:26 CodeSize:36 Lat:50 SizeLat:40 for: %ctpop = call <16 x i16> @llvm.ctpop.v16i16(<16 x i16> %a)
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <16 x i16> %ctpop
;
; SSE42-LABEL: 'var_ctpop_v16i16'
; SSE42-NEXT:  Cost Model: Found costs of RThru:26 CodeSize:28 Lat:36 SizeLat:40 for: %ctpop = call <16 x i16> @llvm.ctpop.v16i16(<16 x i16> %a)
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <16 x i16> %ctpop
;
; AVX1-LABEL: 'var_ctpop_v16i16'
; AVX1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:22 Lat:21 SizeLat:31 for: %ctpop = call <16 x i16> @llvm.ctpop.v16i16(<16 x i16> %a)
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <16 x i16> %ctpop
;
; AVX2-LABEL: 'var_ctpop_v16i16'
; AVX2-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:11 Lat:8 SizeLat:18 for: %ctpop = call <16 x i16> @llvm.ctpop.v16i16(<16 x i16> %a)
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <16 x i16> %ctpop
;
; AVX512F-LABEL: 'var_ctpop_v16i16'
; AVX512F-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:11 Lat:8 SizeLat:18 for: %ctpop = call <16 x i16> @llvm.ctpop.v16i16(<16 x i16> %a)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <16 x i16> %ctpop
;
; AVX512BW-LABEL: 'var_ctpop_v16i16'
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:11 Lat:7 SizeLat:11 for: %ctpop = call <16 x i16> @llvm.ctpop.v16i16(<16 x i16> %a)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <16 x i16> %ctpop
;
; AVX512VPOPCNT-LABEL: 'var_ctpop_v16i16'
; AVX512VPOPCNT-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:11 Lat:8 SizeLat:18 for: %ctpop = call <16 x i16> @llvm.ctpop.v16i16(<16 x i16> %a)
; AVX512VPOPCNT-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <16 x i16> %ctpop
;
; AVX512BITALG-LABEL: 'var_ctpop_v16i16'
; AVX512BITALG-NEXT:  Cost Model: Found costs of 1 for: %ctpop = call <16 x i16> @llvm.ctpop.v16i16(<16 x i16> %a)
; AVX512BITALG-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <16 x i16> %ctpop
;
  %ctpop = call <16 x i16> @llvm.ctpop.v16i16(<16 x i16> %a)
  ret <16 x i16> %ctpop
}

define <32 x i16> @var_ctpop_v32i16(<32 x i16> %a) {
; SSE2-LABEL: 'var_ctpop_v32i16'
; SSE2-NEXT:  Cost Model: Found costs of RThru:52 CodeSize:72 Lat:100 SizeLat:80 for: %ctpop = call <32 x i16> @llvm.ctpop.v32i16(<32 x i16> %a)
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <32 x i16> %ctpop
;
; SSE42-LABEL: 'var_ctpop_v32i16'
; SSE42-NEXT:  Cost Model: Found costs of RThru:52 CodeSize:56 Lat:72 SizeLat:80 for: %ctpop = call <32 x i16> @llvm.ctpop.v32i16(<32 x i16> %a)
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <32 x i16> %ctpop
;
; AVX1-LABEL: 'var_ctpop_v32i16'
; AVX1-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:44 Lat:42 SizeLat:62 for: %ctpop = call <32 x i16> @llvm.ctpop.v32i16(<32 x i16> %a)
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <32 x i16> %ctpop
;
; AVX2-LABEL: 'var_ctpop_v32i16'
; AVX2-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:22 Lat:16 SizeLat:36 for: %ctpop = call <32 x i16> @llvm.ctpop.v32i16(<32 x i16> %a)
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <32 x i16> %ctpop
;
; AVX512F-LABEL: 'var_ctpop_v32i16'
; AVX512F-NEXT:  Cost Model: Found costs of RThru:18 CodeSize:22 Lat:15 SizeLat:22 for: %ctpop = call <32 x i16> @llvm.ctpop.v32i16(<32 x i16> %a)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <32 x i16> %ctpop
;
; AVX512BW-LABEL: 'var_ctpop_v32i16'
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:11 Lat:7 SizeLat:13 for: %ctpop = call <32 x i16> @llvm.ctpop.v32i16(<32 x i16> %a)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <32 x i16> %ctpop
;
; AVX512VPOPCNT-LABEL: 'var_ctpop_v32i16'
; AVX512VPOPCNT-NEXT:  Cost Model: Found costs of RThru:18 CodeSize:22 Lat:15 SizeLat:22 for: %ctpop = call <32 x i16> @llvm.ctpop.v32i16(<32 x i16> %a)
; AVX512VPOPCNT-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <32 x i16> %ctpop
;
; AVX512BITALG-LABEL: 'var_ctpop_v32i16'
; AVX512BITALG-NEXT:  Cost Model: Found costs of 1 for: %ctpop = call <32 x i16> @llvm.ctpop.v32i16(<32 x i16> %a)
; AVX512BITALG-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <32 x i16> %ctpop
;
  %ctpop = call <32 x i16> @llvm.ctpop.v32i16(<32 x i16> %a)
  ret <32 x i16> %ctpop
}

define <16 x i8> @var_ctpop_v16i8(<16 x i8> %a) {
; SSE2-LABEL: 'var_ctpop_v16i8'
; SSE2-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:14 Lat:21 SizeLat:16 for: %ctpop = call <16 x i8> @llvm.ctpop.v16i8(<16 x i8> %a)
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <16 x i8> %ctpop
;
; SSE42-LABEL: 'var_ctpop_v16i8'
; SSE42-NEXT:  Cost Model: Found costs of RThru:11 CodeSize:10 Lat:12 SizeLat:16 for: %ctpop = call <16 x i8> @llvm.ctpop.v16i8(<16 x i8> %a)
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <16 x i8> %ctpop
;
; AVX1-LABEL: 'var_ctpop_v16i8'
; AVX1-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:8 Lat:12 SizeLat:12 for: %ctpop = call <16 x i8> @llvm.ctpop.v16i8(<16 x i8> %a)
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <16 x i8> %ctpop
;
; AVX2-LABEL: 'var_ctpop_v16i8'
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:8 Lat:5 SizeLat:8 for: %ctpop = call <16 x i8> @llvm.ctpop.v16i8(<16 x i8> %a)
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <16 x i8> %ctpop
;
; AVX512F-LABEL: 'var_ctpop_v16i8'
; AVX512F-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:8 Lat:5 SizeLat:8 for: %ctpop = call <16 x i8> @llvm.ctpop.v16i8(<16 x i8> %a)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <16 x i8> %ctpop
;
; AVX512BW-LABEL: 'var_ctpop_v16i8'
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:8 Lat:4 SizeLat:8 for: %ctpop = call <16 x i8> @llvm.ctpop.v16i8(<16 x i8> %a)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <16 x i8> %ctpop
;
; AVX512VPOPCNT-LABEL: 'var_ctpop_v16i8'
; AVX512VPOPCNT-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:8 Lat:5 SizeLat:8 for: %ctpop = call <16 x i8> @llvm.ctpop.v16i8(<16 x i8> %a)
; AVX512VPOPCNT-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <16 x i8> %ctpop
;
; AVX512BITALG-LABEL: 'var_ctpop_v16i8'
; AVX512BITALG-NEXT:  Cost Model: Found costs of 1 for: %ctpop = call <16 x i8> @llvm.ctpop.v16i8(<16 x i8> %a)
; AVX512BITALG-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <16 x i8> %ctpop
;
  %ctpop = call <16 x i8> @llvm.ctpop.v16i8(<16 x i8> %a)
  ret <16 x i8> %ctpop
}

define <32 x i8> @var_ctpop_v32i8(<32 x i8> %a) {
; SSE2-LABEL: 'var_ctpop_v32i8'
; SSE2-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:28 Lat:42 SizeLat:32 for: %ctpop = call <32 x i8> @llvm.ctpop.v32i8(<32 x i8> %a)
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <32 x i8> %ctpop
;
; SSE42-LABEL: 'var_ctpop_v32i8'
; SSE42-NEXT:  Cost Model: Found costs of RThru:22 CodeSize:20 Lat:24 SizeLat:32 for: %ctpop = call <32 x i8> @llvm.ctpop.v32i8(<32 x i8> %a)
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <32 x i8> %ctpop
;
; AVX1-LABEL: 'var_ctpop_v32i8'
; AVX1-NEXT:  Cost Model: Found costs of RThru:13 CodeSize:16 Lat:15 SizeLat:25 for: %ctpop = call <32 x i8> @llvm.ctpop.v32i8(<32 x i8> %a)
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <32 x i8> %ctpop
;
; AVX2-LABEL: 'var_ctpop_v32i8'
; AVX2-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:8 Lat:5 SizeLat:12 for: %ctpop = call <32 x i8> @llvm.ctpop.v32i8(<32 x i8> %a)
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <32 x i8> %ctpop
;
; AVX512F-LABEL: 'var_ctpop_v32i8'
; AVX512F-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:8 Lat:5 SizeLat:12 for: %ctpop = call <32 x i8> @llvm.ctpop.v32i8(<32 x i8> %a)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <32 x i8> %ctpop
;
; AVX512BW-LABEL: 'var_ctpop_v32i8'
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:8 Lat:4 SizeLat:8 for: %ctpop = call <32 x i8> @llvm.ctpop.v32i8(<32 x i8> %a)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <32 x i8> %ctpop
;
; AVX512VPOPCNT-LABEL: 'var_ctpop_v32i8'
; AVX512VPOPCNT-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:8 Lat:5 SizeLat:12 for: %ctpop = call <32 x i8> @llvm.ctpop.v32i8(<32 x i8> %a)
; AVX512VPOPCNT-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <32 x i8> %ctpop
;
; AVX512BITALG-LABEL: 'var_ctpop_v32i8'
; AVX512BITALG-NEXT:  Cost Model: Found costs of 1 for: %ctpop = call <32 x i8> @llvm.ctpop.v32i8(<32 x i8> %a)
; AVX512BITALG-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <32 x i8> %ctpop
;
  %ctpop = call <32 x i8> @llvm.ctpop.v32i8(<32 x i8> %a)
  ret <32 x i8> %ctpop
}

define <64 x i8> @var_ctpop_v64i8(<64 x i8> %a) {
; SSE2-LABEL: 'var_ctpop_v64i8'
; SSE2-NEXT:  Cost Model: Found costs of RThru:40 CodeSize:56 Lat:84 SizeLat:64 for: %ctpop = call <64 x i8> @llvm.ctpop.v64i8(<64 x i8> %a)
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <64 x i8> %ctpop
;
; SSE42-LABEL: 'var_ctpop_v64i8'
; SSE42-NEXT:  Cost Model: Found costs of RThru:44 CodeSize:40 Lat:48 SizeLat:64 for: %ctpop = call <64 x i8> @llvm.ctpop.v64i8(<64 x i8> %a)
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <64 x i8> %ctpop
;
; AVX1-LABEL: 'var_ctpop_v64i8'
; AVX1-NEXT:  Cost Model: Found costs of RThru:26 CodeSize:32 Lat:30 SizeLat:50 for: %ctpop = call <64 x i8> @llvm.ctpop.v64i8(<64 x i8> %a)
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <64 x i8> %ctpop
;
; AVX2-LABEL: 'var_ctpop_v64i8'
; AVX2-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:16 Lat:10 SizeLat:24 for: %ctpop = call <64 x i8> @llvm.ctpop.v64i8(<64 x i8> %a)
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <64 x i8> %ctpop
;
; AVX512F-LABEL: 'var_ctpop_v64i8'
; AVX512F-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:16 Lat:11 SizeLat:16 for: %ctpop = call <64 x i8> @llvm.ctpop.v64i8(<64 x i8> %a)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <64 x i8> %ctpop
;
; AVX512BW-LABEL: 'var_ctpop_v64i8'
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:8 Lat:5 SizeLat:10 for: %ctpop = call <64 x i8> @llvm.ctpop.v64i8(<64 x i8> %a)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <64 x i8> %ctpop
;
; AVX512VPOPCNT-LABEL: 'var_ctpop_v64i8'
; AVX512VPOPCNT-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:16 Lat:11 SizeLat:16 for: %ctpop = call <64 x i8> @llvm.ctpop.v64i8(<64 x i8> %a)
; AVX512VPOPCNT-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <64 x i8> %ctpop
;
; AVX512BITALG-LABEL: 'var_ctpop_v64i8'
; AVX512BITALG-NEXT:  Cost Model: Found costs of 1 for: %ctpop = call <64 x i8> @llvm.ctpop.v64i8(<64 x i8> %a)
; AVX512BITALG-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <64 x i8> %ctpop
;
  %ctpop = call <64 x i8> @llvm.ctpop.v64i8(<64 x i8> %a)
  ret <64 x i8> %ctpop
}
