/* rom-kana.c generated by valac 0.38.8, the Vala compiler
 * generated from rom-kana.vala, do not modify */

/* -*- coding: utf-8 -*-*/
/*
 * Copyright (C) 2011-2014 Daiki Ueno <ueno@gnu.org>
 * Copyright (C) 2011-2014 Red Hat, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>


#define KKC_TYPE_ROM_KANA_ENTRY (kkc_rom_kana_entry_get_type ())
typedef struct _KkcRomKanaEntry KkcRomKanaEntry;
#define _g_free0(var) (var = (g_free (var), NULL))

#define KKC_TYPE_KANA_MODE (kkc_kana_mode_get_type ())

#define KKC_TYPE_ROM_KANA_NODE (kkc_rom_kana_node_get_type ())
#define KKC_ROM_KANA_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_ROM_KANA_NODE, KkcRomKanaNode))
#define KKC_ROM_KANA_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_ROM_KANA_NODE, KkcRomKanaNodeClass))
#define KKC_IS_ROM_KANA_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_ROM_KANA_NODE))
#define KKC_IS_ROM_KANA_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_ROM_KANA_NODE))
#define KKC_ROM_KANA_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_ROM_KANA_NODE, KkcRomKanaNodeClass))

typedef struct _KkcRomKanaNode KkcRomKanaNode;
typedef struct _KkcRomKanaNodeClass KkcRomKanaNodeClass;
typedef struct _KkcRomKanaNodePrivate KkcRomKanaNodePrivate;
enum  {
	KKC_ROM_KANA_NODE_0_PROPERTY,
	KKC_ROM_KANA_NODE_NUM_PROPERTIES
};
static GParamSpec* kkc_rom_kana_node_properties[KKC_ROM_KANA_NODE_NUM_PROPERTIES];
#define _kkc_rom_kana_entry_free0(var) ((var == NULL) ? NULL : (var = (kkc_rom_kana_entry_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define KKC_TYPE_PUNCTUATION_STYLE (kkc_punctuation_style_get_type ())

#define KKC_TYPE_ROM_KANA_CHARACTER (kkc_rom_kana_character_get_type ())
typedef struct _KkcRomKanaCharacter KkcRomKanaCharacter;

#define KKC_TYPE_ROM_KANA_CHARACTER_LIST (kkc_rom_kana_character_list_get_type ())
#define KKC_ROM_KANA_CHARACTER_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_ROM_KANA_CHARACTER_LIST, KkcRomKanaCharacterList))
#define KKC_ROM_KANA_CHARACTER_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_ROM_KANA_CHARACTER_LIST, KkcRomKanaCharacterListClass))
#define KKC_IS_ROM_KANA_CHARACTER_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_ROM_KANA_CHARACTER_LIST))
#define KKC_IS_ROM_KANA_CHARACTER_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_ROM_KANA_CHARACTER_LIST))
#define KKC_ROM_KANA_CHARACTER_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_ROM_KANA_CHARACTER_LIST, KkcRomKanaCharacterListClass))

typedef struct _KkcRomKanaCharacterList KkcRomKanaCharacterList;
typedef struct _KkcRomKanaCharacterListClass KkcRomKanaCharacterListClass;
typedef struct _KkcRomKanaCharacterListPrivate KkcRomKanaCharacterListPrivate;
enum  {
	KKC_ROM_KANA_CHARACTER_LIST_0_PROPERTY,
	KKC_ROM_KANA_CHARACTER_LIST_SIZE_PROPERTY,
	KKC_ROM_KANA_CHARACTER_LIST_NUM_PROPERTIES
};
static GParamSpec* kkc_rom_kana_character_list_properties[KKC_ROM_KANA_CHARACTER_LIST_NUM_PROPERTIES];
#define _kkc_rom_kana_character_free0(var) ((var == NULL) ? NULL : (var = (kkc_rom_kana_character_free (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

#define KKC_TYPE_ROM_KANA_CONVERTER (kkc_rom_kana_converter_get_type ())
#define KKC_ROM_KANA_CONVERTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_ROM_KANA_CONVERTER, KkcRomKanaConverter))
#define KKC_ROM_KANA_CONVERTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_ROM_KANA_CONVERTER, KkcRomKanaConverterClass))
#define KKC_IS_ROM_KANA_CONVERTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_ROM_KANA_CONVERTER))
#define KKC_IS_ROM_KANA_CONVERTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_ROM_KANA_CONVERTER))
#define KKC_ROM_KANA_CONVERTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_ROM_KANA_CONVERTER, KkcRomKanaConverterClass))

typedef struct _KkcRomKanaConverter KkcRomKanaConverter;
typedef struct _KkcRomKanaConverterClass KkcRomKanaConverterClass;
typedef struct _KkcRomKanaConverterPrivate KkcRomKanaConverterPrivate;

#define KKC_TYPE_MAP_FILE (kkc_map_file_get_type ())
#define KKC_MAP_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_MAP_FILE, KkcMapFile))
#define KKC_MAP_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_MAP_FILE, KkcMapFileClass))
#define KKC_IS_MAP_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_MAP_FILE))
#define KKC_IS_MAP_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_MAP_FILE))
#define KKC_MAP_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_MAP_FILE, KkcMapFileClass))

typedef struct _KkcMapFile KkcMapFile;
typedef struct _KkcMapFileClass KkcMapFileClass;

#define KKC_TYPE_ROM_KANA_MAP_FILE (kkc_rom_kana_map_file_get_type ())
#define KKC_ROM_KANA_MAP_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_ROM_KANA_MAP_FILE, KkcRomKanaMapFile))
#define KKC_ROM_KANA_MAP_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_ROM_KANA_MAP_FILE, KkcRomKanaMapFileClass))
#define KKC_IS_ROM_KANA_MAP_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_ROM_KANA_MAP_FILE))
#define KKC_IS_ROM_KANA_MAP_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_ROM_KANA_MAP_FILE))
#define KKC_ROM_KANA_MAP_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_ROM_KANA_MAP_FILE, KkcRomKanaMapFileClass))

typedef struct _KkcRomKanaMapFile KkcRomKanaMapFile;
typedef struct _KkcRomKanaMapFileClass KkcRomKanaMapFileClass;
enum  {
	KKC_ROM_KANA_CONVERTER_0_PROPERTY,
	KKC_ROM_KANA_CONVERTER_RULE_PROPERTY,
	KKC_ROM_KANA_CONVERTER_KANA_MODE_PROPERTY,
	KKC_ROM_KANA_CONVERTER_PUNCTUATION_STYLE_PROPERTY,
	KKC_ROM_KANA_CONVERTER_AUTO_CORRECT_PROPERTY,
	KKC_ROM_KANA_CONVERTER_PENDING_OUTPUT_PROPERTY,
	KKC_ROM_KANA_CONVERTER_PENDING_INPUT_PROPERTY,
	KKC_ROM_KANA_CONVERTER_PRODUCED_PROPERTY,
	KKC_ROM_KANA_CONVERTER_NUM_PROPERTIES
};
static GParamSpec* kkc_rom_kana_converter_properties[KKC_ROM_KANA_CONVERTER_NUM_PROPERTIES];

#define KKC_TYPE_METADATA_FILE (kkc_metadata_file_get_type ())
#define KKC_METADATA_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_METADATA_FILE, KkcMetadataFile))
#define KKC_METADATA_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_METADATA_FILE, KkcMetadataFileClass))
#define KKC_IS_METADATA_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_METADATA_FILE))
#define KKC_IS_METADATA_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_METADATA_FILE))
#define KKC_METADATA_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_METADATA_FILE, KkcMetadataFileClass))

typedef struct _KkcMetadataFile KkcMetadataFile;
typedef struct _KkcMetadataFileClass KkcMetadataFileClass;

#define KKC_TYPE_RULE_METADATA (kkc_rule_metadata_get_type ())
#define KKC_RULE_METADATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_RULE_METADATA, KkcRuleMetadata))
#define KKC_RULE_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_RULE_METADATA, KkcRuleMetadataClass))
#define KKC_IS_RULE_METADATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_RULE_METADATA))
#define KKC_IS_RULE_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_RULE_METADATA))
#define KKC_RULE_METADATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_RULE_METADATA, KkcRuleMetadataClass))

typedef struct _KkcRuleMetadata KkcRuleMetadata;
typedef struct _KkcRuleMetadataClass KkcRuleMetadataClass;
typedef struct _KkcMapFilePrivate KkcMapFilePrivate;
typedef struct _KkcRomKanaMapFilePrivate KkcRomKanaMapFilePrivate;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _KkcRomKanaEntry {
	gchar* rom;
	gchar* carryover;
	gchar* hiragana;
	gchar* katakana;
	gchar* hiragana_partial;
	gchar* katakana_partial;
};

typedef enum  {
	KKC_KANA_MODE_HIRAGANA,
	KKC_KANA_MODE_KATAKANA,
	KKC_KANA_MODE_HANKAKU_KATAKANA,
	KKC_KANA_MODE_LATIN,
	KKC_KANA_MODE_WIDE_LATIN
} KkcKanaMode;

struct _KkcRomKanaNode {
	GObject parent_instance;
	KkcRomKanaNodePrivate * priv;
	KkcRomKanaEntry* entry;
	KkcRomKanaNode* parent;
	KkcRomKanaNode* children[256];
	gchar c;
	guint n_children;
	guint8 valid[32];
};

struct _KkcRomKanaNodeClass {
	GObjectClass parent_class;
};

typedef enum  {
	KKC_PUNCTUATION_STYLE_JA_JA,
	KKC_PUNCTUATION_STYLE_EN_EN,
	KKC_PUNCTUATION_STYLE_JA_EN,
	KKC_PUNCTUATION_STYLE_EN_JA
} KkcPunctuationStyle;

struct _KkcRomKanaCharacter {
	gchar* output;
	gchar* input;
};

struct _KkcRomKanaCharacterList {
	GObject parent_instance;
	KkcRomKanaCharacterListPrivate * priv;
};

struct _KkcRomKanaCharacterListClass {
	GObjectClass parent_class;
};

struct _KkcRomKanaCharacterListPrivate {
	GeeList* _characters;
};

struct _KkcRomKanaConverter {
	GObject parent_instance;
	KkcRomKanaConverterPrivate * priv;
};

struct _KkcRomKanaConverterClass {
	GObjectClass parent_class;
};

struct _KkcRomKanaConverterPrivate {
	KkcRomKanaMapFile* _rule;
	KkcRomKanaNode* current_node;
	KkcKanaMode _kana_mode;
	KkcPunctuationStyle _punctuation_style;
	gboolean _auto_correct;
	GString* _pending_output;
	GString* _pending_input;
	KkcRomKanaCharacterList* _produced;
};

typedef enum  {
	KKC_RULE_PARSE_ERROR_FAILED
} KkcRuleParseError;
#define KKC_RULE_PARSE_ERROR kkc_rule_parse_error_quark ()
struct _KkcMapFile {
	GObject parent_instance;
	KkcMapFilePrivate * priv;
};

struct _KkcMapFileClass {
	GObjectClass parent_class;
	gchar* (*uniquify) (KkcMapFile* self, const gchar* key);
};

struct _KkcRomKanaMapFile {
	KkcMapFile parent_instance;
	KkcRomKanaMapFilePrivate * priv;
	KkcRomKanaNode* root_node;
};

struct _KkcRomKanaMapFileClass {
	KkcMapFileClass parent_class;
};


static gpointer kkc_rom_kana_node_parent_class = NULL;
static gpointer kkc_rom_kana_character_list_parent_class = NULL;
static gpointer kkc_rom_kana_converter_parent_class = NULL;

GType kkc_rom_kana_entry_get_type (void) G_GNUC_CONST;
KkcRomKanaEntry* kkc_rom_kana_entry_dup (const KkcRomKanaEntry* self);
void kkc_rom_kana_entry_free (KkcRomKanaEntry* self);
void kkc_rom_kana_entry_copy (const KkcRomKanaEntry* self, KkcRomKanaEntry* dest);
void kkc_rom_kana_entry_destroy (KkcRomKanaEntry* self);
GType kkc_kana_mode_get_type (void) G_GNUC_CONST;
gchar* kkc_rom_kana_entry_get_kana (KkcRomKanaEntry *self, KkcKanaMode mode, gboolean partial);
gchar* kkc_rom_kana_utils_convert_by_kana_mode (const gchar* str, KkcKanaMode mode);
GType kkc_rom_kana_node_get_type (void) G_GNUC_CONST;
KkcRomKanaNode* kkc_rom_kana_node_new (KkcRomKanaEntry* entry);
KkcRomKanaNode* kkc_rom_kana_node_construct (GType object_type, KkcRomKanaEntry* entry);
void kkc_rom_kana_node_insert (KkcRomKanaNode* self, const gchar* key, KkcRomKanaEntry* entry);
static void kkc_rom_kana_node_finalize (GObject * obj);
GType kkc_punctuation_style_get_type (void) G_GNUC_CONST;
GType kkc_rom_kana_character_get_type (void) G_GNUC_CONST;
KkcRomKanaCharacter* kkc_rom_kana_character_dup (const KkcRomKanaCharacter* self);
void kkc_rom_kana_character_free (KkcRomKanaCharacter* self);
void kkc_rom_kana_character_copy (const KkcRomKanaCharacter* self, KkcRomKanaCharacter* dest);
void kkc_rom_kana_character_destroy (KkcRomKanaCharacter* self);
GType kkc_rom_kana_character_list_get_type (void) G_GNUC_CONST;
#define KKC_ROM_KANA_CHARACTER_LIST_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), KKC_TYPE_ROM_KANA_CHARACTER_LIST, KkcRomKanaCharacterListPrivate))
void kkc_rom_kana_character_list_add (KkcRomKanaCharacterList* self, KkcRomKanaCharacter* character);
void kkc_rom_kana_character_list_add_all (KkcRomKanaCharacterList* self, KkcRomKanaCharacterList* other);
void kkc_rom_kana_character_list_insert (KkcRomKanaCharacterList* self, gint index, KkcRomKanaCharacter* character);
void kkc_rom_kana_character_list_insert_all (KkcRomKanaCharacterList* self, gint index, KkcRomKanaCharacterList* other);
void kkc_rom_kana_character_list_get (KkcRomKanaCharacterList* self, gint index, KkcRomKanaCharacter* result);
void kkc_rom_kana_character_list_clear (KkcRomKanaCharacterList* self);
KkcRomKanaCharacterList* kkc_rom_kana_character_list_slice (KkcRomKanaCharacterList* self, gint start_char_pos, gint stop_char_pos);
KkcRomKanaCharacterList* kkc_rom_kana_character_list_new (void);
KkcRomKanaCharacterList* kkc_rom_kana_character_list_construct (GType object_type);
void kkc_rom_kana_character_list_remove_at (KkcRomKanaCharacterList* self, gint index);
gchar* kkc_rom_kana_character_list_get_output (KkcRomKanaCharacterList* self);
gchar* kkc_rom_kana_character_list_get_input (KkcRomKanaCharacterList* self);
gint kkc_rom_kana_character_list_get_size (KkcRomKanaCharacterList* self);
static void kkc_rom_kana_character_list_finalize (GObject * obj);
static void _vala_kkc_rom_kana_character_list_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
GType kkc_rom_kana_converter_get_type (void) G_GNUC_CONST;
GType kkc_map_file_get_type (void) G_GNUC_CONST;
GType kkc_rom_kana_map_file_get_type (void) G_GNUC_CONST;
#define KKC_ROM_KANA_CONVERTER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), KKC_TYPE_ROM_KANA_CONVERTER, KkcRomKanaConverterPrivate))
gchar* kkc_rom_kana_converter_get_produced_output (KkcRomKanaConverter* self);
KkcRomKanaConverter* kkc_rom_kana_converter_new (void);
KkcRomKanaConverter* kkc_rom_kana_converter_construct (GType object_type);
GType kkc_metadata_file_get_type (void) G_GNUC_CONST;
GType kkc_rule_metadata_get_type (void) G_GNUC_CONST;
KkcRuleMetadata* kkc_rule_metadata_find (const gchar* name);
GQuark kkc_rule_parse_error_quark (void);
KkcRomKanaMapFile* kkc_rom_kana_map_file_new (KkcRuleMetadata* metadata, GError** error);
KkcRomKanaMapFile* kkc_rom_kana_map_file_construct (GType object_type, KkcRuleMetadata* metadata, GError** error);
gboolean kkc_rom_kana_converter_is_valid (KkcRomKanaConverter* self, gunichar uc);
gboolean kkc_rom_kana_converter_flush_partial (KkcRomKanaConverter* self);
KkcKanaMode kkc_rom_kana_converter_get_kana_mode (KkcRomKanaConverter* self);
KkcRomKanaMapFile* kkc_rom_kana_converter_get_rule (KkcRomKanaConverter* self);
gboolean kkc_rom_kana_converter_get_auto_correct (KkcRomKanaConverter* self);
void kkc_rom_kana_converter_append_text (KkcRomKanaConverter* self, const gchar* text);
gboolean kkc_rom_kana_converter_append (KkcRomKanaConverter* self, gunichar uc);
static gboolean kkc_rom_kana_converter_append_punctuation (KkcRomKanaConverter* self, gunichar uc);
KkcPunctuationStyle kkc_rom_kana_converter_get_punctuation_style (KkcRomKanaConverter* self);
gboolean kkc_rom_kana_converter_can_consume (KkcRomKanaConverter* self, gunichar uc, gboolean no_carryover);
void kkc_rom_kana_converter_reset (KkcRomKanaConverter* self);
gboolean kkc_rom_kana_converter_delete (KkcRomKanaConverter* self);
void kkc_rom_kana_converter_set_rule (KkcRomKanaConverter* self, KkcRomKanaMapFile* value);
void kkc_rom_kana_converter_set_kana_mode (KkcRomKanaConverter* self, KkcKanaMode value);
void kkc_rom_kana_converter_set_punctuation_style (KkcRomKanaConverter* self, KkcPunctuationStyle value);
void kkc_rom_kana_converter_set_auto_correct (KkcRomKanaConverter* self, gboolean value);
const gchar* kkc_rom_kana_converter_get_pending_output (KkcRomKanaConverter* self);
const gchar* kkc_rom_kana_converter_get_pending_input (KkcRomKanaConverter* self);
KkcRomKanaCharacterList* kkc_rom_kana_converter_get_produced (KkcRomKanaConverter* self);
static void kkc_rom_kana_converter_finalize (GObject * obj);
static void _vala_kkc_rom_kana_converter_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_kkc_rom_kana_converter_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

const gchar* KKC_PUNCTUATION_RULE[4] = {"。、", "．，", "。，", "．、"};

gchar* kkc_rom_kana_entry_get_kana (KkcRomKanaEntry *self, KkcKanaMode mode, gboolean partial) {
	gchar* result = NULL;
	KkcKanaMode _tmp0_;
	_tmp0_ = mode;
	switch (_tmp0_) {
		case KKC_KANA_MODE_HIRAGANA:
		{
			const gchar* _tmp1_ = NULL;
			gboolean _tmp2_;
			gchar* _tmp5_;
			_tmp2_ = partial;
			if (_tmp2_) {
				const gchar* _tmp3_;
				_tmp3_ = (*self).hiragana_partial;
				_tmp1_ = _tmp3_;
			} else {
				const gchar* _tmp4_;
				_tmp4_ = (*self).hiragana;
				_tmp1_ = _tmp4_;
			}
			_tmp5_ = g_strdup (_tmp1_);
			result = _tmp5_;
			return result;
		}
		case KKC_KANA_MODE_KATAKANA:
		{
			const gchar* _tmp6_ = NULL;
			gboolean _tmp7_;
			gchar* _tmp10_;
			_tmp7_ = partial;
			if (_tmp7_) {
				const gchar* _tmp8_;
				_tmp8_ = (*self).katakana_partial;
				_tmp6_ = _tmp8_;
			} else {
				const gchar* _tmp9_;
				_tmp9_ = (*self).katakana;
				_tmp6_ = _tmp9_;
			}
			_tmp10_ = g_strdup (_tmp6_);
			result = _tmp10_;
			return result;
		}
		default:
		{
			const gchar* _tmp11_ = NULL;
			gboolean _tmp12_;
			KkcKanaMode _tmp15_;
			gchar* _tmp16_;
			_tmp12_ = partial;
			if (_tmp12_) {
				const gchar* _tmp13_;
				_tmp13_ = (*self).hiragana_partial;
				_tmp11_ = _tmp13_;
			} else {
				const gchar* _tmp14_;
				_tmp14_ = (*self).hiragana;
				_tmp11_ = _tmp14_;
			}
			_tmp15_ = mode;
			_tmp16_ = kkc_rom_kana_utils_convert_by_kana_mode (_tmp11_, _tmp15_);
			result = _tmp16_;
			return result;
		}
	}
}


void kkc_rom_kana_entry_copy (const KkcRomKanaEntry* self, KkcRomKanaEntry* dest) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	_tmp0_ = (*self).rom;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).rom);
	(*dest).rom = _tmp1_;
	_tmp2_ = (*self).carryover;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*dest).carryover);
	(*dest).carryover = _tmp3_;
	_tmp4_ = (*self).hiragana;
	_tmp5_ = g_strdup (_tmp4_);
	_g_free0 ((*dest).hiragana);
	(*dest).hiragana = _tmp5_;
	_tmp6_ = (*self).katakana;
	_tmp7_ = g_strdup (_tmp6_);
	_g_free0 ((*dest).katakana);
	(*dest).katakana = _tmp7_;
	_tmp8_ = (*self).hiragana_partial;
	_tmp9_ = g_strdup (_tmp8_);
	_g_free0 ((*dest).hiragana_partial);
	(*dest).hiragana_partial = _tmp9_;
	_tmp10_ = (*self).katakana_partial;
	_tmp11_ = g_strdup (_tmp10_);
	_g_free0 ((*dest).katakana_partial);
	(*dest).katakana_partial = _tmp11_;
}


void kkc_rom_kana_entry_destroy (KkcRomKanaEntry* self) {
	_g_free0 ((*self).rom);
	_g_free0 ((*self).carryover);
	_g_free0 ((*self).hiragana);
	_g_free0 ((*self).katakana);
	_g_free0 ((*self).hiragana_partial);
	_g_free0 ((*self).katakana_partial);
}


KkcRomKanaEntry* kkc_rom_kana_entry_dup (const KkcRomKanaEntry* self) {
	KkcRomKanaEntry* dup;
	dup = g_new0 (KkcRomKanaEntry, 1);
	kkc_rom_kana_entry_copy (self, dup);
	return dup;
}


void kkc_rom_kana_entry_free (KkcRomKanaEntry* self) {
	kkc_rom_kana_entry_destroy (self);
	g_free (self);
}


GType kkc_rom_kana_entry_get_type (void) {
	static volatile gsize kkc_rom_kana_entry_type_id__volatile = 0;
	if (g_once_init_enter (&kkc_rom_kana_entry_type_id__volatile)) {
		GType kkc_rom_kana_entry_type_id;
		kkc_rom_kana_entry_type_id = g_boxed_type_register_static ("KkcRomKanaEntry", (GBoxedCopyFunc) kkc_rom_kana_entry_dup, (GBoxedFreeFunc) kkc_rom_kana_entry_free);
		g_once_init_leave (&kkc_rom_kana_entry_type_id__volatile, kkc_rom_kana_entry_type_id);
	}
	return kkc_rom_kana_entry_type_id__volatile;
}


static gpointer _kkc_rom_kana_entry_dup0 (gpointer self) {
	return self ? kkc_rom_kana_entry_dup (self) : NULL;
}


KkcRomKanaNode* kkc_rom_kana_node_construct (GType object_type, KkcRomKanaEntry* entry) {
	KkcRomKanaNode * self = NULL;
	KkcRomKanaEntry* _tmp0_;
	KkcRomKanaEntry* _tmp1_;
	self = (KkcRomKanaNode*) g_object_new (object_type, NULL);
	_tmp0_ = entry;
	_tmp1_ = _kkc_rom_kana_entry_dup0 (_tmp0_);
	_kkc_rom_kana_entry_free0 (self->entry);
	self->entry = _tmp1_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				gint _tmp4_;
				gint _tmp5_;
				KkcRomKanaNode* _tmp6_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp4_ = i;
				if (!(_tmp4_ < 256)) {
					break;
				}
				_tmp5_ = i;
				_g_object_unref0 (self->children[_tmp5_]);
				self->children[_tmp5_] = NULL;
				_tmp6_ = self->children[_tmp5_];
			}
		}
	}
	memset (self->valid, 0, (gsize) 32);
	return self;
}


KkcRomKanaNode* kkc_rom_kana_node_new (KkcRomKanaEntry* entry) {
	return kkc_rom_kana_node_construct (KKC_TYPE_ROM_KANA_NODE, entry);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gboolean string_get_next_char (const gchar* self, gint* index, gunichar* c) {
	gunichar _vala_c = 0U;
	gboolean result = FALSE;
	gint _tmp0_;
	gunichar _tmp1_;
	gunichar _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = *index;
	_tmp1_ = g_utf8_get_char (((gchar*) self) + _tmp0_);
	_vala_c = _tmp1_;
	_tmp2_ = _vala_c;
	if (_tmp2_ != ((gunichar) 0)) {
		gint _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = *index;
		_tmp4_ = g_utf8_next_char (((gchar*) self) + _tmp3_);
		*index = (gint) (_tmp4_ - ((gchar*) self));
		result = TRUE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	} else {
		result = FALSE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	}
	if (c) {
		*c = _vala_c;
	}
}


void kkc_rom_kana_node_insert (KkcRomKanaNode* self, const gchar* key, KkcRomKanaEntry* entry) {
	KkcRomKanaNode* node = NULL;
	KkcRomKanaNode* _tmp0_;
	gint index = 0;
	gunichar uc = 0U;
	KkcRomKanaNode* _tmp23_;
	KkcRomKanaEntry _tmp24_;
	KkcRomKanaEntry _tmp25_;
	KkcRomKanaEntry* _tmp26_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (key != NULL);
	g_return_if_fail (entry != NULL);
	_tmp0_ = _g_object_ref0 (self);
	node = _tmp0_;
	index = 0;
	while (TRUE) {
		const gchar* _tmp1_;
		gunichar _tmp2_ = 0U;
		gboolean _tmp3_;
		KkcRomKanaNode* _tmp4_;
		gunichar _tmp5_;
		KkcRomKanaNode* _tmp6_;
		KkcRomKanaNode* _tmp14_;
		guint _tmp15_;
		KkcRomKanaNode* _tmp16_;
		gunichar _tmp17_;
		KkcRomKanaNode* _tmp18_;
		KkcRomKanaNode* _tmp19_;
		gunichar _tmp20_;
		gunichar _tmp21_;
		guint8 _tmp22_;
		_tmp1_ = key;
		_tmp3_ = string_get_next_char (_tmp1_, &index, &_tmp2_);
		uc = _tmp2_;
		if (!_tmp3_) {
			break;
		}
		_tmp4_ = node;
		_tmp5_ = uc;
		_tmp6_ = _tmp4_->children[_tmp5_];
		if (_tmp6_ == NULL) {
			KkcRomKanaNode* child = NULL;
			KkcRomKanaNode* _tmp7_;
			gunichar _tmp8_;
			KkcRomKanaNode* _tmp9_;
			KkcRomKanaNode* _tmp10_;
			KkcRomKanaNode* _tmp11_;
			KkcRomKanaNode* _tmp12_;
			KkcRomKanaNode* _tmp13_;
			_tmp7_ = node;
			_tmp8_ = uc;
			_tmp9_ = kkc_rom_kana_node_new (NULL);
			_g_object_unref0 (_tmp7_->children[_tmp8_]);
			_tmp7_->children[_tmp8_] = _tmp9_;
			_tmp10_ = _tmp7_->children[_tmp8_];
			_tmp11_ = _g_object_ref0 (_tmp10_);
			child = _tmp11_;
			_tmp12_ = child;
			_tmp13_ = node;
			_tmp12_->parent = _tmp13_;
			_g_object_unref0 (child);
		}
		_tmp14_ = node;
		_tmp15_ = _tmp14_->n_children;
		_tmp14_->n_children = _tmp15_ + 1;
		_tmp16_ = node;
		_tmp17_ = uc;
		_tmp18_ = _tmp16_->children[_tmp17_];
		_tmp19_ = _g_object_ref0 (_tmp18_);
		_g_object_unref0 (node);
		node = _tmp19_;
		_tmp20_ = uc;
		_tmp21_ = uc;
		self->valid[_tmp20_ / 8] |= (guint8) (1 << (_tmp21_ % 8));
		_tmp22_ = self->valid[_tmp20_ / 8];
	}
	_tmp23_ = node;
	_tmp24_ = *entry;
	_tmp25_ = _tmp24_;
	_tmp26_ = _kkc_rom_kana_entry_dup0 (&_tmp25_);
	_kkc_rom_kana_entry_free0 (_tmp23_->entry);
	_tmp23_->entry = _tmp26_;
	_g_object_unref0 (node);
}


static void kkc_rom_kana_node_class_init (KkcRomKanaNodeClass * klass) {
	kkc_rom_kana_node_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = kkc_rom_kana_node_finalize;
}


static void kkc_rom_kana_node_instance_init (KkcRomKanaNode * self) {
	self->n_children = (guint) 0;
}


static void kkc_rom_kana_node_finalize (GObject * obj) {
	KkcRomKanaNode * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, KKC_TYPE_ROM_KANA_NODE, KkcRomKanaNode);
	_kkc_rom_kana_entry_free0 (self->entry);
	_vala_array_destroy (self->children, 256, (GDestroyNotify) g_object_unref);
	G_OBJECT_CLASS (kkc_rom_kana_node_parent_class)->finalize (obj);
}


GType kkc_rom_kana_node_get_type (void) {
	static volatile gsize kkc_rom_kana_node_type_id__volatile = 0;
	if (g_once_init_enter (&kkc_rom_kana_node_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (KkcRomKanaNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) kkc_rom_kana_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (KkcRomKanaNode), 0, (GInstanceInitFunc) kkc_rom_kana_node_instance_init, NULL };
		GType kkc_rom_kana_node_type_id;
		kkc_rom_kana_node_type_id = g_type_register_static (G_TYPE_OBJECT, "KkcRomKanaNode", &g_define_type_info, 0);
		g_once_init_leave (&kkc_rom_kana_node_type_id__volatile, kkc_rom_kana_node_type_id);
	}
	return kkc_rom_kana_node_type_id__volatile;
}


/**
     * Type representing kana scripts.
     */
GType kkc_kana_mode_get_type (void) {
	static volatile gsize kkc_kana_mode_type_id__volatile = 0;
	if (g_once_init_enter (&kkc_kana_mode_type_id__volatile)) {
		static const GEnumValue values[] = {{KKC_KANA_MODE_HIRAGANA, "KKC_KANA_MODE_HIRAGANA", "hiragana"}, {KKC_KANA_MODE_KATAKANA, "KKC_KANA_MODE_KATAKANA", "katakana"}, {KKC_KANA_MODE_HANKAKU_KATAKANA, "KKC_KANA_MODE_HANKAKU_KATAKANA", "hankaku-katakana"}, {KKC_KANA_MODE_LATIN, "KKC_KANA_MODE_LATIN", "latin"}, {KKC_KANA_MODE_WIDE_LATIN, "KKC_KANA_MODE_WIDE_LATIN", "wide-latin"}, {0, NULL, NULL}};
		GType kkc_kana_mode_type_id;
		kkc_kana_mode_type_id = g_enum_register_static ("KkcKanaMode", values);
		g_once_init_leave (&kkc_kana_mode_type_id__volatile, kkc_kana_mode_type_id);
	}
	return kkc_kana_mode_type_id__volatile;
}


/**
     * Type to specify how "." and "," are converted.
     */
GType kkc_punctuation_style_get_type (void) {
	static volatile gsize kkc_punctuation_style_type_id__volatile = 0;
	if (g_once_init_enter (&kkc_punctuation_style_type_id__volatile)) {
		static const GEnumValue values[] = {{KKC_PUNCTUATION_STYLE_JA_JA, "KKC_PUNCTUATION_STYLE_JA_JA", "ja-ja"}, {KKC_PUNCTUATION_STYLE_EN_EN, "KKC_PUNCTUATION_STYLE_EN_EN", "en-en"}, {KKC_PUNCTUATION_STYLE_JA_EN, "KKC_PUNCTUATION_STYLE_JA_EN", "ja-en"}, {KKC_PUNCTUATION_STYLE_EN_JA, "KKC_PUNCTUATION_STYLE_EN_JA", "en-ja"}, {0, NULL, NULL}};
		GType kkc_punctuation_style_type_id;
		kkc_punctuation_style_type_id = g_enum_register_static ("KkcPunctuationStyle", values);
		g_once_init_leave (&kkc_punctuation_style_type_id__volatile, kkc_punctuation_style_type_id);
	}
	return kkc_punctuation_style_type_id__volatile;
}


void kkc_rom_kana_character_copy (const KkcRomKanaCharacter* self, KkcRomKanaCharacter* dest) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	_tmp0_ = (*self).output;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).output);
	(*dest).output = _tmp1_;
	_tmp2_ = (*self).input;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*dest).input);
	(*dest).input = _tmp3_;
}


void kkc_rom_kana_character_destroy (KkcRomKanaCharacter* self) {
	_g_free0 ((*self).output);
	_g_free0 ((*self).input);
}


KkcRomKanaCharacter* kkc_rom_kana_character_dup (const KkcRomKanaCharacter* self) {
	KkcRomKanaCharacter* dup;
	dup = g_new0 (KkcRomKanaCharacter, 1);
	kkc_rom_kana_character_copy (self, dup);
	return dup;
}


void kkc_rom_kana_character_free (KkcRomKanaCharacter* self) {
	kkc_rom_kana_character_destroy (self);
	g_free (self);
}


GType kkc_rom_kana_character_get_type (void) {
	static volatile gsize kkc_rom_kana_character_type_id__volatile = 0;
	if (g_once_init_enter (&kkc_rom_kana_character_type_id__volatile)) {
		GType kkc_rom_kana_character_type_id;
		kkc_rom_kana_character_type_id = g_boxed_type_register_static ("KkcRomKanaCharacter", (GBoxedCopyFunc) kkc_rom_kana_character_dup, (GBoxedFreeFunc) kkc_rom_kana_character_free);
		g_once_init_leave (&kkc_rom_kana_character_type_id__volatile, kkc_rom_kana_character_type_id);
	}
	return kkc_rom_kana_character_type_id__volatile;
}


/**
         * Append a character to the character list.
         *
         * @param character a RomKanaCharacter
         */
void kkc_rom_kana_character_list_add (KkcRomKanaCharacterList* self, KkcRomKanaCharacter* character) {
	GeeList* _tmp0_;
	KkcRomKanaCharacter _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (character != NULL);
	_tmp0_ = self->priv->_characters;
	_tmp1_ = *character;
	gee_collection_add ((GeeCollection*) _tmp0_, &_tmp1_);
}


/**
         * Append all characters in other character list to the character list.
         *
         * @param other RomKanaCharacterList
         */
void kkc_rom_kana_character_list_add_all (KkcRomKanaCharacterList* self, KkcRomKanaCharacterList* other) {
	GeeList* _tmp0_;
	KkcRomKanaCharacterList* _tmp1_;
	GeeList* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (other != NULL);
	_tmp0_ = self->priv->_characters;
	_tmp1_ = other;
	_tmp2_ = _tmp1_->priv->_characters;
	gee_collection_add_all ((GeeCollection*) _tmp0_, (GeeCollection*) _tmp2_);
}


/**
         * Add a character to the character list at the specified
         * position.
         *
         * @param index index
         * @param character RomKanaCharacter
         */
void kkc_rom_kana_character_list_insert (KkcRomKanaCharacterList* self, gint index, KkcRomKanaCharacter* character) {
	GeeList* _tmp0_;
	gint _tmp1_;
	KkcRomKanaCharacter _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (character != NULL);
	_tmp0_ = self->priv->_characters;
	_tmp1_ = index;
	_tmp2_ = *character;
	gee_list_insert (_tmp0_, _tmp1_, &_tmp2_);
}


/**
         * Add all characters in other character list to the character
         * list at the specified position.
         *
         * @param index index
         * @param other RomKanaCharacterList
         */
void kkc_rom_kana_character_list_insert_all (KkcRomKanaCharacterList* self, gint index, KkcRomKanaCharacterList* other) {
	GeeList* _tmp0_;
	gint _tmp1_;
	KkcRomKanaCharacterList* _tmp2_;
	GeeList* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (other != NULL);
	_tmp0_ = self->priv->_characters;
	_tmp1_ = index;
	_tmp2_ = other;
	_tmp3_ = _tmp2_->priv->_characters;
	gee_list_insert_all (_tmp0_, _tmp1_, (GeeCollection*) _tmp3_);
}


/**
         * Get a character at the given index.
         *
         * @param index index
         *
         * @return a RomKanaCharacter
         */
void kkc_rom_kana_character_list_get (KkcRomKanaCharacterList* self, gint index, KkcRomKanaCharacter* result) {
	GeeList* _tmp0_;
	gint _tmp1_;
	gpointer _tmp2_;
	KkcRomKanaCharacter* _tmp3_;
	KkcRomKanaCharacter _tmp4_ = {0};
	KkcRomKanaCharacter _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_characters;
	_tmp1_ = index;
	_tmp2_ = gee_list_get (_tmp0_, _tmp1_);
	_tmp3_ = (KkcRomKanaCharacter*) _tmp2_;
	kkc_rom_kana_character_copy (_tmp3_, &_tmp4_);
	_tmp5_ = _tmp4_;
	_kkc_rom_kana_character_free0 (_tmp3_);
	*result = _tmp5_;
	return;
}


/**
         * Remove all characters from the character list.
         */
void kkc_rom_kana_character_list_clear (KkcRomKanaCharacterList* self) {
	GeeList* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_characters;
	gee_collection_clear ((GeeCollection*) _tmp0_);
}


/**
         * Return a slice of this character list.
         *
         * @param start_char_pos zero-based index of the begin of the slice
         * @param stop_char_pos zero-based index after the end of the slice
         *
         * @return a RomKanaCharacterList
         */
KkcRomKanaCharacterList* kkc_rom_kana_character_list_slice (KkcRomKanaCharacterList* self, gint start_char_pos, gint stop_char_pos) {
	KkcRomKanaCharacterList* result = NULL;
	gint start = 0;
	gint stop = 0;
	gint char_pos = 0;
	KkcRomKanaCharacterList* _result_ = NULL;
	KkcRomKanaCharacterList* _tmp31_;
	g_return_val_if_fail (self != NULL, NULL);
	char_pos = 0;
	{
		gboolean _tmp0_ = FALSE;
		start = 0;
		_tmp0_ = TRUE;
		while (TRUE) {
			gint _tmp2_;
			GeeList* _tmp3_;
			gint _tmp4_;
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
			GeeList* _tmp9_;
			gint _tmp10_;
			gpointer _tmp11_;
			KkcRomKanaCharacter* _tmp12_;
			const gchar* _tmp13_;
			gint _tmp14_;
			if (!_tmp0_) {
				gint _tmp1_;
				_tmp1_ = start;
				start = _tmp1_ + 1;
			}
			_tmp0_ = FALSE;
			_tmp2_ = start;
			_tmp3_ = self->priv->_characters;
			_tmp4_ = gee_collection_get_size ((GeeCollection*) _tmp3_);
			_tmp5_ = _tmp4_;
			if (!(_tmp2_ < _tmp5_)) {
				break;
			}
			_tmp6_ = char_pos;
			_tmp7_ = start_char_pos;
			if (_tmp6_ >= _tmp7_) {
				break;
			}
			_tmp8_ = char_pos;
			_tmp9_ = self->priv->_characters;
			_tmp10_ = start;
			_tmp11_ = gee_list_get (_tmp9_, _tmp10_);
			_tmp12_ = (KkcRomKanaCharacter*) _tmp11_;
			_tmp13_ = (*_tmp12_).output;
			_tmp14_ = g_utf8_strlen (_tmp13_, (gssize) -1);
			char_pos = _tmp8_ + _tmp14_;
			_kkc_rom_kana_character_free0 (_tmp12_);
		}
	}
	{
		gint _tmp15_;
		gboolean _tmp16_ = FALSE;
		_tmp15_ = start;
		stop = _tmp15_;
		_tmp16_ = TRUE;
		while (TRUE) {
			gint _tmp18_;
			GeeList* _tmp19_;
			gint _tmp20_;
			gint _tmp21_;
			gint _tmp22_;
			GeeList* _tmp23_;
			gint _tmp24_;
			gpointer _tmp25_;
			KkcRomKanaCharacter* _tmp26_;
			const gchar* _tmp27_;
			gint _tmp28_;
			gint _tmp29_;
			gint _tmp30_;
			if (!_tmp16_) {
				gint _tmp17_;
				_tmp17_ = stop;
				stop = _tmp17_ + 1;
			}
			_tmp16_ = FALSE;
			_tmp18_ = stop;
			_tmp19_ = self->priv->_characters;
			_tmp20_ = gee_collection_get_size ((GeeCollection*) _tmp19_);
			_tmp21_ = _tmp20_;
			if (!(_tmp18_ < _tmp21_)) {
				break;
			}
			_tmp22_ = char_pos;
			_tmp23_ = self->priv->_characters;
			_tmp24_ = stop;
			_tmp25_ = gee_list_get (_tmp23_, _tmp24_);
			_tmp26_ = (KkcRomKanaCharacter*) _tmp25_;
			_tmp27_ = (*_tmp26_).output;
			_tmp28_ = g_utf8_strlen (_tmp27_, (gssize) -1);
			char_pos = _tmp22_ + _tmp28_;
			_kkc_rom_kana_character_free0 (_tmp26_);
			_tmp29_ = char_pos;
			_tmp30_ = stop_char_pos;
			if (_tmp29_ >= _tmp30_) {
				break;
			}
		}
	}
	_tmp31_ = kkc_rom_kana_character_list_new ();
	_result_ = _tmp31_;
	{
		gboolean _tmp32_ = FALSE;
		_tmp32_ = TRUE;
		while (TRUE) {
			gint _tmp34_;
			gint _tmp35_;
			KkcRomKanaCharacterList* _tmp36_;
			GeeList* _tmp37_;
			gint _tmp38_;
			gpointer _tmp39_;
			KkcRomKanaCharacter* _tmp40_;
			KkcRomKanaCharacter _tmp41_;
			if (!_tmp32_) {
				gint _tmp33_;
				_tmp33_ = start;
				start = _tmp33_ + 1;
			}
			_tmp32_ = FALSE;
			_tmp34_ = start;
			_tmp35_ = stop;
			if (!(_tmp34_ <= _tmp35_)) {
				break;
			}
			_tmp36_ = _result_;
			_tmp37_ = self->priv->_characters;
			_tmp38_ = start;
			_tmp39_ = gee_list_get (_tmp37_, _tmp38_);
			_tmp40_ = (KkcRomKanaCharacter*) _tmp39_;
			_tmp41_ = *_tmp40_;
			kkc_rom_kana_character_list_add (_tmp36_, &_tmp41_);
			_kkc_rom_kana_character_free0 (_tmp40_);
		}
	}
	result = _result_;
	return result;
}


/**
         * Remove a character at the given index.
         *
         * @param index index
         */
void kkc_rom_kana_character_list_remove_at (KkcRomKanaCharacterList* self, gint index) {
	GeeList* _tmp0_;
	gint _tmp1_;
	gpointer _tmp2_;
	KkcRomKanaCharacter* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_characters;
	_tmp1_ = index;
	_tmp2_ = gee_list_remove_at (_tmp0_, _tmp1_);
	_tmp3_ = (KkcRomKanaCharacter*) _tmp2_;
	_kkc_rom_kana_character_free0 (_tmp3_);
}


/**
         * Return the concatenation of all character output as a string.
         *
         * @return a string
         */
gchar* kkc_rom_kana_character_list_get_output (KkcRomKanaCharacterList* self) {
	gchar* result = NULL;
	GString* builder = NULL;
	GString* _tmp0_;
	GString* _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_string_new ("");
	builder = _tmp0_;
	{
		GeeList* _character_list = NULL;
		GeeList* _tmp1_;
		GeeList* _tmp2_;
		gint _character_size = 0;
		GeeList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _character_index = 0;
		_tmp1_ = self->priv->_characters;
		_tmp2_ = _g_object_ref0 (_tmp1_);
		_character_list = _tmp2_;
		_tmp3_ = _character_list;
		_tmp4_ = gee_collection_get_size ((GeeCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_character_size = _tmp5_;
		_character_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
			KkcRomKanaCharacter* character = NULL;
			GeeList* _tmp9_;
			gint _tmp10_;
			gpointer _tmp11_;
			GString* _tmp12_;
			KkcRomKanaCharacter* _tmp13_;
			const gchar* _tmp14_;
			_tmp6_ = _character_index;
			_character_index = _tmp6_ + 1;
			_tmp7_ = _character_index;
			_tmp8_ = _character_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _character_list;
			_tmp10_ = _character_index;
			_tmp11_ = gee_list_get (_tmp9_, _tmp10_);
			character = (KkcRomKanaCharacter*) _tmp11_;
			_tmp12_ = builder;
			_tmp13_ = character;
			_tmp14_ = (*_tmp13_).output;
			g_string_append (_tmp12_, _tmp14_);
			_kkc_rom_kana_character_free0 (character);
		}
		_g_object_unref0 (_character_list);
	}
	_tmp15_ = builder;
	_tmp16_ = _tmp15_->str;
	_tmp17_ = g_strdup (_tmp16_);
	result = _tmp17_;
	_g_string_free0 (builder);
	return result;
}


/**
         * Return the concatenation of all character input as a string.
         *
         * @return a string
         */
gchar* kkc_rom_kana_character_list_get_input (KkcRomKanaCharacterList* self) {
	gchar* result = NULL;
	GString* builder = NULL;
	GString* _tmp0_;
	GString* _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_string_new ("");
	builder = _tmp0_;
	{
		GeeList* _character_list = NULL;
		GeeList* _tmp1_;
		GeeList* _tmp2_;
		gint _character_size = 0;
		GeeList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _character_index = 0;
		_tmp1_ = self->priv->_characters;
		_tmp2_ = _g_object_ref0 (_tmp1_);
		_character_list = _tmp2_;
		_tmp3_ = _character_list;
		_tmp4_ = gee_collection_get_size ((GeeCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_character_size = _tmp5_;
		_character_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
			KkcRomKanaCharacter* character = NULL;
			GeeList* _tmp9_;
			gint _tmp10_;
			gpointer _tmp11_;
			GString* _tmp12_;
			KkcRomKanaCharacter* _tmp13_;
			const gchar* _tmp14_;
			_tmp6_ = _character_index;
			_character_index = _tmp6_ + 1;
			_tmp7_ = _character_index;
			_tmp8_ = _character_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _character_list;
			_tmp10_ = _character_index;
			_tmp11_ = gee_list_get (_tmp9_, _tmp10_);
			character = (KkcRomKanaCharacter*) _tmp11_;
			_tmp12_ = builder;
			_tmp13_ = character;
			_tmp14_ = (*_tmp13_).input;
			g_string_append (_tmp12_, _tmp14_);
			_kkc_rom_kana_character_free0 (character);
		}
		_g_object_unref0 (_character_list);
	}
	_tmp15_ = builder;
	_tmp16_ = _tmp15_->str;
	_tmp17_ = g_strdup (_tmp16_);
	result = _tmp17_;
	_g_string_free0 (builder);
	return result;
}


KkcRomKanaCharacterList* kkc_rom_kana_character_list_construct (GType object_type) {
	KkcRomKanaCharacterList * self = NULL;
	self = (KkcRomKanaCharacterList*) g_object_new (object_type, NULL);
	return self;
}


KkcRomKanaCharacterList* kkc_rom_kana_character_list_new (void) {
	return kkc_rom_kana_character_list_construct (KKC_TYPE_ROM_KANA_CHARACTER_LIST);
}


gint kkc_rom_kana_character_list_get_size (KkcRomKanaCharacterList* self) {
	gint result;
	GeeList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_characters;
	_tmp1_ = gee_collection_get_size ((GeeCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}


static void kkc_rom_kana_character_list_class_init (KkcRomKanaCharacterListClass * klass) {
	kkc_rom_kana_character_list_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (KkcRomKanaCharacterListPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_kkc_rom_kana_character_list_get_property;
	G_OBJECT_CLASS (klass)->finalize = kkc_rom_kana_character_list_finalize;
	/**
	         * The number of characters in the character list.
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), KKC_ROM_KANA_CHARACTER_LIST_SIZE_PROPERTY, kkc_rom_kana_character_list_properties[KKC_ROM_KANA_CHARACTER_LIST_SIZE_PROPERTY] = g_param_spec_int ("size", "size", "size", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void kkc_rom_kana_character_list_instance_init (KkcRomKanaCharacterList * self) {
	GeeArrayList* _tmp0_;
	self->priv = KKC_ROM_KANA_CHARACTER_LIST_GET_PRIVATE (self);
	_tmp0_ = gee_array_list_new (KKC_TYPE_ROM_KANA_CHARACTER, (GBoxedCopyFunc) kkc_rom_kana_character_dup, (GDestroyNotify) kkc_rom_kana_character_free, NULL, NULL, NULL);
	self->priv->_characters = (GeeList*) _tmp0_;
}


static void kkc_rom_kana_character_list_finalize (GObject * obj) {
	KkcRomKanaCharacterList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, KKC_TYPE_ROM_KANA_CHARACTER_LIST, KkcRomKanaCharacterList);
	_g_object_unref0 (self->priv->_characters);
	G_OBJECT_CLASS (kkc_rom_kana_character_list_parent_class)->finalize (obj);
}


/**
     * A list of RomKanaCharacter
     */
GType kkc_rom_kana_character_list_get_type (void) {
	static volatile gsize kkc_rom_kana_character_list_type_id__volatile = 0;
	if (g_once_init_enter (&kkc_rom_kana_character_list_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (KkcRomKanaCharacterListClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) kkc_rom_kana_character_list_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (KkcRomKanaCharacterList), 0, (GInstanceInitFunc) kkc_rom_kana_character_list_instance_init, NULL };
		GType kkc_rom_kana_character_list_type_id;
		kkc_rom_kana_character_list_type_id = g_type_register_static (G_TYPE_OBJECT, "KkcRomKanaCharacterList", &g_define_type_info, 0);
		g_once_init_leave (&kkc_rom_kana_character_list_type_id__volatile, kkc_rom_kana_character_list_type_id);
	}
	return kkc_rom_kana_character_list_type_id__volatile;
}


static void _vala_kkc_rom_kana_character_list_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	KkcRomKanaCharacterList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, KKC_TYPE_ROM_KANA_CHARACTER_LIST, KkcRomKanaCharacterList);
	switch (property_id) {
		case KKC_ROM_KANA_CHARACTER_LIST_SIZE_PROPERTY:
		g_value_set_int (value, kkc_rom_kana_character_list_get_size (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


/**
         * Return the concatenation of the produced output characters.
         *
         * @return a string
         */
gchar* kkc_rom_kana_converter_get_produced_output (KkcRomKanaConverter* self) {
	gchar* result = NULL;
	GString* builder = NULL;
	GString* _tmp0_;
	GString* _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_string_new ("");
	builder = _tmp0_;
	{
		KkcRomKanaCharacterList* _c_list = NULL;
		KkcRomKanaCharacterList* _tmp1_;
		KkcRomKanaCharacterList* _tmp2_;
		gint _c_size = 0;
		KkcRomKanaCharacterList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _c_index = 0;
		_tmp1_ = self->priv->_produced;
		_tmp2_ = _g_object_ref0 (_tmp1_);
		_c_list = _tmp2_;
		_tmp3_ = _c_list;
		_tmp4_ = kkc_rom_kana_character_list_get_size (_tmp3_);
		_tmp5_ = _tmp4_;
		_c_size = _tmp5_;
		_c_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
			KkcRomKanaCharacter c = {0};
			KkcRomKanaCharacterList* _tmp9_;
			gint _tmp10_;
			KkcRomKanaCharacter _tmp11_ = {0};
			GString* _tmp12_;
			KkcRomKanaCharacter _tmp13_;
			const gchar* _tmp14_;
			_tmp6_ = _c_index;
			_c_index = _tmp6_ + 1;
			_tmp7_ = _c_index;
			_tmp8_ = _c_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _c_list;
			_tmp10_ = _c_index;
			kkc_rom_kana_character_list_get (_tmp9_, _tmp10_, &_tmp11_);
			c = _tmp11_;
			_tmp12_ = builder;
			_tmp13_ = c;
			_tmp14_ = _tmp13_.output;
			g_string_append (_tmp12_, _tmp14_);
			kkc_rom_kana_character_destroy (&c);
		}
		_g_object_unref0 (_c_list);
	}
	_tmp15_ = builder;
	_tmp16_ = _tmp15_->str;
	_tmp17_ = g_strdup (_tmp16_);
	result = _tmp17_;
	_g_string_free0 (builder);
	return result;
}


/**
         * Create a new RomKanaConverter.
         *
         * @return a new RomKanaConverter
         */
KkcRomKanaConverter* kkc_rom_kana_converter_construct (GType object_type) {
	KkcRomKanaConverter * self = NULL;
	GError * _inner_error_ = NULL;
	self = (KkcRomKanaConverter*) g_object_new (object_type, NULL);
	{
		KkcRomKanaMapFile* _tmp0_ = NULL;
		KkcRuleMetadata* _tmp1_;
		KkcRuleMetadata* _tmp2_;
		KkcRomKanaMapFile* _tmp3_;
		KkcRomKanaMapFile* _tmp4_;
		KkcRomKanaMapFile* _tmp5_;
		KkcRomKanaMapFile* _tmp6_;
		KkcRomKanaNode* _tmp7_;
		KkcRomKanaNode* _tmp8_;
		_tmp1_ = kkc_rule_metadata_find ("default");
		_tmp2_ = _tmp1_;
		_tmp3_ = kkc_rom_kana_map_file_new (_tmp2_, &_inner_error_);
		_tmp4_ = _tmp3_;
		_g_object_unref0 (_tmp2_);
		_tmp0_ = _tmp4_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == KKC_RULE_PARSE_ERROR) {
				goto __catch4_kkc_rule_parse_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp5_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (self->priv->_rule);
		self->priv->_rule = _tmp5_;
		_tmp6_ = self->priv->_rule;
		_tmp7_ = _tmp6_->root_node;
		_tmp8_ = _g_object_ref0 (_tmp7_);
		_g_object_unref0 (self->priv->current_node);
		self->priv->current_node = _tmp8_;
		_g_object_unref0 (_tmp0_);
	}
	goto __finally4;
	__catch4_kkc_rule_parse_error:
	{
		GError* e = NULL;
		const gchar* _tmp9_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp9_ = e->message;
		g_warning ("rom-kana.vala:400: can't find default rom-kana rule: %s", _tmp9_);
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally4:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	return self;
}


KkcRomKanaConverter* kkc_rom_kana_converter_new (void) {
	return kkc_rom_kana_converter_construct (KKC_TYPE_ROM_KANA_CONVERTER);
}


/**
         * Check if a character is a valid conversion input.
         *
         * @param uc unichar
         * @return `true` if uc is in a valid range, `false` otherwise
         */
gboolean kkc_rom_kana_converter_is_valid (KkcRomKanaConverter* self, gunichar uc) {
	gboolean result = FALSE;
	gunichar _tmp0_;
	guint8 mask = 0U;
	gunichar _tmp1_;
	gboolean _tmp2_ = FALSE;
	KkcRomKanaNode* _tmp3_;
	gunichar _tmp4_;
	guint8 _tmp5_;
	guint8 _tmp6_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = uc;
	if (_tmp0_ >= ((gunichar) 256)) {
		result = FALSE;
		return result;
	}
	_tmp1_ = uc;
	mask = (guint8) (1 << (_tmp1_ % 8));
	_tmp3_ = self->priv->current_node;
	_tmp4_ = uc;
	_tmp5_ = _tmp3_->valid[_tmp4_ / 8];
	_tmp6_ = mask;
	if (((gint) (_tmp5_ & _tmp6_)) != 0) {
		_tmp2_ = TRUE;
	} else {
		KkcRomKanaMapFile* _tmp7_;
		KkcRomKanaNode* _tmp8_;
		gunichar _tmp9_;
		guint8 _tmp10_;
		guint8 _tmp11_;
		_tmp7_ = self->priv->_rule;
		_tmp8_ = _tmp7_->root_node;
		_tmp9_ = uc;
		_tmp10_ = _tmp8_->valid[_tmp9_ / 8];
		_tmp11_ = mask;
		_tmp2_ = ((gint) (_tmp10_ & _tmp11_)) != 0;
	}
	result = _tmp2_;
	return result;
}


/**
         * Finish pending input, if any.
         *
         * Note that this does not reset pending input/output and the
         * current node if there is no partial output.
         *
         * @return `true` if there is partial output, `false` otherwise
         */
static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_;
	gchar _tmp1_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


gboolean kkc_rom_kana_converter_flush_partial (KkcRomKanaConverter* self) {
	gboolean result = FALSE;
	KkcRomKanaNode* _tmp0_;
	KkcRomKanaEntry* _tmp1_;
	gboolean _tmp23_ = FALSE;
	gboolean _tmp24_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->current_node;
	_tmp1_ = _tmp0_->entry;
	if (_tmp1_ != NULL) {
		gchar* output = NULL;
		KkcRomKanaNode* _tmp2_;
		KkcRomKanaEntry* _tmp3_;
		KkcKanaMode _tmp4_;
		gchar* _tmp5_;
		const gchar* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		_tmp2_ = self->priv->current_node;
		_tmp3_ = _tmp2_->entry;
		_tmp4_ = self->priv->_kana_mode;
		_tmp5_ = kkc_rom_kana_entry_get_kana (_tmp3_, _tmp4_, TRUE);
		output = _tmp5_;
		_tmp6_ = output;
		_tmp7_ = strlen (_tmp6_);
		_tmp8_ = _tmp7_;
		if (_tmp8_ > 0) {
			KkcRomKanaCharacterList* _tmp9_;
			const gchar* _tmp10_;
			gchar* _tmp11_;
			GString* _tmp12_;
			const gchar* _tmp13_;
			gchar* _tmp14_;
			KkcRomKanaCharacter _tmp15_ = {0};
			KkcRomKanaCharacter _tmp16_;
			GString* _tmp17_;
			GString* _tmp18_;
			KkcRomKanaMapFile* _tmp19_;
			KkcRomKanaMapFile* _tmp20_;
			KkcRomKanaNode* _tmp21_;
			KkcRomKanaNode* _tmp22_;
			_tmp9_ = self->priv->_produced;
			_tmp10_ = output;
			_tmp11_ = g_strdup (_tmp10_);
			_tmp12_ = self->priv->_pending_input;
			_tmp13_ = _tmp12_->str;
			_tmp14_ = g_strdup (_tmp13_);
			memset (&_tmp15_, 0, sizeof (KkcRomKanaCharacter));
			_g_free0 (_tmp15_.output);
			_tmp15_.output = _tmp11_;
			_g_free0 (_tmp15_.input);
			_tmp15_.input = _tmp14_;
			_tmp16_ = _tmp15_;
			kkc_rom_kana_character_list_add (_tmp9_, &_tmp16_);
			kkc_rom_kana_character_destroy (&_tmp16_);
			_tmp17_ = self->priv->_pending_input;
			g_string_erase (_tmp17_, (gssize) 0, (gssize) -1);
			_tmp18_ = self->priv->_pending_output;
			g_string_erase (_tmp18_, (gssize) 0, (gssize) -1);
			_tmp19_ = kkc_rom_kana_converter_get_rule (self);
			_tmp20_ = _tmp19_;
			_tmp21_ = _tmp20_->root_node;
			_tmp22_ = _g_object_ref0 (_tmp21_);
			_g_object_unref0 (self->priv->current_node);
			self->priv->current_node = _tmp22_;
			result = TRUE;
			_g_free0 (output);
			return result;
		}
		_g_free0 (output);
	}
	_tmp24_ = self->priv->_auto_correct;
	if (!_tmp24_) {
		gboolean _tmp25_ = FALSE;
		GString* _tmp26_;
		gssize _tmp27_;
		_tmp26_ = self->priv->_pending_output;
		_tmp27_ = _tmp26_->len;
		if (_tmp27_ > ((gssize) 0)) {
			_tmp25_ = TRUE;
		} else {
			GString* _tmp28_;
			gssize _tmp29_;
			_tmp28_ = self->priv->_pending_input;
			_tmp29_ = _tmp28_->len;
			_tmp25_ = _tmp29_ > ((gssize) 0);
		}
		_tmp23_ = _tmp25_;
	} else {
		_tmp23_ = FALSE;
	}
	if (_tmp23_) {
		GString* _tmp30_;
		gssize _tmp31_;
		GString* _tmp61_;
		GString* _tmp62_;
		KkcRomKanaMapFile* _tmp63_;
		KkcRomKanaMapFile* _tmp64_;
		KkcRomKanaNode* _tmp65_;
		KkcRomKanaNode* _tmp66_;
		_tmp30_ = self->priv->_pending_output;
		_tmp31_ = _tmp30_->len;
		if (_tmp31_ > ((gssize) 0)) {
			KkcRomKanaCharacterList* _tmp32_;
			GString* _tmp33_;
			const gchar* _tmp34_;
			gchar* _tmp35_;
			GString* _tmp36_;
			const gchar* _tmp37_;
			gchar* _tmp38_;
			KkcRomKanaCharacter _tmp39_ = {0};
			KkcRomKanaCharacter _tmp40_;
			_tmp32_ = self->priv->_produced;
			_tmp33_ = self->priv->_pending_output;
			_tmp34_ = _tmp33_->str;
			_tmp35_ = g_strdup (_tmp34_);
			_tmp36_ = self->priv->_pending_input;
			_tmp37_ = _tmp36_->str;
			_tmp38_ = g_strdup (_tmp37_);
			memset (&_tmp39_, 0, sizeof (KkcRomKanaCharacter));
			_g_free0 (_tmp39_.output);
			_tmp39_.output = _tmp35_;
			_g_free0 (_tmp39_.input);
			_tmp39_.input = _tmp38_;
			_tmp40_ = _tmp39_;
			kkc_rom_kana_character_list_add (_tmp32_, &_tmp40_);
			kkc_rom_kana_character_destroy (&_tmp40_);
		} else {
			GString* _tmp41_;
			gssize _tmp42_;
			_tmp41_ = self->priv->_pending_input;
			_tmp42_ = _tmp41_->len;
			if (_tmp42_ > ((gssize) 0)) {
				{
					gint i = 0;
					i = 0;
					{
						gboolean _tmp43_ = FALSE;
						_tmp43_ = TRUE;
						while (TRUE) {
							gint _tmp45_;
							GString* _tmp46_;
							gssize _tmp47_;
							KkcRomKanaCharacterList* _tmp48_;
							GString* _tmp49_;
							const gchar* _tmp50_;
							gint _tmp51_;
							gchar _tmp52_;
							gchar* _tmp53_;
							GString* _tmp54_;
							const gchar* _tmp55_;
							gint _tmp56_;
							gchar _tmp57_;
							gchar* _tmp58_;
							KkcRomKanaCharacter _tmp59_ = {0};
							KkcRomKanaCharacter _tmp60_;
							if (!_tmp43_) {
								gint _tmp44_;
								_tmp44_ = i;
								i = _tmp44_ + 1;
							}
							_tmp43_ = FALSE;
							_tmp45_ = i;
							_tmp46_ = self->priv->_pending_input;
							_tmp47_ = _tmp46_->len;
							if (!(((gssize) _tmp45_) < _tmp47_)) {
								break;
							}
							_tmp48_ = self->priv->_produced;
							_tmp49_ = self->priv->_pending_input;
							_tmp50_ = _tmp49_->str;
							_tmp51_ = i;
							_tmp52_ = string_get (_tmp50_, (glong) _tmp51_);
							_tmp53_ = g_strdup_printf ("%c", _tmp52_);
							_tmp54_ = self->priv->_pending_input;
							_tmp55_ = _tmp54_->str;
							_tmp56_ = i;
							_tmp57_ = string_get (_tmp55_, (glong) _tmp56_);
							_tmp58_ = g_strdup_printf ("%c", _tmp57_);
							memset (&_tmp59_, 0, sizeof (KkcRomKanaCharacter));
							_g_free0 (_tmp59_.output);
							_tmp59_.output = _tmp53_;
							_g_free0 (_tmp59_.input);
							_tmp59_.input = _tmp58_;
							_tmp60_ = _tmp59_;
							kkc_rom_kana_character_list_add (_tmp48_, &_tmp60_);
							kkc_rom_kana_character_destroy (&_tmp60_);
						}
					}
				}
			}
		}
		_tmp61_ = self->priv->_pending_input;
		g_string_erase (_tmp61_, (gssize) 0, (gssize) -1);
		_tmp62_ = self->priv->_pending_output;
		g_string_erase (_tmp62_, (gssize) 0, (gssize) -1);
		_tmp63_ = kkc_rom_kana_converter_get_rule (self);
		_tmp64_ = _tmp63_;
		_tmp65_ = _tmp64_->root_node;
		_tmp66_ = _g_object_ref0 (_tmp65_);
		_g_object_unref0 (self->priv->current_node);
		self->priv->current_node = _tmp66_;
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


/**
         * Append text to the internal buffer.
         *
         * @param text a string
         */
void kkc_rom_kana_converter_append_text (KkcRomKanaConverter* self, const gchar* text) {
	gint index = 0;
	gunichar c = 0U;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	index = 0;
	while (TRUE) {
		const gchar* _tmp0_;
		gunichar _tmp1_ = 0U;
		gboolean _tmp2_;
		gunichar _tmp3_;
		_tmp0_ = text;
		_tmp2_ = string_get_next_char (_tmp0_, &index, &_tmp1_);
		c = _tmp1_;
		if (!_tmp2_) {
			break;
		}
		_tmp3_ = c;
		kkc_rom_kana_converter_append (self, _tmp3_);
	}
}


static gint string_index_of_nth_char (const gchar* self, glong c) {
	gint result = 0;
	glong _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = c;
	_tmp1_ = g_utf8_offset_to_pointer (self, _tmp0_);
	result = (gint) (_tmp1_ - ((gchar*) self));
	return result;
}


static gunichar string_get_char (const gchar* self, glong index) {
	gunichar result = 0U;
	glong _tmp0_;
	gunichar _tmp1_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = index;
	_tmp1_ = g_utf8_get_char (((gchar*) self) + _tmp0_);
	result = _tmp1_;
	return result;
}


static gchar* g_unichar_to_string (gunichar self) {
	gchar* result = NULL;
	gchar* str = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	_tmp0_ = g_new0 (gchar, 7);
	str = (gchar*) _tmp0_;
	_tmp1_ = str;
	g_unichar_to_utf8 (self, _tmp1_);
	result = str;
	return result;
}


static gboolean kkc_rom_kana_converter_append_punctuation (KkcRomKanaConverter* self, gunichar uc) {
	gboolean result = FALSE;
	gint index = 0;
	gunichar _tmp0_;
	gboolean _tmp1_;
	gint _tmp16_;
	g_return_val_if_fail (self != NULL, FALSE);
	index = -1;
	_tmp0_ = uc;
	_tmp1_ = kkc_rom_kana_converter_is_valid (self, _tmp0_);
	if (_tmp1_) {
		KkcRomKanaNode* node = NULL;
		KkcRomKanaNode* _tmp2_;
		gunichar _tmp3_;
		KkcRomKanaNode* _tmp4_;
		KkcRomKanaNode* _tmp5_;
		gboolean _tmp6_ = FALSE;
		KkcRomKanaNode* _tmp7_;
		_tmp2_ = self->priv->current_node;
		_tmp3_ = uc;
		_tmp4_ = _tmp2_->children[_tmp3_];
		_tmp5_ = _g_object_ref0 (_tmp4_);
		node = _tmp5_;
		_tmp7_ = node;
		if (_tmp7_ != NULL) {
			KkcRomKanaNode* _tmp8_;
			KkcRomKanaEntry* _tmp9_;
			_tmp8_ = node;
			_tmp9_ = _tmp8_->entry;
			_tmp6_ = _tmp9_ != NULL;
		} else {
			_tmp6_ = FALSE;
		}
		if (_tmp6_) {
			KkcRomKanaNode* _tmp10_;
			KkcRomKanaEntry* _tmp11_;
			const gchar* _tmp12_;
			_tmp10_ = node;
			_tmp11_ = _tmp10_->entry;
			_tmp12_ = (*_tmp11_).hiragana;
			if (g_strcmp0 (_tmp12_, "。") == 0) {
				index = 0;
			} else {
				KkcRomKanaNode* _tmp13_;
				KkcRomKanaEntry* _tmp14_;
				const gchar* _tmp15_;
				_tmp13_ = node;
				_tmp14_ = _tmp13_->entry;
				_tmp15_ = (*_tmp14_).hiragana;
				if (g_strcmp0 (_tmp15_, "、") == 0) {
					index = 1;
				}
			}
		}
		_g_object_unref0 (node);
	}
	_tmp16_ = index;
	if (_tmp16_ >= 0) {
		KkcRomKanaNode* _tmp17_;
		KkcRomKanaEntry* _tmp18_;
		KkcPunctuationStyle _tmp28_;
		const gchar* _tmp29_;
		gint _tmp30_;
		gint _tmp31_;
		gunichar punctuation = 0U;
		KkcPunctuationStyle _tmp32_;
		const gchar* _tmp33_;
		gint _tmp34_;
		gunichar _tmp35_;
		KkcRomKanaCharacterList* _tmp36_;
		gunichar _tmp37_;
		gchar* _tmp38_;
		gunichar _tmp39_;
		gchar* _tmp40_;
		KkcRomKanaCharacter _tmp41_ = {0};
		KkcRomKanaCharacter _tmp42_;
		GString* _tmp43_;
		GString* _tmp44_;
		KkcRomKanaMapFile* _tmp45_;
		KkcRomKanaMapFile* _tmp46_;
		KkcRomKanaNode* _tmp47_;
		KkcRomKanaNode* _tmp48_;
		_tmp17_ = self->priv->current_node;
		_tmp18_ = _tmp17_->entry;
		if (_tmp18_ != NULL) {
			KkcRomKanaCharacterList* _tmp19_;
			GString* _tmp20_;
			const gchar* _tmp21_;
			gchar* _tmp22_;
			GString* _tmp23_;
			const gchar* _tmp24_;
			gchar* _tmp25_;
			KkcRomKanaCharacter _tmp26_ = {0};
			KkcRomKanaCharacter _tmp27_;
			_tmp19_ = self->priv->_produced;
			_tmp20_ = self->priv->_pending_output;
			_tmp21_ = _tmp20_->str;
			_tmp22_ = g_strdup (_tmp21_);
			_tmp23_ = self->priv->_pending_input;
			_tmp24_ = _tmp23_->str;
			_tmp25_ = g_strdup (_tmp24_);
			memset (&_tmp26_, 0, sizeof (KkcRomKanaCharacter));
			_g_free0 (_tmp26_.output);
			_tmp26_.output = _tmp22_;
			_g_free0 (_tmp26_.input);
			_tmp26_.input = _tmp25_;
			_tmp27_ = _tmp26_;
			kkc_rom_kana_character_list_add (_tmp19_, &_tmp27_);
			kkc_rom_kana_character_destroy (&_tmp27_);
		}
		_tmp28_ = self->priv->_punctuation_style;
		_tmp29_ = KKC_PUNCTUATION_RULE[_tmp28_];
		_tmp30_ = index;
		_tmp31_ = string_index_of_nth_char (_tmp29_, (glong) _tmp30_);
		index = _tmp31_;
		_tmp32_ = self->priv->_punctuation_style;
		_tmp33_ = KKC_PUNCTUATION_RULE[_tmp32_];
		_tmp34_ = index;
		_tmp35_ = string_get_char (_tmp33_, (glong) _tmp34_);
		punctuation = _tmp35_;
		_tmp36_ = self->priv->_produced;
		_tmp37_ = punctuation;
		_tmp38_ = g_unichar_to_string (_tmp37_);
		_tmp39_ = uc;
		_tmp40_ = g_unichar_to_string (_tmp39_);
		memset (&_tmp41_, 0, sizeof (KkcRomKanaCharacter));
		_g_free0 (_tmp41_.output);
		_tmp41_.output = _tmp38_;
		_g_free0 (_tmp41_.input);
		_tmp41_.input = _tmp40_;
		_tmp42_ = _tmp41_;
		kkc_rom_kana_character_list_add (_tmp36_, &_tmp42_);
		kkc_rom_kana_character_destroy (&_tmp42_);
		_tmp43_ = self->priv->_pending_input;
		g_string_erase (_tmp43_, (gssize) 0, (gssize) -1);
		_tmp44_ = self->priv->_pending_output;
		g_string_erase (_tmp44_, (gssize) 0, (gssize) -1);
		_tmp45_ = kkc_rom_kana_converter_get_rule (self);
		_tmp46_ = _tmp45_;
		_tmp47_ = _tmp46_->root_node;
		_tmp48_ = _g_object_ref0 (_tmp47_);
		_g_object_unref0 (self->priv->current_node);
		self->priv->current_node = _tmp48_;
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


/**
         * Append a character to the internal buffer.
         *
         * @param uc an ASCII character
         *
         * @return `true` if the character is handled, `false` otherwise
         */
gboolean kkc_rom_kana_converter_append (KkcRomKanaConverter* self, gunichar uc) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	KkcKanaMode _tmp1_;
	KkcRomKanaNode* child_node = NULL;
	KkcRomKanaNode* _tmp15_;
	gunichar _tmp16_;
	KkcRomKanaNode* _tmp17_;
	KkcRomKanaNode* _tmp18_;
	KkcRomKanaNode* _tmp19_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->_kana_mode;
	if (_tmp1_ == KKC_KANA_MODE_LATIN) {
		_tmp0_ = TRUE;
	} else {
		KkcKanaMode _tmp2_;
		_tmp2_ = self->priv->_kana_mode;
		_tmp0_ = _tmp2_ == KKC_KANA_MODE_WIDE_LATIN;
	}
	if (_tmp0_) {
		gchar* input = NULL;
		gunichar _tmp3_;
		gchar* _tmp4_;
		gchar* output = NULL;
		const gchar* _tmp5_;
		KkcKanaMode _tmp6_;
		gchar* _tmp7_;
		KkcRomKanaCharacterList* _tmp8_;
		const gchar* _tmp9_;
		gchar* _tmp10_;
		const gchar* _tmp11_;
		gchar* _tmp12_;
		KkcRomKanaCharacter _tmp13_ = {0};
		KkcRomKanaCharacter _tmp14_;
		_tmp3_ = uc;
		_tmp4_ = g_unichar_to_string (_tmp3_);
		input = _tmp4_;
		_tmp5_ = input;
		_tmp6_ = self->priv->_kana_mode;
		_tmp7_ = kkc_rom_kana_utils_convert_by_kana_mode (_tmp5_, _tmp6_);
		output = _tmp7_;
		_tmp8_ = self->priv->_produced;
		_tmp9_ = output;
		_tmp10_ = g_strdup (_tmp9_);
		_tmp11_ = input;
		_tmp12_ = g_strdup (_tmp11_);
		memset (&_tmp13_, 0, sizeof (KkcRomKanaCharacter));
		_g_free0 (_tmp13_.output);
		_tmp13_.output = _tmp10_;
		_g_free0 (_tmp13_.input);
		_tmp13_.input = _tmp12_;
		_tmp14_ = _tmp13_;
		kkc_rom_kana_character_list_add (_tmp8_, &_tmp14_);
		kkc_rom_kana_character_destroy (&_tmp14_);
		result = TRUE;
		_g_free0 (output);
		_g_free0 (input);
		return result;
	}
	_tmp15_ = self->priv->current_node;
	_tmp16_ = uc;
	_tmp17_ = _tmp15_->children[_tmp16_];
	_tmp18_ = _g_object_ref0 (_tmp17_);
	child_node = _tmp18_;
	_tmp19_ = child_node;
	if (_tmp19_ == NULL) {
		gboolean retval = FALSE;
		gboolean _tmp20_;
		gunichar _tmp21_;
		gboolean _tmp22_;
		_tmp20_ = kkc_rom_kana_converter_flush_partial (self);
		retval = _tmp20_;
		_tmp21_ = uc;
		_tmp22_ = kkc_rom_kana_converter_append_punctuation (self, _tmp21_);
		if (_tmp22_) {
			result = TRUE;
			_g_object_unref0 (child_node);
			return result;
		} else {
			KkcRomKanaMapFile* _tmp23_;
			KkcRomKanaMapFile* _tmp24_;
			KkcRomKanaNode* _tmp25_;
			gunichar _tmp26_;
			KkcRomKanaNode* _tmp27_;
			_tmp23_ = kkc_rom_kana_converter_get_rule (self);
			_tmp24_ = _tmp23_;
			_tmp25_ = _tmp24_->root_node;
			_tmp26_ = uc;
			_tmp27_ = _tmp25_->children[_tmp26_];
			if (_tmp27_ == NULL) {
				GString* _tmp28_;
				GString* _tmp29_;
				KkcRomKanaMapFile* _tmp30_;
				KkcRomKanaMapFile* _tmp31_;
				KkcRomKanaNode* _tmp32_;
				KkcRomKanaNode* _tmp33_;
				_tmp28_ = self->priv->_pending_input;
				g_string_erase (_tmp28_, (gssize) 0, (gssize) -1);
				_tmp29_ = self->priv->_pending_output;
				g_string_erase (_tmp29_, (gssize) 0, (gssize) -1);
				_tmp30_ = kkc_rom_kana_converter_get_rule (self);
				_tmp31_ = _tmp30_;
				_tmp32_ = _tmp31_->root_node;
				_tmp33_ = _g_object_ref0 (_tmp32_);
				_g_object_unref0 (self->priv->current_node);
				self->priv->current_node = _tmp33_;
				result = retval;
				_g_object_unref0 (child_node);
				return result;
			} else {
				KkcRomKanaNode* _tmp34_;
				KkcRomKanaEntry* _tmp35_;
				_tmp34_ = self->priv->current_node;
				_tmp35_ = _tmp34_->entry;
				if (_tmp35_ != NULL) {
					KkcRomKanaCharacterList* _tmp36_;
					GString* _tmp37_;
					const gchar* _tmp38_;
					gchar* _tmp39_;
					GString* _tmp40_;
					const gchar* _tmp41_;
					gchar* _tmp42_;
					KkcRomKanaCharacter _tmp43_ = {0};
					KkcRomKanaCharacter _tmp44_;
					GString* _tmp45_;
					GString* _tmp46_;
					KkcRomKanaMapFile* _tmp47_;
					KkcRomKanaMapFile* _tmp48_;
					KkcRomKanaNode* _tmp49_;
					KkcRomKanaNode* _tmp50_;
					gunichar _tmp51_;
					gboolean _tmp52_;
					_tmp36_ = self->priv->_produced;
					_tmp37_ = self->priv->_pending_output;
					_tmp38_ = _tmp37_->str;
					_tmp39_ = g_strdup (_tmp38_);
					_tmp40_ = self->priv->_pending_input;
					_tmp41_ = _tmp40_->str;
					_tmp42_ = g_strdup (_tmp41_);
					memset (&_tmp43_, 0, sizeof (KkcRomKanaCharacter));
					_g_free0 (_tmp43_.output);
					_tmp43_.output = _tmp39_;
					_g_free0 (_tmp43_.input);
					_tmp43_.input = _tmp42_;
					_tmp44_ = _tmp43_;
					kkc_rom_kana_character_list_add (_tmp36_, &_tmp44_);
					kkc_rom_kana_character_destroy (&_tmp44_);
					_tmp45_ = self->priv->_pending_input;
					g_string_erase (_tmp45_, (gssize) 0, (gssize) -1);
					_tmp46_ = self->priv->_pending_output;
					g_string_erase (_tmp46_, (gssize) 0, (gssize) -1);
					_tmp47_ = kkc_rom_kana_converter_get_rule (self);
					_tmp48_ = _tmp47_;
					_tmp49_ = _tmp48_->root_node;
					_tmp50_ = _g_object_ref0 (_tmp49_);
					_g_object_unref0 (self->priv->current_node);
					self->priv->current_node = _tmp50_;
					_tmp51_ = uc;
					_tmp52_ = kkc_rom_kana_converter_append (self, _tmp51_);
					result = _tmp52_;
					_g_object_unref0 (child_node);
					return result;
				} else {
					gboolean _tmp53_;
					_tmp53_ = self->priv->_auto_correct;
					if (_tmp53_) {
						GString* _tmp54_;
						GString* _tmp55_;
						KkcRomKanaMapFile* _tmp56_;
						KkcRomKanaMapFile* _tmp57_;
						KkcRomKanaNode* _tmp58_;
						KkcRomKanaNode* _tmp59_;
						gunichar _tmp60_;
						gboolean _tmp61_;
						_tmp54_ = self->priv->_pending_input;
						g_string_erase (_tmp54_, (gssize) 0, (gssize) -1);
						_tmp55_ = self->priv->_pending_output;
						g_string_erase (_tmp55_, (gssize) 0, (gssize) -1);
						_tmp56_ = kkc_rom_kana_converter_get_rule (self);
						_tmp57_ = _tmp56_;
						_tmp58_ = _tmp57_->root_node;
						_tmp59_ = _g_object_ref0 (_tmp58_);
						_g_object_unref0 (self->priv->current_node);
						self->priv->current_node = _tmp59_;
						_tmp60_ = uc;
						_tmp61_ = kkc_rom_kana_converter_append (self, _tmp60_);
						result = _tmp61_;
						_g_object_unref0 (child_node);
						return result;
					} else {
						KkcRomKanaCharacterList* _tmp62_;
						GString* _tmp63_;
						const gchar* _tmp64_;
						gchar* _tmp65_;
						GString* _tmp66_;
						const gchar* _tmp67_;
						gchar* _tmp68_;
						KkcRomKanaCharacter _tmp69_ = {0};
						KkcRomKanaCharacter _tmp70_;
						GString* _tmp71_;
						GString* _tmp72_;
						KkcRomKanaMapFile* _tmp73_;
						KkcRomKanaMapFile* _tmp74_;
						KkcRomKanaNode* _tmp75_;
						KkcRomKanaNode* _tmp76_;
						gunichar _tmp77_;
						gboolean _tmp78_;
						_tmp62_ = self->priv->_produced;
						_tmp63_ = self->priv->_pending_output;
						_tmp64_ = _tmp63_->str;
						_tmp65_ = g_strdup (_tmp64_);
						_tmp66_ = self->priv->_pending_input;
						_tmp67_ = _tmp66_->str;
						_tmp68_ = g_strdup (_tmp67_);
						memset (&_tmp69_, 0, sizeof (KkcRomKanaCharacter));
						_g_free0 (_tmp69_.output);
						_tmp69_.output = _tmp65_;
						_g_free0 (_tmp69_.input);
						_tmp69_.input = _tmp68_;
						_tmp70_ = _tmp69_;
						kkc_rom_kana_character_list_add (_tmp62_, &_tmp70_);
						kkc_rom_kana_character_destroy (&_tmp70_);
						_tmp71_ = self->priv->_pending_input;
						g_string_erase (_tmp71_, (gssize) 0, (gssize) -1);
						_tmp72_ = self->priv->_pending_output;
						g_string_erase (_tmp72_, (gssize) 0, (gssize) -1);
						_tmp73_ = kkc_rom_kana_converter_get_rule (self);
						_tmp74_ = _tmp73_;
						_tmp75_ = _tmp74_->root_node;
						_tmp76_ = _g_object_ref0 (_tmp75_);
						_g_object_unref0 (self->priv->current_node);
						self->priv->current_node = _tmp76_;
						_tmp77_ = uc;
						_tmp78_ = kkc_rom_kana_converter_append (self, _tmp77_);
						result = _tmp78_;
						_g_object_unref0 (child_node);
						return result;
					}
				}
			}
		}
	} else {
		KkcRomKanaNode* _tmp79_;
		guint _tmp80_;
		_tmp79_ = child_node;
		_tmp80_ = _tmp79_->n_children;
		if (_tmp80_ > ((guint) 0)) {
			KkcRomKanaNode* _tmp81_;
			KkcRomKanaEntry* _tmp82_;
			KkcRomKanaNode* _tmp95_;
			KkcRomKanaNode* _tmp96_;
			_tmp81_ = child_node;
			_tmp82_ = _tmp81_->entry;
			if (_tmp82_ != NULL) {
				GString* _tmp83_;
				gunichar _tmp84_;
				GString* _tmp85_;
				KkcRomKanaNode* _tmp86_;
				KkcRomKanaEntry* _tmp87_;
				KkcKanaMode _tmp88_;
				gchar* _tmp89_;
				gchar* _tmp90_;
				_tmp83_ = self->priv->_pending_input;
				_tmp84_ = uc;
				g_string_append_unichar (_tmp83_, _tmp84_);
				_tmp85_ = self->priv->_pending_output;
				_tmp86_ = child_node;
				_tmp87_ = _tmp86_->entry;
				_tmp88_ = self->priv->_kana_mode;
				_tmp89_ = kkc_rom_kana_entry_get_kana (_tmp87_, _tmp88_, FALSE);
				_tmp90_ = _tmp89_;
				g_string_append (_tmp85_, _tmp90_);
				_g_free0 (_tmp90_);
			} else {
				GString* _tmp91_;
				gunichar _tmp92_;
				GString* _tmp93_;
				gunichar _tmp94_;
				_tmp91_ = self->priv->_pending_input;
				_tmp92_ = uc;
				g_string_append_unichar (_tmp91_, _tmp92_);
				_tmp93_ = self->priv->_pending_output;
				_tmp94_ = uc;
				g_string_append_unichar (_tmp93_, _tmp94_);
			}
			_tmp95_ = child_node;
			_tmp96_ = _g_object_ref0 (_tmp95_);
			_g_object_unref0 (self->priv->current_node);
			self->priv->current_node = _tmp96_;
			result = TRUE;
			_g_object_unref0 (child_node);
			return result;
		} else {
			gunichar _tmp97_;
			gboolean _tmp98_;
			GString* _tmp99_;
			gunichar _tmp100_;
			KkcRomKanaCharacterList* _tmp101_;
			KkcRomKanaNode* _tmp102_;
			KkcRomKanaEntry* _tmp103_;
			KkcKanaMode _tmp104_;
			gchar* _tmp105_;
			GString* _tmp106_;
			const gchar* _tmp107_;
			gchar* _tmp108_;
			KkcRomKanaCharacter _tmp109_ = {0};
			KkcRomKanaCharacter _tmp110_;
			GString* _tmp111_;
			GString* _tmp112_;
			KkcRomKanaMapFile* _tmp113_;
			KkcRomKanaMapFile* _tmp114_;
			KkcRomKanaNode* _tmp115_;
			KkcRomKanaNode* _tmp116_;
			_tmp97_ = uc;
			_tmp98_ = kkc_rom_kana_converter_append_punctuation (self, _tmp97_);
			if (_tmp98_) {
				result = TRUE;
				_g_object_unref0 (child_node);
				return result;
			}
			_tmp99_ = self->priv->_pending_input;
			_tmp100_ = uc;
			g_string_append_unichar (_tmp99_, _tmp100_);
			_tmp101_ = self->priv->_produced;
			_tmp102_ = child_node;
			_tmp103_ = _tmp102_->entry;
			_tmp104_ = self->priv->_kana_mode;
			_tmp105_ = kkc_rom_kana_entry_get_kana (_tmp103_, _tmp104_, FALSE);
			_tmp106_ = self->priv->_pending_input;
			_tmp107_ = _tmp106_->str;
			_tmp108_ = g_strdup (_tmp107_);
			memset (&_tmp109_, 0, sizeof (KkcRomKanaCharacter));
			_g_free0 (_tmp109_.output);
			_tmp109_.output = _tmp105_;
			_g_free0 (_tmp109_.input);
			_tmp109_.input = _tmp108_;
			_tmp110_ = _tmp109_;
			kkc_rom_kana_character_list_add (_tmp101_, &_tmp110_);
			kkc_rom_kana_character_destroy (&_tmp110_);
			_tmp111_ = self->priv->_pending_input;
			g_string_erase (_tmp111_, (gssize) 0, (gssize) -1);
			_tmp112_ = self->priv->_pending_output;
			g_string_erase (_tmp112_, (gssize) 0, (gssize) -1);
			_tmp113_ = kkc_rom_kana_converter_get_rule (self);
			_tmp114_ = _tmp113_;
			_tmp115_ = _tmp114_->root_node;
			_tmp116_ = _g_object_ref0 (_tmp115_);
			_g_object_unref0 (self->priv->current_node);
			self->priv->current_node = _tmp116_;
			{
				gint i = 0;
				i = 0;
				{
					gboolean _tmp117_ = FALSE;
					_tmp117_ = TRUE;
					while (TRUE) {
						gint _tmp119_;
						KkcRomKanaNode* _tmp120_;
						KkcRomKanaEntry* _tmp121_;
						const gchar* _tmp122_;
						gint _tmp123_;
						gint _tmp124_;
						KkcRomKanaNode* _tmp125_;
						KkcRomKanaEntry* _tmp126_;
						const gchar* _tmp127_;
						gint _tmp128_;
						gchar _tmp129_;
						if (!_tmp117_) {
							gint _tmp118_;
							_tmp118_ = i;
							i = _tmp118_ + 1;
						}
						_tmp117_ = FALSE;
						_tmp119_ = i;
						_tmp120_ = child_node;
						_tmp121_ = _tmp120_->entry;
						_tmp122_ = (*_tmp121_).carryover;
						_tmp123_ = strlen (_tmp122_);
						_tmp124_ = _tmp123_;
						if (!(_tmp119_ < _tmp124_)) {
							break;
						}
						_tmp125_ = child_node;
						_tmp126_ = _tmp125_->entry;
						_tmp127_ = (*_tmp126_).carryover;
						_tmp128_ = i;
						_tmp129_ = string_get (_tmp127_, (glong) _tmp128_);
						kkc_rom_kana_converter_append (self, (gunichar) _tmp129_);
					}
				}
			}
			result = TRUE;
			_g_object_unref0 (child_node);
			return result;
		}
	}
	_g_object_unref0 (child_node);
}


/**
         * Check if a character will be consumed by the current conversion.
         *
         * @param uc an ASCII character
         * @param no_carryover return false if there will be carryover
         *
         * @return `true` if the character can be consumed
         */
gboolean kkc_rom_kana_converter_can_consume (KkcRomKanaConverter* self, gunichar uc, gboolean no_carryover) {
	gboolean result = FALSE;
	KkcRomKanaNode* child_node = NULL;
	KkcRomKanaNode* _tmp0_;
	gunichar _tmp1_;
	KkcRomKanaNode* _tmp2_;
	KkcRomKanaNode* _tmp3_;
	KkcRomKanaNode* _tmp4_;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->current_node;
	_tmp1_ = uc;
	_tmp2_ = _tmp0_->children[_tmp1_];
	_tmp3_ = _g_object_ref0 (_tmp2_);
	child_node = _tmp3_;
	_tmp4_ = child_node;
	if (_tmp4_ == NULL) {
		result = FALSE;
		_g_object_unref0 (child_node);
		return result;
	}
	_tmp7_ = no_carryover;
	if (_tmp7_) {
		KkcRomKanaNode* _tmp8_;
		KkcRomKanaEntry* _tmp9_;
		_tmp8_ = child_node;
		_tmp9_ = _tmp8_->entry;
		_tmp6_ = _tmp9_ != NULL;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		KkcRomKanaNode* _tmp10_;
		KkcRomKanaEntry* _tmp11_;
		const gchar* _tmp12_;
		_tmp10_ = child_node;
		_tmp11_ = _tmp10_->entry;
		_tmp12_ = (*_tmp11_).carryover;
		_tmp5_ = g_strcmp0 (_tmp12_, "") != 0;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		result = FALSE;
		_g_object_unref0 (child_node);
		return result;
	}
	result = TRUE;
	_g_object_unref0 (child_node);
	return result;
}


/**
         * Reset the internal state of the converter.
         */
void kkc_rom_kana_converter_reset (KkcRomKanaConverter* self) {
	KkcRomKanaCharacterList* _tmp0_;
	GString* _tmp1_;
	GString* _tmp2_;
	KkcRomKanaMapFile* _tmp3_;
	KkcRomKanaMapFile* _tmp4_;
	KkcRomKanaNode* _tmp5_;
	KkcRomKanaNode* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_produced;
	kkc_rom_kana_character_list_clear (_tmp0_);
	_tmp1_ = self->priv->_pending_input;
	g_string_erase (_tmp1_, (gssize) 0, (gssize) -1);
	_tmp2_ = self->priv->_pending_output;
	g_string_erase (_tmp2_, (gssize) 0, (gssize) -1);
	_tmp3_ = kkc_rom_kana_converter_get_rule (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_->root_node;
	_tmp6_ = _g_object_ref0 (_tmp5_);
	_g_object_unref0 (self->priv->current_node);
	self->priv->current_node = _tmp6_;
}


/**
         * Delete the trailing character from the internal buffer.
         *
         * @return `true` if any character is removed, `false` otherwise
         */
gboolean kkc_rom_kana_converter_delete (KkcRomKanaConverter* self) {
	gboolean result = FALSE;
	GString* _tmp0_;
	gssize _tmp1_;
	KkcRomKanaCharacterList* _tmp24_;
	gint _tmp25_;
	gint _tmp26_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_pending_output;
	_tmp1_ = _tmp0_->len;
	if (_tmp1_ > ((gssize) 0)) {
		KkcRomKanaNode* _tmp2_;
		KkcRomKanaNode* _tmp3_;
		KkcRomKanaNode* _tmp4_;
		KkcRomKanaNode* _tmp5_;
		GString* _tmp10_;
		GString* _tmp11_;
		const gchar* _tmp12_;
		GString* _tmp13_;
		const gchar* _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		GString* _tmp17_;
		GString* _tmp18_;
		const gchar* _tmp19_;
		GString* _tmp20_;
		const gchar* _tmp21_;
		gint _tmp22_;
		gint _tmp23_;
		_tmp2_ = self->priv->current_node;
		_tmp3_ = _tmp2_->parent;
		_tmp4_ = _g_object_ref0 (_tmp3_);
		_g_object_unref0 (self->priv->current_node);
		self->priv->current_node = _tmp4_;
		_tmp5_ = self->priv->current_node;
		if (_tmp5_ == NULL) {
			KkcRomKanaMapFile* _tmp6_;
			KkcRomKanaMapFile* _tmp7_;
			KkcRomKanaNode* _tmp8_;
			KkcRomKanaNode* _tmp9_;
			_tmp6_ = kkc_rom_kana_converter_get_rule (self);
			_tmp7_ = _tmp6_;
			_tmp8_ = _tmp7_->root_node;
			_tmp9_ = _g_object_ref0 (_tmp8_);
			_g_object_unref0 (self->priv->current_node);
			self->priv->current_node = _tmp9_;
		}
		_tmp10_ = self->priv->_pending_output;
		_tmp11_ = self->priv->_pending_output;
		_tmp12_ = _tmp11_->str;
		_tmp13_ = self->priv->_pending_output;
		_tmp14_ = _tmp13_->str;
		_tmp15_ = g_utf8_strlen (_tmp14_, (gssize) -1);
		_tmp16_ = string_index_of_nth_char (_tmp12_, (glong) (_tmp15_ - 1));
		g_string_truncate (_tmp10_, (gsize) _tmp16_);
		_tmp17_ = self->priv->_pending_input;
		_tmp18_ = self->priv->_pending_input;
		_tmp19_ = _tmp18_->str;
		_tmp20_ = self->priv->_pending_input;
		_tmp21_ = _tmp20_->str;
		_tmp22_ = g_utf8_strlen (_tmp21_, (gssize) -1);
		_tmp23_ = string_index_of_nth_char (_tmp19_, (glong) (_tmp22_ - 1));
		g_string_truncate (_tmp17_, (gsize) _tmp23_);
		result = TRUE;
		return result;
	}
	_tmp24_ = self->priv->_produced;
	_tmp25_ = kkc_rom_kana_character_list_get_size (_tmp24_);
	_tmp26_ = _tmp25_;
	if (_tmp26_ > 0) {
		KkcRomKanaCharacterList* _tmp27_;
		KkcRomKanaCharacterList* _tmp28_;
		gint _tmp29_;
		gint _tmp30_;
		_tmp27_ = self->priv->_produced;
		_tmp28_ = self->priv->_produced;
		_tmp29_ = kkc_rom_kana_character_list_get_size (_tmp28_);
		_tmp30_ = _tmp29_;
		kkc_rom_kana_character_list_remove_at (_tmp27_, _tmp30_ - 1);
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


KkcRomKanaMapFile* kkc_rom_kana_converter_get_rule (KkcRomKanaConverter* self) {
	KkcRomKanaMapFile* result;
	KkcRomKanaMapFile* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_rule;
	result = _tmp0_;
	return result;
}


void kkc_rom_kana_converter_set_rule (KkcRomKanaConverter* self, KkcRomKanaMapFile* value) {
	KkcRomKanaMapFile* _tmp0_;
	KkcRomKanaMapFile* _tmp1_;
	KkcRomKanaMapFile* _tmp2_;
	KkcRomKanaNode* _tmp3_;
	KkcRomKanaNode* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_rule);
	self->priv->_rule = _tmp1_;
	_tmp2_ = self->priv->_rule;
	_tmp3_ = _tmp2_->root_node;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (self->priv->current_node);
	self->priv->current_node = _tmp4_;
	g_object_notify_by_pspec ((GObject *) self, kkc_rom_kana_converter_properties[KKC_ROM_KANA_CONVERTER_RULE_PROPERTY]);
}


KkcKanaMode kkc_rom_kana_converter_get_kana_mode (KkcRomKanaConverter* self) {
	KkcKanaMode result;
	KkcKanaMode _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_kana_mode;
	result = _tmp0_;
	return result;
}


void kkc_rom_kana_converter_set_kana_mode (KkcRomKanaConverter* self, KkcKanaMode value) {
	g_return_if_fail (self != NULL);
	if (kkc_rom_kana_converter_get_kana_mode (self) != value) {
		KkcKanaMode _tmp0_;
		_tmp0_ = value;
		self->priv->_kana_mode = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, kkc_rom_kana_converter_properties[KKC_ROM_KANA_CONVERTER_KANA_MODE_PROPERTY]);
	}
}


KkcPunctuationStyle kkc_rom_kana_converter_get_punctuation_style (KkcRomKanaConverter* self) {
	KkcPunctuationStyle result;
	KkcPunctuationStyle _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_punctuation_style;
	result = _tmp0_;
	return result;
}


void kkc_rom_kana_converter_set_punctuation_style (KkcRomKanaConverter* self, KkcPunctuationStyle value) {
	g_return_if_fail (self != NULL);
	if (kkc_rom_kana_converter_get_punctuation_style (self) != value) {
		KkcPunctuationStyle _tmp0_;
		_tmp0_ = value;
		self->priv->_punctuation_style = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, kkc_rom_kana_converter_properties[KKC_ROM_KANA_CONVERTER_PUNCTUATION_STYLE_PROPERTY]);
	}
}


gboolean kkc_rom_kana_converter_get_auto_correct (KkcRomKanaConverter* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_auto_correct;
	result = _tmp0_;
	return result;
}


void kkc_rom_kana_converter_set_auto_correct (KkcRomKanaConverter* self, gboolean value) {
	g_return_if_fail (self != NULL);
	if (kkc_rom_kana_converter_get_auto_correct (self) != value) {
		gboolean _tmp0_;
		_tmp0_ = value;
		self->priv->_auto_correct = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, kkc_rom_kana_converter_properties[KKC_ROM_KANA_CONVERTER_AUTO_CORRECT_PROPERTY]);
	}
}


const gchar* kkc_rom_kana_converter_get_pending_output (KkcRomKanaConverter* self) {
	const gchar* result;
	GString* _tmp0_;
	const gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_pending_output;
	_tmp1_ = _tmp0_->str;
	result = _tmp1_;
	return result;
}


const gchar* kkc_rom_kana_converter_get_pending_input (KkcRomKanaConverter* self) {
	const gchar* result;
	GString* _tmp0_;
	const gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_pending_input;
	_tmp1_ = _tmp0_->str;
	result = _tmp1_;
	return result;
}


KkcRomKanaCharacterList* kkc_rom_kana_converter_get_produced (KkcRomKanaConverter* self) {
	KkcRomKanaCharacterList* result;
	KkcRomKanaCharacterList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_produced;
	result = _tmp0_;
	return result;
}


static void kkc_rom_kana_converter_class_init (KkcRomKanaConverterClass * klass) {
	kkc_rom_kana_converter_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (KkcRomKanaConverterPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_kkc_rom_kana_converter_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_kkc_rom_kana_converter_set_property;
	G_OBJECT_CLASS (klass)->finalize = kkc_rom_kana_converter_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), KKC_ROM_KANA_CONVERTER_RULE_PROPERTY, kkc_rom_kana_converter_properties[KKC_ROM_KANA_CONVERTER_RULE_PROPERTY] = g_param_spec_object ("rule", "rule", "rule", KKC_TYPE_ROM_KANA_MAP_FILE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	         * The current kana mode.
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), KKC_ROM_KANA_CONVERTER_KANA_MODE_PROPERTY, kkc_rom_kana_converter_properties[KKC_ROM_KANA_CONVERTER_KANA_MODE_PROPERTY] = g_param_spec_enum ("kana-mode", "kana-mode", "kana-mode", KKC_TYPE_KANA_MODE, KKC_KANA_MODE_HIRAGANA, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	         * The current punctuation style.
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), KKC_ROM_KANA_CONVERTER_PUNCTUATION_STYLE_PROPERTY, kkc_rom_kana_converter_properties[KKC_ROM_KANA_CONVERTER_PUNCTUATION_STYLE_PROPERTY] = g_param_spec_enum ("punctuation-style", "punctuation-style", "punctuation-style", KKC_TYPE_PUNCTUATION_STYLE, KKC_PUNCTUATION_STYLE_JA_JA, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	         * The current auto correct flag.
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), KKC_ROM_KANA_CONVERTER_AUTO_CORRECT_PROPERTY, kkc_rom_kana_converter_properties[KKC_ROM_KANA_CONVERTER_AUTO_CORRECT_PROPERTY] = g_param_spec_boolean ("auto-correct", "auto-correct", "auto-correct", TRUE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	         * The output being processed.
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), KKC_ROM_KANA_CONVERTER_PENDING_OUTPUT_PROPERTY, kkc_rom_kana_converter_properties[KKC_ROM_KANA_CONVERTER_PENDING_OUTPUT_PROPERTY] = g_param_spec_string ("pending-output", "pending-output", "pending-output", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	         * The input being processed.
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), KKC_ROM_KANA_CONVERTER_PENDING_INPUT_PROPERTY, kkc_rom_kana_converter_properties[KKC_ROM_KANA_CONVERTER_PENDING_INPUT_PROPERTY] = g_param_spec_string ("pending-input", "pending-input", "pending-input", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	         * A list of already processed characters.
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), KKC_ROM_KANA_CONVERTER_PRODUCED_PROPERTY, kkc_rom_kana_converter_properties[KKC_ROM_KANA_CONVERTER_PRODUCED_PROPERTY] = g_param_spec_object ("produced", "produced", "produced", KKC_TYPE_ROM_KANA_CHARACTER_LIST, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void kkc_rom_kana_converter_instance_init (KkcRomKanaConverter * self) {
	GString* _tmp0_;
	GString* _tmp1_;
	KkcRomKanaCharacterList* _tmp2_;
	self->priv = KKC_ROM_KANA_CONVERTER_GET_PRIVATE (self);
	self->priv->_kana_mode = KKC_KANA_MODE_HIRAGANA;
	self->priv->_punctuation_style = KKC_PUNCTUATION_STYLE_JA_JA;
	self->priv->_auto_correct = TRUE;
	_tmp0_ = g_string_new ("");
	self->priv->_pending_output = _tmp0_;
	_tmp1_ = g_string_new ("");
	self->priv->_pending_input = _tmp1_;
	_tmp2_ = kkc_rom_kana_character_list_new ();
	self->priv->_produced = _tmp2_;
}


static void kkc_rom_kana_converter_finalize (GObject * obj) {
	KkcRomKanaConverter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, KKC_TYPE_ROM_KANA_CONVERTER, KkcRomKanaConverter);
	_g_object_unref0 (self->priv->_rule);
	_g_object_unref0 (self->priv->current_node);
	_g_string_free0 (self->priv->_pending_output);
	_g_string_free0 (self->priv->_pending_input);
	_g_object_unref0 (self->priv->_produced);
	G_OBJECT_CLASS (kkc_rom_kana_converter_parent_class)->finalize (obj);
}


/**
     * Romaji-to-kana converter.
     */
GType kkc_rom_kana_converter_get_type (void) {
	static volatile gsize kkc_rom_kana_converter_type_id__volatile = 0;
	if (g_once_init_enter (&kkc_rom_kana_converter_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (KkcRomKanaConverterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) kkc_rom_kana_converter_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (KkcRomKanaConverter), 0, (GInstanceInitFunc) kkc_rom_kana_converter_instance_init, NULL };
		GType kkc_rom_kana_converter_type_id;
		kkc_rom_kana_converter_type_id = g_type_register_static (G_TYPE_OBJECT, "KkcRomKanaConverter", &g_define_type_info, 0);
		g_once_init_leave (&kkc_rom_kana_converter_type_id__volatile, kkc_rom_kana_converter_type_id);
	}
	return kkc_rom_kana_converter_type_id__volatile;
}


static void _vala_kkc_rom_kana_converter_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	KkcRomKanaConverter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, KKC_TYPE_ROM_KANA_CONVERTER, KkcRomKanaConverter);
	switch (property_id) {
		case KKC_ROM_KANA_CONVERTER_RULE_PROPERTY:
		g_value_set_object (value, kkc_rom_kana_converter_get_rule (self));
		break;
		case KKC_ROM_KANA_CONVERTER_KANA_MODE_PROPERTY:
		g_value_set_enum (value, kkc_rom_kana_converter_get_kana_mode (self));
		break;
		case KKC_ROM_KANA_CONVERTER_PUNCTUATION_STYLE_PROPERTY:
		g_value_set_enum (value, kkc_rom_kana_converter_get_punctuation_style (self));
		break;
		case KKC_ROM_KANA_CONVERTER_AUTO_CORRECT_PROPERTY:
		g_value_set_boolean (value, kkc_rom_kana_converter_get_auto_correct (self));
		break;
		case KKC_ROM_KANA_CONVERTER_PENDING_OUTPUT_PROPERTY:
		g_value_set_string (value, kkc_rom_kana_converter_get_pending_output (self));
		break;
		case KKC_ROM_KANA_CONVERTER_PENDING_INPUT_PROPERTY:
		g_value_set_string (value, kkc_rom_kana_converter_get_pending_input (self));
		break;
		case KKC_ROM_KANA_CONVERTER_PRODUCED_PROPERTY:
		g_value_set_object (value, kkc_rom_kana_converter_get_produced (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_kkc_rom_kana_converter_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	KkcRomKanaConverter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, KKC_TYPE_ROM_KANA_CONVERTER, KkcRomKanaConverter);
	switch (property_id) {
		case KKC_ROM_KANA_CONVERTER_RULE_PROPERTY:
		kkc_rom_kana_converter_set_rule (self, g_value_get_object (value));
		break;
		case KKC_ROM_KANA_CONVERTER_KANA_MODE_PROPERTY:
		kkc_rom_kana_converter_set_kana_mode (self, g_value_get_enum (value));
		break;
		case KKC_ROM_KANA_CONVERTER_PUNCTUATION_STYLE_PROPERTY:
		kkc_rom_kana_converter_set_punctuation_style (self, g_value_get_enum (value));
		break;
		case KKC_ROM_KANA_CONVERTER_AUTO_CORRECT_PROPERTY:
		kkc_rom_kana_converter_set_auto_correct (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



