/* MediaDialog.c generated by valac 0.38.7, the Vala compiler
 * generated from MediaDialog.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include "CbTweet.h"
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>
#include "CbMedia.h"
#include "CbMediaVideoWidget.h"
#include "CbMediaImageWidget.h"


#define TYPE_MEDIA_DIALOG (media_dialog_get_type ())
#define MEDIA_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_DIALOG, MediaDialog))
#define MEDIA_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_DIALOG, MediaDialogClass))
#define IS_MEDIA_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_DIALOG))
#define IS_MEDIA_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_DIALOG))
#define MEDIA_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_DIALOG, MediaDialogClass))

typedef struct _MediaDialog MediaDialog;
typedef struct _MediaDialogClass MediaDialogClass;
typedef struct _MediaDialogPrivate MediaDialogPrivate;
enum  {
	MEDIA_DIALOG_0_PROPERTY,
	MEDIA_DIALOG_NUM_PROPERTIES
};
static GParamSpec* media_dialog_properties[MEDIA_DIALOG_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _MediaDialog {
	GtkWindow parent_instance;
	MediaDialogPrivate * priv;
};

struct _MediaDialogClass {
	GtkWindowClass parent_class;
};

struct _MediaDialogPrivate {
	GtkFrame* frame;
	GtkRevealer* next_revealer;
	GtkRevealer* previous_revealer;
	CbTweet* tweet;
	gint cur_index;
	GtkGestureMultiPress* button_gesture;
	gdouble initial_px;
	gdouble initial_py;
};


static gpointer media_dialog_parent_class = NULL;

GType media_dialog_get_type (void) G_GNUC_CONST;
#define MEDIA_DIALOG_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_MEDIA_DIALOG, MediaDialogPrivate))
MediaDialog* media_dialog_new (CbTweet* tweet, gint start_media_index, gdouble px, gdouble py);
MediaDialog* media_dialog_construct (GType object_type, CbTweet* tweet, gint start_media_index, gdouble px, gdouble py);
static void media_dialog_button_released_cb (MediaDialog* self, gint n_press, gdouble x, gdouble y);
static void _media_dialog_button_released_cb_gtk_gesture_multi_press_released (GtkGestureMultiPress* _sender, gint p0, gdouble p1, gdouble p2, gpointer self);
static void media_dialog_change_media (MediaDialog* self, CbMedia* media);
static void media_dialog_next_media (MediaDialog* self);
static void media_dialog_previous_media (MediaDialog* self);
static gboolean media_dialog_key_press_event_cb (MediaDialog* self, GdkEventKey* evt);
static gboolean _media_dialog_key_press_event_cb_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self);
static void media_dialog_next_button_clicked_cb (MediaDialog* self);
static void _media_dialog_next_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void media_dialog_previous_button_clicked_cb (MediaDialog* self);
static void _media_dialog_previous_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static gboolean media_dialog_real_enter_notify_event (GtkWidget* base, GdkEventCrossing* event);
static gboolean media_dialog_real_leave_notify_event (GtkWidget* base, GdkEventCrossing* event);
static void media_dialog_finalize (GObject * obj);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _media_dialog_button_released_cb_gtk_gesture_multi_press_released (GtkGestureMultiPress* _sender, gint p0, gdouble p1, gdouble p2, gpointer self) {
	media_dialog_button_released_cb ((MediaDialog*) self, p0, p1, p2);
}


MediaDialog* media_dialog_construct (GType object_type, CbTweet* tweet, gint start_media_index, gdouble px, gdouble py) {
	MediaDialog * self = NULL;
	CbMedia* cur_media = NULL;
	CbTweet* _tmp0_;
	gint _tmp1_;
	CbMedia** _tmp2_;
	gint _tmp3_;
	CbMedia* _tmp4_;
	CbMedia* _tmp5_;
	CbTweet* _tmp6_;
	gint _tmp7_;
	GtkGestureMultiPress* _tmp8_;
	GtkGestureMultiPress* _tmp9_;
	GtkGestureMultiPress* _tmp10_;
	GtkGestureMultiPress* _tmp11_;
	gdouble _tmp12_;
	gdouble _tmp13_;
	CbTweet* _tmp14_;
	gint _tmp15_;
	CbMedia** _tmp16_;
	CbMedia* _tmp19_;
	g_return_val_if_fail (CB_IS_TWEET (tweet), NULL);
	self = (MediaDialog*) g_object_new (object_type, NULL);
	_tmp0_ = tweet;
	_tmp2_ = cb_tweet_get_medias (_tmp0_, &_tmp1_);
	_tmp3_ = start_media_index;
	_tmp4_ = _tmp2_[_tmp3_];
	_tmp5_ = _g_object_ref0 (_tmp4_);
	cur_media = _tmp5_;
	_tmp6_ = tweet;
	self->priv->tweet = _tmp6_;
	_tmp7_ = start_media_index;
	self->priv->cur_index = _tmp7_;
	_tmp8_ = (GtkGestureMultiPress*) gtk_gesture_multi_press_new (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (self->priv->button_gesture);
	self->priv->button_gesture = _tmp8_;
	_tmp9_ = self->priv->button_gesture;
	gtk_gesture_single_set_button (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_gesture_single_get_type (), GtkGestureSingle), (guint) 0);
	_tmp10_ = self->priv->button_gesture;
	gtk_event_controller_set_propagation_phase (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_event_controller_get_type (), GtkEventController), GTK_PHASE_BUBBLE);
	_tmp11_ = self->priv->button_gesture;
	g_signal_connect_object (_tmp11_, "released", (GCallback) _media_dialog_button_released_cb_gtk_gesture_multi_press_released, self, 0);
	_tmp12_ = px;
	self->priv->initial_px = _tmp12_;
	_tmp13_ = py;
	self->priv->initial_py = _tmp13_;
	_tmp14_ = tweet;
	_tmp16_ = cb_tweet_get_medias (_tmp14_, &_tmp15_);
	if (_tmp15_ == 1) {
		GtkRevealer* _tmp17_;
		GtkRevealer* _tmp18_;
		_tmp17_ = self->priv->next_revealer;
		gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, gtk_widget_get_type (), GtkWidget));
		_tmp18_ = self->priv->previous_revealer;
		gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, gtk_widget_get_type (), GtkWidget));
	}
	_tmp19_ = cur_media;
	media_dialog_change_media (self, _tmp19_);
	_g_object_unref0 (cur_media);
	return self;
}


MediaDialog* media_dialog_new (CbTweet* tweet, gint start_media_index, gdouble px, gdouble py) {
	return media_dialog_construct (TYPE_MEDIA_DIALOG, tweet, start_media_index, px, py);
}


static void media_dialog_button_released_cb (MediaDialog* self, gint n_press, gdouble x, gdouble y) {
	GtkGestureMultiPress* _tmp0_;
	g_return_if_fail (IS_MEDIA_DIALOG (self));
	gtk_widget_destroy (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	_tmp0_ = self->priv->button_gesture;
	gtk_gesture_set_state (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_gesture_get_type (), GtkGesture), GTK_EVENT_SEQUENCE_CLAIMED);
}


static void media_dialog_change_media (MediaDialog* self, CbMedia* media) {
	GtkWidget* cur_child = NULL;
	GtkFrame* _tmp0_;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp2_;
	gint cur_width = 0;
	gint cur_height = 0;
	gint new_width = 0;
	gint new_height = 0;
	GtkFrame* _tmp3_;
	GtkWidget* _tmp4_;
	GtkWidget* new_widget = NULL;
	CbMedia* _tmp10_;
	gboolean _tmp11_;
	GtkWidget* _tmp24_;
	GtkWidget* _tmp25_;
	gint _tmp26_ = 0;
	gint _tmp27_ = 0;
	gboolean _tmp28_ = FALSE;
	gboolean _tmp29_ = FALSE;
	gboolean _tmp30_ = FALSE;
	gint _tmp31_;
	gint _tmp32_;
	GtkRevealer* _tmp39_;
	gint _tmp40_;
	CbTweet* _tmp41_;
	gint _tmp42_;
	CbMedia** _tmp43_;
	GtkRevealer* _tmp44_;
	gint _tmp45_;
	g_return_if_fail (IS_MEDIA_DIALOG (self));
	g_return_if_fail (CB_IS_MEDIA (media));
	_tmp0_ = self->priv->frame;
	_tmp1_ = gtk_bin_get_child (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_bin_get_type (), GtkBin));
	_tmp2_ = _g_object_ref0 (_tmp1_);
	cur_child = _tmp2_;
	cur_width = 0;
	cur_height = 0;
	_tmp3_ = self->priv->frame;
	_tmp4_ = gtk_bin_get_child (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_bin_get_type (), GtkBin));
	if (_tmp4_ != NULL) {
		GtkFrame* _tmp5_;
		GtkWidget* _tmp6_;
		GtkWidget* _tmp7_;
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
		_tmp5_ = self->priv->frame;
		_tmp6_ = cur_child;
		gtk_container_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_container_get_type (), GtkContainer), _tmp6_);
		_tmp7_ = cur_child;
		gtk_widget_get_size_request (_tmp7_, &_tmp8_, &_tmp9_);
		cur_width = _tmp8_;
		cur_height = _tmp9_;
	}
	new_widget = NULL;
	_tmp10_ = media;
	_tmp11_ = cb_media_is_video (_tmp10_);
	if (_tmp11_) {
		CbMedia* _tmp12_;
		CbMediaVideoWidget* _tmp13_;
		GtkFrame* _tmp14_;
		GtkWidget* _tmp15_;
		GtkWidget* _tmp16_;
		_tmp12_ = media;
		_tmp13_ = cb_media_video_widget_new (_tmp12_);
		g_object_ref_sink (_tmp13_);
		_g_object_unref0 (new_widget);
		new_widget = G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, gtk_widget_get_type (), GtkWidget);
		_tmp14_ = self->priv->frame;
		_tmp15_ = new_widget;
		gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, gtk_container_get_type (), GtkContainer), _tmp15_);
		_tmp16_ = new_widget;
		cb_media_video_widget_start (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, CB_TYPE_MEDIA_VIDEO_WIDGET, CbMediaVideoWidget));
	} else {
		CbMedia* _tmp17_;
		CbMediaImageWidget* _tmp18_;
		GtkWidget* _tmp19_;
		gdouble _tmp20_;
		gdouble _tmp21_;
		GtkFrame* _tmp22_;
		GtkWidget* _tmp23_;
		_tmp17_ = media;
		_tmp18_ = cb_media_image_widget_new (_tmp17_);
		g_object_ref_sink (_tmp18_);
		_g_object_unref0 (new_widget);
		new_widget = G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, gtk_widget_get_type (), GtkWidget);
		_tmp19_ = new_widget;
		_tmp20_ = self->priv->initial_px;
		_tmp21_ = self->priv->initial_py;
		cb_media_image_widget_scroll_to (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, CB_TYPE_MEDIA_IMAGE_WIDGET, CbMediaImageWidget), _tmp20_, _tmp21_);
		_tmp22_ = self->priv->frame;
		_tmp23_ = new_widget;
		gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, gtk_container_get_type (), GtkContainer), _tmp23_);
		self->priv->initial_px = 0.5;
		self->priv->initial_py = 0.0;
	}
	_tmp24_ = new_widget;
	gtk_widget_show_all (_tmp24_);
	_tmp25_ = new_widget;
	gtk_widget_get_size_request (_tmp25_, &_tmp26_, &_tmp27_);
	new_width = _tmp26_;
	new_height = _tmp27_;
	_tmp31_ = new_width;
	_tmp32_ = cur_width;
	if (_tmp31_ != _tmp32_) {
		_tmp30_ = TRUE;
	} else {
		gint _tmp33_;
		gint _tmp34_;
		_tmp33_ = new_height;
		_tmp34_ = cur_height;
		_tmp30_ = _tmp33_ != _tmp34_;
	}
	if (_tmp30_) {
		gint _tmp35_;
		_tmp35_ = new_width;
		_tmp29_ = _tmp35_ > 0;
	} else {
		_tmp29_ = FALSE;
	}
	if (_tmp29_) {
		gint _tmp36_;
		_tmp36_ = new_height;
		_tmp28_ = _tmp36_ > 0;
	} else {
		_tmp28_ = FALSE;
	}
	if (_tmp28_) {
		gint _tmp37_;
		gint _tmp38_;
		_tmp37_ = new_width;
		_tmp38_ = new_height;
		gtk_window_resize (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), _tmp37_, _tmp38_);
	}
	gtk_widget_queue_resize (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	_tmp39_ = self->priv->next_revealer;
	_tmp40_ = self->priv->cur_index;
	_tmp41_ = self->priv->tweet;
	_tmp43_ = cb_tweet_get_medias (_tmp41_, &_tmp42_);
	gtk_widget_set_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp39_, gtk_widget_get_type (), GtkWidget), _tmp40_ != (_tmp42_ - 1));
	_tmp44_ = self->priv->previous_revealer;
	_tmp45_ = self->priv->cur_index;
	gtk_widget_set_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp44_, gtk_widget_get_type (), GtkWidget), _tmp45_ != 0);
	_g_object_unref0 (new_widget);
	_g_object_unref0 (cur_child);
}


static void media_dialog_next_media (MediaDialog* self) {
	gint _tmp0_;
	CbTweet* _tmp1_;
	gint _tmp2_;
	CbMedia** _tmp3_;
	g_return_if_fail (IS_MEDIA_DIALOG (self));
	_tmp0_ = self->priv->cur_index;
	_tmp1_ = self->priv->tweet;
	_tmp3_ = cb_tweet_get_medias (_tmp1_, &_tmp2_);
	if (_tmp0_ < (_tmp2_ - 1)) {
		gint _tmp4_;
		CbTweet* _tmp5_;
		gint _tmp6_;
		CbMedia** _tmp7_;
		gint _tmp8_;
		CbMedia* _tmp9_;
		_tmp4_ = self->priv->cur_index;
		self->priv->cur_index = _tmp4_ + 1;
		_tmp5_ = self->priv->tweet;
		_tmp7_ = cb_tweet_get_medias (_tmp5_, &_tmp6_);
		_tmp8_ = self->priv->cur_index;
		_tmp9_ = _tmp7_[_tmp8_];
		media_dialog_change_media (self, _tmp9_);
	}
}


static void media_dialog_previous_media (MediaDialog* self) {
	gint _tmp0_;
	g_return_if_fail (IS_MEDIA_DIALOG (self));
	_tmp0_ = self->priv->cur_index;
	if (_tmp0_ > 0) {
		gint _tmp1_;
		CbTweet* _tmp2_;
		gint _tmp3_;
		CbMedia** _tmp4_;
		gint _tmp5_;
		CbMedia* _tmp6_;
		_tmp1_ = self->priv->cur_index;
		self->priv->cur_index = _tmp1_ - 1;
		_tmp2_ = self->priv->tweet;
		_tmp4_ = cb_tweet_get_medias (_tmp2_, &_tmp3_);
		_tmp5_ = self->priv->cur_index;
		_tmp6_ = _tmp4_[_tmp5_];
		media_dialog_change_media (self, _tmp6_);
	}
}


static gboolean media_dialog_key_press_event_cb (MediaDialog* self, GdkEventKey* evt) {
	gboolean result = FALSE;
	GdkEventKey* _tmp0_;
	guint _tmp1_;
	g_return_val_if_fail (IS_MEDIA_DIALOG (self), FALSE);
	g_return_val_if_fail (evt != NULL, FALSE);
	_tmp0_ = evt;
	_tmp1_ = _tmp0_->keyval;
	if (_tmp1_ == ((guint) GDK_KEY_Left)) {
		media_dialog_previous_media (self);
	} else {
		GdkEventKey* _tmp2_;
		guint _tmp3_;
		_tmp2_ = evt;
		_tmp3_ = _tmp2_->keyval;
		if (_tmp3_ == ((guint) GDK_KEY_Right)) {
			media_dialog_next_media (self);
		} else {
			gtk_widget_destroy (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
		}
	}
	result = GDK_EVENT_PROPAGATE;
	return result;
}


static gboolean _media_dialog_key_press_event_cb_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self) {
	gboolean result;
	result = media_dialog_key_press_event_cb ((MediaDialog*) self, event);
	return result;
}


static void media_dialog_next_button_clicked_cb (MediaDialog* self) {
	g_return_if_fail (IS_MEDIA_DIALOG (self));
	media_dialog_next_media (self);
}


static void _media_dialog_next_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	media_dialog_next_button_clicked_cb ((MediaDialog*) self);
}


static void media_dialog_previous_button_clicked_cb (MediaDialog* self) {
	g_return_if_fail (IS_MEDIA_DIALOG (self));
	media_dialog_previous_media (self);
}


static void _media_dialog_previous_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	media_dialog_previous_button_clicked_cb ((MediaDialog*) self);
}


static gboolean media_dialog_real_enter_notify_event (GtkWidget* base, GdkEventCrossing* event) {
	MediaDialog * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GdkEventCrossing* _tmp1_;
	GdkWindow* _tmp2_;
	GdkWindow* _tmp3_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_MEDIA_DIALOG, MediaDialog);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp1_ = event;
	_tmp2_ = _tmp1_->window;
	_tmp3_ = gtk_widget_get_window (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	if (_tmp2_ == _tmp3_) {
		GdkEventCrossing* _tmp4_;
		GdkNotifyType _tmp5_;
		_tmp4_ = event;
		_tmp5_ = _tmp4_->detail;
		_tmp0_ = _tmp5_ != GDK_NOTIFY_INFERIOR;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GtkRevealer* _tmp6_;
		GtkRevealer* _tmp7_;
		_tmp6_ = self->priv->next_revealer;
		gtk_revealer_set_reveal_child (_tmp6_, TRUE);
		_tmp7_ = self->priv->previous_revealer;
		gtk_revealer_set_reveal_child (_tmp7_, TRUE);
	}
	result = FALSE;
	return result;
}


static gboolean media_dialog_real_leave_notify_event (GtkWidget* base, GdkEventCrossing* event) {
	MediaDialog * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GdkEventCrossing* _tmp1_;
	GdkWindow* _tmp2_;
	GdkWindow* _tmp3_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_MEDIA_DIALOG, MediaDialog);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp1_ = event;
	_tmp2_ = _tmp1_->window;
	_tmp3_ = gtk_widget_get_window (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	if (_tmp2_ == _tmp3_) {
		GdkEventCrossing* _tmp4_;
		GdkNotifyType _tmp5_;
		_tmp4_ = event;
		_tmp5_ = _tmp4_->detail;
		_tmp0_ = _tmp5_ != GDK_NOTIFY_INFERIOR;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GtkRevealer* _tmp6_;
		GtkRevealer* _tmp7_;
		_tmp6_ = self->priv->next_revealer;
		gtk_revealer_set_reveal_child (_tmp6_, FALSE);
		_tmp7_ = self->priv->previous_revealer;
		gtk_revealer_set_reveal_child (_tmp7_, FALSE);
	}
	result = FALSE;
	return result;
}


static void media_dialog_class_init (MediaDialogClass * klass) {
	gint MediaDialog_private_offset;
	media_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (MediaDialogPrivate));
	((GtkWidgetClass *) klass)->enter_notify_event = (gboolean (*) (GtkWidget *, GdkEventCrossing*)) media_dialog_real_enter_notify_event;
	((GtkWidgetClass *) klass)->leave_notify_event = (gboolean (*) (GtkWidget *, GdkEventCrossing*)) media_dialog_real_leave_notify_event;
	G_OBJECT_CLASS (klass)->finalize = media_dialog_finalize;
	MediaDialog_private_offset = g_type_class_get_instance_private_offset (klass);
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/baedert/corebird/ui/media-dialog.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "frame", FALSE, MediaDialog_private_offset + G_STRUCT_OFFSET (MediaDialogPrivate, frame));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "next_revealer", FALSE, MediaDialog_private_offset + G_STRUCT_OFFSET (MediaDialogPrivate, next_revealer));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "previous_revealer", FALSE, MediaDialog_private_offset + G_STRUCT_OFFSET (MediaDialogPrivate, previous_revealer));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "key_press_event_cb", G_CALLBACK(_media_dialog_key_press_event_cb_gtk_widget_key_press_event));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "next_button_clicked_cb", G_CALLBACK(_media_dialog_next_button_clicked_cb_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "previous_button_clicked_cb", G_CALLBACK(_media_dialog_previous_button_clicked_cb_gtk_button_clicked));
}


static void media_dialog_instance_init (MediaDialog * self) {
	self->priv = MEDIA_DIALOG_GET_PRIVATE (self);
	self->priv->cur_index = 0;
	gtk_widget_init_template (GTK_WIDGET (self));
}


static void media_dialog_finalize (GObject * obj) {
	MediaDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MEDIA_DIALOG, MediaDialog);
	_g_object_unref0 (self->priv->frame);
	_g_object_unref0 (self->priv->next_revealer);
	_g_object_unref0 (self->priv->previous_revealer);
	_g_object_unref0 (self->priv->button_gesture);
	G_OBJECT_CLASS (media_dialog_parent_class)->finalize (obj);
}


GType media_dialog_get_type (void) {
	static volatile gsize media_dialog_type_id__volatile = 0;
	if (g_once_init_enter (&media_dialog_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MediaDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) media_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MediaDialog), 0, (GInstanceInitFunc) media_dialog_instance_init, NULL };
		GType media_dialog_type_id;
		media_dialog_type_id = g_type_register_static (gtk_window_get_type (), "MediaDialog", &g_define_type_info, 0);
		g_once_init_leave (&media_dialog_type_id__volatile, media_dialog_type_id);
	}
	return media_dialog_type_id__volatile;
}



