/* ComposeImageManager.c generated by valac 0.36.4, the Vala compiler
 * generated from ComposeImageManager.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <cairo.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>
#include <gdk-pixbuf/gdk-pixbuf.h>


#define TYPE_COMPOSE_IMAGE_MANAGER (compose_image_manager_get_type ())
#define COMPOSE_IMAGE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPOSE_IMAGE_MANAGER, ComposeImageManager))
#define COMPOSE_IMAGE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPOSE_IMAGE_MANAGER, ComposeImageManagerClass))
#define IS_COMPOSE_IMAGE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPOSE_IMAGE_MANAGER))
#define IS_COMPOSE_IMAGE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPOSE_IMAGE_MANAGER))
#define COMPOSE_IMAGE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPOSE_IMAGE_MANAGER, ComposeImageManagerClass))

typedef struct _ComposeImageManager ComposeImageManager;
typedef struct _ComposeImageManagerClass ComposeImageManagerClass;
typedef struct _ComposeImageManagerPrivate ComposeImageManagerPrivate;

#define TYPE_ADD_IMAGE_BUTTON (add_image_button_get_type ())
#define ADD_IMAGE_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ADD_IMAGE_BUTTON, AddImageButton))
#define ADD_IMAGE_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ADD_IMAGE_BUTTON, AddImageButtonClass))
#define IS_ADD_IMAGE_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ADD_IMAGE_BUTTON))
#define IS_ADD_IMAGE_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ADD_IMAGE_BUTTON))
#define ADD_IMAGE_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ADD_IMAGE_BUTTON, AddImageButtonClass))

typedef struct _AddImageButton AddImageButton;
typedef struct _AddImageButtonClass AddImageButtonClass;
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
typedef struct _Block52Data Block52Data;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _AddImageButtonPrivate AddImageButtonPrivate;
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
enum  {
	COMPOSE_IMAGE_MANAGER_IMAGE_REMOVED_SIGNAL,
	COMPOSE_IMAGE_MANAGER_LAST_SIGNAL
};
static guint compose_image_manager_signals[COMPOSE_IMAGE_MANAGER_LAST_SIGNAL] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ComposeImageManager {
	GtkContainer parent_instance;
	ComposeImageManagerPrivate * priv;
};

struct _ComposeImageManagerClass {
	GtkContainerClass parent_class;
};

struct _ComposeImageManagerPrivate {
	GPtrArray* buttons;
	GPtrArray* close_buttons;
	GPtrArray* progress_bars;
};

struct _Block52Data {
	int _ref_count_;
	ComposeImageManager* self;
	gint index;
	AddImageButton* aib;
};

struct _AddImageButton {
	GtkWidget parent_instance;
	AddImageButtonPrivate * priv;
	gchar* image_path;
	cairo_surface_t* surface;
};

struct _AddImageButtonClass {
	GtkWidgetClass parent_class;
};


static gpointer compose_image_manager_parent_class = NULL;

GType compose_image_manager_get_type (void) G_GNUC_CONST;
GType add_image_button_get_type (void) G_GNUC_CONST;
#define COMPOSE_IMAGE_MANAGER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_COMPOSE_IMAGE_MANAGER, ComposeImageManagerPrivate))
enum  {
	COMPOSE_IMAGE_MANAGER_DUMMY_PROPERTY,
	COMPOSE_IMAGE_MANAGER_N_IMAGES,
	COMPOSE_IMAGE_MANAGER_HAS_GIF,
	COMPOSE_IMAGE_MANAGER_FULL
};
#define COMPOSE_IMAGE_MANAGER_BUTTON_DELTA 10
#define COMPOSE_IMAGE_MANAGER_BUTTON_SPACING 12
static void compose_image_manager_remove_clicked_cb (ComposeImageManager* self, GtkButton* source);
static Block52Data* block52_data_ref (Block52Data* _data52_);
static void block52_data_unref (void * _userdata_);
static void __lambda33_ (Block52Data* _data52_);
static void ___lambda33__add_image_button_deleted (AddImageButton* _sender, gpointer self);
void add_image_button_start_remove (AddImageButton* self);
static void compose_image_manager_real_forall_internal (GtkContainer* base, gboolean include_internals, GtkCallback cb, void* cb_target);
static void compose_image_manager_real_add (GtkContainer* base, GtkWidget* widget);
static void _compose_image_manager_remove_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void compose_image_manager_real_remove (GtkContainer* base, GtkWidget* widget);
static GtkSizeRequestMode compose_image_manager_real_get_request_mode (GtkWidget* base);
static void compose_image_manager_real_size_allocate (GtkWidget* base, GtkAllocation* allocation);
void add_image_button_get_draw_size (AddImageButton* self, gint* width, gint* height, gdouble* scale);
static void compose_image_manager_real_get_preferred_height_for_width (GtkWidget* base, gint width, gint* minimum, gint* natural);
static void compose_image_manager_real_get_preferred_height (GtkWidget* base, gint* minimum, gint* natural);
static void compose_image_manager_real_get_preferred_width (GtkWidget* base, gint* minimum, gint* natural);
static gboolean compose_image_manager_real_draw (GtkWidget* base, cairo_t* ct);
void compose_image_manager_load_image (ComposeImageManager* self, const gchar* path, GdkPixbuf* image);
cairo_surface_t* load_surface (const gchar* path);
AddImageButton* add_image_button_new (void);
AddImageButton* add_image_button_construct (GType object_type);
void compose_image_manager_set_image_progress (ComposeImageManager* self, const gchar* image_path, gdouble progress);
void compose_image_manager_end_progress (ComposeImageManager* self, const gchar* image_path, const gchar* error_message);
void compose_image_manager_insensitivize_buttons (ComposeImageManager* self);
ComposeImageManager* compose_image_manager_new (void);
ComposeImageManager* compose_image_manager_construct (GType object_type);
gint compose_image_manager_get_n_images (ComposeImageManager* self);
gboolean compose_image_manager_get_has_gif (ComposeImageManager* self);
gboolean compose_image_manager_get_full (ComposeImageManager* self);
#define TWITTER_max_media_per_upload 4
static GObject * compose_image_manager_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _g_object_unref0_ (gpointer var);
static void compose_image_manager_finalize (GObject * obj);
static void _vala_compose_image_manager_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);


static Block52Data* block52_data_ref (Block52Data* _data52_) {
	g_atomic_int_inc (&_data52_->_ref_count_);
	return _data52_;
}


static void block52_data_unref (void * _userdata_) {
	Block52Data* _data52_;
	_data52_ = (Block52Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data52_->_ref_count_)) {
		ComposeImageManager* self;
		self = _data52_->self;
		_g_object_unref0 (_data52_->aib);
		_g_object_unref0 (self);
		g_slice_free (Block52Data, _data52_);
	}
}


static gint g_ptr_array_get_length (GPtrArray* self) {
	gint result;
	guint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->len;
	result = (gint) _tmp0_;
	return result;
}


static void g_ptr_array_set_length (GPtrArray* self, gint value) {
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	g_ptr_array_set_size (self, _tmp0_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void __lambda33_ (Block52Data* _data52_) {
	ComposeImageManager* self;
	GPtrArray* _tmp0_;
	gint _tmp1_;
	GPtrArray* _tmp2_;
	gint _tmp3_;
	GPtrArray* _tmp4_;
	gint _tmp5_;
	const gchar* _tmp6_;
	self = _data52_->self;
	_tmp0_ = self->priv->buttons;
	_tmp1_ = _data52_->index;
	g_ptr_array_remove_index (_tmp0_, (guint) _tmp1_);
	_tmp2_ = self->priv->close_buttons;
	_tmp3_ = _data52_->index;
	g_ptr_array_remove_index (_tmp2_, (guint) _tmp3_);
	_tmp4_ = self->priv->progress_bars;
	_tmp5_ = _data52_->index;
	g_ptr_array_remove_index (_tmp4_, (guint) _tmp5_);
	gtk_widget_queue_draw (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	_tmp6_ = _data52_->aib->image_path;
	g_signal_emit (self, compose_image_manager_signals[COMPOSE_IMAGE_MANAGER_IMAGE_REMOVED_SIGNAL], 0, _tmp6_);
}


static void ___lambda33__add_image_button_deleted (AddImageButton* _sender, gpointer self) {
	__lambda33_ (self);
}


static void compose_image_manager_remove_clicked_cb (ComposeImageManager* self, GtkButton* source) {
	Block52Data* _data52_;
	gint _tmp11_;
	GPtrArray* _tmp12_;
	gint _tmp13_;
	gconstpointer _tmp14_;
	GPtrArray* _tmp15_;
	gint _tmp16_;
	gconstpointer _tmp17_;
	GPtrArray* _tmp18_;
	gint _tmp19_;
	gconstpointer _tmp20_;
	AddImageButton* _tmp21_;
	g_return_if_fail (IS_COMPOSE_IMAGE_MANAGER (self));
	g_return_if_fail (GTK_IS_BUTTON (source));
	_data52_ = g_slice_new0 (Block52Data);
	_data52_->_ref_count_ = 1;
	_data52_->self = g_object_ref (self);
	_data52_->index = -1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				GPtrArray* _tmp3_;
				gint _tmp4_;
				gint _tmp5_;
				GPtrArray* _tmp6_;
				gint _tmp7_;
				gconstpointer _tmp8_;
				GtkButton* _tmp9_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = self->priv->close_buttons;
				_tmp4_ = g_ptr_array_get_length (_tmp3_);
				_tmp5_ = _tmp4_;
				if (!(_tmp2_ < _tmp5_)) {
					break;
				}
				_tmp6_ = self->priv->close_buttons;
				_tmp7_ = i;
				_tmp8_ = g_ptr_array_index (_tmp6_, (guint) _tmp7_);
				_tmp9_ = source;
				if (((GtkButton*) _tmp8_) == _tmp9_) {
					gint _tmp10_;
					_tmp10_ = i;
					_data52_->index = _tmp10_;
					break;
				}
			}
		}
	}
	_tmp11_ = _data52_->index;
	_vala_assert (_tmp11_ >= 0, "index >= 0");
	_tmp12_ = self->priv->close_buttons;
	_tmp13_ = _data52_->index;
	_tmp14_ = g_ptr_array_index (_tmp12_, (guint) _tmp13_);
	gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST ((GtkButton*) _tmp14_, gtk_widget_get_type (), GtkWidget));
	_tmp15_ = self->priv->progress_bars;
	_tmp16_ = _data52_->index;
	_tmp17_ = g_ptr_array_index (_tmp15_, (guint) _tmp16_);
	gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST ((GtkProgressBar*) _tmp17_, gtk_widget_get_type (), GtkWidget));
	_tmp18_ = self->priv->buttons;
	_tmp19_ = _data52_->index;
	_tmp20_ = g_ptr_array_index (_tmp18_, (guint) _tmp19_);
	_tmp21_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST ((AddImageButton*) _tmp20_, TYPE_ADD_IMAGE_BUTTON, AddImageButton));
	_data52_->aib = _tmp21_;
	g_signal_connect_data (_data52_->aib, "deleted", (GCallback) ___lambda33__add_image_button_deleted, block52_data_ref (_data52_), (GClosureNotify) block52_data_unref, 0);
	add_image_button_start_remove (_data52_->aib);
	block52_data_unref (_data52_);
	_data52_ = NULL;
}


static void compose_image_manager_real_forall_internal (GtkContainer* base, gboolean include_internals, GtkCallback cb, void* cb_target) {
	ComposeImageManager * self;
	GPtrArray* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GPtrArray* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	GPtrArray* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	GPtrArray* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_COMPOSE_IMAGE_MANAGER, ComposeImageManager);
	_tmp0_ = self->priv->buttons;
	_tmp1_ = g_ptr_array_get_length (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->close_buttons;
	_tmp4_ = g_ptr_array_get_length (_tmp3_);
	_tmp5_ = _tmp4_;
	_vala_assert (_tmp2_ == _tmp5_, "buttons.length == close_buttons.length");
	_tmp6_ = self->priv->buttons;
	_tmp7_ = g_ptr_array_get_length (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = self->priv->progress_bars;
	_tmp10_ = g_ptr_array_get_length (_tmp9_);
	_tmp11_ = _tmp10_;
	_vala_assert (_tmp8_ == _tmp11_, "buttons.length == progress_bars.length");
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp12_ = FALSE;
			_tmp12_ = TRUE;
			while (TRUE) {
				gint _tmp13_;
				GPtrArray* _tmp14_;
				gint _tmp15_;
				gint _tmp16_;
				gint size_before = 0;
				GPtrArray* _tmp17_;
				gint _tmp18_;
				gint _tmp19_;
				GtkCallback _tmp20_;
				void* _tmp20__target;
				GPtrArray* _tmp21_;
				gint _tmp22_;
				gconstpointer _tmp23_;
				gint _tmp24_;
				GPtrArray* _tmp25_;
				gint _tmp26_;
				gint _tmp27_;
				gint _tmp28_;
				if (!_tmp12_) {
				}
				_tmp12_ = FALSE;
				_tmp13_ = i;
				_tmp14_ = self->priv->close_buttons;
				_tmp15_ = g_ptr_array_get_length (_tmp14_);
				_tmp16_ = _tmp15_;
				if (!(_tmp13_ < _tmp16_)) {
					break;
				}
				_tmp17_ = self->priv->close_buttons;
				_tmp18_ = g_ptr_array_get_length (_tmp17_);
				_tmp19_ = _tmp18_;
				size_before = _tmp19_;
				_tmp20_ = cb;
				_tmp20__target = cb_target;
				_tmp21_ = self->priv->close_buttons;
				_tmp22_ = i;
				_tmp23_ = g_ptr_array_index (_tmp21_, (guint) _tmp22_);
				_tmp20_ (G_TYPE_CHECK_INSTANCE_CAST ((GtkButton*) _tmp23_, gtk_widget_get_type (), GtkWidget), _tmp20__target);
				_tmp24_ = i;
				_tmp25_ = self->priv->close_buttons;
				_tmp26_ = g_ptr_array_get_length (_tmp25_);
				_tmp27_ = _tmp26_;
				_tmp28_ = size_before;
				i = _tmp24_ + ((_tmp27_ - _tmp28_) + 1);
			}
		}
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp29_ = FALSE;
			_tmp29_ = TRUE;
			while (TRUE) {
				gint _tmp30_;
				GPtrArray* _tmp31_;
				gint _tmp32_;
				gint _tmp33_;
				gint size_before = 0;
				GPtrArray* _tmp34_;
				gint _tmp35_;
				gint _tmp36_;
				GtkCallback _tmp37_;
				void* _tmp37__target;
				GPtrArray* _tmp38_;
				gint _tmp39_;
				gconstpointer _tmp40_;
				gint _tmp41_;
				GPtrArray* _tmp42_;
				gint _tmp43_;
				gint _tmp44_;
				gint _tmp45_;
				if (!_tmp29_) {
				}
				_tmp29_ = FALSE;
				_tmp30_ = i;
				_tmp31_ = self->priv->progress_bars;
				_tmp32_ = g_ptr_array_get_length (_tmp31_);
				_tmp33_ = _tmp32_;
				if (!(_tmp30_ < _tmp33_)) {
					break;
				}
				_tmp34_ = self->priv->progress_bars;
				_tmp35_ = g_ptr_array_get_length (_tmp34_);
				_tmp36_ = _tmp35_;
				size_before = _tmp36_;
				_tmp37_ = cb;
				_tmp37__target = cb_target;
				_tmp38_ = self->priv->progress_bars;
				_tmp39_ = i;
				_tmp40_ = g_ptr_array_index (_tmp38_, (guint) _tmp39_);
				_tmp37_ (G_TYPE_CHECK_INSTANCE_CAST ((GtkProgressBar*) _tmp40_, gtk_widget_get_type (), GtkWidget), _tmp37__target);
				_tmp41_ = i;
				_tmp42_ = self->priv->progress_bars;
				_tmp43_ = g_ptr_array_get_length (_tmp42_);
				_tmp44_ = _tmp43_;
				_tmp45_ = size_before;
				i = _tmp41_ + ((_tmp44_ - _tmp45_) + 1);
			}
		}
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp46_ = FALSE;
			_tmp46_ = TRUE;
			while (TRUE) {
				gint _tmp47_;
				GPtrArray* _tmp48_;
				gint _tmp49_;
				gint _tmp50_;
				gint size_before = 0;
				GPtrArray* _tmp51_;
				gint _tmp52_;
				gint _tmp53_;
				GtkCallback _tmp54_;
				void* _tmp54__target;
				GPtrArray* _tmp55_;
				gint _tmp56_;
				gconstpointer _tmp57_;
				gint _tmp58_;
				GPtrArray* _tmp59_;
				gint _tmp60_;
				gint _tmp61_;
				gint _tmp62_;
				if (!_tmp46_) {
				}
				_tmp46_ = FALSE;
				_tmp47_ = i;
				_tmp48_ = self->priv->buttons;
				_tmp49_ = g_ptr_array_get_length (_tmp48_);
				_tmp50_ = _tmp49_;
				if (!(_tmp47_ < _tmp50_)) {
					break;
				}
				_tmp51_ = self->priv->buttons;
				_tmp52_ = g_ptr_array_get_length (_tmp51_);
				_tmp53_ = _tmp52_;
				size_before = _tmp53_;
				_tmp54_ = cb;
				_tmp54__target = cb_target;
				_tmp55_ = self->priv->buttons;
				_tmp56_ = i;
				_tmp57_ = g_ptr_array_index (_tmp55_, (guint) _tmp56_);
				_tmp54_ (G_TYPE_CHECK_INSTANCE_CAST ((AddImageButton*) _tmp57_, gtk_widget_get_type (), GtkWidget), _tmp54__target);
				_tmp58_ = i;
				_tmp59_ = self->priv->buttons;
				_tmp60_ = g_ptr_array_get_length (_tmp59_);
				_tmp61_ = _tmp60_;
				_tmp62_ = size_before;
				i = _tmp58_ + ((_tmp61_ - _tmp62_) + 1);
			}
		}
	}
}


static void _compose_image_manager_remove_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	compose_image_manager_remove_clicked_cb ((ComposeImageManager*) self, _sender);
}


static void compose_image_manager_real_add (GtkContainer* base, GtkWidget* widget) {
	ComposeImageManager * self;
	GtkWidget* _tmp0_;
	GPtrArray* _tmp1_;
	GtkWidget* _tmp2_;
	AddImageButton* _tmp3_;
	GtkButton* btn = NULL;
	GtkButton* _tmp4_;
	GtkStyleContext* _tmp5_;
	GtkStyleContext* _tmp6_;
	GPtrArray* _tmp7_;
	GtkButton* _tmp8_;
	GtkProgressBar* bar = NULL;
	GtkProgressBar* _tmp9_;
	GPtrArray* _tmp10_;
	GtkProgressBar* _tmp11_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_COMPOSE_IMAGE_MANAGER, ComposeImageManager);
	g_return_if_fail (GTK_IS_WIDGET (widget));
	_tmp0_ = widget;
	gtk_widget_set_parent (_tmp0_, (GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_container_get_type (), GtkContainer));
	_tmp1_ = self->priv->buttons;
	_tmp2_ = widget;
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_ADD_IMAGE_BUTTON, AddImageButton));
	g_ptr_array_add (_tmp1_, _tmp3_);
	_tmp4_ = (GtkButton*) gtk_button_new_from_icon_name ("window-close-symbolic", GTK_ICON_SIZE_BUTTON);
	g_object_ref_sink (_tmp4_);
	btn = _tmp4_;
	gtk_widget_set_parent (G_TYPE_CHECK_INSTANCE_CAST (btn, gtk_widget_get_type (), GtkWidget), (GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_container_get_type (), GtkContainer));
	_tmp5_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (btn, gtk_widget_get_type (), GtkWidget));
	gtk_style_context_add_class (_tmp5_, "image-button");
	_tmp6_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (btn, gtk_widget_get_type (), GtkWidget));
	gtk_style_context_add_class (_tmp6_, "close-button");
	g_signal_connect_object (btn, "clicked", (GCallback) _compose_image_manager_remove_clicked_cb_gtk_button_clicked, self, 0);
	gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (btn, gtk_widget_get_type (), GtkWidget));
	_tmp7_ = self->priv->close_buttons;
	_tmp8_ = _g_object_ref0 (btn);
	g_ptr_array_add (_tmp7_, _tmp8_);
	_tmp9_ = (GtkProgressBar*) gtk_progress_bar_new ();
	g_object_ref_sink (_tmp9_);
	bar = _tmp9_;
	gtk_widget_set_parent (G_TYPE_CHECK_INSTANCE_CAST (bar, gtk_widget_get_type (), GtkWidget), (GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_container_get_type (), GtkContainer));
	gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (bar, gtk_widget_get_type (), GtkWidget));
	_tmp10_ = self->priv->progress_bars;
	_tmp11_ = _g_object_ref0 (bar);
	g_ptr_array_add (_tmp10_, _tmp11_);
	_g_object_unref0 (bar);
	_g_object_unref0 (btn);
}


static void compose_image_manager_real_remove (GtkContainer* base, GtkWidget* widget) {
	ComposeImageManager * self;
	GtkWidget* _tmp0_;
	GtkWidget* _tmp1_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_COMPOSE_IMAGE_MANAGER, ComposeImageManager);
	g_return_if_fail (GTK_IS_WIDGET (widget));
	_tmp0_ = widget;
	gtk_widget_unparent (_tmp0_);
	_tmp1_ = widget;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, TYPE_ADD_IMAGE_BUTTON)) {
		GPtrArray* _tmp2_;
		GtkWidget* _tmp3_;
		_tmp2_ = self->priv->buttons;
		_tmp3_ = widget;
		g_ptr_array_remove (_tmp2_, G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TYPE_ADD_IMAGE_BUTTON, AddImageButton));
	} else {
		GtkWidget* _tmp4_;
		_tmp4_ = widget;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, gtk_button_get_type ())) {
			GPtrArray* _tmp5_;
			GtkWidget* _tmp6_;
			_tmp5_ = self->priv->close_buttons;
			_tmp6_ = widget;
			g_ptr_array_remove (_tmp5_, G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_button_get_type (), GtkButton));
		} else {
			GPtrArray* _tmp7_;
			GtkWidget* _tmp8_;
			_tmp7_ = self->priv->progress_bars;
			_tmp8_ = widget;
			g_ptr_array_remove (_tmp7_, G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_progress_bar_get_type (), GtkProgressBar));
		}
	}
}


static GtkSizeRequestMode compose_image_manager_real_get_request_mode (GtkWidget* base) {
	ComposeImageManager * self;
	GtkSizeRequestMode result = 0;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_COMPOSE_IMAGE_MANAGER, ComposeImageManager);
	result = GTK_SIZE_REQUEST_HEIGHT_FOR_WIDTH;
	return result;
}


static void compose_image_manager_real_size_allocate (GtkWidget* base, GtkAllocation* allocation) {
	ComposeImageManager * self;
	GtkAllocation _tmp0_;
	GtkAllocation child_allocation = {0};
	GtkAllocation _tmp1_ = {0};
	GPtrArray* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint default_button_width = 0;
	GtkAllocation _tmp5_;
	gint _tmp6_;
	GPtrArray* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	GPtrArray* _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	GtkAllocation _tmp13_;
	gint _tmp14_;
	GtkAllocation _tmp15_;
	gint _tmp16_;
	GtkAllocation _tmp17_;
	gint _tmp18_;
	gint _tmp19_;
	GtkAllocation close_allocation = {0};
	GtkAllocation _tmp20_ = {0};
	GtkAllocation _tmp21_;
	gint _tmp22_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_COMPOSE_IMAGE_MANAGER, ComposeImageManager);
	g_return_if_fail (allocation != NULL);
	_tmp0_ = *allocation;
	GTK_WIDGET_CLASS (compose_image_manager_parent_class)->size_allocate (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_container_get_type (), GtkContainer), gtk_widget_get_type (), GtkWidget), &_tmp0_);
	child_allocation = _tmp1_;
	_tmp2_ = self->priv->buttons;
	_tmp3_ = g_ptr_array_get_length (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == 0) {
		return;
	}
	_tmp5_ = *allocation;
	_tmp6_ = _tmp5_.width;
	_tmp7_ = self->priv->buttons;
	_tmp8_ = g_ptr_array_get_length (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = self->priv->buttons;
	_tmp11_ = g_ptr_array_get_length (_tmp10_);
	_tmp12_ = _tmp11_;
	default_button_width = (_tmp6_ - (_tmp9_ * COMPOSE_IMAGE_MANAGER_BUTTON_SPACING)) / _tmp12_;
	_tmp13_ = *allocation;
	_tmp14_ = _tmp13_.x;
	child_allocation.x = _tmp14_;
	_tmp15_ = *allocation;
	_tmp16_ = _tmp15_.y;
	child_allocation.y = _tmp16_ + COMPOSE_IMAGE_MANAGER_BUTTON_DELTA;
	_tmp17_ = *allocation;
	_tmp18_ = _tmp17_.height;
	_tmp19_ = MAX (_tmp18_ - COMPOSE_IMAGE_MANAGER_BUTTON_DELTA, 0);
	child_allocation.height = _tmp19_;
	close_allocation = _tmp20_;
	_tmp21_ = *allocation;
	_tmp22_ = _tmp21_.y;
	close_allocation.y = _tmp22_;
	{
		gint i = 0;
		gint p = 0;
		GPtrArray* _tmp23_;
		gint _tmp24_;
		gint _tmp25_;
		i = 0;
		_tmp23_ = self->priv->buttons;
		_tmp24_ = g_ptr_array_get_length (_tmp23_);
		_tmp25_ = _tmp24_;
		p = _tmp25_;
		{
			gboolean _tmp26_ = FALSE;
			_tmp26_ = TRUE;
			while (TRUE) {
				gint _tmp28_;
				gint _tmp29_;
				gint min = 0;
				gint nat = 0;
				AddImageButton* aib = NULL;
				GPtrArray* _tmp30_;
				gint _tmp31_;
				gconstpointer _tmp32_;
				AddImageButton* _tmp33_;
				AddImageButton* _tmp34_;
				GtkAllocation _tmp35_;
				gint _tmp36_;
				gint _tmp37_ = 0;
				gint _tmp38_ = 0;
				gint _tmp39_;
				gint _tmp40_;
				gint _tmp41_;
				AddImageButton* _tmp42_;
				GtkAllocation _tmp43_;
				gint n = 0;
				GtkWidget* btn = NULL;
				GPtrArray* _tmp44_;
				gint _tmp45_;
				gconstpointer _tmp46_;
				GtkWidget* _tmp47_;
				GtkWidget* _tmp48_;
				gint _tmp49_ = 0;
				gint _tmp50_ = 0;
				GtkWidget* _tmp51_;
				gint _tmp52_ = 0;
				gint _tmp53_ = 0;
				GtkAllocation _tmp54_;
				gint _tmp55_;
				GtkAllocation _tmp56_;
				gint _tmp57_;
				GtkAllocation _tmp58_;
				gint _tmp59_;
				GtkWidget* _tmp60_;
				GtkAllocation _tmp61_;
				gint button_width = 0;
				gint button_height = 0;
				gdouble scale = 0.0;
				AddImageButton* _tmp62_;
				gint _tmp63_ = 0;
				gint _tmp64_ = 0;
				gdouble _tmp65_ = 0.0;
				GtkWidget* bar = NULL;
				GPtrArray* _tmp66_;
				gint _tmp67_;
				gconstpointer _tmp68_;
				GtkWidget* _tmp69_;
				GtkAllocation bar_allocation = {0};
				GtkAllocation _tmp70_ = {0};
				GtkAllocation _tmp71_;
				gint _tmp72_;
				GtkWidget* _tmp73_;
				gint _tmp74_ = 0;
				gint _tmp75_ = 0;
				gint _tmp76_;
				GtkAllocation _tmp77_;
				gint _tmp78_;
				gint _tmp79_;
				GtkWidget* _tmp80_;
				gint _tmp81_ = 0;
				gint _tmp82_ = 0;
				GtkAllocation _tmp83_;
				gint _tmp84_;
				gint _tmp85_;
				GtkAllocation _tmp86_;
				gint _tmp87_;
				GtkWidget* _tmp88_;
				GtkAllocation _tmp89_;
				gint _tmp90_;
				GtkAllocation _tmp91_;
				gint _tmp92_;
				if (!_tmp26_) {
					gint _tmp27_;
					_tmp27_ = i;
					i = _tmp27_ + 1;
				}
				_tmp26_ = FALSE;
				_tmp28_ = i;
				_tmp29_ = p;
				if (!(_tmp28_ < _tmp29_)) {
					break;
				}
				_tmp30_ = self->priv->buttons;
				_tmp31_ = i;
				_tmp32_ = g_ptr_array_index (_tmp30_, (guint) _tmp31_);
				_tmp33_ = _g_object_ref0 ((AddImageButton*) _tmp32_);
				aib = _tmp33_;
				_tmp34_ = aib;
				_tmp35_ = child_allocation;
				_tmp36_ = _tmp35_.height;
				gtk_widget_get_preferred_width_for_height (G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, gtk_widget_get_type (), GtkWidget), _tmp36_, &_tmp37_, &_tmp38_);
				min = _tmp37_;
				nat = _tmp38_;
				_tmp39_ = default_button_width;
				_tmp40_ = nat;
				_tmp41_ = MIN (_tmp39_, _tmp40_);
				child_allocation.width = _tmp41_;
				_tmp42_ = aib;
				_tmp43_ = child_allocation;
				gtk_widget_size_allocate (G_TYPE_CHECK_INSTANCE_CAST (_tmp42_, gtk_widget_get_type (), GtkWidget), &_tmp43_);
				_tmp44_ = self->priv->close_buttons;
				_tmp45_ = i;
				_tmp46_ = g_ptr_array_index (_tmp44_, (guint) _tmp45_);
				_tmp47_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST ((GtkButton*) _tmp46_, gtk_widget_get_type (), GtkWidget));
				btn = _tmp47_;
				_tmp48_ = btn;
				gtk_widget_get_preferred_width (_tmp48_, &_tmp49_, &_tmp50_);
				close_allocation.width = _tmp49_;
				n = _tmp50_;
				_tmp51_ = btn;
				gtk_widget_get_preferred_height (_tmp51_, &_tmp52_, &_tmp53_);
				close_allocation.height = _tmp52_;
				n = _tmp53_;
				_tmp54_ = child_allocation;
				_tmp55_ = _tmp54_.x;
				_tmp56_ = child_allocation;
				_tmp57_ = _tmp56_.width;
				_tmp58_ = close_allocation;
				_tmp59_ = _tmp58_.width;
				close_allocation.x = ((_tmp55_ + _tmp57_) - _tmp59_) + COMPOSE_IMAGE_MANAGER_BUTTON_DELTA;
				_tmp60_ = btn;
				_tmp61_ = close_allocation;
				gtk_widget_size_allocate (_tmp60_, &_tmp61_);
				_tmp62_ = aib;
				add_image_button_get_draw_size (_tmp62_, &_tmp63_, &_tmp64_, &_tmp65_);
				button_width = _tmp63_;
				button_height = _tmp64_;
				scale = _tmp65_;
				_tmp66_ = self->priv->progress_bars;
				_tmp67_ = i;
				_tmp68_ = g_ptr_array_index (_tmp66_, (guint) _tmp67_);
				_tmp69_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST ((GtkProgressBar*) _tmp68_, gtk_widget_get_type (), GtkWidget));
				bar = _tmp69_;
				_tmp70_.x = 0;
				bar_allocation = _tmp70_;
				_tmp71_ = child_allocation;
				_tmp72_ = _tmp71_.x;
				bar_allocation.x = _tmp72_ + 6;
				_tmp73_ = bar;
				gtk_widget_get_preferred_width (_tmp73_, &_tmp74_, &_tmp75_);
				bar_allocation.width = _tmp74_;
				n = _tmp75_;
				_tmp76_ = button_width;
				_tmp77_ = bar_allocation;
				_tmp78_ = _tmp77_.width;
				_tmp79_ = MAX (_tmp76_ - 12, _tmp78_);
				bar_allocation.width = _tmp79_;
				_tmp80_ = bar;
				gtk_widget_get_preferred_height (_tmp80_, &_tmp81_, &_tmp82_);
				bar_allocation.height = _tmp81_;
				n = _tmp82_;
				_tmp83_ = child_allocation;
				_tmp84_ = _tmp83_.y;
				_tmp85_ = button_height;
				_tmp86_ = bar_allocation;
				_tmp87_ = _tmp86_.height;
				bar_allocation.y = ((_tmp84_ + _tmp85_) - _tmp87_) - 6;
				_tmp88_ = bar;
				_tmp89_ = bar_allocation;
				gtk_widget_size_allocate (_tmp88_, &_tmp89_);
				_tmp90_ = child_allocation.x;
				_tmp91_ = child_allocation;
				_tmp92_ = _tmp91_.width;
				child_allocation.x = _tmp90_ + (_tmp92_ + COMPOSE_IMAGE_MANAGER_BUTTON_SPACING);
				_g_object_unref0 (bar);
				_g_object_unref0 (btn);
				_g_object_unref0 (aib);
			}
		}
	}
}


static void compose_image_manager_real_get_preferred_height_for_width (GtkWidget* base, gint width, gint* minimum, gint* natural) {
	ComposeImageManager * self;
	gint _vala_minimum = 0;
	gint _vala_natural = 0;
	gint min = 0;
	gint nat = 0;
	gint _tmp20_;
	gint _tmp21_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_COMPOSE_IMAGE_MANAGER, ComposeImageManager);
	min = 0;
	nat = 0;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				GPtrArray* _tmp3_;
				gint _tmp4_;
				gint _tmp5_;
				AddImageButton* btn = NULL;
				GPtrArray* _tmp6_;
				gint _tmp7_;
				gconstpointer _tmp8_;
				AddImageButton* _tmp9_;
				gint m = 0;
				gint n = 0;
				AddImageButton* _tmp10_;
				gint _tmp11_;
				gint _tmp12_ = 0;
				gint _tmp13_ = 0;
				gint _tmp14_;
				gint _tmp15_;
				gint _tmp16_;
				gint _tmp17_;
				gint _tmp18_;
				gint _tmp19_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = self->priv->buttons;
				_tmp4_ = g_ptr_array_get_length (_tmp3_);
				_tmp5_ = _tmp4_;
				if (!(_tmp2_ < _tmp5_)) {
					break;
				}
				_tmp6_ = self->priv->buttons;
				_tmp7_ = i;
				_tmp8_ = g_ptr_array_index (_tmp6_, (guint) _tmp7_);
				_tmp9_ = _g_object_ref0 ((AddImageButton*) _tmp8_);
				btn = _tmp9_;
				_tmp10_ = btn;
				_tmp11_ = width;
				gtk_widget_get_preferred_height_for_width (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_widget_get_type (), GtkWidget), _tmp11_, &_tmp12_, &_tmp13_);
				m = _tmp12_;
				n = _tmp13_;
				_tmp14_ = m;
				_tmp15_ = min;
				_tmp16_ = MAX (_tmp14_, _tmp15_);
				min = _tmp16_;
				_tmp17_ = n;
				_tmp18_ = nat;
				_tmp19_ = MAX (_tmp17_, _tmp18_);
				nat = _tmp19_;
				_g_object_unref0 (btn);
			}
		}
	}
	_tmp20_ = min;
	_vala_minimum = _tmp20_ + COMPOSE_IMAGE_MANAGER_BUTTON_DELTA;
	_tmp21_ = nat;
	_vala_natural = _tmp21_ + COMPOSE_IMAGE_MANAGER_BUTTON_DELTA;
	if (minimum) {
		*minimum = _vala_minimum;
	}
	if (natural) {
		*natural = _vala_natural;
	}
}


static void compose_image_manager_real_get_preferred_height (GtkWidget* base, gint* minimum, gint* natural) {
	ComposeImageManager * self;
	gint _vala_minimum = 0;
	gint _vala_natural = 0;
	gint min = 0;
	gint nat = 0;
	gint _tmp19_;
	gint _tmp20_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_COMPOSE_IMAGE_MANAGER, ComposeImageManager);
	min = 0;
	nat = 0;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				GPtrArray* _tmp3_;
				gint _tmp4_;
				gint _tmp5_;
				AddImageButton* btn = NULL;
				GPtrArray* _tmp6_;
				gint _tmp7_;
				gconstpointer _tmp8_;
				AddImageButton* _tmp9_;
				gint m = 0;
				gint n = 0;
				AddImageButton* _tmp10_;
				gint _tmp11_ = 0;
				gint _tmp12_ = 0;
				gint _tmp13_;
				gint _tmp14_;
				gint _tmp15_;
				gint _tmp16_;
				gint _tmp17_;
				gint _tmp18_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = self->priv->buttons;
				_tmp4_ = g_ptr_array_get_length (_tmp3_);
				_tmp5_ = _tmp4_;
				if (!(_tmp2_ < _tmp5_)) {
					break;
				}
				_tmp6_ = self->priv->buttons;
				_tmp7_ = i;
				_tmp8_ = g_ptr_array_index (_tmp6_, (guint) _tmp7_);
				_tmp9_ = _g_object_ref0 ((AddImageButton*) _tmp8_);
				btn = _tmp9_;
				_tmp10_ = btn;
				gtk_widget_get_preferred_height (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_widget_get_type (), GtkWidget), &_tmp11_, &_tmp12_);
				m = _tmp11_;
				n = _tmp12_;
				_tmp13_ = m;
				_tmp14_ = min;
				_tmp15_ = MAX (_tmp13_, _tmp14_);
				min = _tmp15_;
				_tmp16_ = n;
				_tmp17_ = nat;
				_tmp18_ = MAX (_tmp16_, _tmp17_);
				nat = _tmp18_;
				_g_object_unref0 (btn);
			}
		}
	}
	_tmp19_ = min;
	_vala_minimum = _tmp19_ + COMPOSE_IMAGE_MANAGER_BUTTON_DELTA;
	_tmp20_ = nat;
	_vala_natural = _tmp20_ + COMPOSE_IMAGE_MANAGER_BUTTON_DELTA;
	if (minimum) {
		*minimum = _vala_minimum;
	}
	if (natural) {
		*natural = _vala_natural;
	}
}


static void compose_image_manager_real_get_preferred_width (GtkWidget* base, gint* minimum, gint* natural) {
	ComposeImageManager * self;
	gint _vala_minimum = 0;
	gint _vala_natural = 0;
	gint min = 0;
	gint nat = 0;
	gint _tmp17_;
	GPtrArray* _tmp18_;
	gint _tmp19_;
	gint _tmp20_;
	gint _tmp21_;
	GPtrArray* _tmp22_;
	gint _tmp23_;
	gint _tmp24_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_COMPOSE_IMAGE_MANAGER, ComposeImageManager);
	min = 0;
	nat = 0;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				GPtrArray* _tmp3_;
				gint _tmp4_;
				gint _tmp5_;
				AddImageButton* btn = NULL;
				GPtrArray* _tmp6_;
				gint _tmp7_;
				gconstpointer _tmp8_;
				AddImageButton* _tmp9_;
				gint m = 0;
				gint n = 0;
				AddImageButton* _tmp10_;
				gint _tmp11_ = 0;
				gint _tmp12_ = 0;
				gint _tmp13_;
				gint _tmp14_;
				gint _tmp15_;
				gint _tmp16_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = self->priv->buttons;
				_tmp4_ = g_ptr_array_get_length (_tmp3_);
				_tmp5_ = _tmp4_;
				if (!(_tmp2_ < _tmp5_)) {
					break;
				}
				_tmp6_ = self->priv->buttons;
				_tmp7_ = i;
				_tmp8_ = g_ptr_array_index (_tmp6_, (guint) _tmp7_);
				_tmp9_ = _g_object_ref0 ((AddImageButton*) _tmp8_);
				btn = _tmp9_;
				_tmp10_ = btn;
				gtk_widget_get_preferred_width (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_widget_get_type (), GtkWidget), &_tmp11_, &_tmp12_);
				m = _tmp11_;
				n = _tmp12_;
				_tmp13_ = min;
				_tmp14_ = m;
				min = _tmp13_ + _tmp14_;
				_tmp15_ = nat;
				_tmp16_ = n;
				nat = _tmp15_ + _tmp16_;
				_g_object_unref0 (btn);
			}
		}
	}
	_tmp17_ = min;
	_tmp18_ = self->priv->buttons;
	_tmp19_ = g_ptr_array_get_length (_tmp18_);
	_tmp20_ = _tmp19_;
	_vala_minimum = _tmp17_ + (_tmp20_ * COMPOSE_IMAGE_MANAGER_BUTTON_SPACING);
	_tmp21_ = nat;
	_tmp22_ = self->priv->buttons;
	_tmp23_ = g_ptr_array_get_length (_tmp22_);
	_tmp24_ = _tmp23_;
	_vala_natural = _tmp21_ + (_tmp24_ * COMPOSE_IMAGE_MANAGER_BUTTON_SPACING);
	if (minimum) {
		*minimum = _vala_minimum;
	}
	if (natural) {
		*natural = _vala_natural;
	}
}


static gboolean compose_image_manager_real_draw (GtkWidget* base, cairo_t* ct) {
	ComposeImageManager * self;
	gboolean result = FALSE;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_COMPOSE_IMAGE_MANAGER, ComposeImageManager);
	g_return_val_if_fail (ct != NULL, FALSE);
	{
		gint i = 0;
		gint p = 0;
		GPtrArray* _tmp0_;
		gint _tmp1_;
		gint _tmp2_;
		i = 0;
		_tmp0_ = self->priv->buttons;
		_tmp1_ = g_ptr_array_get_length (_tmp0_);
		_tmp2_ = _tmp1_;
		p = _tmp2_;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				gint _tmp5_;
				gint _tmp6_;
				GtkWidget* btn = NULL;
				GPtrArray* _tmp7_;
				gint _tmp8_;
				gconstpointer _tmp9_;
				GtkWidget* _tmp10_;
				GtkWidget* _tmp11_;
				cairo_t* _tmp12_;
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp5_ = i;
				_tmp6_ = p;
				if (!(_tmp5_ < _tmp6_)) {
					break;
				}
				_tmp7_ = self->priv->buttons;
				_tmp8_ = i;
				_tmp9_ = g_ptr_array_index (_tmp7_, (guint) _tmp8_);
				_tmp10_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST ((AddImageButton*) _tmp9_, gtk_widget_get_type (), GtkWidget));
				btn = _tmp10_;
				_tmp11_ = btn;
				_tmp12_ = ct;
				gtk_container_propagate_draw (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_container_get_type (), GtkContainer), _tmp11_, _tmp12_);
				_g_object_unref0 (btn);
			}
		}
	}
	{
		gint i = 0;
		gint p = 0;
		GPtrArray* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		i = 0;
		_tmp13_ = self->priv->close_buttons;
		_tmp14_ = g_ptr_array_get_length (_tmp13_);
		_tmp15_ = _tmp14_;
		p = _tmp15_;
		{
			gboolean _tmp16_ = FALSE;
			_tmp16_ = TRUE;
			while (TRUE) {
				gint _tmp18_;
				gint _tmp19_;
				GtkButton* btn = NULL;
				GPtrArray* _tmp20_;
				gint _tmp21_;
				gconstpointer _tmp22_;
				GtkButton* _tmp23_;
				GtkButton* _tmp24_;
				cairo_t* _tmp25_;
				if (!_tmp16_) {
					gint _tmp17_;
					_tmp17_ = i;
					i = _tmp17_ + 1;
				}
				_tmp16_ = FALSE;
				_tmp18_ = i;
				_tmp19_ = p;
				if (!(_tmp18_ < _tmp19_)) {
					break;
				}
				_tmp20_ = self->priv->close_buttons;
				_tmp21_ = i;
				_tmp22_ = g_ptr_array_index (_tmp20_, (guint) _tmp21_);
				_tmp23_ = _g_object_ref0 ((GtkButton*) _tmp22_);
				btn = _tmp23_;
				_tmp24_ = btn;
				_tmp25_ = ct;
				gtk_container_propagate_draw (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, gtk_widget_get_type (), GtkWidget), _tmp25_);
				_g_object_unref0 (btn);
			}
		}
	}
	{
		gint i = 0;
		gint p = 0;
		GPtrArray* _tmp26_;
		gint _tmp27_;
		gint _tmp28_;
		i = 0;
		_tmp26_ = self->priv->progress_bars;
		_tmp27_ = g_ptr_array_get_length (_tmp26_);
		_tmp28_ = _tmp27_;
		p = _tmp28_;
		{
			gboolean _tmp29_ = FALSE;
			_tmp29_ = TRUE;
			while (TRUE) {
				gint _tmp31_;
				gint _tmp32_;
				GtkProgressBar* bar = NULL;
				GPtrArray* _tmp33_;
				gint _tmp34_;
				gconstpointer _tmp35_;
				GtkProgressBar* _tmp36_;
				GtkProgressBar* _tmp37_;
				cairo_t* _tmp38_;
				if (!_tmp29_) {
					gint _tmp30_;
					_tmp30_ = i;
					i = _tmp30_ + 1;
				}
				_tmp29_ = FALSE;
				_tmp31_ = i;
				_tmp32_ = p;
				if (!(_tmp31_ < _tmp32_)) {
					break;
				}
				_tmp33_ = self->priv->progress_bars;
				_tmp34_ = i;
				_tmp35_ = g_ptr_array_index (_tmp33_, (guint) _tmp34_);
				_tmp36_ = _g_object_ref0 ((GtkProgressBar*) _tmp35_);
				bar = _tmp36_;
				_tmp37_ = bar;
				_tmp38_ = ct;
				gtk_container_propagate_draw (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp37_, gtk_widget_get_type (), GtkWidget), _tmp38_);
				_g_object_unref0 (bar);
			}
		}
	}
	result = GDK_EVENT_PROPAGATE;
	return result;
}


static gpointer _cairo_surface_reference0 (gpointer self) {
	return self ? cairo_surface_reference (self) : NULL;
}


void compose_image_manager_load_image (ComposeImageManager* self, const gchar* path, GdkPixbuf* image) {
	cairo_surface_t* surface = NULL;
	GdkPixbuf* _tmp0_;
	AddImageButton* button = NULL;
	AddImageButton* _tmp7_;
	cairo_surface_t* _tmp8_;
	cairo_surface_t* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	g_return_if_fail (IS_COMPOSE_IMAGE_MANAGER (self));
	g_return_if_fail (path != NULL);
	g_return_if_fail ((image == NULL) || GDK_IS_PIXBUF (image));
	_tmp0_ = image;
	if (_tmp0_ == NULL) {
		const gchar* _tmp1_;
		cairo_surface_t* _tmp2_;
		_tmp1_ = path;
		_tmp2_ = load_surface (_tmp1_);
		_cairo_surface_destroy0 (surface);
		surface = (cairo_surface_t*) _tmp2_;
	} else {
		GdkPixbuf* _tmp3_;
		gint _tmp4_;
		GdkWindow* _tmp5_;
		cairo_surface_t* _tmp6_;
		_tmp3_ = image;
		_tmp4_ = gtk_widget_get_scale_factor (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
		_tmp5_ = gtk_widget_get_window (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
		_tmp6_ = gdk_cairo_surface_create_from_pixbuf (_tmp3_, _tmp4_, _tmp5_);
		_cairo_surface_destroy0 (surface);
		surface = (cairo_surface_t*) _tmp6_;
	}
	_tmp7_ = add_image_button_new ();
	g_object_ref_sink (_tmp7_);
	button = _tmp7_;
	_tmp8_ = surface;
	_tmp9_ = _cairo_surface_reference0 (_tmp8_);
	_cairo_surface_destroy0 (button->surface);
	button->surface = _tmp9_;
	_tmp10_ = path;
	_tmp11_ = g_strdup (_tmp10_);
	_g_free0 (button->image_path);
	button->image_path = _tmp11_;
	gtk_widget_set_hexpand (G_TYPE_CHECK_INSTANCE_CAST (button, gtk_widget_get_type (), GtkWidget), FALSE);
	gtk_widget_set_halign (G_TYPE_CHECK_INSTANCE_CAST (button, gtk_widget_get_type (), GtkWidget), GTK_ALIGN_START);
	gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (button, gtk_widget_get_type (), GtkWidget));
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (button, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (button);
	_cairo_surface_destroy0 (surface);
}


void compose_image_manager_set_image_progress (ComposeImageManager* self, const gchar* image_path, gdouble progress) {
	g_return_if_fail (IS_COMPOSE_IMAGE_MANAGER (self));
	g_return_if_fail (image_path != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				GPtrArray* _tmp3_;
				gint _tmp4_;
				gint _tmp5_;
				AddImageButton* btn = NULL;
				GPtrArray* _tmp6_;
				gint _tmp7_;
				gconstpointer _tmp8_;
				AddImageButton* _tmp9_;
				AddImageButton* _tmp10_;
				const gchar* _tmp11_;
				const gchar* _tmp12_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = self->priv->buttons;
				_tmp4_ = g_ptr_array_get_length (_tmp3_);
				_tmp5_ = _tmp4_;
				if (!(_tmp2_ < _tmp5_)) {
					break;
				}
				_tmp6_ = self->priv->buttons;
				_tmp7_ = i;
				_tmp8_ = g_ptr_array_index (_tmp6_, (guint) _tmp7_);
				_tmp9_ = _g_object_ref0 ((AddImageButton*) _tmp8_);
				btn = _tmp9_;
				_tmp10_ = btn;
				_tmp11_ = _tmp10_->image_path;
				_tmp12_ = image_path;
				if (g_strcmp0 (_tmp11_, _tmp12_) == 0) {
					GtkProgressBar* progress_bar = NULL;
					GPtrArray* _tmp13_;
					gint _tmp14_;
					gconstpointer _tmp15_;
					GtkProgressBar* _tmp16_;
					GtkProgressBar* _tmp17_;
					gdouble _tmp18_;
					gdouble _tmp19_;
					_tmp13_ = self->priv->progress_bars;
					_tmp14_ = i;
					_tmp15_ = g_ptr_array_index (_tmp13_, (guint) _tmp14_);
					_tmp16_ = _g_object_ref0 ((GtkProgressBar*) _tmp15_);
					progress_bar = _tmp16_;
					_tmp17_ = progress_bar;
					_tmp18_ = progress;
					gtk_progress_bar_set_fraction (_tmp17_, _tmp18_);
					_tmp19_ = progress;
					if (_tmp19_ == 1.0) {
						GtkProgressBar* _tmp20_;
						_tmp20_ = progress_bar;
						gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, gtk_widget_get_type (), GtkWidget));
					}
					_g_object_unref0 (progress_bar);
					_g_object_unref0 (btn);
					break;
				}
				_g_object_unref0 (btn);
			}
		}
	}
}


void compose_image_manager_end_progress (ComposeImageManager* self, const gchar* image_path, const gchar* error_message) {
	g_return_if_fail (IS_COMPOSE_IMAGE_MANAGER (self));
	g_return_if_fail (image_path != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				GPtrArray* _tmp3_;
				gint _tmp4_;
				gint _tmp5_;
				AddImageButton* btn = NULL;
				GPtrArray* _tmp6_;
				gint _tmp7_;
				gconstpointer _tmp8_;
				AddImageButton* _tmp9_;
				AddImageButton* _tmp10_;
				const gchar* _tmp11_;
				const gchar* _tmp12_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = self->priv->buttons;
				_tmp4_ = g_ptr_array_get_length (_tmp3_);
				_tmp5_ = _tmp4_;
				if (!(_tmp2_ < _tmp5_)) {
					break;
				}
				_tmp6_ = self->priv->buttons;
				_tmp7_ = i;
				_tmp8_ = g_ptr_array_index (_tmp6_, (guint) _tmp7_);
				_tmp9_ = _g_object_ref0 ((AddImageButton*) _tmp8_);
				btn = _tmp9_;
				_tmp10_ = btn;
				_tmp11_ = _tmp10_->image_path;
				_tmp12_ = image_path;
				if (g_strcmp0 (_tmp11_, _tmp12_) == 0) {
					AddImageButton* _tmp13_;
					GtkStyleContext* _tmp14_;
					const gchar* _tmp15_;
					_tmp13_ = btn;
					_tmp14_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, gtk_widget_get_type (), GtkWidget));
					gtk_style_context_remove_class (_tmp14_, "image-progress");
					_tmp15_ = error_message;
					if (_tmp15_ == NULL) {
						AddImageButton* _tmp16_;
						GtkStyleContext* _tmp17_;
						_tmp16_ = btn;
						_tmp17_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, gtk_widget_get_type (), GtkWidget));
						gtk_style_context_add_class (_tmp17_, "image-success");
					} else {
						const gchar* _tmp18_;
						const gchar* _tmp19_;
						AddImageButton* _tmp20_;
						GtkStyleContext* _tmp21_;
						_tmp18_ = image_path;
						_tmp19_ = error_message;
						g_warning ("ComposeImageManager.vala:316: %s: %s", _tmp18_, _tmp19_);
						_tmp20_ = btn;
						_tmp21_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, gtk_widget_get_type (), GtkWidget));
						gtk_style_context_add_class (_tmp21_, "image-error");
					}
					_g_object_unref0 (btn);
					break;
				}
				_g_object_unref0 (btn);
			}
		}
	}
}


void compose_image_manager_insensitivize_buttons (ComposeImageManager* self) {
	g_return_if_fail (IS_COMPOSE_IMAGE_MANAGER (self));
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				GPtrArray* _tmp3_;
				gint _tmp4_;
				gint _tmp5_;
				GPtrArray* _tmp6_;
				gint _tmp7_;
				gconstpointer _tmp8_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = self->priv->close_buttons;
				_tmp4_ = g_ptr_array_get_length (_tmp3_);
				_tmp5_ = _tmp4_;
				if (!(_tmp2_ < _tmp5_)) {
					break;
				}
				_tmp6_ = self->priv->close_buttons;
				_tmp7_ = i;
				_tmp8_ = g_ptr_array_index (_tmp6_, (guint) _tmp7_);
				gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST ((GtkButton*) _tmp8_, gtk_widget_get_type (), GtkWidget), FALSE);
			}
		}
	}
}


ComposeImageManager* compose_image_manager_construct (GType object_type) {
	ComposeImageManager * self = NULL;
	self = (ComposeImageManager*) g_object_new (object_type, NULL);
	return self;
}


ComposeImageManager* compose_image_manager_new (void) {
	return compose_image_manager_construct (TYPE_COMPOSE_IMAGE_MANAGER);
}


gint compose_image_manager_get_n_images (ComposeImageManager* self) {
	gint result;
	GPtrArray* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	g_return_val_if_fail (IS_COMPOSE_IMAGE_MANAGER (self), 0);
	_tmp0_ = self->priv->buttons;
	_tmp1_ = g_ptr_array_get_length (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}


gboolean compose_image_manager_get_has_gif (ComposeImageManager* self) {
	gboolean result;
	g_return_val_if_fail (IS_COMPOSE_IMAGE_MANAGER (self), FALSE);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				GPtrArray* _tmp3_;
				gint _tmp4_;
				gint _tmp5_;
				GPtrArray* _tmp6_;
				gint _tmp7_;
				gconstpointer _tmp8_;
				const gchar* _tmp9_;
				gboolean _tmp10_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = self->priv->buttons;
				_tmp4_ = g_ptr_array_get_length (_tmp3_);
				_tmp5_ = _tmp4_;
				if (!(_tmp2_ < _tmp5_)) {
					break;
				}
				_tmp6_ = self->priv->buttons;
				_tmp7_ = i;
				_tmp8_ = g_ptr_array_index (_tmp6_, (guint) _tmp7_);
				_tmp9_ = ((AddImageButton*) _tmp8_)->image_path;
				_tmp10_ = g_str_has_suffix (_tmp9_, ".gif");
				if (_tmp10_) {
					result = TRUE;
					return result;
				}
			}
		}
	}
	result = FALSE;
	return result;
}


gboolean compose_image_manager_get_full (ComposeImageManager* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	GPtrArray* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	g_return_val_if_fail (IS_COMPOSE_IMAGE_MANAGER (self), FALSE);
	_tmp1_ = self->priv->buttons;
	_tmp2_ = g_ptr_array_get_length (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == TWITTER_max_media_per_upload) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp4_;
		gboolean _tmp5_;
		_tmp4_ = compose_image_manager_get_has_gif (self);
		_tmp5_ = _tmp4_;
		_tmp0_ = _tmp5_;
	}
	result = _tmp0_;
	return result;
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static GObject * compose_image_manager_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	ComposeImageManager * self;
	GPtrArray* _tmp0_;
	GPtrArray* _tmp1_;
	GPtrArray* _tmp2_;
	parent_class = G_OBJECT_CLASS (compose_image_manager_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_COMPOSE_IMAGE_MANAGER, ComposeImageManager);
	_tmp0_ = g_ptr_array_new_full ((guint) 0, _g_object_unref0_);
	_g_ptr_array_unref0 (self->priv->buttons);
	self->priv->buttons = _tmp0_;
	_tmp1_ = g_ptr_array_new_full ((guint) 0, _g_object_unref0_);
	_g_ptr_array_unref0 (self->priv->close_buttons);
	self->priv->close_buttons = _tmp1_;
	_tmp2_ = g_ptr_array_new_full ((guint) 0, _g_object_unref0_);
	_g_ptr_array_unref0 (self->priv->progress_bars);
	self->priv->progress_bars = _tmp2_;
	gtk_widget_set_has_window (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), FALSE);
	return obj;
}


static void compose_image_manager_class_init (ComposeImageManagerClass * klass) {
	compose_image_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ComposeImageManagerPrivate));
	((GtkContainerClass *) klass)->forall = (void (*) (GtkContainer *, gboolean, GtkCallback, void*)) compose_image_manager_real_forall_internal;
	((GtkContainerClass *) klass)->add = (void (*) (GtkContainer *, GtkWidget*)) compose_image_manager_real_add;
	((GtkContainerClass *) klass)->remove = (void (*) (GtkContainer *, GtkWidget*)) compose_image_manager_real_remove;
	((GtkWidgetClass *) klass)->get_request_mode = (GtkSizeRequestMode (*) (GtkWidget *)) compose_image_manager_real_get_request_mode;
	((GtkWidgetClass *) klass)->size_allocate = (void (*) (GtkWidget *, GtkAllocation*)) compose_image_manager_real_size_allocate;
	((GtkWidgetClass *) klass)->get_preferred_height_for_width = (void (*) (GtkWidget *, gint, gint*, gint*)) compose_image_manager_real_get_preferred_height_for_width;
	((GtkWidgetClass *) klass)->get_preferred_height = (void (*) (GtkWidget *, gint*, gint*)) compose_image_manager_real_get_preferred_height;
	((GtkWidgetClass *) klass)->get_preferred_width = (void (*) (GtkWidget *, gint*, gint*)) compose_image_manager_real_get_preferred_width;
	((GtkWidgetClass *) klass)->draw = (gboolean (*) (GtkWidget *, cairo_t*)) compose_image_manager_real_draw;
	G_OBJECT_CLASS (klass)->get_property = _vala_compose_image_manager_get_property;
	G_OBJECT_CLASS (klass)->constructor = compose_image_manager_constructor;
	G_OBJECT_CLASS (klass)->finalize = compose_image_manager_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), COMPOSE_IMAGE_MANAGER_N_IMAGES, g_param_spec_int ("n-images", "n-images", "n-images", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), COMPOSE_IMAGE_MANAGER_HAS_GIF, g_param_spec_boolean ("has-gif", "has-gif", "has-gif", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), COMPOSE_IMAGE_MANAGER_FULL, g_param_spec_boolean ("full", "full", "full", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	compose_image_manager_signals[COMPOSE_IMAGE_MANAGER_IMAGE_REMOVED_SIGNAL] = g_signal_new ("image_removed", TYPE_COMPOSE_IMAGE_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
}


static void compose_image_manager_instance_init (ComposeImageManager * self) {
	self->priv = COMPOSE_IMAGE_MANAGER_GET_PRIVATE (self);
}


static void compose_image_manager_finalize (GObject * obj) {
	ComposeImageManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_COMPOSE_IMAGE_MANAGER, ComposeImageManager);
	_g_ptr_array_unref0 (self->priv->buttons);
	_g_ptr_array_unref0 (self->priv->close_buttons);
	_g_ptr_array_unref0 (self->priv->progress_bars);
	G_OBJECT_CLASS (compose_image_manager_parent_class)->finalize (obj);
}


GType compose_image_manager_get_type (void) {
	static volatile gsize compose_image_manager_type_id__volatile = 0;
	if (g_once_init_enter (&compose_image_manager_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ComposeImageManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) compose_image_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ComposeImageManager), 0, (GInstanceInitFunc) compose_image_manager_instance_init, NULL };
		GType compose_image_manager_type_id;
		compose_image_manager_type_id = g_type_register_static (gtk_container_get_type (), "ComposeImageManager", &g_define_type_info, 0);
		g_once_init_leave (&compose_image_manager_type_id__volatile, compose_image_manager_type_id);
	}
	return compose_image_manager_type_id__volatile;
}


static void _vala_compose_image_manager_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ComposeImageManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_COMPOSE_IMAGE_MANAGER, ComposeImageManager);
	switch (property_id) {
		case COMPOSE_IMAGE_MANAGER_N_IMAGES:
		g_value_set_int (value, compose_image_manager_get_n_images (self));
		break;
		case COMPOSE_IMAGE_MANAGER_HAS_GIF:
		g_value_set_boolean (value, compose_image_manager_get_has_gif (self));
		break;
		case COMPOSE_IMAGE_MANAGER_FULL:
		g_value_set_boolean (value, compose_image_manager_get_full (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



