/* AccountCreateWidget.c generated by valac 0.36.4, the Vala compiler
 * generated from AccountCreateWidget.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include "rest/oauth-proxy.h"
#include "CbUserStream.h"
#include "CbUserCounter.h"
#include "CbFilter.h"
#include <gio/gio.h>
#include "rest/rest-proxy-call.h"
#include "rest/rest-proxy.h"
#include <json-glib/json-glib.h>
#include "CbUtils.h"
#include <gdk/gdk.h>


#define TYPE_ACCOUNT_CREATE_WIDGET (account_create_widget_get_type ())
#define ACCOUNT_CREATE_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNT_CREATE_WIDGET, AccountCreateWidget))
#define ACCOUNT_CREATE_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ACCOUNT_CREATE_WIDGET, AccountCreateWidgetClass))
#define IS_ACCOUNT_CREATE_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNT_CREATE_WIDGET))
#define IS_ACCOUNT_CREATE_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ACCOUNT_CREATE_WIDGET))
#define ACCOUNT_CREATE_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ACCOUNT_CREATE_WIDGET, AccountCreateWidgetClass))

typedef struct _AccountCreateWidget AccountCreateWidget;
typedef struct _AccountCreateWidgetClass AccountCreateWidgetClass;
typedef struct _AccountCreateWidgetPrivate AccountCreateWidgetPrivate;

#define TYPE_ACCOUNT (account_get_type ())
#define ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNT, Account))
#define ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ACCOUNT, AccountClass))
#define IS_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNT))
#define IS_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ACCOUNT))
#define ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ACCOUNT, AccountClass))

typedef struct _Account Account;
typedef struct _AccountClass AccountClass;

#define TYPE_COREBIRD (corebird_get_type ())
#define COREBIRD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COREBIRD, Corebird))
#define COREBIRD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COREBIRD, CorebirdClass))
#define IS_COREBIRD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COREBIRD))
#define IS_COREBIRD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COREBIRD))
#define COREBIRD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COREBIRD, CorebirdClass))

typedef struct _Corebird Corebird;
typedef struct _CorebirdClass CorebirdClass;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _AccountPrivate AccountPrivate;

#define SQL_TYPE_DATABASE (sql_database_get_type ())
#define SQL_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SQL_TYPE_DATABASE, SqlDatabase))
#define SQL_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SQL_TYPE_DATABASE, SqlDatabaseClass))
#define SQL_IS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SQL_TYPE_DATABASE))
#define SQL_IS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SQL_TYPE_DATABASE))
#define SQL_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SQL_TYPE_DATABASE, SqlDatabaseClass))

typedef struct _SqlDatabase SqlDatabase;
typedef struct _SqlDatabaseClass SqlDatabaseClass;

#define TYPE_NOTIFICATION_MANAGER (notification_manager_get_type ())
#define NOTIFICATION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFICATION_MANAGER, NotificationManager))
#define NOTIFICATION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFICATION_MANAGER, NotificationManagerClass))
#define IS_NOTIFICATION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFICATION_MANAGER))
#define IS_NOTIFICATION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFICATION_MANAGER))
#define NOTIFICATION_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFICATION_MANAGER, NotificationManagerClass))

typedef struct _NotificationManager NotificationManager;
typedef struct _NotificationManagerClass NotificationManagerClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _AccountCreateWidgetConfirmButtonClickedCbData AccountCreateWidgetConfirmButtonClickedCbData;
#define __vala_JsonNode_free0(var) ((var == NULL) ? NULL : (var = (_vala_JsonNode_free (var), NULL)))
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))

#define SQL_TYPE_INSERT_STATEMENT (sql_insert_statement_get_type ())
#define SQL_INSERT_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SQL_TYPE_INSERT_STATEMENT, SqlInsertStatement))
#define SQL_INSERT_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SQL_TYPE_INSERT_STATEMENT, SqlInsertStatementClass))
#define SQL_IS_INSERT_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SQL_TYPE_INSERT_STATEMENT))
#define SQL_IS_INSERT_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SQL_TYPE_INSERT_STATEMENT))
#define SQL_INSERT_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SQL_TYPE_INSERT_STATEMENT, SqlInsertStatementClass))

typedef struct _SqlInsertStatement SqlInsertStatement;
typedef struct _SqlInsertStatementClass SqlInsertStatementClass;
typedef struct _AccountCreateWidgetDoConfirmData AccountCreateWidgetDoConfirmData;
enum  {
	ACCOUNT_CREATE_WIDGET_RESULT_RECEIVED_SIGNAL,
	ACCOUNT_CREATE_WIDGET_LAST_SIGNAL
};
static guint account_create_widget_signals[ACCOUNT_CREATE_WIDGET_LAST_SIGNAL] = {0};

struct _AccountCreateWidget {
	GtkBox parent_instance;
	AccountCreateWidgetPrivate * priv;
};

struct _AccountCreateWidgetClass {
	GtkBoxClass parent_class;
};

struct _AccountCreateWidgetPrivate {
	GtkEntry* pin_entry;
	GtkLabel* error_label;
	GtkButton* confirm_button;
	GtkButton* request_pin_button;
	GtkLabel* info_label;
	GtkStack* content_stack;
	Account* acc;
	Corebird* corebird;
	MainWindow* main_window;
};

struct _Account {
	GObject parent_instance;
	AccountPrivate * priv;
	gint64 id;
	SqlDatabase* db;
	gchar* screen_name;
	gchar* name;
	gchar* avatar_url;
	gchar* banner_url;
	gchar* website;
	gchar* description;
	OAuthProxy* proxy;
	CbUserStream* user_stream;
	CbUserCounter* user_counter;
	NotificationManager* notifications;
	gint64* friends;
	gint friends_length1;
	gint64* blocked;
	gint blocked_length1;
	gint64* muted;
	gint muted_length1;
	gint64* disabled_rts;
	gint disabled_rts_length1;
	GPtrArray* filters;
};

struct _AccountClass {
	GObjectClass parent_class;
};

struct _AccountCreateWidgetConfirmButtonClickedCbData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	AccountCreateWidget* self;
	GtkEntry* _tmp0_;
	GtkButton* _tmp1_;
	GtkButton* _tmp2_;
};

struct _AccountCreateWidgetDoConfirmData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	AccountCreateWidget* self;
	Account* _tmp0_;
	OAuthProxy* _tmp1_;
	GtkEntry* _tmp2_;
	const gchar* _tmp3_;
	GError* e;
	GError* _tmp4_;
	const gchar* _tmp5_;
	GtkEntry* _tmp6_;
	GtkButton* _tmp7_;
	GtkButton* _tmp8_;
	RestProxyCall* call;
	Account* _tmp9_;
	OAuthProxy* _tmp10_;
	RestProxyCall* _tmp11_;
	RestProxyCall* _tmp12_;
	RestProxyCall* _tmp13_;
	JsonNode* root_node;
	JsonNode* _tmp14_;
	RestProxyCall* _tmp15_;
	JsonNode* _tmp16_;
	JsonNode* _tmp17_;
	GError* _vala1_e;
	GError* _tmp18_;
	const gchar* _tmp19_;
	JsonObject* root;
	JsonNode* _tmp20_;
	JsonObject* _tmp21_;
	JsonObject* _tmp22_;
	gchar* screen_name;
	JsonObject* _tmp23_;
	const gchar* _tmp24_;
	gchar* _tmp25_;
	const gchar* _tmp26_;
	Account* existing_account;
	const gchar* _tmp27_;
	Account* _tmp28_;
	Account* _tmp29_;
	Account* _tmp30_;
	Account* _tmp31_;
	GtkEntry* _tmp32_;
	GtkEntry* _tmp33_;
	GtkButton* _tmp34_;
	Account* _tmp35_;
	const gchar* _tmp36_;
	Account* _tmp37_;
	Account* _tmp38_;
	Account* _tmp39_;
	SqlDatabase* _tmp40_;
	SqlInsertStatement* _tmp41_;
	SqlInsertStatement* _tmp42_;
	Account* _tmp43_;
	OAuthProxy* _tmp44_;
	const gchar* _tmp45_;
	const gchar* _tmp46_;
	SqlInsertStatement* _tmp47_;
	SqlInsertStatement* _tmp48_;
	Account* _tmp49_;
	OAuthProxy* _tmp50_;
	const gchar* _tmp51_;
	const gchar* _tmp52_;
	SqlInsertStatement* _tmp53_;
	SqlInsertStatement* _tmp54_;
	Account* _tmp55_;
	Corebird* _tmp56_;
	Account* _tmp57_;
	Account* _tmp58_;
	GError * _inner_error_;
};


static gpointer account_create_widget_parent_class = NULL;

GType account_create_widget_get_type (void) G_GNUC_CONST;
GType account_get_type (void) G_GNUC_CONST;
GType corebird_get_type (void) G_GNUC_CONST;
GType main_window_get_type (void) G_GNUC_CONST;
#define ACCOUNT_CREATE_WIDGET_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_ACCOUNT_CREATE_WIDGET, AccountCreateWidgetPrivate))
enum  {
	ACCOUNT_CREATE_WIDGET_DUMMY_PROPERTY
};
AccountCreateWidget* account_create_widget_new (Account* acc, Corebird* corebird, MainWindow* main_window);
AccountCreateWidget* account_create_widget_construct (GType object_type, Account* acc, Corebird* corebird, MainWindow* main_window);
static void account_create_widget_pin_changed_cb (AccountCreateWidget* self);
static void _account_create_widget_pin_changed_cb_gtk_entry_buffer_deleted_text (GtkEntryBuffer* _sender, guint position, guint n_chars, gpointer self);
static void _account_create_widget_pin_changed_cb_gtk_entry_buffer_inserted_text (GtkEntryBuffer* _sender, guint position, const gchar* chars, guint n_chars, gpointer self);
void account_create_widget_open_pin_request_site (AccountCreateWidget* self);
void account_init_proxy (Account* self, gboolean load_secrets, gboolean force);
GType sql_database_get_type (void) G_GNUC_CONST;
GType notification_manager_get_type (void) G_GNUC_CONST;
static void __lambda136_ (AccountCreateWidget* self, GObject* obj, GAsyncResult* res);
void utils_show_error_dialog (const gchar* message, GtkWindow* transient_for);
static void account_create_widget_show_error (AccountCreateWidget* self, const gchar* err);
static void ___lambda136__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void account_create_widget_request_pin_clicked_cb (AccountCreateWidget* self);
static void _account_create_widget_request_pin_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void account_create_widget_confirm_button_clicked_cb_data_free (gpointer _data);
static void account_create_widget_confirm_button_clicked_cb (AccountCreateWidget* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void account_create_widget_confirm_button_clicked_cb_finish (AccountCreateWidget* self, GAsyncResult* _res_);
static gboolean account_create_widget_confirm_button_clicked_cb_co (AccountCreateWidgetConfirmButtonClickedCbData* _data_);
static void account_create_widget_do_confirm (AccountCreateWidget* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void account_create_widget_do_confirm_finish (AccountCreateWidget* self, GAsyncResult* _res_);
static void _account_create_widget_confirm_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void account_create_widget_do_confirm_data_free (gpointer _data);
static gboolean account_create_widget_do_confirm_co (AccountCreateWidgetDoConfirmData* _data_);
static void account_create_widget_do_confirm_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _vala_JsonNode_free (JsonNode* self);
Account* account_query_account (const gchar* screen_name);
void account_query_user_info_by_screen_name (Account* self, const gchar* screen_name, GAsyncReadyCallback _callback_, gpointer _user_data_);
void account_query_user_info_by_screen_name_finish (Account* self, GAsyncResult* _res_);
void account_init_database (Account* self);
void account_save_info (Account* self);
GType sql_insert_statement_get_type (void) G_GNUC_CONST;
SqlInsertStatement* sql_database_insert (SqlDatabase* self, const gchar* table_name);
SqlInsertStatement* sql_insert_statement_val (SqlInsertStatement* self, const gchar* col_name, const gchar* col_value);
gint64 sql_insert_statement_run (SqlInsertStatement* self);
static gboolean account_create_widget_delete_event_cb (AccountCreateWidget* self);
void account_remove_account (const gchar* screen_name);
#define ACCOUNT_DUMMY "screen_name"
static gboolean _account_create_widget_delete_event_cb_gtk_widget_delete_event (GtkWidget* _sender, GdkEventAny* event, gpointer self);
static void g_cclosure_user_marshal_VOID__BOOLEAN_OBJECT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void account_create_widget_finalize (GObject * obj);


static void _account_create_widget_pin_changed_cb_gtk_entry_buffer_deleted_text (GtkEntryBuffer* _sender, guint position, guint n_chars, gpointer self) {
	account_create_widget_pin_changed_cb ((AccountCreateWidget*) self);
}


static void _account_create_widget_pin_changed_cb_gtk_entry_buffer_inserted_text (GtkEntryBuffer* _sender, guint position, const gchar* chars, guint n_chars, gpointer self) {
	account_create_widget_pin_changed_cb ((AccountCreateWidget*) self);
}


AccountCreateWidget* account_create_widget_construct (GType object_type, Account* acc, Corebird* corebird, MainWindow* main_window) {
	AccountCreateWidget * self = NULL;
	Account* _tmp0_;
	Corebird* _tmp1_;
	MainWindow* _tmp2_;
	GtkLabel* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GtkEntry* _tmp6_;
	GtkEntryBuffer* _tmp7_;
	GtkEntryBuffer* _tmp8_;
	GtkEntry* _tmp9_;
	GtkEntryBuffer* _tmp10_;
	GtkEntryBuffer* _tmp11_;
	g_return_val_if_fail (IS_ACCOUNT (acc), NULL);
	g_return_val_if_fail (IS_COREBIRD (corebird), NULL);
	g_return_val_if_fail (IS_MAIN_WINDOW (main_window), NULL);
	self = (AccountCreateWidget*) g_object_new (object_type, NULL);
	_tmp0_ = acc;
	self->priv->acc = _tmp0_;
	_tmp1_ = corebird;
	self->priv->corebird = _tmp1_;
	_tmp2_ = main_window;
	self->priv->main_window = _tmp2_;
	_tmp3_ = self->priv->info_label;
	_tmp4_ = g_strdup_printf ("%s <a href=\"https://twitter.com/signup\">%s</a>", _ ("Don’t have a Twitter account yet?"), _ ("Create one"));
	_tmp5_ = _tmp4_;
	gtk_label_set_label (_tmp3_, _tmp5_);
	_g_free0 (_tmp5_);
	_tmp6_ = self->priv->pin_entry;
	_tmp7_ = gtk_entry_get_buffer (_tmp6_);
	_tmp8_ = _tmp7_;
	g_signal_connect_object (_tmp8_, "deleted-text", (GCallback) _account_create_widget_pin_changed_cb_gtk_entry_buffer_deleted_text, self, 0);
	_tmp9_ = self->priv->pin_entry;
	_tmp10_ = gtk_entry_get_buffer (_tmp9_);
	_tmp11_ = _tmp10_;
	g_signal_connect_object (_tmp11_, "inserted-text", (GCallback) _account_create_widget_pin_changed_cb_gtk_entry_buffer_inserted_text, self, 0);
	return self;
}


AccountCreateWidget* account_create_widget_new (Account* acc, Corebird* corebird, MainWindow* main_window) {
	return account_create_widget_construct (TYPE_ACCOUNT_CREATE_WIDGET, acc, corebird, main_window);
}


static void __lambda136_ (AccountCreateWidget* self, GObject* obj, GAsyncResult* res) {
	gchar* uri = NULL;
	Account* _tmp14_;
	OAuthProxy* _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	const gchar* _tmp18_;
	GError * _inner_error_ = NULL;
	g_return_if_fail ((obj == NULL) || G_IS_OBJECT (obj));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	{
		Account* _tmp0_;
		OAuthProxy* _tmp1_;
		GAsyncResult* _tmp2_;
		_tmp0_ = self->priv->acc;
		_tmp1_ = _tmp0_->proxy;
		_tmp2_ = res;
		oauth_proxy_request_token_finish (_tmp1_, _tmp2_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch44_g_error;
		}
	}
	goto __finally44;
	__catch44_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gboolean _tmp7_;
		GError* _tmp12_;
		const gchar* _tmp13_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		_tmp5_ = g_utf8_strdown (_tmp4_, (gssize) -1);
		_tmp6_ = _tmp5_;
		_tmp7_ = g_strcmp0 (_tmp6_, "unauthorized") == 0;
		_g_free0 (_tmp6_);
		if (_tmp7_) {
			MainWindow* _tmp8_;
			_tmp8_ = self->priv->main_window;
			utils_show_error_dialog (_ ("Unauthorized. Most of the time, this means that there’s something wron" \
"g with the Twitter servers and you should try again later"), G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_window_get_type (), GtkWindow));
		} else {
			GError* _tmp9_;
			const gchar* _tmp10_;
			MainWindow* _tmp11_;
			_tmp9_ = e;
			_tmp10_ = _tmp9_->message;
			_tmp11_ = self->priv->main_window;
			utils_show_error_dialog (_tmp10_, G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, gtk_window_get_type (), GtkWindow));
		}
		_tmp12_ = e;
		_tmp13_ = _tmp12_->message;
		g_critical ("AccountCreateWidget.vala:59: %s", _tmp13_);
		_g_error_free0 (e);
		return;
	}
	__finally44:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp14_ = self->priv->acc;
	_tmp15_ = _tmp14_->proxy;
	_tmp16_ = oauth_proxy_get_token (_tmp15_);
	_tmp17_ = g_strconcat ("http://twitter.com/oauth/authorize?oauth_token=", _tmp16_, NULL);
	uri = _tmp17_;
	_tmp18_ = uri;
	g_debug ("AccountCreateWidget.vala:64: Trying to open %s", _tmp18_);
	{
		const gchar* _tmp19_;
		_tmp19_ = uri;
		g_app_info_launch_default_for_uri (_tmp19_, NULL, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch45_g_error;
		}
	}
	goto __finally45;
	__catch45_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		const gchar* _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		gchar* _tmp29_;
		gchar* _tmp30_;
		gchar* _tmp31_;
		GError* _tmp32_;
		const gchar* _tmp33_;
		MainWindow* _tmp34_;
		const gchar* _tmp35_;
		GError* _tmp36_;
		const gchar* _tmp37_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp20_ = uri;
		_tmp21_ = g_strconcat ("<a href=\"", _tmp20_, NULL);
		_tmp22_ = _tmp21_;
		_tmp23_ = g_strconcat (_tmp22_, "\">", NULL);
		_tmp24_ = _tmp23_;
		_tmp25_ = uri;
		_tmp26_ = g_strconcat (_tmp24_, _tmp25_, NULL);
		_tmp27_ = _tmp26_;
		_tmp28_ = g_strconcat (_tmp27_, "</a>", NULL);
		_tmp29_ = _tmp28_;
		_tmp30_ = g_strdup_printf (_ ("Could not open %s"), _tmp29_);
		_tmp31_ = _tmp30_;
		account_create_widget_show_error (self, _tmp31_);
		_g_free0 (_tmp31_);
		_g_free0 (_tmp29_);
		_g_free0 (_tmp27_);
		_g_free0 (_tmp24_);
		_g_free0 (_tmp22_);
		_tmp32_ = e;
		_tmp33_ = _tmp32_->message;
		_tmp34_ = self->priv->main_window;
		utils_show_error_dialog (_tmp33_, G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, gtk_window_get_type (), GtkWindow));
		_tmp35_ = uri;
		g_critical ("AccountCreateWidget.vala:71: Could not open %s", _tmp35_);
		_tmp36_ = e;
		_tmp37_ = _tmp36_->message;
		g_critical ("AccountCreateWidget.vala:72: %s", _tmp37_);
		_g_error_free0 (e);
	}
	__finally45:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (uri);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (uri);
}


static void ___lambda136__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda136_ ((AccountCreateWidget*) self, source_object, res);
	g_object_unref (self);
}


void account_create_widget_open_pin_request_site (AccountCreateWidget* self) {
	Account* _tmp0_;
	Account* _tmp1_;
	OAuthProxy* _tmp2_;
	g_return_if_fail (IS_ACCOUNT_CREATE_WIDGET (self));
	_tmp0_ = self->priv->acc;
	account_init_proxy (_tmp0_, FALSE, TRUE);
	_tmp1_ = self->priv->acc;
	_tmp2_ = _tmp1_->proxy;
	oauth_proxy_request_token_async (_tmp2_, "oauth/request_token", "oob", NULL, ___lambda136__gasync_ready_callback, g_object_ref (self));
}


static void account_create_widget_request_pin_clicked_cb (AccountCreateWidget* self) {
	GtkStack* _tmp0_;
	g_return_if_fail (IS_ACCOUNT_CREATE_WIDGET (self));
	account_create_widget_open_pin_request_site (self);
	_tmp0_ = self->priv->content_stack;
	gtk_stack_set_visible_child_name (_tmp0_, "pin");
}


static void _account_create_widget_request_pin_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	account_create_widget_request_pin_clicked_cb ((AccountCreateWidget*) self);
}


static void account_create_widget_confirm_button_clicked_cb_data_free (gpointer _data) {
	AccountCreateWidgetConfirmButtonClickedCbData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (AccountCreateWidgetConfirmButtonClickedCbData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void account_create_widget_confirm_button_clicked_cb (AccountCreateWidget* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	AccountCreateWidgetConfirmButtonClickedCbData* _data_;
	AccountCreateWidget* _tmp0_;
	_data_ = g_slice_new0 (AccountCreateWidgetConfirmButtonClickedCbData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, account_create_widget_confirm_button_clicked_cb_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	account_create_widget_confirm_button_clicked_cb_co (_data_);
}


static void account_create_widget_confirm_button_clicked_cb_finish (AccountCreateWidget* self, GAsyncResult* _res_) {
	AccountCreateWidgetConfirmButtonClickedCbData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}


static gboolean account_create_widget_confirm_button_clicked_cb_co (AccountCreateWidgetConfirmButtonClickedCbData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->pin_entry;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp0_, gtk_widget_get_type (), GtkWidget), FALSE);
	_data_->_tmp1_ = _data_->self->priv->confirm_button;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp1_, gtk_widget_get_type (), GtkWidget), FALSE);
	_data_->_tmp2_ = _data_->self->priv->request_pin_button;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp2_, gtk_widget_get_type (), GtkWidget), FALSE);
	account_create_widget_do_confirm (_data_->self, NULL, NULL);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (g_task_get_completed (_data_->_async_result) != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void _account_create_widget_confirm_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	account_create_widget_confirm_button_clicked_cb ((AccountCreateWidget*) self, NULL, NULL);
}


static void account_create_widget_do_confirm_data_free (gpointer _data) {
	AccountCreateWidgetDoConfirmData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (AccountCreateWidgetDoConfirmData, _data_);
}


static void account_create_widget_do_confirm (AccountCreateWidget* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	AccountCreateWidgetDoConfirmData* _data_;
	AccountCreateWidget* _tmp0_;
	_data_ = g_slice_new0 (AccountCreateWidgetDoConfirmData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, account_create_widget_do_confirm_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	account_create_widget_do_confirm_co (_data_);
}


static void account_create_widget_do_confirm_finish (AccountCreateWidget* self, GAsyncResult* _res_) {
	AccountCreateWidgetDoConfirmData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}


static void account_create_widget_do_confirm_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	AccountCreateWidgetDoConfirmData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	account_create_widget_do_confirm_co (_data_);
}


static void _vala_JsonNode_free (JsonNode* self) {
	g_boxed_free (json_node_get_type (), self);
}


static gpointer _json_object_ref0 (gpointer self) {
	return self ? json_object_ref (self) : NULL;
}


static gboolean account_create_widget_do_confirm_co (AccountCreateWidgetDoConfirmData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp0_ = _data_->self->priv->acc;
		_data_->_tmp1_ = _data_->_tmp0_->proxy;
		_data_->_tmp2_ = _data_->self->priv->pin_entry;
		_data_->_tmp3_ = gtk_entry_get_text (_data_->_tmp2_);
		_data_->_state_ = 1;
		oauth_proxy_access_token_async (_data_->_tmp1_, "oauth/access_token", _data_->_tmp3_, NULL, account_create_widget_do_confirm_ready, _data_);
		return FALSE;
		_state_1:
		oauth_proxy_access_token_finish (_data_->_tmp1_, _data_->_res_, &_data_->_inner_error_);
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			goto __catch46_g_error;
		}
	}
	goto __finally46;
	__catch46_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp4_ = _data_->e;
		_data_->_tmp5_ = _data_->_tmp4_->message;
		g_critical ("AccountCreateWidget.vala:96: %s", _data_->_tmp5_);
		account_create_widget_show_error (_data_->self, _ ("Wrong PIN"));
		_data_->_tmp6_ = _data_->self->priv->pin_entry;
		gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp6_, gtk_widget_get_type (), GtkWidget), TRUE);
		_data_->_tmp7_ = _data_->self->priv->confirm_button;
		gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp7_, gtk_widget_get_type (), GtkWidget), TRUE);
		_data_->_tmp8_ = _data_->self->priv->request_pin_button;
		gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp8_, gtk_widget_get_type (), GtkWidget), TRUE);
		_g_error_free0 (_data_->e);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (g_task_get_completed (_data_->_async_result) != TRUE) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally46:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp9_ = _data_->self->priv->acc;
	_data_->_tmp10_ = _data_->_tmp9_->proxy;
	_data_->_tmp11_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp10_, rest_proxy_get_type (), RestProxy));
	_data_->call = _data_->_tmp11_;
	_data_->_tmp12_ = _data_->call;
	rest_proxy_call_set_function (_data_->_tmp12_, "1.1/account/settings.json");
	_data_->_tmp13_ = _data_->call;
	rest_proxy_call_set_method (_data_->_tmp13_, "GET");
	{
		_data_->_tmp15_ = _data_->call;
		_data_->_state_ = 2;
		cb_utils_load_threaded_async (_data_->_tmp15_, NULL, account_create_widget_do_confirm_ready, _data_);
		return FALSE;
		_state_2:
		_data_->_tmp16_ = cb_utils_load_threaded_finish (_data_->_res_, &_data_->_inner_error_);
		_data_->_tmp14_ = _data_->_tmp16_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			goto __catch47_g_error;
		}
		_data_->_tmp17_ = _data_->_tmp14_;
		_data_->_tmp14_ = NULL;
		__vala_JsonNode_free0 (_data_->root_node);
		_data_->root_node = _data_->_tmp17_;
		__vala_JsonNode_free0 (_data_->_tmp14_);
	}
	goto __finally47;
	__catch47_g_error:
	{
		_data_->_vala1_e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp18_ = _data_->_vala1_e;
		_data_->_tmp19_ = _data_->_tmp18_->message;
		g_warning ("AccountCreateWidget.vala:113: Could not get json data: %s", _data_->_tmp19_);
		_g_error_free0 (_data_->_vala1_e);
		__vala_JsonNode_free0 (_data_->root_node);
		_g_object_unref0 (_data_->call);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (g_task_get_completed (_data_->_async_result) != TRUE) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally47:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		__vala_JsonNode_free0 (_data_->root_node);
		_g_object_unref0 (_data_->call);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp20_ = _data_->root_node;
	_data_->_tmp21_ = json_node_get_object (_data_->_tmp20_);
	_data_->_tmp22_ = _json_object_ref0 (_data_->_tmp21_);
	_data_->root = _data_->_tmp22_;
	_data_->_tmp23_ = _data_->root;
	_data_->_tmp24_ = json_object_get_string_member (_data_->_tmp23_, "screen_name");
	_data_->_tmp25_ = g_strdup (_data_->_tmp24_);
	_data_->screen_name = _data_->_tmp25_;
	_data_->_tmp26_ = _data_->screen_name;
	g_debug ("AccountCreateWidget.vala:119: Checking for %s", _data_->_tmp26_);
	_data_->_tmp27_ = _data_->screen_name;
	_data_->_tmp28_ = account_query_account (_data_->_tmp27_);
	_data_->_tmp29_ = _g_object_ref0 (_data_->_tmp28_);
	_data_->existing_account = _data_->_tmp29_;
	_data_->_tmp30_ = _data_->existing_account;
	if (_data_->_tmp30_ != NULL) {
		_data_->_tmp31_ = _data_->existing_account;
		g_signal_emit (_data_->self, account_create_widget_signals[ACCOUNT_CREATE_WIDGET_RESULT_RECEIVED_SIGNAL], 0, FALSE, _data_->_tmp31_);
		g_critical ("AccountCreateWidget.vala:123: Account is already in use");
		account_create_widget_show_error (_data_->self, _ ("Account already in use"));
		_data_->_tmp32_ = _data_->self->priv->pin_entry;
		gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp32_, gtk_widget_get_type (), GtkWidget), TRUE);
		_data_->_tmp33_ = _data_->self->priv->pin_entry;
		gtk_entry_set_text (_data_->_tmp33_, "");
		_data_->_tmp34_ = _data_->self->priv->request_pin_button;
		gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp34_, gtk_widget_get_type (), GtkWidget), TRUE);
		_g_object_unref0 (_data_->existing_account);
		_g_free0 (_data_->screen_name);
		_json_object_unref0 (_data_->root);
		__vala_JsonNode_free0 (_data_->root_node);
		_g_object_unref0 (_data_->call);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (g_task_get_completed (_data_->_async_result) != TRUE) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp35_ = _data_->self->priv->acc;
	_data_->_tmp36_ = _data_->screen_name;
	_data_->_state_ = 3;
	account_query_user_info_by_screen_name (_data_->_tmp35_, _data_->_tmp36_, account_create_widget_do_confirm_ready, _data_);
	return FALSE;
	_state_3:
	account_query_user_info_by_screen_name_finish (_data_->_tmp35_, _data_->_res_);
	g_debug ("AccountCreateWidget.vala:132: user info call");
	_data_->_tmp37_ = _data_->self->priv->acc;
	account_init_database (_data_->_tmp37_);
	_data_->_tmp38_ = _data_->self->priv->acc;
	account_save_info (_data_->_tmp38_);
	_data_->_tmp39_ = _data_->self->priv->acc;
	_data_->_tmp40_ = _data_->_tmp39_->db;
	_data_->_tmp41_ = sql_database_insert (_data_->_tmp40_, "common");
	_data_->_tmp42_ = _data_->_tmp41_;
	_data_->_tmp43_ = _data_->self->priv->acc;
	_data_->_tmp44_ = _data_->_tmp43_->proxy;
	_data_->_tmp45_ = oauth_proxy_get_token (_data_->_tmp44_);
	_data_->_tmp46_ = _data_->_tmp45_;
	_data_->_tmp47_ = sql_insert_statement_val (_data_->_tmp42_, "token", _data_->_tmp46_);
	_data_->_tmp48_ = _data_->_tmp47_;
	_data_->_tmp49_ = _data_->self->priv->acc;
	_data_->_tmp50_ = _data_->_tmp49_->proxy;
	_data_->_tmp51_ = oauth_proxy_get_token_secret (_data_->_tmp50_);
	_data_->_tmp52_ = _data_->_tmp51_;
	_data_->_tmp53_ = sql_insert_statement_val (_data_->_tmp48_, "token_secret", _data_->_tmp52_);
	_data_->_tmp54_ = _data_->_tmp53_;
	sql_insert_statement_run (_data_->_tmp54_);
	_g_object_unref0 (_data_->_tmp54_);
	_g_object_unref0 (_data_->_tmp48_);
	_g_object_unref0 (_data_->_tmp42_);
	_data_->_tmp55_ = _data_->self->priv->acc;
	account_init_proxy (_data_->_tmp55_, TRUE, TRUE);
	_data_->_tmp56_ = _data_->self->priv->corebird;
	_data_->_tmp57_ = _data_->self->priv->acc;
	g_signal_emit_by_name (_data_->_tmp56_, "account-added", _data_->_tmp57_);
	_data_->_tmp58_ = _data_->self->priv->acc;
	g_signal_emit (_data_->self, account_create_widget_signals[ACCOUNT_CREATE_WIDGET_RESULT_RECEIVED_SIGNAL], 0, TRUE, _data_->_tmp58_);
	_g_object_unref0 (_data_->existing_account);
	_g_free0 (_data_->screen_name);
	_json_object_unref0 (_data_->root);
	__vala_JsonNode_free0 (_data_->root_node);
	_g_object_unref0 (_data_->call);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (g_task_get_completed (_data_->_async_result) != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void account_create_widget_show_error (AccountCreateWidget* self, const gchar* err) {
	GtkLabel* _tmp0_;
	GtkLabel* _tmp1_;
	GtkLabel* _tmp2_;
	const gchar* _tmp3_;
	g_return_if_fail (IS_ACCOUNT_CREATE_WIDGET (self));
	g_return_if_fail (err != NULL);
	_tmp0_ = self->priv->info_label;
	gtk_widget_set_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_widget_get_type (), GtkWidget), FALSE);
	_tmp1_ = self->priv->error_label;
	gtk_widget_set_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_widget_get_type (), GtkWidget), TRUE);
	_tmp2_ = self->priv->error_label;
	_tmp3_ = err;
	gtk_label_set_label (_tmp2_, _tmp3_);
}


static void account_create_widget_pin_changed_cb (AccountCreateWidget* self) {
	gchar* text = NULL;
	GtkEntry* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gboolean confirm_possible = FALSE;
	GtkButton* _tmp9_;
	g_return_if_fail (IS_ACCOUNT_CREATE_WIDGET (self));
	_tmp0_ = self->priv->pin_entry;
	_tmp1_ = gtk_entry_get_text (_tmp0_);
	_tmp2_ = g_strdup (_tmp1_);
	text = _tmp2_;
	_tmp4_ = text;
	_tmp5_ = strlen (_tmp4_);
	_tmp6_ = _tmp5_;
	if (_tmp6_ > 0) {
		Account* _tmp7_;
		OAuthProxy* _tmp8_;
		_tmp7_ = self->priv->acc;
		_tmp8_ = _tmp7_->proxy;
		_tmp3_ = _tmp8_ != NULL;
	} else {
		_tmp3_ = FALSE;
	}
	confirm_possible = _tmp3_;
	_tmp9_ = self->priv->confirm_button;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_widget_get_type (), GtkWidget), confirm_possible);
	_g_free0 (text);
}


static gboolean account_create_widget_delete_event_cb (AccountCreateWidget* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (IS_ACCOUNT_CREATE_WIDGET (self), FALSE);
	account_remove_account (ACCOUNT_DUMMY);
	result = FALSE;
	return result;
}


static gboolean _account_create_widget_delete_event_cb_gtk_widget_delete_event (GtkWidget* _sender, GdkEventAny* event, gpointer self) {
	gboolean result;
	result = account_create_widget_delete_event_cb ((AccountCreateWidget*) self);
	return result;
}


static void g_cclosure_user_marshal_VOID__BOOLEAN_OBJECT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__BOOLEAN_OBJECT) (gpointer data1, gboolean arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__BOOLEAN_OBJECT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__BOOLEAN_OBJECT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_boolean (param_values + 1), g_value_get_object (param_values + 2), data2);
}


static void account_create_widget_class_init (AccountCreateWidgetClass * klass) {
	gint AccountCreateWidget_private_offset;
	account_create_widget_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (AccountCreateWidgetPrivate));
	G_OBJECT_CLASS (klass)->finalize = account_create_widget_finalize;
	AccountCreateWidget_private_offset = g_type_class_get_instance_private_offset (klass);
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/baedert/corebird/ui/account-create-widget.ui");
	account_create_widget_signals[ACCOUNT_CREATE_WIDGET_RESULT_RECEIVED_SIGNAL] = g_signal_new ("result_received", TYPE_ACCOUNT_CREATE_WIDGET, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__BOOLEAN_OBJECT, G_TYPE_NONE, 2, G_TYPE_BOOLEAN, TYPE_ACCOUNT);
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "pin_entry", FALSE, AccountCreateWidget_private_offset + G_STRUCT_OFFSET (AccountCreateWidgetPrivate, pin_entry));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "error_label", FALSE, AccountCreateWidget_private_offset + G_STRUCT_OFFSET (AccountCreateWidgetPrivate, error_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "confirm_button", FALSE, AccountCreateWidget_private_offset + G_STRUCT_OFFSET (AccountCreateWidgetPrivate, confirm_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "request_pin_button", FALSE, AccountCreateWidget_private_offset + G_STRUCT_OFFSET (AccountCreateWidgetPrivate, request_pin_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "info_label", FALSE, AccountCreateWidget_private_offset + G_STRUCT_OFFSET (AccountCreateWidgetPrivate, info_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "content_stack", FALSE, AccountCreateWidget_private_offset + G_STRUCT_OFFSET (AccountCreateWidgetPrivate, content_stack));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "request_pin_clicked_cb", G_CALLBACK(_account_create_widget_request_pin_clicked_cb_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "confirm_button_clicked_cb", G_CALLBACK(_account_create_widget_confirm_button_clicked_cb_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "delete_event_cb", G_CALLBACK(_account_create_widget_delete_event_cb_gtk_widget_delete_event));
}


static void account_create_widget_instance_init (AccountCreateWidget * self) {
	self->priv = ACCOUNT_CREATE_WIDGET_GET_PRIVATE (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}


static void account_create_widget_finalize (GObject * obj) {
	AccountCreateWidget * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ACCOUNT_CREATE_WIDGET, AccountCreateWidget);
	_g_object_unref0 (self->priv->pin_entry);
	_g_object_unref0 (self->priv->error_label);
	_g_object_unref0 (self->priv->confirm_button);
	_g_object_unref0 (self->priv->request_pin_button);
	_g_object_unref0 (self->priv->info_label);
	_g_object_unref0 (self->priv->content_stack);
	G_OBJECT_CLASS (account_create_widget_parent_class)->finalize (obj);
}


GType account_create_widget_get_type (void) {
	static volatile gsize account_create_widget_type_id__volatile = 0;
	if (g_once_init_enter (&account_create_widget_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (AccountCreateWidgetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) account_create_widget_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AccountCreateWidget), 0, (GInstanceInitFunc) account_create_widget_instance_init, NULL };
		GType account_create_widget_type_id;
		account_create_widget_type_id = g_type_register_static (gtk_box_get_type (), "AccountCreateWidget", &g_define_type_info, 0);
		g_once_init_leave (&account_create_widget_type_id__volatile, account_create_widget_type_id);
	}
	return account_create_widget_type_id__volatile;
}



