/* FilterPage.c generated by valac 0.36.4, the Vala compiler
 * generated from FilterPage.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include "CbBundle.h"
#include <stdlib.h>
#include <string.h>
#include "CbMessageReceiver.h"
#include <glib/gi18n-lib.h>
#include "CbFilter.h"
#include "rest/oauth-proxy.h"
#include "CbUserStream.h"
#include "CbUserCounter.h"
#include <gio/gio.h>
#include "rest/rest-proxy-call.h"
#include "rest/rest-proxy.h"
#include "CbUtils.h"
#include <json-glib/json-glib.h>
#include "CbTwitterItem.h"
#include <gdk/gdk.h>


#define TYPE_IPAGE (ipage_get_type ())
#define IPAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IPAGE, IPage))
#define IS_IPAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IPAGE))
#define IPAGE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_IPAGE, IPageIface))

typedef struct _IPage IPage;
typedef struct _IPageIface IPageIface;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;

#define TYPE_FILTER_PAGE (filter_page_get_type ())
#define FILTER_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FILTER_PAGE, FilterPage))
#define FILTER_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FILTER_PAGE, FilterPageClass))
#define IS_FILTER_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FILTER_PAGE))
#define IS_FILTER_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FILTER_PAGE))
#define FILTER_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FILTER_PAGE, FilterPageClass))

typedef struct _FilterPage FilterPage;
typedef struct _FilterPageClass FilterPageClass;
typedef struct _FilterPagePrivate FilterPagePrivate;

#define TYPE_ACCOUNT (account_get_type ())
#define ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNT, Account))
#define ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ACCOUNT, AccountClass))
#define IS_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNT))
#define IS_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ACCOUNT))
#define ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ACCOUNT, AccountClass))

typedef struct _Account Account;
typedef struct _AccountClass AccountClass;

#define TYPE_BADGE_RADIO_BUTTON (badge_radio_button_get_type ())
#define BADGE_RADIO_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BADGE_RADIO_BUTTON, BadgeRadioButton))
#define BADGE_RADIO_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BADGE_RADIO_BUTTON, BadgeRadioButtonClass))
#define IS_BADGE_RADIO_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BADGE_RADIO_BUTTON))
#define IS_BADGE_RADIO_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BADGE_RADIO_BUTTON))
#define BADGE_RADIO_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BADGE_RADIO_BUTTON, BadgeRadioButtonClass))

typedef struct _BadgeRadioButton BadgeRadioButton;
typedef struct _BadgeRadioButtonClass BadgeRadioButtonClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block35Data Block35Data;

#define TYPE_ADD_LIST_ENTRY (add_list_entry_get_type ())
#define ADD_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ADD_LIST_ENTRY, AddListEntry))
#define ADD_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ADD_LIST_ENTRY, AddListEntryClass))
#define IS_ADD_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ADD_LIST_ENTRY))
#define IS_ADD_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ADD_LIST_ENTRY))
#define ADD_LIST_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ADD_LIST_ENTRY, AddListEntryClass))

typedef struct _AddListEntry AddListEntry;
typedef struct _AddListEntryClass AddListEntryClass;

#define TYPE_MODIFY_FILTER_DIALOG (modify_filter_dialog_get_type ())
#define MODIFY_FILTER_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MODIFY_FILTER_DIALOG, ModifyFilterDialog))
#define MODIFY_FILTER_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MODIFY_FILTER_DIALOG, ModifyFilterDialogClass))
#define IS_MODIFY_FILTER_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MODIFY_FILTER_DIALOG))
#define IS_MODIFY_FILTER_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MODIFY_FILTER_DIALOG))
#define MODIFY_FILTER_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MODIFY_FILTER_DIALOG, ModifyFilterDialogClass))

typedef struct _ModifyFilterDialog ModifyFilterDialog;
typedef struct _ModifyFilterDialogClass ModifyFilterDialogClass;

#define TYPE_FILTER_LIST_ENTRY (filter_list_entry_get_type ())
#define FILTER_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FILTER_LIST_ENTRY, FilterListEntry))
#define FILTER_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FILTER_LIST_ENTRY, FilterListEntryClass))
#define IS_FILTER_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FILTER_LIST_ENTRY))
#define IS_FILTER_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FILTER_LIST_ENTRY))
#define FILTER_LIST_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FILTER_LIST_ENTRY, FilterListEntryClass))

typedef struct _FilterListEntry FilterListEntry;
typedef struct _FilterListEntryClass FilterListEntryClass;

#define TYPE_COLLECT (collect_get_type ())
#define COLLECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COLLECT, Collect))
#define COLLECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COLLECT, CollectClass))
#define IS_COLLECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COLLECT))
#define IS_COLLECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COLLECT))
#define COLLECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COLLECT, CollectClass))

typedef struct _Collect Collect;
typedef struct _CollectClass CollectClass;
typedef struct _Block36Data Block36Data;
typedef struct _AccountPrivate AccountPrivate;

#define SQL_TYPE_DATABASE (sql_database_get_type ())
#define SQL_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SQL_TYPE_DATABASE, SqlDatabase))
#define SQL_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SQL_TYPE_DATABASE, SqlDatabaseClass))
#define SQL_IS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SQL_TYPE_DATABASE))
#define SQL_IS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SQL_TYPE_DATABASE))
#define SQL_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SQL_TYPE_DATABASE, SqlDatabaseClass))

typedef struct _SqlDatabase SqlDatabase;
typedef struct _SqlDatabaseClass SqlDatabaseClass;

#define TYPE_NOTIFICATION_MANAGER (notification_manager_get_type ())
#define NOTIFICATION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFICATION_MANAGER, NotificationManager))
#define NOTIFICATION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFICATION_MANAGER, NotificationManagerClass))
#define IS_NOTIFICATION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFICATION_MANAGER))
#define IS_NOTIFICATION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFICATION_MANAGER))
#define NOTIFICATION_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFICATION_MANAGER, NotificationManagerClass))

typedef struct _NotificationManager NotificationManager;
typedef struct _NotificationManagerClass NotificationManagerClass;
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define __vala_JsonNode_free0(var) ((var == NULL) ? NULL : (var = (_vala_JsonNode_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))
#define _json_array_unref0(var) ((var == NULL) ? NULL : (var = (json_array_unref (var), NULL)))

#define TYPE_USER_FILTER_ENTRY (user_filter_entry_get_type ())
#define USER_FILTER_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_USER_FILTER_ENTRY, UserFilterEntry))
#define USER_FILTER_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_USER_FILTER_ENTRY, UserFilterEntryClass))
#define IS_USER_FILTER_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_USER_FILTER_ENTRY))
#define IS_USER_FILTER_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_USER_FILTER_ENTRY))
#define USER_FILTER_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_USER_FILTER_ENTRY, UserFilterEntryClass))

typedef struct _UserFilterEntry UserFilterEntry;
typedef struct _UserFilterEntryClass UserFilterEntryClass;
typedef struct _Block37Data Block37Data;
typedef struct _UserFilterEntryPrivate UserFilterEntryPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
typedef struct _Block38Data Block38Data;
typedef struct _Block39Data Block39Data;

struct _IPageIface {
	GTypeInterface parent_iface;
	void (*on_join) (IPage* self, gint page_id, CbBundle* args);
	void (*on_leave) (IPage* self);
	void (*create_radio_button) (IPage* self, GtkRadioButton* group);
	GtkRadioButton* (*get_radio_button) (IPage* self);
	gchar* (*get_title) (IPage* self);
	gboolean (*handles_double_open) (IPage* self);
	void (*double_open) (IPage* self);
	gint (*get_id) (IPage* self);
	void (*set_id) (IPage* self, gint value);
	void (*set_window) (IPage* self, MainWindow* value);
};

struct _FilterPage {
	GtkScrolledWindow parent_instance;
	FilterPagePrivate * priv;
	Account* account;
};

struct _FilterPageClass {
	GtkScrolledWindowClass parent_class;
};

struct _FilterPagePrivate {
	gint _id;
	MainWindow* main_window;
	BadgeRadioButton* radio_button;
	GtkListBox* filter_list;
	GtkListBox* user_list;
	GtkFrame* user_list_frame;
	GtkRevealer* user_list_revealer;
	gboolean filters_loaded;
	gboolean users_loaded;
};

struct _Block35Data {
	int _ref_count_;
	FilterPage* self;
	Account* account;
};

struct _Block36Data {
	int _ref_count_;
	FilterPage* self;
	Collect* collect_obj;
};

struct _Account {
	GObject parent_instance;
	AccountPrivate * priv;
	gint64 id;
	SqlDatabase* db;
	gchar* screen_name;
	gchar* name;
	gchar* avatar_url;
	gchar* banner_url;
	gchar* website;
	gchar* description;
	OAuthProxy* proxy;
	CbUserStream* user_stream;
	CbUserCounter* user_counter;
	NotificationManager* notifications;
	gint64* friends;
	gint friends_length1;
	gint64* blocked;
	gint blocked_length1;
	gint64* muted;
	gint muted_length1;
	gint64* disabled_rts;
	gint disabled_rts_length1;
	GPtrArray* filters;
};

struct _AccountClass {
	GObjectClass parent_class;
};

struct _Block37Data {
	int _ref_count_;
	FilterPage* self;
	UserFilterEntry* entry;
};

struct _UserFilterEntry {
	GtkListBoxRow parent_instance;
	UserFilterEntryPrivate * priv;
	gint64 user_id;
	gboolean muted;
	gboolean blocked;
};

struct _UserFilterEntryClass {
	GtkListBoxRowClass parent_class;
};

struct _Block38Data {
	int _ref_count_;
	FilterPage* self;
	RestProxyCall* call;
};

struct _Block39Data {
	int _ref_count_;
	FilterPage* self;
	RestProxyCall* call;
};


static gpointer filter_page_parent_class = NULL;
static IPageIface * filter_page_ipage_parent_iface = NULL;
static CbMessageReceiverInterface * filter_page_cb_message_receiver_parent_iface = NULL;

GType main_window_get_type (void) G_GNUC_CONST;
GType ipage_get_type (void) G_GNUC_CONST;
GType filter_page_get_type (void) G_GNUC_CONST;
GType account_get_type (void) G_GNUC_CONST;
GType badge_radio_button_get_type (void) G_GNUC_CONST;
#define FILTER_PAGE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_FILTER_PAGE, FilterPagePrivate))
enum  {
	FILTER_PAGE_DUMMY_PROPERTY,
	FILTER_PAGE_ID,
	FILTER_PAGE_WINDOW
};
FilterPage* filter_page_new (gint id, Account* account);
FilterPage* filter_page_construct (GType object_type, gint id, Account* account);
static Block35Data* block35_data_ref (Block35Data* _data35_);
static void block35_data_unref (void * _userdata_);
void ipage_set_id (IPage* self, gint value);
void default_header_func (GtkListBoxRow* row, GtkListBoxRow* row_before);
static void _default_header_func_gtk_list_box_update_header_func (GtkListBoxRow* row, GtkListBoxRow* before, gpointer self);
AddListEntry* add_list_entry_new (const gchar* label);
AddListEntry* add_list_entry_construct (GType object_type, const gchar* label);
GType add_list_entry_get_type (void) G_GNUC_CONST;
static void __lambda161_ (Block35Data* _data35_, GtkListBoxRow* row);
GType modify_filter_dialog_get_type (void) G_GNUC_CONST;
ModifyFilterDialog* modify_filter_dialog_new (MainWindow* parent, Account* account, CbFilter* filter);
ModifyFilterDialog* modify_filter_dialog_construct (GType object_type, MainWindow* parent, Account* account, CbFilter* filter);
static void filter_page_filter_added_cb (FilterPage* self, CbFilter* f, gboolean created);
static void _filter_page_filter_added_cb_modify_filter_dialog_filter_added (ModifyFilterDialog* _sender, CbFilter* filter, gboolean created, gpointer self);
GType filter_list_entry_get_type (void) G_GNUC_CONST;
CbFilter* filter_list_entry_get_filter (FilterListEntry* self);
static void ___lambda161__gtk_list_box_row_activated (GtkListBox* _sender, GtkListBoxRow* row, gpointer self);
static void filter_page_real_on_join (IPage* base, gint page_id, CbBundle* args);
GType collect_get_type (void) G_GNUC_CONST;
static Block36Data* block36_data_ref (Block36Data* _data36_);
static void block36_data_unref (void * _userdata_);
GType sql_database_get_type (void) G_GNUC_CONST;
GType notification_manager_get_type (void) G_GNUC_CONST;
FilterListEntry* filter_list_entry_new (CbFilter* f, Account* account, MainWindow* main_window);
FilterListEntry* filter_list_entry_construct (GType object_type, CbFilter* f, Account* account, MainWindow* main_window);
Collect* collect_new (gint max);
Collect* collect_construct (GType object_type, gint max);
static void __lambda163_ (FilterPage* self);
static void ___lambda163__collect_finished (Collect* _sender, GError* _error_, gpointer self);
static void __lambda164_ (Block36Data* _data36_, GObject* _, GAsyncResult* res);
static void _vala_JsonNode_free (JsonNode* self);
void collect_emit (Collect* self, GError* _error_);
static void __lambda165_ (FilterPage* self, JsonArray* arr, guint index, JsonNode* node);
static void filter_page_add_user (FilterPage* self, JsonObject* user_obj, gboolean muted);
static void ___lambda165__json_array_foreach (JsonArray* array, guint index_, JsonNode* element_node, gpointer self);
static void ___lambda164__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void __lambda170_ (Block36Data* _data36_, GObject* _, GAsyncResult* res);
static void __lambda171_ (FilterPage* self, JsonArray* arr, guint index, JsonNode* node);
static void ___lambda171__json_array_foreach (JsonArray* array, guint index_, JsonNode* element_node, gpointer self);
static void ___lambda170__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
void filter_list_entry_set_content (FilterListEntry* self, const gchar* value);
static void filter_page_real_stream_message_received (CbMessageReceiver* base, CbStreamMessageType type, JsonNode* root_node);
static void filter_page_remove_user (FilterPage* self, gint64 id, gboolean muted);
GType user_filter_entry_get_type (void) G_GNUC_CONST;
static Block37Data* block37_data_ref (Block37Data* _data37_);
static void block37_data_unref (void * _userdata_);
UserFilterEntry* user_filter_entry_new (void);
UserFilterEntry* user_filter_entry_construct (GType object_type);
void user_filter_entry_set_name (UserFilterEntry* self, const gchar* value);
void user_filter_entry_set_screen_name (UserFilterEntry* self, const gchar* value);
void user_filter_entry_set_avatar_url (UserFilterEntry* self, const gchar* value);
static void __lambda167_ (Block37Data* _data37_, gint64 id);
static void filter_page_unmute_user (FilterPage* self, gint64 id);
static void filter_page_unblock_user (FilterPage* self, gint64 id);
static void ___lambda167__user_filter_entry_deleted (UserFilterEntry* _sender, gint64 id, gpointer self);
static Block38Data* block38_data_ref (Block38Data* _data38_);
static void block38_data_unref (void * _userdata_);
static void __lambda169_ (Block38Data* _data38_, GObject* o, GAsyncResult* res);
void utils_show_error_object (const gchar* json_data, const gchar* alternative, gint line, const gchar* file, GtkWindow* transient_for);
static void ___lambda169__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static Block39Data* block39_data_ref (Block39Data* _data39_);
static void block39_data_unref (void * _userdata_);
static void __lambda168_ (Block39Data* _data39_, GObject* o, GAsyncResult* res);
static void ___lambda168__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static gboolean filter_page_filter_list_keynav_failed_cb (FilterPage* self, GtkDirectionType direction);
static gboolean _filter_page_filter_list_keynav_failed_cb_gtk_widget_keynav_failed (GtkWidget* _sender, GtkDirectionType direction, gpointer self);
static gboolean filter_page_user_list_keynav_failed_cb (FilterPage* self, GtkDirectionType direction);
static gboolean _filter_page_user_list_keynav_failed_cb_gtk_widget_keynav_failed (GtkWidget* _sender, GtkDirectionType direction, gpointer self);
static void filter_page_real_on_leave (IPage* base);
static void filter_page_real_create_radio_button (IPage* base, GtkRadioButton* group);
BadgeRadioButton* badge_radio_button_new (GtkRadioButton* group, const gchar* icon_name, const gchar* text);
BadgeRadioButton* badge_radio_button_construct (GType object_type, GtkRadioButton* group, const gchar* icon_name, const gchar* text);
static GtkRadioButton* filter_page_real_get_radio_button (IPage* base);
static gchar* filter_page_real_get_title (IPage* base);
static void filter_page_finalize (GObject * obj);
gint ipage_get_id (IPage* self);
static void _vala_filter_page_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
void ipage_set_window (IPage* self, MainWindow* value);
static void _vala_filter_page_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static Block35Data* block35_data_ref (Block35Data* _data35_) {
	g_atomic_int_inc (&_data35_->_ref_count_);
	return _data35_;
}


static void block35_data_unref (void * _userdata_) {
	Block35Data* _data35_;
	_data35_ = (Block35Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data35_->_ref_count_)) {
		FilterPage* self;
		self = _data35_->self;
		_g_object_unref0 (_data35_->account);
		_g_object_unref0 (self);
		g_slice_free (Block35Data, _data35_);
	}
}


static void _default_header_func_gtk_list_box_update_header_func (GtkListBoxRow* row, GtkListBoxRow* before, gpointer self) {
	default_header_func (row, before);
}


static void _filter_page_filter_added_cb_modify_filter_dialog_filter_added (ModifyFilterDialog* _sender, CbFilter* filter, gboolean created, gpointer self) {
	filter_page_filter_added_cb ((FilterPage*) self, filter, created);
}


static void __lambda161_ (Block35Data* _data35_, GtkListBoxRow* row) {
	FilterPage* self;
	GtkListBoxRow* _tmp0_;
	self = _data35_->self;
	g_return_if_fail (GTK_IS_LIST_BOX_ROW (row));
	_tmp0_ = row;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, TYPE_ADD_LIST_ENTRY)) {
		ModifyFilterDialog* dialog = NULL;
		MainWindow* _tmp1_;
		Account* _tmp2_;
		ModifyFilterDialog* _tmp3_;
		ModifyFilterDialog* _tmp4_;
		ModifyFilterDialog* _tmp5_;
		_tmp1_ = self->priv->main_window;
		_tmp2_ = _data35_->account;
		_tmp3_ = modify_filter_dialog_new (_tmp1_, _tmp2_, NULL);
		g_object_ref_sink (_tmp3_);
		dialog = _tmp3_;
		_tmp4_ = dialog;
		g_signal_connect_object (_tmp4_, "filter-added", (GCallback) _filter_page_filter_added_cb_modify_filter_dialog_filter_added, self, 0);
		_tmp5_ = dialog;
		gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_widget_get_type (), GtkWidget));
		_g_object_unref0 (dialog);
	} else {
		GtkListBoxRow* _tmp6_;
		_tmp6_ = row;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, TYPE_FILTER_LIST_ENTRY)) {
			FilterListEntry* filter_row = NULL;
			GtkListBoxRow* _tmp7_;
			FilterListEntry* _tmp8_;
			ModifyFilterDialog* dialog = NULL;
			MainWindow* _tmp9_;
			Account* _tmp10_;
			FilterListEntry* _tmp11_;
			CbFilter* _tmp12_;
			CbFilter* _tmp13_;
			ModifyFilterDialog* _tmp14_;
			ModifyFilterDialog* _tmp15_;
			ModifyFilterDialog* _tmp16_;
			_tmp7_ = row;
			_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_FILTER_LIST_ENTRY, FilterListEntry));
			filter_row = _tmp8_;
			_tmp9_ = self->priv->main_window;
			_tmp10_ = _data35_->account;
			_tmp11_ = filter_row;
			_tmp12_ = filter_list_entry_get_filter (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = modify_filter_dialog_new (_tmp9_, _tmp10_, _tmp13_);
			g_object_ref_sink (_tmp14_);
			dialog = _tmp14_;
			_tmp15_ = dialog;
			g_signal_connect_object (_tmp15_, "filter-added", (GCallback) _filter_page_filter_added_cb_modify_filter_dialog_filter_added, self, 0);
			_tmp16_ = dialog;
			gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, gtk_widget_get_type (), GtkWidget));
			_g_object_unref0 (dialog);
			_g_object_unref0 (filter_row);
		}
	}
}


static void ___lambda161__gtk_list_box_row_activated (GtkListBox* _sender, GtkListBoxRow* row, gpointer self) {
	__lambda161_ (self, row);
}


FilterPage* filter_page_construct (GType object_type, gint id, Account* account) {
	FilterPage * self = NULL;
	Block35Data* _data35_;
	Account* _tmp0_;
	Account* _tmp1_;
	gint _tmp2_;
	Account* _tmp3_;
	GtkListBox* _tmp4_;
	GtkListBox* _tmp5_;
	AddListEntry* _tmp6_;
	AddListEntry* _tmp7_;
	GtkListBox* _tmp8_;
	GtkListBox* _tmp9_;
	g_return_val_if_fail (IS_ACCOUNT (account), NULL);
	_data35_ = g_slice_new0 (Block35Data);
	_data35_->_ref_count_ = 1;
	_tmp0_ = account;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data35_->account);
	_data35_->account = _tmp1_;
	self = (FilterPage*) g_object_new (object_type, NULL);
	_data35_->self = g_object_ref (self);
	_tmp2_ = id;
	ipage_set_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage), _tmp2_);
	_tmp3_ = _data35_->account;
	self->account = _tmp3_;
	_tmp4_ = self->priv->filter_list;
	gtk_list_box_set_header_func (_tmp4_, _default_header_func_gtk_list_box_update_header_func, NULL, NULL);
	_tmp5_ = self->priv->filter_list;
	_tmp6_ = add_list_entry_new (_ ("Add new Filter"));
	g_object_ref_sink (_tmp6_);
	_tmp7_ = _tmp6_;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (_tmp7_);
	_tmp8_ = self->priv->filter_list;
	g_signal_connect_data (_tmp8_, "row-activated", (GCallback) ___lambda161__gtk_list_box_row_activated, block35_data_ref (_data35_), (GClosureNotify) block35_data_unref, 0);
	_tmp9_ = self->priv->user_list;
	gtk_list_box_set_header_func (_tmp9_, _default_header_func_gtk_list_box_update_header_func, NULL, NULL);
	block35_data_unref (_data35_);
	_data35_ = NULL;
	return self;
}


FilterPage* filter_page_new (gint id, Account* account) {
	return filter_page_construct (TYPE_FILTER_PAGE, id, account);
}


static Block36Data* block36_data_ref (Block36Data* _data36_) {
	g_atomic_int_inc (&_data36_->_ref_count_);
	return _data36_;
}


static void block36_data_unref (void * _userdata_) {
	Block36Data* _data36_;
	_data36_ = (Block36Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data36_->_ref_count_)) {
		FilterPage* self;
		self = _data36_->self;
		_g_object_unref0 (_data36_->collect_obj);
		_g_object_unref0 (self);
		g_slice_free (Block36Data, _data36_);
	}
}


static gint g_ptr_array_get_length (GPtrArray* self) {
	gint result;
	guint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->len;
	result = (gint) _tmp0_;
	return result;
}


static void g_ptr_array_set_length (GPtrArray* self, gint value) {
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	g_ptr_array_set_size (self, _tmp0_);
}


static void __lambda163_ (FilterPage* self) {
	GtkListBox* _tmp0_;
	GList* _tmp1_;
	GList* _tmp2_;
	guint _tmp3_;
	gboolean _tmp4_;
	_tmp0_ = self->priv->user_list;
	_tmp1_ = gtk_container_get_children (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_container_get_type (), GtkContainer));
	_tmp2_ = _tmp1_;
	_tmp3_ = g_list_length (_tmp2_);
	_tmp4_ = _tmp3_ > ((guint) 0);
	_g_list_free0 (_tmp2_);
	if (_tmp4_) {
		GtkFrame* _tmp5_;
		GtkRevealer* _tmp6_;
		_tmp5_ = self->priv->user_list_frame;
		gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_widget_get_type (), GtkWidget));
		_tmp6_ = self->priv->user_list_revealer;
		gtk_revealer_set_reveal_child (_tmp6_, TRUE);
	}
}


static void ___lambda163__collect_finished (Collect* _sender, GError* _error_, gpointer self) {
	__lambda163_ ((FilterPage*) self);
}


static void _vala_JsonNode_free (JsonNode* self) {
	g_boxed_free (json_node_get_type (), self);
}


static gpointer _json_array_ref0 (gpointer self) {
	return self ? json_array_ref (self) : NULL;
}


static gpointer _json_object_ref0 (gpointer self) {
	return self ? json_object_ref (self) : NULL;
}


static void __lambda165_ (FilterPage* self, JsonArray* arr, guint index, JsonNode* node) {
	JsonObject* obj = NULL;
	JsonNode* _tmp0_;
	JsonObject* _tmp1_;
	JsonObject* _tmp2_;
	g_return_if_fail (arr != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = node;
	_tmp1_ = json_node_get_object (_tmp0_);
	_tmp2_ = _json_object_ref0 (_tmp1_);
	obj = _tmp2_;
	filter_page_add_user (self, obj, FALSE);
	_json_object_unref0 (obj);
}


static void ___lambda165__json_array_foreach (JsonArray* array, guint index_, JsonNode* element_node, gpointer self) {
	__lambda165_ ((FilterPage*) self, array, index_, element_node);
}


static void __lambda164_ (Block36Data* _data36_, GObject* _, GAsyncResult* res) {
	FilterPage* self;
	JsonNode* root = NULL;
	JsonNode* _tmp6_;
	JsonArray* users = NULL;
	JsonNode* _tmp8_;
	JsonObject* _tmp9_;
	JsonArray* _tmp10_;
	JsonArray* _tmp11_;
	JsonArray* _tmp12_;
	Collect* _tmp13_;
	GError * _inner_error_ = NULL;
	self = _data36_->self;
	g_return_if_fail ((_ == NULL) || G_IS_OBJECT (_));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	root = NULL;
	{
		JsonNode* _tmp0_ = NULL;
		GAsyncResult* _tmp1_;
		JsonNode* _tmp2_;
		JsonNode* _tmp3_;
		_tmp1_ = res;
		_tmp2_ = cb_utils_load_threaded_finish (_tmp1_, &_inner_error_);
		_tmp0_ = _tmp2_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch36_g_error;
		}
		_tmp3_ = _tmp0_;
		_tmp0_ = NULL;
		__vala_JsonNode_free0 (root);
		root = _tmp3_;
		__vala_JsonNode_free0 (_tmp0_);
	}
	goto __finally36;
	__catch36_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_warning ("FilterPage.vala:101: %s", _tmp5_);
		_g_error_free0 (e);
		__vala_JsonNode_free0 (root);
		return;
	}
	__finally36:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		__vala_JsonNode_free0 (root);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp6_ = root;
	if (_tmp6_ == NULL) {
		Collect* _tmp7_;
		_tmp7_ = _data36_->collect_obj;
		collect_emit (_tmp7_, NULL);
		__vala_JsonNode_free0 (root);
		return;
	}
	_tmp8_ = root;
	_tmp9_ = json_node_get_object (_tmp8_);
	_tmp10_ = json_object_get_array_member (_tmp9_, "users");
	_tmp11_ = _json_array_ref0 (_tmp10_);
	users = _tmp11_;
	_tmp12_ = users;
	json_array_foreach_element (_tmp12_, ___lambda165__json_array_foreach, self);
	_tmp13_ = _data36_->collect_obj;
	collect_emit (_tmp13_, NULL);
	_json_array_unref0 (users);
	__vala_JsonNode_free0 (root);
}


static void ___lambda164__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda164_ (self, source_object, res);
	block36_data_unref (self);
}


static void __lambda171_ (FilterPage* self, JsonArray* arr, guint index, JsonNode* node) {
	JsonObject* obj = NULL;
	JsonNode* _tmp0_;
	JsonObject* _tmp1_;
	JsonObject* _tmp2_;
	g_return_if_fail (arr != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = node;
	_tmp1_ = json_node_get_object (_tmp0_);
	_tmp2_ = _json_object_ref0 (_tmp1_);
	obj = _tmp2_;
	filter_page_add_user (self, obj, TRUE);
	_json_object_unref0 (obj);
}


static void ___lambda171__json_array_foreach (JsonArray* array, guint index_, JsonNode* element_node, gpointer self) {
	__lambda171_ ((FilterPage*) self, array, index_, element_node);
}


static void __lambda170_ (Block36Data* _data36_, GObject* _, GAsyncResult* res) {
	FilterPage* self;
	JsonNode* root = NULL;
	JsonNode* _tmp6_;
	JsonArray* users = NULL;
	JsonNode* _tmp8_;
	JsonObject* _tmp9_;
	JsonArray* _tmp10_;
	JsonArray* _tmp11_;
	JsonArray* _tmp12_;
	Collect* _tmp13_;
	GError * _inner_error_ = NULL;
	self = _data36_->self;
	g_return_if_fail ((_ == NULL) || G_IS_OBJECT (_));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	root = NULL;
	{
		JsonNode* _tmp0_ = NULL;
		GAsyncResult* _tmp1_;
		JsonNode* _tmp2_;
		JsonNode* _tmp3_;
		_tmp1_ = res;
		_tmp2_ = cb_utils_load_threaded_finish (_tmp1_, &_inner_error_);
		_tmp0_ = _tmp2_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch37_g_error;
		}
		_tmp3_ = _tmp0_;
		_tmp0_ = NULL;
		__vala_JsonNode_free0 (root);
		root = _tmp3_;
		__vala_JsonNode_free0 (_tmp0_);
	}
	goto __finally37;
	__catch37_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_warning ("FilterPage.vala:129: %s", _tmp5_);
		_g_error_free0 (e);
		__vala_JsonNode_free0 (root);
		return;
	}
	__finally37:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		__vala_JsonNode_free0 (root);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp6_ = root;
	if (_tmp6_ == NULL) {
		Collect* _tmp7_;
		_tmp7_ = _data36_->collect_obj;
		collect_emit (_tmp7_, NULL);
		__vala_JsonNode_free0 (root);
		return;
	}
	_tmp8_ = root;
	_tmp9_ = json_node_get_object (_tmp8_);
	_tmp10_ = json_object_get_array_member (_tmp9_, "users");
	_tmp11_ = _json_array_ref0 (_tmp10_);
	users = _tmp11_;
	_tmp12_ = users;
	json_array_foreach_element (_tmp12_, ___lambda171__json_array_foreach, self);
	_tmp13_ = _data36_->collect_obj;
	collect_emit (_tmp13_, NULL);
	_json_array_unref0 (users);
	__vala_JsonNode_free0 (root);
}


static void ___lambda170__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda170_ (self, source_object, res);
	block36_data_unref (self);
}


static void filter_page_real_on_join (IPage* base, gint page_id, CbBundle* args) {
	FilterPage * self;
	Block36Data* _data36_;
	gboolean _tmp0_;
	GNetworkMonitor* _tmp19_;
	gboolean _tmp20_;
	gboolean _tmp21_;
	Collect* _tmp22_;
	Collect* _tmp23_;
	RestProxyCall* call = NULL;
	Account* _tmp24_;
	OAuthProxy* _tmp25_;
	RestProxyCall* _tmp26_;
	RestProxyCall* _tmp27_;
	RestProxyCall* _tmp28_;
	RestProxyCall* _tmp29_;
	RestProxyCall* _tmp30_;
	RestProxyCall* _tmp31_;
	RestProxyCall* call2 = NULL;
	Account* _tmp32_;
	OAuthProxy* _tmp33_;
	RestProxyCall* _tmp34_;
	RestProxyCall* _tmp35_;
	RestProxyCall* _tmp36_;
	RestProxyCall* _tmp37_;
	RestProxyCall* _tmp38_;
	RestProxyCall* _tmp39_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_FILTER_PAGE, FilterPage);
	g_return_if_fail ((args == NULL) || CB_IS_BUNDLE (args));
	_data36_ = g_slice_new0 (Block36Data);
	_data36_->_ref_count_ = 1;
	_data36_->self = g_object_ref (self);
	_tmp0_ = self->priv->filters_loaded;
	if (!_tmp0_) {
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp1_ = FALSE;
				_tmp1_ = TRUE;
				while (TRUE) {
					gint _tmp3_;
					Account* _tmp4_;
					GPtrArray* _tmp5_;
					gint _tmp6_;
					gint _tmp7_;
					CbFilter* f = NULL;
					Account* _tmp8_;
					GPtrArray* _tmp9_;
					gint _tmp10_;
					gconstpointer _tmp11_;
					CbFilter* _tmp12_;
					FilterListEntry* entry = NULL;
					CbFilter* _tmp13_;
					Account* _tmp14_;
					MainWindow* _tmp15_;
					FilterListEntry* _tmp16_;
					GtkListBox* _tmp17_;
					FilterListEntry* _tmp18_;
					if (!_tmp1_) {
						gint _tmp2_;
						_tmp2_ = i;
						i = _tmp2_ + 1;
					}
					_tmp1_ = FALSE;
					_tmp3_ = i;
					_tmp4_ = self->account;
					_tmp5_ = _tmp4_->filters;
					_tmp6_ = g_ptr_array_get_length (_tmp5_);
					_tmp7_ = _tmp6_;
					if (!(_tmp3_ < _tmp7_)) {
						break;
					}
					_tmp8_ = self->account;
					_tmp9_ = _tmp8_->filters;
					_tmp10_ = i;
					_tmp11_ = g_ptr_array_index (_tmp9_, (guint) _tmp10_);
					_tmp12_ = _g_object_ref0 ((CbFilter*) _tmp11_);
					f = _tmp12_;
					_tmp13_ = f;
					_tmp14_ = self->account;
					_tmp15_ = self->priv->main_window;
					_tmp16_ = filter_list_entry_new (_tmp13_, _tmp14_, _tmp15_);
					g_object_ref_sink (_tmp16_);
					entry = _tmp16_;
					_tmp17_ = self->priv->filter_list;
					_tmp18_ = entry;
					gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, gtk_widget_get_type (), GtkWidget));
					_g_object_unref0 (entry);
					_g_object_unref0 (f);
				}
			}
		}
		self->priv->filters_loaded = TRUE;
	}
	_tmp19_ = g_network_monitor_get_default ();
	_tmp20_ = g_network_monitor_get_network_available (_tmp19_);
	if (!_tmp20_) {
		block36_data_unref (_data36_);
		_data36_ = NULL;
		return;
	}
	_tmp21_ = self->priv->users_loaded;
	if (_tmp21_) {
		block36_data_unref (_data36_);
		_data36_ = NULL;
		return;
	}
	self->priv->users_loaded = TRUE;
	_tmp22_ = collect_new (2);
	_data36_->collect_obj = _tmp22_;
	_tmp23_ = _data36_->collect_obj;
	g_signal_connect_object (_tmp23_, "finished", (GCallback) ___lambda163__collect_finished, self, 0);
	_tmp24_ = self->account;
	_tmp25_ = _tmp24_->proxy;
	_tmp26_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, rest_proxy_get_type (), RestProxy));
	call = _tmp26_;
	_tmp27_ = call;
	rest_proxy_call_set_function (_tmp27_, "1.1/blocks/list.json");
	_tmp28_ = call;
	rest_proxy_call_set_method (_tmp28_, "GET");
	_tmp29_ = call;
	rest_proxy_call_add_param (_tmp29_, "include_entities", "false");
	_tmp30_ = call;
	rest_proxy_call_add_param (_tmp30_, "skip_status", "true");
	_tmp31_ = call;
	cb_utils_load_threaded_async (_tmp31_, NULL, ___lambda164__gasync_ready_callback, block36_data_ref (_data36_));
	_tmp32_ = self->account;
	_tmp33_ = _tmp32_->proxy;
	_tmp34_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_tmp33_, rest_proxy_get_type (), RestProxy));
	call2 = _tmp34_;
	_tmp35_ = call2;
	rest_proxy_call_set_function (_tmp35_, "1.1/mutes/users/list.json");
	_tmp36_ = call2;
	rest_proxy_call_set_method (_tmp36_, "GET");
	_tmp37_ = call2;
	rest_proxy_call_add_param (_tmp37_, "include_entities", "false");
	_tmp38_ = call2;
	rest_proxy_call_add_param (_tmp38_, "skip_status", "true");
	_tmp39_ = call2;
	cb_utils_load_threaded_async (_tmp39_, NULL, ___lambda170__gasync_ready_callback, block36_data_ref (_data36_));
	_g_object_unref0 (call2);
	_g_object_unref0 (call);
	block36_data_unref (_data36_);
	_data36_ = NULL;
}


/**
   * Called when the user adds a new Cb.Filter via the AddFilterDialog
   *
   **/
static void filter_page_filter_added_cb (FilterPage* self, CbFilter* f, gboolean created) {
	gboolean _tmp0_;
	g_return_if_fail (IS_FILTER_PAGE (self));
	g_return_if_fail (CB_IS_FILTER (f));
	_tmp0_ = created;
	if (_tmp0_) {
		FilterListEntry* entry = NULL;
		CbFilter* _tmp1_;
		Account* _tmp2_;
		MainWindow* _tmp3_;
		FilterListEntry* _tmp4_;
		GtkListBox* _tmp5_;
		FilterListEntry* _tmp6_;
		_tmp1_ = f;
		_tmp2_ = self->account;
		_tmp3_ = self->priv->main_window;
		_tmp4_ = filter_list_entry_new (_tmp1_, _tmp2_, _tmp3_);
		g_object_ref_sink (_tmp4_);
		entry = _tmp4_;
		_tmp5_ = self->priv->filter_list;
		_tmp6_ = entry;
		gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_widget_get_type (), GtkWidget));
		_g_object_unref0 (entry);
	} else {
		GList* children = NULL;
		GtkListBox* _tmp7_;
		GList* _tmp8_;
		GList* _tmp9_;
		_tmp7_ = self->priv->filter_list;
		_tmp8_ = gtk_container_get_children (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_container_get_type (), GtkContainer));
		children = _tmp8_;
		_tmp9_ = children;
		{
			GList* w_collection = NULL;
			GList* w_it = NULL;
			w_collection = _tmp9_;
			for (w_it = w_collection; w_it != NULL; w_it = w_it->next) {
				GtkWidget* _tmp10_;
				GtkWidget* w = NULL;
				_tmp10_ = _g_object_ref0 ((GtkWidget*) w_it->data);
				w = _tmp10_;
				{
					GtkWidget* _tmp11_;
					FilterListEntry* le = NULL;
					GtkWidget* _tmp12_;
					FilterListEntry* _tmp13_;
					FilterListEntry* _tmp14_;
					CbFilter* _tmp15_;
					CbFilter* _tmp16_;
					gint _tmp17_;
					CbFilter* _tmp18_;
					gint _tmp19_;
					_tmp11_ = w;
					if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp11_, TYPE_FILTER_LIST_ENTRY)) {
						_g_object_unref0 (w);
						continue;
					}
					_tmp12_ = w;
					_tmp13_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, TYPE_FILTER_LIST_ENTRY, FilterListEntry));
					le = _tmp13_;
					_tmp14_ = le;
					_tmp15_ = filter_list_entry_get_filter (_tmp14_);
					_tmp16_ = _tmp15_;
					_tmp17_ = cb_filter_get_id (_tmp16_);
					_tmp18_ = f;
					_tmp19_ = cb_filter_get_id (_tmp18_);
					if (_tmp17_ == _tmp19_) {
						FilterListEntry* _tmp20_;
						CbFilter* _tmp21_;
						const gchar* _tmp22_;
						_tmp20_ = le;
						_tmp21_ = f;
						_tmp22_ = cb_filter_get_contents (_tmp21_);
						filter_list_entry_set_content (_tmp20_, _tmp22_);
						_g_object_unref0 (le);
						_g_object_unref0 (w);
						break;
					}
					_g_object_unref0 (le);
					_g_object_unref0 (w);
				}
			}
		}
		_g_list_free0 (children);
	}
}


static void filter_page_real_stream_message_received (CbMessageReceiver* base, CbStreamMessageType type, JsonNode* root_node) {
	FilterPage * self;
	CbStreamMessageType _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_FILTER_PAGE, FilterPage);
	g_return_if_fail (root_node != NULL);
	_tmp0_ = type;
	if (_tmp0_ == CB_STREAM_MESSAGE_EVENT_BLOCK) {
		JsonObject* obj = NULL;
		JsonNode* _tmp1_;
		JsonObject* _tmp2_;
		JsonObject* _tmp3_;
		JsonObject* _tmp4_;
		JsonObject* _tmp5_;
		_tmp1_ = root_node;
		_tmp2_ = json_node_get_object (_tmp1_);
		_tmp3_ = json_object_get_object_member (_tmp2_, "target");
		_tmp4_ = _json_object_ref0 (_tmp3_);
		obj = _tmp4_;
		_tmp5_ = obj;
		filter_page_add_user (self, _tmp5_, FALSE);
		_json_object_unref0 (obj);
	} else {
		CbStreamMessageType _tmp6_;
		_tmp6_ = type;
		if (_tmp6_ == CB_STREAM_MESSAGE_EVENT_UNBLOCK) {
			JsonObject* obj = NULL;
			JsonNode* _tmp7_;
			JsonObject* _tmp8_;
			JsonObject* _tmp9_;
			JsonObject* _tmp10_;
			gint64 user_id = 0LL;
			JsonObject* _tmp11_;
			gint64 _tmp12_;
			gint64 _tmp13_;
			_tmp7_ = root_node;
			_tmp8_ = json_node_get_object (_tmp7_);
			_tmp9_ = json_object_get_object_member (_tmp8_, "target");
			_tmp10_ = _json_object_ref0 (_tmp9_);
			obj = _tmp10_;
			_tmp11_ = obj;
			_tmp12_ = json_object_get_int_member (_tmp11_, "id");
			user_id = _tmp12_;
			_tmp13_ = user_id;
			filter_page_remove_user (self, _tmp13_, FALSE);
			_json_object_unref0 (obj);
		} else {
			CbStreamMessageType _tmp14_;
			_tmp14_ = type;
			if (_tmp14_ == CB_STREAM_MESSAGE_EVENT_MUTE) {
				JsonObject* obj = NULL;
				JsonNode* _tmp15_;
				JsonObject* _tmp16_;
				JsonObject* _tmp17_;
				JsonObject* _tmp18_;
				JsonObject* _tmp19_;
				_tmp15_ = root_node;
				_tmp16_ = json_node_get_object (_tmp15_);
				_tmp17_ = json_object_get_object_member (_tmp16_, "target");
				_tmp18_ = _json_object_ref0 (_tmp17_);
				obj = _tmp18_;
				_tmp19_ = obj;
				filter_page_add_user (self, _tmp19_, TRUE);
				_json_object_unref0 (obj);
			} else {
				CbStreamMessageType _tmp20_;
				_tmp20_ = type;
				if (_tmp20_ == CB_STREAM_MESSAGE_EVENT_UNMUTE) {
					JsonObject* obj = NULL;
					JsonNode* _tmp21_;
					JsonObject* _tmp22_;
					JsonObject* _tmp23_;
					JsonObject* _tmp24_;
					gint64 user_id = 0LL;
					JsonObject* _tmp25_;
					gint64 _tmp26_;
					gint64 _tmp27_;
					_tmp21_ = root_node;
					_tmp22_ = json_node_get_object (_tmp21_);
					_tmp23_ = json_object_get_object_member (_tmp22_, "target");
					_tmp24_ = _json_object_ref0 (_tmp23_);
					obj = _tmp24_;
					_tmp25_ = obj;
					_tmp26_ = json_object_get_int_member (_tmp25_, "id");
					user_id = _tmp26_;
					_tmp27_ = user_id;
					filter_page_remove_user (self, _tmp27_, TRUE);
					_json_object_unref0 (obj);
				}
			}
		}
	}
}


static Block37Data* block37_data_ref (Block37Data* _data37_) {
	g_atomic_int_inc (&_data37_->_ref_count_);
	return _data37_;
}


static void block37_data_unref (void * _userdata_) {
	Block37Data* _data37_;
	_data37_ = (Block37Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data37_->_ref_count_)) {
		FilterPage* self;
		self = _data37_->self;
		_g_object_unref0 (_data37_->entry);
		_g_object_unref0 (self);
		g_slice_free (Block37Data, _data37_);
	}
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		const gchar* _tmp2_;
		_tmp2_ = old;
		_tmp1_ = (*((gchar*) _tmp2_)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp3_ = old;
		_tmp4_ = replacement;
		_tmp0_ = g_strcmp0 (_tmp3_, _tmp4_) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp5_;
		_tmp5_ = g_strdup (self);
		result = _tmp5_;
		return result;
	}
	{
		GRegex* regex = NULL;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		GRegex* _tmp9_;
		GRegex* _tmp10_;
		gchar* _tmp11_ = NULL;
		GRegex* _tmp12_;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		_tmp6_ = old;
		_tmp7_ = g_regex_escape_string (_tmp6_, -1);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_regex_new (_tmp8_, 0, 0, &_inner_error_);
		_tmp10_ = _tmp9_;
		_g_free0 (_tmp8_);
		regex = _tmp10_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch38_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp12_ = regex;
		_tmp13_ = replacement;
		_tmp14_ = g_regex_replace_literal (_tmp12_, self, (gssize) -1, 0, _tmp13_, 0, &_inner_error_);
		_tmp11_ = _tmp14_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch38_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp15_ = _tmp11_;
		_tmp11_ = NULL;
		result = _tmp15_;
		_g_free0 (_tmp11_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally38;
	__catch38_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally38:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static void __lambda167_ (Block37Data* _data37_, gint64 id) {
	FilterPage* self;
	UserFilterEntry* _tmp0_;
	gboolean _tmp1_;
	UserFilterEntry* _tmp3_;
	gboolean _tmp4_;
	self = _data37_->self;
	_tmp0_ = _data37_->entry;
	_tmp1_ = _tmp0_->muted;
	if (_tmp1_) {
		gint64 _tmp2_;
		_tmp2_ = id;
		filter_page_unmute_user (self, _tmp2_);
	}
	_tmp3_ = _data37_->entry;
	_tmp4_ = _tmp3_->blocked;
	if (_tmp4_) {
		gint64 _tmp5_;
		_tmp5_ = id;
		filter_page_unblock_user (self, _tmp5_);
	}
}


static void ___lambda167__user_filter_entry_deleted (UserFilterEntry* _sender, gint64 id, gpointer self) {
	__lambda167_ (self, id);
}


static void filter_page_add_user (FilterPage* self, JsonObject* user_obj, gboolean muted) {
	Block37Data* _data37_;
	gint64 id = 0LL;
	JsonObject* _tmp0_;
	gint64 _tmp1_;
	GtkListBox* _tmp2_;
	GList* _tmp3_;
	gchar* avatar_url = NULL;
	JsonObject* _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	gint _tmp17_;
	UserFilterEntry* _tmp20_;
	UserFilterEntry* _tmp21_;
	gint64 _tmp22_;
	UserFilterEntry* _tmp23_;
	gboolean _tmp24_;
	UserFilterEntry* _tmp25_;
	gboolean _tmp26_;
	UserFilterEntry* _tmp27_;
	JsonObject* _tmp28_;
	const gchar* _tmp29_;
	UserFilterEntry* _tmp30_;
	JsonObject* _tmp31_;
	const gchar* _tmp32_;
	UserFilterEntry* _tmp33_;
	const gchar* _tmp34_;
	UserFilterEntry* _tmp35_;
	GtkListBox* _tmp36_;
	UserFilterEntry* _tmp37_;
	GtkFrame* _tmp38_;
	g_return_if_fail (IS_FILTER_PAGE (self));
	g_return_if_fail (user_obj != NULL);
	_data37_ = g_slice_new0 (Block37Data);
	_data37_->_ref_count_ = 1;
	_data37_->self = g_object_ref (self);
	_tmp0_ = user_obj;
	_tmp1_ = json_object_get_int_member (_tmp0_, "id");
	id = _tmp1_;
	_tmp2_ = self->priv->user_list;
	_tmp3_ = gtk_container_get_children (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_container_get_type (), GtkContainer));
	{
		GList* w_collection = NULL;
		GList* w_it = NULL;
		w_collection = _tmp3_;
		for (w_it = w_collection; w_it != NULL; w_it = w_it->next) {
			GtkWidget* _tmp4_;
			GtkWidget* w = NULL;
			_tmp4_ = _g_object_ref0 ((GtkWidget*) w_it->data);
			w = _tmp4_;
			{
				GtkWidget* _tmp5_;
				UserFilterEntry* ufe = NULL;
				GtkWidget* _tmp6_;
				UserFilterEntry* _tmp7_;
				UserFilterEntry* _tmp8_;
				gint64 _tmp9_;
				gint64 _tmp10_;
				_tmp5_ = w;
				if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, TYPE_USER_FILTER_ENTRY)) {
					_g_object_unref0 (w);
					continue;
				}
				_tmp6_ = w;
				_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, TYPE_USER_FILTER_ENTRY, UserFilterEntry));
				ufe = _tmp7_;
				_tmp8_ = ufe;
				_tmp9_ = _tmp8_->user_id;
				_tmp10_ = id;
				if (_tmp9_ == _tmp10_) {
					gboolean _tmp11_;
					_tmp11_ = muted;
					if (_tmp11_) {
						UserFilterEntry* _tmp12_;
						_tmp12_ = ufe;
						_tmp12_->muted = TRUE;
					} else {
						UserFilterEntry* _tmp13_;
						_tmp13_ = ufe;
						_tmp13_->blocked = TRUE;
					}
					_g_object_unref0 (ufe);
					_g_object_unref0 (w);
					_g_list_free0 (w_collection);
					block37_data_unref (_data37_);
					_data37_ = NULL;
					return;
				}
				_g_object_unref0 (ufe);
				_g_object_unref0 (w);
			}
		}
		_g_list_free0 (w_collection);
	}
	_tmp14_ = user_obj;
	_tmp15_ = json_object_get_string_member (_tmp14_, "profile_image_url");
	_tmp16_ = g_strdup (_tmp15_);
	avatar_url = _tmp16_;
	_tmp17_ = gtk_widget_get_scale_factor (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	if (_tmp17_ == 2) {
		const gchar* _tmp18_;
		gchar* _tmp19_;
		_tmp18_ = avatar_url;
		_tmp19_ = string_replace (_tmp18_, "_normal", "_bigger");
		_g_free0 (avatar_url);
		avatar_url = _tmp19_;
	}
	_tmp20_ = user_filter_entry_new ();
	g_object_ref_sink (_tmp20_);
	_data37_->entry = _tmp20_;
	_tmp21_ = _data37_->entry;
	_tmp22_ = id;
	_tmp21_->user_id = _tmp22_;
	_tmp23_ = _data37_->entry;
	_tmp24_ = muted;
	_tmp23_->muted = _tmp24_;
	_tmp25_ = _data37_->entry;
	_tmp26_ = muted;
	_tmp25_->blocked = !_tmp26_;
	_tmp27_ = _data37_->entry;
	_tmp28_ = user_obj;
	_tmp29_ = json_object_get_string_member (_tmp28_, "name");
	user_filter_entry_set_name (_tmp27_, _tmp29_);
	_tmp30_ = _data37_->entry;
	_tmp31_ = user_obj;
	_tmp32_ = json_object_get_string_member (_tmp31_, "screen_name");
	user_filter_entry_set_screen_name (_tmp30_, _tmp32_);
	_tmp33_ = _data37_->entry;
	_tmp34_ = avatar_url;
	user_filter_entry_set_avatar_url (_tmp33_, _tmp34_);
	_tmp35_ = _data37_->entry;
	g_signal_connect_data (_tmp35_, "deleted", (GCallback) ___lambda167__user_filter_entry_deleted, block37_data_ref (_data37_), (GClosureNotify) block37_data_unref, 0);
	_tmp36_ = self->priv->user_list;
	_tmp37_ = _data37_->entry;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp36_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp37_, gtk_widget_get_type (), GtkWidget));
	_tmp38_ = self->priv->user_list_frame;
	gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp38_, gtk_widget_get_type (), GtkWidget));
	_g_free0 (avatar_url);
	block37_data_unref (_data37_);
	_data37_ = NULL;
}


static void filter_page_remove_user (FilterPage* self, gint64 id, gboolean muted) {
	GtkListBox* _tmp0_;
	GList* _tmp1_;
	GtkListBox* _tmp19_;
	GList* _tmp20_;
	GList* _tmp21_;
	guint _tmp22_;
	gboolean _tmp23_;
	g_return_if_fail (IS_FILTER_PAGE (self));
	_tmp0_ = self->priv->user_list;
	_tmp1_ = gtk_container_get_children (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_container_get_type (), GtkContainer));
	{
		GList* w_collection = NULL;
		GList* w_it = NULL;
		w_collection = _tmp1_;
		for (w_it = w_collection; w_it != NULL; w_it = w_it->next) {
			GtkWidget* _tmp2_;
			GtkWidget* w = NULL;
			_tmp2_ = _g_object_ref0 ((GtkWidget*) w_it->data);
			w = _tmp2_;
			{
				GtkWidget* _tmp3_;
				UserFilterEntry* ufe = NULL;
				GtkWidget* _tmp4_;
				UserFilterEntry* _tmp5_;
				UserFilterEntry* _tmp6_;
				gint64 _tmp7_;
				gint64 _tmp8_;
				_tmp3_ = w;
				if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, TYPE_USER_FILTER_ENTRY)) {
					_g_object_unref0 (w);
					continue;
				}
				_tmp4_ = w;
				_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_USER_FILTER_ENTRY, UserFilterEntry));
				ufe = _tmp5_;
				_tmp6_ = ufe;
				_tmp7_ = _tmp6_->user_id;
				_tmp8_ = id;
				if (_tmp7_ == _tmp8_) {
					gboolean _tmp9_;
					gboolean _tmp12_ = FALSE;
					UserFilterEntry* _tmp13_;
					gboolean _tmp14_;
					_tmp9_ = muted;
					if (_tmp9_) {
						UserFilterEntry* _tmp10_;
						_tmp10_ = ufe;
						_tmp10_->muted = FALSE;
					} else {
						UserFilterEntry* _tmp11_;
						_tmp11_ = ufe;
						_tmp11_->blocked = FALSE;
					}
					_tmp13_ = ufe;
					_tmp14_ = _tmp13_->blocked;
					if (!_tmp14_) {
						UserFilterEntry* _tmp15_;
						gboolean _tmp16_;
						_tmp15_ = ufe;
						_tmp16_ = _tmp15_->muted;
						_tmp12_ = !_tmp16_;
					} else {
						_tmp12_ = FALSE;
					}
					if (_tmp12_) {
						GtkListBox* _tmp17_;
						GtkWidget* _tmp18_;
						_tmp17_ = self->priv->user_list;
						_tmp18_ = w;
						gtk_container_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, gtk_container_get_type (), GtkContainer), _tmp18_);
					}
					_g_object_unref0 (ufe);
					_g_object_unref0 (w);
					break;
				}
				_g_object_unref0 (ufe);
				_g_object_unref0 (w);
			}
		}
		_g_list_free0 (w_collection);
	}
	_tmp19_ = self->priv->user_list;
	_tmp20_ = gtk_container_get_children (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, gtk_container_get_type (), GtkContainer));
	_tmp21_ = _tmp20_;
	_tmp22_ = g_list_length (_tmp21_);
	_tmp23_ = _tmp22_ == ((guint) 0);
	_g_list_free0 (_tmp21_);
	if (_tmp23_) {
		GtkFrame* _tmp24_;
		_tmp24_ = self->priv->user_list_frame;
		gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, gtk_widget_get_type (), GtkWidget));
	}
}


static Block38Data* block38_data_ref (Block38Data* _data38_) {
	g_atomic_int_inc (&_data38_->_ref_count_);
	return _data38_;
}


static void block38_data_unref (void * _userdata_) {
	Block38Data* _data38_;
	_data38_ = (Block38Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data38_->_ref_count_)) {
		FilterPage* self;
		self = _data38_->self;
		_g_object_unref0 (_data38_->call);
		_g_object_unref0 (self);
		g_slice_free (Block38Data, _data38_);
	}
}


static void __lambda169_ (Block38Data* _data38_, GObject* o, GAsyncResult* res) {
	FilterPage* self;
	GError * _inner_error_ = NULL;
	self = _data38_->self;
	g_return_if_fail ((o == NULL) || G_IS_OBJECT (o));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	{
		GAsyncResult* _tmp0_;
		_tmp0_ = res;
		rest_proxy_call_invoke_finish (_data38_->call, _tmp0_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch39_g_error;
		}
	}
	goto __finally39;
	__catch39_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp1_;
		GError* _tmp2_;
		const gchar* _tmp3_;
		MainWindow* _tmp4_;
		GError* _tmp5_;
		const gchar* _tmp6_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp1_ = rest_proxy_call_get_payload (_data38_->call);
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		_tmp4_ = self->priv->main_window;
		utils_show_error_object (_tmp1_, _tmp3_, 265, "FilterPage.vala", G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_window_get_type (), GtkWindow));
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		g_warning ("FilterPage.vala:266: %s", _tmp6_);
		_g_error_free0 (e);
		return;
	}
	__finally39:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void ___lambda169__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda169_ (self, source_object, res);
	block38_data_unref (self);
}


static void filter_page_unblock_user (FilterPage* self, gint64 id) {
	Block38Data* _data38_;
	Account* _tmp0_;
	OAuthProxy* _tmp1_;
	RestProxyCall* _tmp2_;
	gint64 _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gint64 _tmp6_;
	g_return_if_fail (IS_FILTER_PAGE (self));
	_data38_ = g_slice_new0 (Block38Data);
	_data38_->_ref_count_ = 1;
	_data38_->self = g_object_ref (self);
	_tmp0_ = self->account;
	_tmp1_ = _tmp0_->proxy;
	_tmp2_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, rest_proxy_get_type (), RestProxy));
	_data38_->call = _tmp2_;
	rest_proxy_call_set_method (_data38_->call, "POST");
	rest_proxy_call_set_function (_data38_->call, "1.1/blocks/destroy.json");
	rest_proxy_call_add_param (_data38_->call, "include_entities", "false");
	rest_proxy_call_add_param (_data38_->call, "skip_status", "true");
	_tmp3_ = id;
	_tmp4_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp3_);
	_tmp5_ = _tmp4_;
	rest_proxy_call_add_param (_data38_->call, "user_id", _tmp5_);
	_g_free0 (_tmp5_);
	rest_proxy_call_invoke_async (_data38_->call, NULL, ___lambda169__gasync_ready_callback, block38_data_ref (_data38_));
	_tmp6_ = id;
	filter_page_remove_user (self, _tmp6_, FALSE);
	block38_data_unref (_data38_);
	_data38_ = NULL;
}


static Block39Data* block39_data_ref (Block39Data* _data39_) {
	g_atomic_int_inc (&_data39_->_ref_count_);
	return _data39_;
}


static void block39_data_unref (void * _userdata_) {
	Block39Data* _data39_;
	_data39_ = (Block39Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data39_->_ref_count_)) {
		FilterPage* self;
		self = _data39_->self;
		_g_object_unref0 (_data39_->call);
		_g_object_unref0 (self);
		g_slice_free (Block39Data, _data39_);
	}
}


static void __lambda168_ (Block39Data* _data39_, GObject* o, GAsyncResult* res) {
	FilterPage* self;
	GError * _inner_error_ = NULL;
	self = _data39_->self;
	g_return_if_fail ((o == NULL) || G_IS_OBJECT (o));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	{
		GAsyncResult* _tmp0_;
		_tmp0_ = res;
		rest_proxy_call_invoke_finish (_data39_->call, _tmp0_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch40_g_error;
		}
	}
	goto __finally40;
	__catch40_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp1_;
		GError* _tmp2_;
		const gchar* _tmp3_;
		MainWindow* _tmp4_;
		GError* _tmp5_;
		const gchar* _tmp6_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp1_ = rest_proxy_call_get_payload (_data39_->call);
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		_tmp4_ = self->priv->main_window;
		utils_show_error_object (_tmp1_, _tmp3_, 285, "FilterPage.vala", G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_window_get_type (), GtkWindow));
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		g_warning ("FilterPage.vala:286: %s", _tmp6_);
		_g_error_free0 (e);
		return;
	}
	__finally40:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void ___lambda168__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda168_ (self, source_object, res);
	block39_data_unref (self);
}


static void filter_page_unmute_user (FilterPage* self, gint64 id) {
	Block39Data* _data39_;
	Account* _tmp0_;
	OAuthProxy* _tmp1_;
	RestProxyCall* _tmp2_;
	gint64 _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gint64 _tmp6_;
	g_return_if_fail (IS_FILTER_PAGE (self));
	_data39_ = g_slice_new0 (Block39Data);
	_data39_->_ref_count_ = 1;
	_data39_->self = g_object_ref (self);
	_tmp0_ = self->account;
	_tmp1_ = _tmp0_->proxy;
	_tmp2_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, rest_proxy_get_type (), RestProxy));
	_data39_->call = _tmp2_;
	rest_proxy_call_set_method (_data39_->call, "POST");
	rest_proxy_call_set_function (_data39_->call, "1.1/mutes/users/destroy.json");
	rest_proxy_call_add_param (_data39_->call, "include_entities", "false");
	rest_proxy_call_add_param (_data39_->call, "skip_status", "true");
	_tmp3_ = id;
	_tmp4_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp3_);
	_tmp5_ = _tmp4_;
	rest_proxy_call_add_param (_data39_->call, "user_id", _tmp5_);
	_g_free0 (_tmp5_);
	rest_proxy_call_invoke_async (_data39_->call, NULL, ___lambda168__gasync_ready_callback, block39_data_ref (_data39_));
	_tmp6_ = id;
	filter_page_remove_user (self, _tmp6_, TRUE);
	block39_data_unref (_data39_);
	_data39_ = NULL;
}


static gboolean filter_page_filter_list_keynav_failed_cb (FilterPage* self, GtkDirectionType direction) {
	gboolean result = FALSE;
	GtkDirectionType _tmp0_;
	g_return_val_if_fail (IS_FILTER_PAGE (self), FALSE);
	_tmp0_ = direction;
	if (_tmp0_ == GTK_DIR_DOWN) {
		GtkListBox* _tmp1_;
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp1_ = self->priv->user_list;
		_tmp2_ = gtk_widget_get_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_widget_get_type (), GtkWidget));
		_tmp3_ = _tmp2_;
		if (_tmp3_) {
			GtkListBox* _tmp4_;
			GtkDirectionType _tmp5_;
			_tmp4_ = self->priv->user_list;
			_tmp5_ = direction;
			gtk_widget_child_focus (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_widget_get_type (), GtkWidget), _tmp5_);
		}
		result = GDK_EVENT_STOP;
		return result;
	}
	result = GDK_EVENT_PROPAGATE;
	return result;
}


static gboolean _filter_page_filter_list_keynav_failed_cb_gtk_widget_keynav_failed (GtkWidget* _sender, GtkDirectionType direction, gpointer self) {
	gboolean result;
	result = filter_page_filter_list_keynav_failed_cb ((FilterPage*) self, direction);
	return result;
}


static gboolean filter_page_user_list_keynav_failed_cb (FilterPage* self, GtkDirectionType direction) {
	gboolean result = FALSE;
	GtkDirectionType _tmp0_;
	g_return_val_if_fail (IS_FILTER_PAGE (self), FALSE);
	_tmp0_ = direction;
	if (_tmp0_ == GTK_DIR_UP) {
		GtkListBox* _tmp1_;
		GtkDirectionType _tmp2_;
		_tmp1_ = self->priv->filter_list;
		_tmp2_ = direction;
		gtk_widget_child_focus (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_widget_get_type (), GtkWidget), _tmp2_);
		result = GDK_EVENT_STOP;
		return result;
	}
	result = GDK_EVENT_PROPAGATE;
	return result;
}


static gboolean _filter_page_user_list_keynav_failed_cb_gtk_widget_keynav_failed (GtkWidget* _sender, GtkDirectionType direction, gpointer self) {
	gboolean result;
	result = filter_page_user_list_keynav_failed_cb ((FilterPage*) self, direction);
	return result;
}


static void filter_page_real_on_leave (IPage* base) {
	FilterPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_FILTER_PAGE, FilterPage);
}


static void filter_page_real_create_radio_button (IPage* base, GtkRadioButton* group) {
	FilterPage * self;
	GtkRadioButton* _tmp0_;
	BadgeRadioButton* _tmp1_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_FILTER_PAGE, FilterPage);
	g_return_if_fail ((group == NULL) || GTK_IS_RADIO_BUTTON (group));
	_tmp0_ = group;
	_tmp1_ = badge_radio_button_new (_tmp0_, "corebird-filter-symbolic", _ ("Filters"));
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->radio_button);
	self->priv->radio_button = _tmp1_;
}


static GtkRadioButton* filter_page_real_get_radio_button (IPage* base) {
	FilterPage * self;
	GtkRadioButton* result = NULL;
	BadgeRadioButton* _tmp0_;
	GtkRadioButton* _tmp1_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_FILTER_PAGE, FilterPage);
	_tmp0_ = self->priv->radio_button;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_radio_button_get_type (), GtkRadioButton));
	result = _tmp1_;
	return result;
}


static gchar* filter_page_real_get_title (IPage* base) {
	FilterPage * self;
	gchar* result = NULL;
	gchar* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_FILTER_PAGE, FilterPage);
	_tmp0_ = g_strdup (_ ("Filters"));
	result = _tmp0_;
	return result;
}


static gint filter_page_real_get_id (IPage* base) {
	gint result;
	FilterPage* self;
	gint _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_FILTER_PAGE, FilterPage);
	_tmp0_ = self->priv->_id;
	result = _tmp0_;
	return result;
}


static void filter_page_real_set_id (IPage* base, gint value) {
	FilterPage* self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_FILTER_PAGE, FilterPage);
	if (filter_page_real_get_id (base) != value) {
		gint _tmp0_;
		_tmp0_ = value;
		self->priv->_id = _tmp0_;
		g_object_notify ((GObject *) self, "id");
	}
}


static void filter_page_real_set_window (IPage* base, MainWindow* value) {
	FilterPage* self;
	MainWindow* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_FILTER_PAGE, FilterPage);
	_tmp0_ = value;
	self->priv->main_window = _tmp0_;
	g_object_notify ((GObject *) self, "window");
}


static void filter_page_class_init (FilterPageClass * klass) {
	gint FilterPage_private_offset;
	filter_page_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (FilterPagePrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_filter_page_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_filter_page_set_property;
	G_OBJECT_CLASS (klass)->finalize = filter_page_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILTER_PAGE_ID, g_param_spec_int ("id", "id", "id", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILTER_PAGE_WINDOW, g_param_spec_object ("window", "window", "window", TYPE_MAIN_WINDOW, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE));
	FilterPage_private_offset = g_type_class_get_instance_private_offset (klass);
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/baedert/corebird/ui/filter-page.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "filter_list", FALSE, FilterPage_private_offset + G_STRUCT_OFFSET (FilterPagePrivate, filter_list));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "user_list", FALSE, FilterPage_private_offset + G_STRUCT_OFFSET (FilterPagePrivate, user_list));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "user_list_frame", FALSE, FilterPage_private_offset + G_STRUCT_OFFSET (FilterPagePrivate, user_list_frame));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "user_list_revealer", FALSE, FilterPage_private_offset + G_STRUCT_OFFSET (FilterPagePrivate, user_list_revealer));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "filter_list_keynav_failed_cb", G_CALLBACK(_filter_page_filter_list_keynav_failed_cb_gtk_widget_keynav_failed));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "user_list_keynav_failed_cb", G_CALLBACK(_filter_page_user_list_keynav_failed_cb_gtk_widget_keynav_failed));
}


static void filter_page_ipage_interface_init (IPageIface * iface) {
	filter_page_ipage_parent_iface = g_type_interface_peek_parent (iface);
	iface->on_join = (void (*) (IPage *, gint, CbBundle*)) filter_page_real_on_join;
	iface->on_leave = (void (*) (IPage *)) filter_page_real_on_leave;
	iface->create_radio_button = (void (*) (IPage *, GtkRadioButton*)) filter_page_real_create_radio_button;
	iface->get_radio_button = (GtkRadioButton* (*) (IPage *)) filter_page_real_get_radio_button;
	iface->get_title = (gchar* (*) (IPage *)) filter_page_real_get_title;
	iface->get_id = filter_page_real_get_id;
	iface->set_id = filter_page_real_set_id;
	iface->set_window = filter_page_real_set_window;
}


static void filter_page_cb_message_receiver_interface_init (CbMessageReceiverInterface * iface) {
	filter_page_cb_message_receiver_parent_iface = g_type_interface_peek_parent (iface);
	iface->stream_message_received = (void (*) (CbMessageReceiver *, CbStreamMessageType, JsonNode*)) filter_page_real_stream_message_received;
}


static void filter_page_instance_init (FilterPage * self) {
	self->priv = FILTER_PAGE_GET_PRIVATE (self);
	self->priv->filters_loaded = FALSE;
	self->priv->users_loaded = FALSE;
	gtk_widget_init_template (GTK_WIDGET (self));
}


static void filter_page_finalize (GObject * obj) {
	FilterPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_FILTER_PAGE, FilterPage);
	_g_object_unref0 (self->priv->radio_button);
	_g_object_unref0 (self->priv->filter_list);
	_g_object_unref0 (self->priv->user_list);
	_g_object_unref0 (self->priv->user_list_frame);
	_g_object_unref0 (self->priv->user_list_revealer);
	G_OBJECT_CLASS (filter_page_parent_class)->finalize (obj);
}


GType filter_page_get_type (void) {
	static volatile gsize filter_page_type_id__volatile = 0;
	if (g_once_init_enter (&filter_page_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FilterPageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) filter_page_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FilterPage), 0, (GInstanceInitFunc) filter_page_instance_init, NULL };
		static const GInterfaceInfo ipage_info = { (GInterfaceInitFunc) filter_page_ipage_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo cb_message_receiver_info = { (GInterfaceInitFunc) filter_page_cb_message_receiver_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType filter_page_type_id;
		filter_page_type_id = g_type_register_static (gtk_scrolled_window_get_type (), "FilterPage", &g_define_type_info, 0);
		g_type_add_interface_static (filter_page_type_id, TYPE_IPAGE, &ipage_info);
		g_type_add_interface_static (filter_page_type_id, CB_TYPE_MESSAGE_RECEIVER, &cb_message_receiver_info);
		g_once_init_leave (&filter_page_type_id__volatile, filter_page_type_id);
	}
	return filter_page_type_id__volatile;
}


static void _vala_filter_page_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	FilterPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_FILTER_PAGE, FilterPage);
	switch (property_id) {
		case FILTER_PAGE_ID:
		g_value_set_int (value, ipage_get_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage)));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_filter_page_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	FilterPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_FILTER_PAGE, FilterPage);
	switch (property_id) {
		case FILTER_PAGE_ID:
		ipage_set_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage), g_value_get_int (value));
		break;
		case FILTER_PAGE_WINDOW:
		ipage_set_window (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage), g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



