/* DMManager.c generated by valac 0.36.4, the Vala compiler
 * generated from DMManager.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include "rest/oauth-proxy.h"
#include "CbUserStream.h"
#include "CbUserCounter.h"
#include "CbFilter.h"
#include "CbTypes.h"
#include <cairo.h>
#include <gio/gio.h>
#include "rest/rest-proxy-call.h"
#include "rest/rest-proxy.h"
#include "CbUtils.h"
#include <json-glib/json-glib.h>
#include "CbTextTransform.h"


#define TYPE_DM_MANAGER (dm_manager_get_type ())
#define DM_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DM_MANAGER, DMManager))
#define DM_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DM_MANAGER, DMManagerClass))
#define IS_DM_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DM_MANAGER))
#define IS_DM_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DM_MANAGER))
#define DM_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DM_MANAGER, DMManagerClass))

typedef struct _DMManager DMManager;
typedef struct _DMManagerClass DMManagerClass;
typedef struct _DMManagerPrivate DMManagerPrivate;

#define TYPE_ACCOUNT (account_get_type ())
#define ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNT, Account))
#define ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ACCOUNT, AccountClass))
#define IS_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNT))
#define IS_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ACCOUNT))
#define ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ACCOUNT, AccountClass))

typedef struct _Account Account;
typedef struct _AccountClass AccountClass;

#define TYPE_DM_THREADS_MODEL (dm_threads_model_get_type ())
#define DM_THREADS_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DM_THREADS_MODEL, DMThreadsModel))
#define DM_THREADS_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DM_THREADS_MODEL, DMThreadsModelClass))
#define IS_DM_THREADS_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DM_THREADS_MODEL))
#define IS_DM_THREADS_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DM_THREADS_MODEL))
#define DM_THREADS_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DM_THREADS_MODEL, DMThreadsModelClass))

typedef struct _DMThreadsModel DMThreadsModel;
typedef struct _DMThreadsModelClass DMThreadsModelClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _AccountPrivate AccountPrivate;

#define SQL_TYPE_DATABASE (sql_database_get_type ())
#define SQL_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SQL_TYPE_DATABASE, SqlDatabase))
#define SQL_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SQL_TYPE_DATABASE, SqlDatabaseClass))
#define SQL_IS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SQL_TYPE_DATABASE))
#define SQL_IS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SQL_TYPE_DATABASE))
#define SQL_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SQL_TYPE_DATABASE, SqlDatabaseClass))

typedef struct _SqlDatabase SqlDatabase;
typedef struct _SqlDatabaseClass SqlDatabaseClass;

#define TYPE_NOTIFICATION_MANAGER (notification_manager_get_type ())
#define NOTIFICATION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFICATION_MANAGER, NotificationManager))
#define NOTIFICATION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFICATION_MANAGER, NotificationManagerClass))
#define IS_NOTIFICATION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFICATION_MANAGER))
#define IS_NOTIFICATION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFICATION_MANAGER))
#define NOTIFICATION_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFICATION_MANAGER, NotificationManagerClass))

typedef struct _NotificationManager NotificationManager;
typedef struct _NotificationManagerClass NotificationManagerClass;

#define SQL_TYPE_SELECT_STATEMENT (sql_select_statement_get_type ())
#define SQL_SELECT_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SQL_TYPE_SELECT_STATEMENT, SqlSelectStatement))
#define SQL_SELECT_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SQL_TYPE_SELECT_STATEMENT, SqlSelectStatementClass))
#define SQL_IS_SELECT_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SQL_TYPE_SELECT_STATEMENT))
#define SQL_IS_SELECT_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SQL_TYPE_SELECT_STATEMENT))
#define SQL_SELECT_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SQL_TYPE_SELECT_STATEMENT, SqlSelectStatementClass))

typedef struct _SqlSelectStatement SqlSelectStatement;
typedef struct _SqlSelectStatementClass SqlSelectStatementClass;

#define TYPE_DM_THREAD (dm_thread_get_type ())
#define DM_THREAD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DM_THREAD, DMThread))
#define DM_THREAD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DM_THREAD, DMThreadClass))
#define IS_DM_THREAD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DM_THREAD))
#define IS_DM_THREAD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DM_THREAD))
#define DM_THREAD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DM_THREAD, DMThreadClass))

typedef struct _DMThread DMThread;
typedef struct _DMThreadClass DMThreadClass;
typedef struct _DMThreadPrivate DMThreadPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_COLLECT (collect_get_type ())
#define COLLECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COLLECT, Collect))
#define COLLECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COLLECT, CollectClass))
#define IS_COLLECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COLLECT))
#define IS_COLLECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COLLECT))
#define COLLECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COLLECT, CollectClass))

typedef struct _Collect Collect;
typedef struct _CollectClass CollectClass;
typedef struct _Block40Data Block40Data;
#define __vala_JsonNode_free0(var) ((var == NULL) ? NULL : (var = (_vala_JsonNode_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _DmManagerLoadNewestDmsData DmManagerLoadNewestDmsData;
typedef struct _Block41Data Block41Data;
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))
#define _json_array_unref0(var) ((var == NULL) ? NULL : (var = (json_array_unref (var), NULL)))
typedef struct _Block42Data Block42Data;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

#define SQL_TYPE_INSERT_STATEMENT (sql_insert_statement_get_type ())
#define SQL_INSERT_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SQL_TYPE_INSERT_STATEMENT, SqlInsertStatement))
#define SQL_INSERT_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SQL_TYPE_INSERT_STATEMENT, SqlInsertStatementClass))
#define SQL_IS_INSERT_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SQL_TYPE_INSERT_STATEMENT))
#define SQL_IS_INSERT_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SQL_TYPE_INSERT_STATEMENT))
#define SQL_INSERT_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SQL_TYPE_INSERT_STATEMENT, SqlInsertStatementClass))

typedef struct _SqlInsertStatement SqlInsertStatement;
typedef struct _SqlInsertStatementClass SqlInsertStatementClass;

#define SQL_TYPE_UPDATE_STATEMENT (sql_update_statement_get_type ())
#define SQL_UPDATE_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SQL_TYPE_UPDATE_STATEMENT, SqlUpdateStatement))
#define SQL_UPDATE_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SQL_TYPE_UPDATE_STATEMENT, SqlUpdateStatementClass))
#define SQL_IS_UPDATE_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SQL_TYPE_UPDATE_STATEMENT))
#define SQL_IS_UPDATE_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SQL_TYPE_UPDATE_STATEMENT))
#define SQL_UPDATE_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SQL_TYPE_UPDATE_STATEMENT, SqlUpdateStatementClass))

typedef struct _SqlUpdateStatement SqlUpdateStatement;
typedef struct _SqlUpdateStatementClass SqlUpdateStatementClass;
typedef struct _Block43Data Block43Data;
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
enum  {
	DM_MANAGER_MESSAGE_RECEIVED_SIGNAL,
	DM_MANAGER_THREAD_CHANGED_SIGNAL,
	DM_MANAGER_LAST_SIGNAL
};
static guint dm_manager_signals[DM_MANAGER_LAST_SIGNAL] = {0};

struct _DMManager {
	GObject parent_instance;
	DMManagerPrivate * priv;
};

struct _DMManagerClass {
	GObjectClass parent_class;
};

struct _DMManagerPrivate {
	Account* account;
	DMThreadsModel* threads_model;
};

struct _Account {
	GObject parent_instance;
	AccountPrivate * priv;
	gint64 id;
	SqlDatabase* db;
	gchar* screen_name;
	gchar* name;
	gchar* avatar_url;
	gchar* banner_url;
	gchar* website;
	gchar* description;
	OAuthProxy* proxy;
	CbUserStream* user_stream;
	CbUserCounter* user_counter;
	NotificationManager* notifications;
	gint64* friends;
	gint friends_length1;
	gint64* blocked;
	gint blocked_length1;
	gint64* muted;
	gint muted_length1;
	gint64* disabled_rts;
	gint disabled_rts_length1;
	GPtrArray* filters;
};

struct _AccountClass {
	GObjectClass parent_class;
};

typedef gboolean (*SqlSelectCallback) (gchar** vals, int vals_length1, void* user_data);
struct _DMThread {
	GObject parent_instance;
	DMThreadPrivate * priv;
	CbUserIdentity user;
	gint64 last_message_id;
	gchar* last_message;
	gint unread_count;
	gchar* notification_id;
	cairo_surface_t* avatar_surface;
};

struct _DMThreadClass {
	GObjectClass parent_class;
};

struct _Block40Data {
	int _ref_count_;
	DMManager* self;
	Collect* collect_obj;
	gpointer _async_data_;
};

struct _DmManagerLoadNewestDmsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	DMManager* self;
	Block40Data* _data40_;
	Collect* _tmp0_;
	gint64 max_received_id;
	Account* _tmp1_;
	SqlDatabase* _tmp2_;
	SqlSelectStatement* _tmp3_;
	SqlSelectStatement* _tmp4_;
	SqlSelectStatement* _tmp5_;
	SqlSelectStatement* _tmp6_;
	Account* _tmp7_;
	gint64 _tmp8_;
	SqlSelectStatement* _tmp9_;
	SqlSelectStatement* _tmp10_;
	SqlSelectStatement* _tmp11_;
	SqlSelectStatement* _tmp12_;
	SqlSelectStatement* _tmp13_;
	SqlSelectStatement* _tmp14_;
	gint64 _tmp15_;
	gint64 _tmp16_;
	gint64 max_sent_id;
	Account* _tmp17_;
	SqlDatabase* _tmp18_;
	SqlSelectStatement* _tmp19_;
	SqlSelectStatement* _tmp20_;
	SqlSelectStatement* _tmp21_;
	SqlSelectStatement* _tmp22_;
	Account* _tmp23_;
	gint64 _tmp24_;
	SqlSelectStatement* _tmp25_;
	SqlSelectStatement* _tmp26_;
	SqlSelectStatement* _tmp27_;
	SqlSelectStatement* _tmp28_;
	SqlSelectStatement* _tmp29_;
	SqlSelectStatement* _tmp30_;
	gint64 _tmp31_;
	gint64 _tmp32_;
	RestProxyCall* call;
	Account* _tmp33_;
	OAuthProxy* _tmp34_;
	RestProxyCall* _tmp35_;
	gchar* _tmp36_;
	gchar* _tmp37_;
	RestProxyCall* sent_call;
	Account* _tmp38_;
	OAuthProxy* _tmp39_;
	RestProxyCall* _tmp40_;
	gchar* _tmp41_;
	gchar* _tmp42_;
};

struct _Block41Data {
	int _ref_count_;
	DMManager* self;
	gboolean received;
};

struct _Block42Data {
	int _ref_count_;
	DMManager* self;
	CbTextEntity* url_list;
	gint url_list_length1;
	gint _url_list_size_;
};

struct _Block43Data {
	int _ref_count_;
	DMManager* self;
	CbTextEntity* url_list;
	gint url_list_length1;
	gint _url_list_size_;
};


static gpointer dm_manager_parent_class = NULL;

GType dm_manager_get_type (void) G_GNUC_CONST;
GType account_get_type (void) G_GNUC_CONST;
GType dm_threads_model_get_type (void) G_GNUC_CONST;
#define DM_MANAGER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_DM_MANAGER, DMManagerPrivate))
enum  {
	DM_MANAGER_DUMMY_PROPERTY,
	DM_MANAGER_EMPTY
};
DMManager* dm_manager_new_for_account (Account* account);
DMManager* dm_manager_construct_for_account (GType object_type, Account* account);
DMThreadsModel* dm_threads_model_new (void);
DMThreadsModel* dm_threads_model_construct (GType object_type);
void dm_manager_load_cached_threads (DMManager* self);
GType sql_database_get_type (void) G_GNUC_CONST;
GType notification_manager_get_type (void) G_GNUC_CONST;
GType sql_select_statement_get_type (void) G_GNUC_CONST;
SqlSelectStatement* sql_database_select (SqlDatabase* self, const gchar* table_name);
SqlSelectStatement* sql_select_statement_cols (SqlSelectStatement* self, const gchar* first, ...);
SqlSelectStatement* sql_select_statement_order (SqlSelectStatement* self, const gchar* order_by);
gint sql_select_statement_run (SqlSelectStatement* self, SqlSelectCallback callback, void* callback_target);
static gboolean __lambda98_ (DMManager* self, gchar** vals, int vals_length1);
GType dm_thread_get_type (void) G_GNUC_CONST;
DMThread* dm_thread_new (void);
DMThread* dm_thread_construct (GType object_type);
void dm_threads_model_add (DMThreadsModel* self, DMThread* thread);
static gboolean ___lambda98__sql_select_callback (gchar** vals, int vals_length1, gpointer self);
GListModel* dm_manager_get_threads_model (DMManager* self);
gboolean dm_manager_has_thread (DMManager* self, gint64 user_id);
gboolean dm_threads_model_has_thread (DMThreadsModel* self, gint64 user_id);
gint dm_manager_reset_unread_count (DMManager* self, gint64 user_id);
gint dm_threads_model_reset_unread_count (DMThreadsModel* self, gint64 user_id);
DMThread* dm_threads_model_get_thread (DMThreadsModel* self, gint64 user_id);
gchar* dm_manager_reset_notification_id (DMManager* self, gint64 user_id);
gchar* dm_threads_model_reset_notification_id (DMThreadsModel* self, gint64 user_id);
static void dm_manager_load_newest_dms_data_free (gpointer _data);
void dm_manager_load_newest_dms (DMManager* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void dm_manager_load_newest_dms_finish (DMManager* self, GAsyncResult* _res_);
static gboolean dm_manager_load_newest_dms_co (DmManagerLoadNewestDmsData* _data_);
GType collect_get_type (void) G_GNUC_CONST;
static Block40Data* block40_data_ref (Block40Data* _data40_);
static void block40_data_unref (void * _userdata_);
Collect* collect_new (gint max);
Collect* collect_construct (GType object_type, gint max);
static void __lambda99_ (Block40Data* _data40_);
static void ___lambda99__collect_finished (Collect* _sender, GError* _error_, gpointer self);
SqlSelectStatement* sql_select_statement_where_eqi (SqlSelectStatement* self, const gchar* w, gint64 v);
SqlSelectStatement* sql_select_statement_limit (SqlSelectStatement* self, gint limit);
gint64 sql_select_statement_once_i64 (SqlSelectStatement* self);
static void __lambda100_ (Block40Data* _data40_, GObject* obj, GAsyncResult* res);
static void dm_manager_on_dm_result (DMManager* self, JsonNode* root, gboolean received);
static void _vala_JsonNode_free (JsonNode* self);
void collect_emit (Collect* self, GError* _error_);
static void ___lambda100__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void __lambda104_ (Block40Data* _data40_, GObject* obj, GAsyncResult* res);
static void ___lambda104__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static Block41Data* block41_data_ref (Block41Data* _data41_);
static void block41_data_unref (void * _userdata_);
void sql_database_begin_transaction (SqlDatabase* self);
static void ___lambda101_ (Block41Data* _data41_, JsonArray* arr, guint pos, JsonNode* node);
static void dm_manager_update_thread (DMManager* self, JsonObject* dm_obj, gboolean initial);
static void dm_manager_save_message (DMManager* self, JsonObject* dm_obj, gboolean initial);
static void ____lambda101__json_array_foreach (JsonArray* array, guint index_, JsonNode* element_node, gpointer self);
void sql_database_end_transaction (SqlDatabase* self);
void dm_manager_insert_message (DMManager* self, JsonObject* dm_obj);
static Block42Data* block42_data_ref (Block42Data* _data42_);
static void _vala_CbTextEntity_array_free (CbTextEntity * array, gint array_length);
static void block42_data_unref (void * _userdata_);
static void __lambda102_ (Block42Data* _data42_, JsonArray* arr, guint index, JsonNode* node);
static void ___lambda102__json_array_foreach (JsonArray* array, guint index_, JsonNode* element_node, gpointer self);
GType sql_insert_statement_get_type (void) G_GNUC_CONST;
SqlInsertStatement* sql_database_insert (SqlDatabase* self, const gchar* table_name);
SqlInsertStatement* sql_insert_statement_vali64 (SqlInsertStatement* self, const gchar* col_name, gint64 col_value);
SqlInsertStatement* sql_insert_statement_val (SqlInsertStatement* self, const gchar* col_name, const gchar* col_value);
gint64 sql_insert_statement_run (SqlInsertStatement* self);
void dm_threads_model_update_last_message (DMThreadsModel* self, gint64 sender_id, gint64 message_id, const gchar* message_text);
GType sql_update_statement_get_type (void) G_GNUC_CONST;
SqlUpdateStatement* sql_database_update (SqlDatabase* self, const gchar* table_name);
SqlUpdateStatement* sql_update_statement_val (SqlUpdateStatement* self, const gchar* col_name, const gchar* col_value);
SqlUpdateStatement* sql_update_statement_vali64 (SqlUpdateStatement* self, const gchar* col_name, gint64 col_value);
SqlUpdateStatement* sql_update_statement_where_eqi (SqlUpdateStatement* self, const gchar* col, gint64 iv);
gint64 sql_update_statement_run (SqlUpdateStatement* self);
static Block43Data* block43_data_ref (Block43Data* _data43_);
static void block43_data_unref (void * _userdata_);
static void ___lambda103_ (Block43Data* _data43_, JsonArray* arr, guint index, JsonNode* node);
static void ____lambda103__json_array_foreach (JsonArray* array, guint index_, JsonNode* element_node, gpointer self);
void dm_threads_model_increase_unread_count (DMThreadsModel* self, gint64 user_id, gint amount);
DMManager* dm_manager_new (void);
DMManager* dm_manager_construct (GType object_type);
gboolean dm_manager_get_empty (DMManager* self);
static void g_cclosure_user_marshal_VOID__OBJECT_STRING_BOOLEAN (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void dm_manager_finalize (GObject * obj);
static void _vala_dm_manager_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);


DMManager* dm_manager_construct_for_account (GType object_type, Account* account) {
	DMManager * self = NULL;
	Account* _tmp0_;
	DMThreadsModel* _tmp1_;
	g_return_val_if_fail (IS_ACCOUNT (account), NULL);
	self = (DMManager*) g_object_new (object_type, NULL);
	_tmp0_ = account;
	self->priv->account = _tmp0_;
	_tmp1_ = dm_threads_model_new ();
	_g_object_unref0 (self->priv->threads_model);
	self->priv->threads_model = _tmp1_;
	return self;
}


DMManager* dm_manager_new_for_account (Account* account) {
	return dm_manager_construct_for_account (TYPE_DM_MANAGER, account);
}


static gint64 int64_parse (const gchar* str) {
	gint64 result = 0LL;
	const gchar* _tmp0_;
	gint64 _tmp1_;
	g_return_val_if_fail (str != NULL, 0LL);
	_tmp0_ = str;
	_tmp1_ = g_ascii_strtoll (_tmp0_, NULL, (guint) 0);
	result = _tmp1_;
	return result;
}


static gboolean __lambda98_ (DMManager* self, gchar** vals, int vals_length1) {
	gboolean result = FALSE;
	DMThread* thread = NULL;
	DMThread* _tmp0_;
	gchar** _tmp1_;
	gint _tmp1__length1;
	const gchar* _tmp2_;
	gint64 _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar** _tmp7_;
	gint _tmp7__length1;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gchar** _tmp10_;
	gint _tmp10__length1;
	const gchar* _tmp11_;
	gint64 _tmp12_;
	gchar** _tmp13_;
	gint _tmp13__length1;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	DMThreadsModel* _tmp16_;
	_tmp0_ = dm_thread_new ();
	thread = _tmp0_;
	_tmp1_ = vals;
	_tmp1__length1 = vals_length1;
	_tmp2_ = _tmp1_[0];
	_tmp3_ = int64_parse (_tmp2_);
	thread->user.id = _tmp3_;
	_tmp4_ = vals;
	_tmp4__length1 = vals_length1;
	_tmp5_ = _tmp4_[1];
	_tmp6_ = g_strdup (_tmp5_);
	_g_free0 (thread->user.screen_name);
	thread->user.screen_name = _tmp6_;
	_tmp7_ = vals;
	_tmp7__length1 = vals_length1;
	_tmp8_ = _tmp7_[2];
	_tmp9_ = g_strdup (_tmp8_);
	_g_free0 (thread->user.user_name);
	thread->user.user_name = _tmp9_;
	_tmp10_ = vals;
	_tmp10__length1 = vals_length1;
	_tmp11_ = _tmp10_[4];
	_tmp12_ = int64_parse (_tmp11_);
	thread->last_message_id = _tmp12_;
	_tmp13_ = vals;
	_tmp13__length1 = vals_length1;
	_tmp14_ = _tmp13_[3];
	_tmp15_ = g_strdup (_tmp14_);
	_g_free0 (thread->last_message);
	thread->last_message = _tmp15_;
	_tmp16_ = self->priv->threads_model;
	dm_threads_model_add (_tmp16_, thread);
	result = TRUE;
	_g_object_unref0 (thread);
	return result;
}


static gboolean ___lambda98__sql_select_callback (gchar** vals, int vals_length1, gpointer self) {
	gboolean result;
	result = __lambda98_ ((DMManager*) self, vals, vals_length1);
	return result;
}


void dm_manager_load_cached_threads (DMManager* self) {
	Account* _tmp0_;
	SqlDatabase* _tmp1_;
	SqlSelectStatement* _tmp2_;
	SqlSelectStatement* _tmp3_;
	SqlSelectStatement* _tmp4_;
	SqlSelectStatement* _tmp5_;
	SqlSelectStatement* _tmp6_;
	SqlSelectStatement* _tmp7_;
	g_return_if_fail (IS_DM_MANAGER (self));
	_tmp0_ = self->priv->account;
	_tmp1_ = _tmp0_->db;
	_tmp2_ = sql_database_select (_tmp1_, "dm_threads");
	_tmp3_ = _tmp2_;
	_tmp4_ = sql_select_statement_cols (_tmp3_, "user_id", "screen_name", "name", "last_message", "last_message_id", NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = sql_select_statement_order (_tmp5_, "last_message_id");
	_tmp7_ = _tmp6_;
	sql_select_statement_run (_tmp7_, ___lambda98__sql_select_callback, self);
	_g_object_unref0 (_tmp7_);
	_g_object_unref0 (_tmp5_);
	_g_object_unref0 (_tmp3_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


GListModel* dm_manager_get_threads_model (DMManager* self) {
	GListModel* result = NULL;
	DMThreadsModel* _tmp0_;
	GListModel* _tmp1_;
	g_return_val_if_fail (IS_DM_MANAGER (self), NULL);
	_tmp0_ = self->priv->threads_model;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, g_list_model_get_type (), GListModel));
	result = _tmp1_;
	return result;
}


gboolean dm_manager_has_thread (DMManager* self, gint64 user_id) {
	gboolean result = FALSE;
	DMThreadsModel* _tmp0_;
	gint64 _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (IS_DM_MANAGER (self), FALSE);
	_tmp0_ = self->priv->threads_model;
	_tmp1_ = user_id;
	_tmp2_ = dm_threads_model_has_thread (_tmp0_, _tmp1_);
	result = _tmp2_;
	return result;
}


gint dm_manager_reset_unread_count (DMManager* self, gint64 user_id) {
	gint result = 0;
	DMThreadsModel* _tmp0_;
	gint64 _tmp1_;
	gboolean _tmp2_;
	gint prev_count = 0;
	DMThreadsModel* _tmp6_;
	gint64 _tmp7_;
	gint _tmp8_;
	DMThreadsModel* _tmp9_;
	gint64 _tmp10_;
	DMThread* _tmp11_;
	DMThread* _tmp12_;
	g_return_val_if_fail (IS_DM_MANAGER (self), 0);
	_tmp0_ = self->priv->threads_model;
	_tmp1_ = user_id;
	_tmp2_ = dm_threads_model_has_thread (_tmp0_, _tmp1_);
	if (!_tmp2_) {
		gint64 _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp3_ = user_id;
		_tmp4_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp3_);
		_tmp5_ = _tmp4_;
		g_debug ("DMManager.vala:63: No thread found for user id %s", _tmp5_);
		_g_free0 (_tmp5_);
		result = 0;
		return result;
	}
	_tmp6_ = self->priv->threads_model;
	_tmp7_ = user_id;
	_tmp8_ = dm_threads_model_reset_unread_count (_tmp6_, _tmp7_);
	prev_count = _tmp8_;
	_tmp9_ = self->priv->threads_model;
	_tmp10_ = user_id;
	_tmp11_ = dm_threads_model_get_thread (_tmp9_, _tmp10_);
	_tmp12_ = _tmp11_;
	g_signal_emit (self, dm_manager_signals[DM_MANAGER_THREAD_CHANGED_SIGNAL], 0, _tmp12_);
	_g_object_unref0 (_tmp12_);
	result = prev_count;
	return result;
}


gchar* dm_manager_reset_notification_id (DMManager* self, gint64 user_id) {
	gchar* result = NULL;
	DMThreadsModel* _tmp0_;
	gint64 _tmp1_;
	gboolean _tmp2_;
	DMThreadsModel* _tmp6_;
	gint64 _tmp7_;
	gchar* _tmp8_;
	g_return_val_if_fail (IS_DM_MANAGER (self), NULL);
	_tmp0_ = self->priv->threads_model;
	_tmp1_ = user_id;
	_tmp2_ = dm_threads_model_has_thread (_tmp0_, _tmp1_);
	if (!_tmp2_) {
		gint64 _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp3_ = user_id;
		_tmp4_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp3_);
		_tmp5_ = _tmp4_;
		g_debug ("DMManager.vala:76: No thread found for user id %s", _tmp5_);
		_g_free0 (_tmp5_);
		result = NULL;
		return result;
	}
	_tmp6_ = self->priv->threads_model;
	_tmp7_ = user_id;
	_tmp8_ = dm_threads_model_reset_notification_id (_tmp6_, _tmp7_);
	result = _tmp8_;
	return result;
}


static void dm_manager_load_newest_dms_data_free (gpointer _data) {
	DmManagerLoadNewestDmsData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (DmManagerLoadNewestDmsData, _data_);
}


void dm_manager_load_newest_dms (DMManager* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DmManagerLoadNewestDmsData* _data_;
	DMManager* _tmp0_;
	_data_ = g_slice_new0 (DmManagerLoadNewestDmsData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, dm_manager_load_newest_dms_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	dm_manager_load_newest_dms_co (_data_);
}


void dm_manager_load_newest_dms_finish (DMManager* self, GAsyncResult* _res_) {
	DmManagerLoadNewestDmsData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}


static Block40Data* block40_data_ref (Block40Data* _data40_) {
	g_atomic_int_inc (&_data40_->_ref_count_);
	return _data40_;
}


static void block40_data_unref (void * _userdata_) {
	Block40Data* _data40_;
	_data40_ = (Block40Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data40_->_ref_count_)) {
		DMManager* self;
		self = _data40_->self;
		_g_object_unref0 (_data40_->collect_obj);
		_g_object_unref0 (self);
		g_slice_free (Block40Data, _data40_);
	}
}


static void __lambda99_ (Block40Data* _data40_) {
	DMManager* self;
	self = _data40_->self;
	dm_manager_load_newest_dms_co (_data40_->_async_data_);
}


static void ___lambda99__collect_finished (Collect* _sender, GError* _error_, gpointer self) {
	__lambda99_ (self);
}


static void _vala_JsonNode_free (JsonNode* self) {
	g_boxed_free (json_node_get_type (), self);
}


static void __lambda100_ (Block40Data* _data40_, GObject* obj, GAsyncResult* res) {
	DMManager* self;
	GError * _inner_error_ = NULL;
	self = _data40_->self;
	g_return_if_fail ((obj == NULL) || G_IS_OBJECT (obj));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	{
		JsonNode* root = NULL;
		GAsyncResult* _tmp0_;
		JsonNode* _tmp1_;
		_tmp0_ = res;
		_tmp1_ = cb_utils_load_threaded_finish (_tmp0_, &_inner_error_);
		root = _tmp1_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch41_g_error;
		}
		dm_manager_on_dm_result (self, root, TRUE);
		__vala_JsonNode_free0 (root);
	}
	goto __finally41;
	__catch41_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		g_warning ("DMManager.vala:109: %s", _tmp3_);
		_g_error_free0 (e);
	}
	__finally41:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	collect_emit (_data40_->collect_obj, NULL);
}


static void ___lambda100__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda100_ (self, source_object, res);
	block40_data_unref (self);
}


static void __lambda104_ (Block40Data* _data40_, GObject* obj, GAsyncResult* res) {
	DMManager* self;
	GError * _inner_error_ = NULL;
	self = _data40_->self;
	g_return_if_fail ((obj == NULL) || G_IS_OBJECT (obj));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	{
		JsonNode* root = NULL;
		GAsyncResult* _tmp0_;
		JsonNode* _tmp1_;
		_tmp0_ = res;
		_tmp1_ = cb_utils_load_threaded_finish (_tmp0_, &_inner_error_);
		root = _tmp1_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch42_g_error;
		}
		dm_manager_on_dm_result (self, root, FALSE);
		__vala_JsonNode_free0 (root);
	}
	goto __finally42;
	__catch42_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		g_warning ("DMManager.vala:126: %s", _tmp3_);
		_g_error_free0 (e);
	}
	__finally42:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	collect_emit (_data40_->collect_obj, NULL);
}


static void ___lambda104__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda104_ (self, source_object, res);
	block40_data_unref (self);
}


static gboolean dm_manager_load_newest_dms_co (DmManagerLoadNewestDmsData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data40_ = g_slice_new0 (Block40Data);
	_data_->_data40_->_ref_count_ = 1;
	_data_->_data40_->self = g_object_ref (_data_->self);
	_data_->_data40_->_async_data_ = _data_;
	_data_->_tmp0_ = collect_new (2);
	_data_->_data40_->collect_obj = _data_->_tmp0_;
	g_signal_connect_data (_data_->_data40_->collect_obj, "finished", (GCallback) ___lambda99__collect_finished, block40_data_ref (_data_->_data40_), (GClosureNotify) block40_data_unref, 0);
	_data_->_tmp1_ = _data_->self->priv->account;
	_data_->_tmp2_ = _data_->_tmp1_->db;
	_data_->_tmp3_ = sql_database_select (_data_->_tmp2_, "dms");
	_data_->_tmp4_ = _data_->_tmp3_;
	_data_->_tmp5_ = sql_select_statement_cols (_data_->_tmp4_, "id", NULL);
	_data_->_tmp6_ = _data_->_tmp5_;
	_data_->_tmp7_ = _data_->self->priv->account;
	_data_->_tmp8_ = _data_->_tmp7_->id;
	_data_->_tmp9_ = sql_select_statement_where_eqi (_data_->_tmp6_, "to_id", _data_->_tmp8_);
	_data_->_tmp10_ = _data_->_tmp9_;
	_data_->_tmp11_ = sql_select_statement_order (_data_->_tmp10_, "id DESC");
	_data_->_tmp12_ = _data_->_tmp11_;
	_data_->_tmp13_ = sql_select_statement_limit (_data_->_tmp12_, 1);
	_data_->_tmp14_ = _data_->_tmp13_;
	_data_->_tmp15_ = sql_select_statement_once_i64 (_data_->_tmp14_);
	_data_->_tmp16_ = _data_->_tmp15_;
	_g_object_unref0 (_data_->_tmp14_);
	_g_object_unref0 (_data_->_tmp12_);
	_g_object_unref0 (_data_->_tmp10_);
	_g_object_unref0 (_data_->_tmp6_);
	_g_object_unref0 (_data_->_tmp4_);
	_data_->max_received_id = _data_->_tmp16_;
	_data_->_tmp17_ = _data_->self->priv->account;
	_data_->_tmp18_ = _data_->_tmp17_->db;
	_data_->_tmp19_ = sql_database_select (_data_->_tmp18_, "dms");
	_data_->_tmp20_ = _data_->_tmp19_;
	_data_->_tmp21_ = sql_select_statement_cols (_data_->_tmp20_, "id", NULL);
	_data_->_tmp22_ = _data_->_tmp21_;
	_data_->_tmp23_ = _data_->self->priv->account;
	_data_->_tmp24_ = _data_->_tmp23_->id;
	_data_->_tmp25_ = sql_select_statement_where_eqi (_data_->_tmp22_, "from_id", _data_->_tmp24_);
	_data_->_tmp26_ = _data_->_tmp25_;
	_data_->_tmp27_ = sql_select_statement_order (_data_->_tmp26_, "id DESC");
	_data_->_tmp28_ = _data_->_tmp27_;
	_data_->_tmp29_ = sql_select_statement_limit (_data_->_tmp28_, 1);
	_data_->_tmp30_ = _data_->_tmp29_;
	_data_->_tmp31_ = sql_select_statement_once_i64 (_data_->_tmp30_);
	_data_->_tmp32_ = _data_->_tmp31_;
	_g_object_unref0 (_data_->_tmp30_);
	_g_object_unref0 (_data_->_tmp28_);
	_g_object_unref0 (_data_->_tmp26_);
	_g_object_unref0 (_data_->_tmp22_);
	_g_object_unref0 (_data_->_tmp20_);
	_data_->max_sent_id = _data_->_tmp32_;
	_data_->_tmp33_ = _data_->self->priv->account;
	_data_->_tmp34_ = _data_->_tmp33_->proxy;
	_data_->_tmp35_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp34_, rest_proxy_get_type (), RestProxy));
	_data_->call = _data_->_tmp35_;
	rest_proxy_call_set_function (_data_->call, "1.1/direct_messages.json");
	rest_proxy_call_set_method (_data_->call, "GET");
	rest_proxy_call_add_param (_data_->call, "skip_status", "true");
	_data_->_tmp36_ = g_strdup_printf ("%" G_GINT64_FORMAT, _data_->max_received_id);
	_data_->_tmp37_ = _data_->_tmp36_;
	rest_proxy_call_add_param (_data_->call, "since_id", _data_->_tmp37_);
	_g_free0 (_data_->_tmp37_);
	rest_proxy_call_add_param (_data_->call, "count", "200");
	rest_proxy_call_add_param (_data_->call, "full_text", "true");
	cb_utils_load_threaded_async (_data_->call, NULL, ___lambda100__gasync_ready_callback, block40_data_ref (_data_->_data40_));
	_data_->_tmp38_ = _data_->self->priv->account;
	_data_->_tmp39_ = _data_->_tmp38_->proxy;
	_data_->_tmp40_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp39_, rest_proxy_get_type (), RestProxy));
	_data_->sent_call = _data_->_tmp40_;
	rest_proxy_call_set_function (_data_->sent_call, "1.1/direct_messages/sent.json");
	rest_proxy_call_add_param (_data_->sent_call, "skip_status", "true");
	_data_->_tmp41_ = g_strdup_printf ("%" G_GINT64_FORMAT, _data_->max_sent_id);
	_data_->_tmp42_ = _data_->_tmp41_;
	rest_proxy_call_add_param (_data_->sent_call, "since_id", _data_->_tmp42_);
	_g_free0 (_data_->_tmp42_);
	rest_proxy_call_add_param (_data_->sent_call, "count", "200");
	rest_proxy_call_add_param (_data_->sent_call, "full_text", "true");
	rest_proxy_call_set_method (_data_->sent_call, "GET");
	cb_utils_load_threaded_async (_data_->sent_call, NULL, ___lambda104__gasync_ready_callback, block40_data_ref (_data_->_data40_));
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	_g_object_unref0 (_data_->sent_call);
	_g_object_unref0 (_data_->call);
	block40_data_unref (_data_->_data40_);
	_data_->_data40_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (g_task_get_completed (_data_->_async_result) != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static Block41Data* block41_data_ref (Block41Data* _data41_) {
	g_atomic_int_inc (&_data41_->_ref_count_);
	return _data41_;
}


static void block41_data_unref (void * _userdata_) {
	Block41Data* _data41_;
	_data41_ = (Block41Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data41_->_ref_count_)) {
		DMManager* self;
		self = _data41_->self;
		_g_object_unref0 (self);
		g_slice_free (Block41Data, _data41_);
	}
}


static gpointer _json_array_ref0 (gpointer self) {
	return self ? json_array_ref (self) : NULL;
}


static gpointer _json_object_ref0 (gpointer self) {
	return self ? json_object_ref (self) : NULL;
}


static void ___lambda101_ (Block41Data* _data41_, JsonArray* arr, guint pos, JsonNode* node) {
	DMManager* self;
	JsonObject* dm_obj = NULL;
	JsonNode* _tmp0_;
	JsonObject* _tmp1_;
	JsonObject* _tmp2_;
	JsonObject* _tmp3_;
	gint64 _tmp4_;
	Account* _tmp5_;
	gint64 _tmp6_;
	self = _data41_->self;
	g_return_if_fail (arr != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = node;
	_tmp1_ = json_node_get_object (_tmp0_);
	_tmp2_ = _json_object_ref0 (_tmp1_);
	dm_obj = _tmp2_;
	_tmp3_ = dm_obj;
	_tmp4_ = json_object_get_int_member (_tmp3_, "sender_id");
	_tmp5_ = self->priv->account;
	_tmp6_ = _tmp5_->id;
	if (_tmp4_ == _tmp6_) {
		gboolean _tmp7_;
		_tmp7_ = _data41_->received;
		if (_tmp7_) {
			JsonObject* _tmp8_;
			_tmp8_ = dm_obj;
			dm_manager_update_thread (self, _tmp8_, TRUE);
		} else {
			JsonObject* _tmp9_;
			_tmp9_ = dm_obj;
			dm_manager_save_message (self, _tmp9_, TRUE);
		}
	} else {
		JsonObject* _tmp10_;
		_tmp10_ = dm_obj;
		dm_manager_update_thread (self, _tmp10_, TRUE);
	}
	_json_object_unref0 (dm_obj);
}


static void ____lambda101__json_array_foreach (JsonArray* array, guint index_, JsonNode* element_node, gpointer self) {
	___lambda101_ (self, array, index_, element_node);
}


static void dm_manager_on_dm_result (DMManager* self, JsonNode* root, gboolean received) {
	Block41Data* _data41_;
	gboolean _tmp0_;
	JsonArray* root_arr = NULL;
	JsonNode* _tmp1_;
	JsonArray* _tmp2_;
	JsonArray* _tmp3_;
	JsonArray* _tmp4_;
	guint _tmp5_;
	JsonArray* _tmp6_;
	guint _tmp7_;
	g_return_if_fail (IS_DM_MANAGER (self));
	_data41_ = g_slice_new0 (Block41Data);
	_data41_->_ref_count_ = 1;
	_data41_->self = g_object_ref (self);
	_tmp0_ = received;
	_data41_->received = _tmp0_;
	_tmp1_ = root;
	_tmp2_ = json_node_get_array (_tmp1_);
	_tmp3_ = _json_array_ref0 (_tmp2_);
	root_arr = _tmp3_;
	_tmp4_ = root_arr;
	_tmp5_ = json_array_get_length (_tmp4_);
	g_debug ("DMManager.vala:136: sent: %u", _tmp5_);
	_tmp6_ = root_arr;
	_tmp7_ = json_array_get_length (_tmp6_);
	if (_tmp7_ > ((guint) 0)) {
		Account* _tmp8_;
		SqlDatabase* _tmp9_;
		JsonArray* _tmp10_;
		Account* _tmp11_;
		SqlDatabase* _tmp12_;
		_tmp8_ = self->priv->account;
		_tmp9_ = _tmp8_->db;
		sql_database_begin_transaction (_tmp9_);
		_tmp10_ = root_arr;
		json_array_foreach_element (_tmp10_, ____lambda101__json_array_foreach, _data41_);
		_tmp11_ = self->priv->account;
		_tmp12_ = _tmp11_->db;
		sql_database_end_transaction (_tmp12_);
	}
	_json_array_unref0 (root_arr);
	block41_data_unref (_data41_);
	_data41_ = NULL;
}


void dm_manager_insert_message (DMManager* self, JsonObject* dm_obj) {
	JsonObject* _tmp0_;
	g_return_if_fail (IS_DM_MANAGER (self));
	g_return_if_fail (dm_obj != NULL);
	_tmp0_ = dm_obj;
	dm_manager_update_thread (self, _tmp0_, FALSE);
}


static Block42Data* block42_data_ref (Block42Data* _data42_) {
	g_atomic_int_inc (&_data42_->_ref_count_);
	return _data42_;
}


static void _vala_CbTextEntity_array_free (CbTextEntity * array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			cb_text_entity_free (&array[i]);
		}
	}
	g_free (array);
}


static void block42_data_unref (void * _userdata_) {
	Block42Data* _data42_;
	_data42_ = (Block42Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data42_->_ref_count_)) {
		DMManager* self;
		self = _data42_->self;
		_data42_->url_list = (_vala_CbTextEntity_array_free (_data42_->url_list, _data42_->url_list_length1), NULL);
		_g_object_unref0 (self);
		g_slice_free (Block42Data, _data42_);
	}
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		const gchar* _tmp2_;
		_tmp2_ = old;
		_tmp1_ = (*((gchar*) _tmp2_)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp3_ = old;
		_tmp4_ = replacement;
		_tmp0_ = g_strcmp0 (_tmp3_, _tmp4_) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp5_;
		_tmp5_ = g_strdup (self);
		result = _tmp5_;
		return result;
	}
	{
		GRegex* regex = NULL;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		GRegex* _tmp9_;
		GRegex* _tmp10_;
		gchar* _tmp11_ = NULL;
		GRegex* _tmp12_;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		_tmp6_ = old;
		_tmp7_ = g_regex_escape_string (_tmp6_, -1);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_regex_new (_tmp8_, 0, 0, &_inner_error_);
		_tmp10_ = _tmp9_;
		_g_free0 (_tmp8_);
		regex = _tmp10_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch43_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp12_ = regex;
		_tmp13_ = replacement;
		_tmp14_ = g_regex_replace_literal (_tmp12_, self, (gssize) -1, 0, _tmp13_, 0, &_inner_error_);
		_tmp11_ = _tmp14_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch43_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp15_ = _tmp11_;
		_tmp11_ = NULL;
		result = _tmp15_;
		_g_free0 (_tmp11_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally43;
	__catch43_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally43:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static void __lambda102_ (Block42Data* _data42_, JsonArray* arr, guint index, JsonNode* node) {
	DMManager* self;
	JsonObject* url = NULL;
	JsonNode* _tmp0_;
	JsonObject* _tmp1_;
	JsonObject* _tmp2_;
	gchar* expanded_url = NULL;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	JsonArray* indices = NULL;
	JsonArray* _tmp5_;
	JsonArray* _tmp6_;
	CbTextEntity* _tmp7_;
	gint _tmp7__length1;
	guint _tmp8_;
	gint64 _tmp9_;
	gint64 _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	CbTextEntity _tmp15_ = {0};
	CbTextEntity _tmp16_;
	self = _data42_->self;
	g_return_if_fail (arr != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = node;
	_tmp1_ = json_node_get_object (_tmp0_);
	_tmp2_ = _json_object_ref0 (_tmp1_);
	url = _tmp2_;
	_tmp3_ = json_object_get_string_member (url, "expanded_url");
	_tmp4_ = g_strdup (_tmp3_);
	expanded_url = _tmp4_;
	_tmp5_ = json_object_get_array_member (url, "indices");
	_tmp6_ = _json_array_ref0 (_tmp5_);
	indices = _tmp6_;
	_tmp7_ = _data42_->url_list;
	_tmp7__length1 = _data42_->url_list_length1;
	_tmp8_ = index;
	_tmp9_ = json_array_get_int_element (indices, (guint) 0);
	_tmp10_ = json_array_get_int_element (indices, (guint) 1);
	_tmp11_ = json_object_get_string_member (url, "display_url");
	_tmp12_ = g_strdup (_tmp11_);
	_tmp13_ = string_replace (expanded_url, "&", "&amp;");
	_tmp14_ = g_strdup (expanded_url);
	memset (&_tmp15_, 0, sizeof (CbTextEntity));
	_tmp15_.from = (guint) _tmp9_;
	_tmp15_.to = (guint) _tmp10_;
	_g_free0 (_tmp15_.display_text);
	_tmp15_.display_text = _tmp12_;
	_g_free0 (_tmp15_.target);
	_tmp15_.target = _tmp13_;
	_g_free0 (_tmp15_.tooltip_text);
	_tmp15_.tooltip_text = _tmp14_;
	cb_text_entity_free (&_tmp7_[_tmp8_]);
	_tmp7_[_tmp8_] = _tmp15_;
	_tmp16_ = _tmp7_[_tmp8_];
	_json_array_unref0 (indices);
	_g_free0 (expanded_url);
	_json_object_unref0 (url);
}


static void ___lambda102__json_array_foreach (JsonArray* array, guint index_, JsonNode* element_node, gpointer self) {
	__lambda102_ (self, array, index_, element_node);
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


static void dm_manager_update_thread (DMManager* self, JsonObject* dm_obj, gboolean initial) {
	Block42Data* _data42_;
	gint64 recipient_id = 0LL;
	JsonObject* _tmp0_;
	gint64 _tmp1_;
	gint64 sender_id = 0LL;
	JsonObject* _tmp2_;
	gint64 _tmp3_;
	gint64 message_id = 0LL;
	JsonObject* _tmp4_;
	gint64 _tmp5_;
	gchar* source_text = NULL;
	JsonObject* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	JsonArray* urls = NULL;
	JsonObject* _tmp9_;
	JsonObject* _tmp10_;
	JsonArray* _tmp11_;
	JsonArray* _tmp12_;
	JsonArray* _tmp13_;
	guint _tmp14_;
	CbTextEntity* _tmp15_;
	JsonArray* _tmp16_;
	gchar* text = NULL;
	const gchar* _tmp17_;
	CbTextEntity* _tmp18_;
	gint _tmp18__length1;
	gchar* _tmp19_;
	gchar* sender_screen_name = NULL;
	JsonObject* _tmp20_;
	const gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* sender_name = NULL;
	JsonObject* _tmp23_;
	JsonObject* _tmp24_;
	const gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	gint64 thread_user_id = 0LL;
	gint64 _tmp30_;
	Account* _tmp31_;
	gint64 _tmp32_;
	DMThreadsModel* _tmp35_;
	gint64 _tmp36_;
	gboolean _tmp37_;
	Account* _tmp104_;
	CbUserCounter* _tmp105_;
	gint64 _tmp106_;
	const gchar* _tmp107_;
	const gchar* _tmp108_;
	JsonObject* _tmp109_;
	gboolean _tmp110_;
	g_return_if_fail (IS_DM_MANAGER (self));
	g_return_if_fail (dm_obj != NULL);
	_data42_ = g_slice_new0 (Block42Data);
	_data42_->_ref_count_ = 1;
	_data42_->self = g_object_ref (self);
	_tmp0_ = dm_obj;
	_tmp1_ = json_object_get_int_member (_tmp0_, "recipient_id");
	recipient_id = _tmp1_;
	_tmp2_ = dm_obj;
	_tmp3_ = json_object_get_int_member (_tmp2_, "sender_id");
	sender_id = _tmp3_;
	_tmp4_ = dm_obj;
	_tmp5_ = json_object_get_int_member (_tmp4_, "id");
	message_id = _tmp5_;
	_tmp6_ = dm_obj;
	_tmp7_ = json_object_get_string_member (_tmp6_, "text");
	_tmp8_ = g_strdup (_tmp7_);
	source_text = _tmp8_;
	_tmp9_ = dm_obj;
	_tmp10_ = json_object_get_object_member (_tmp9_, "entities");
	_tmp11_ = json_object_get_array_member (_tmp10_, "urls");
	_tmp12_ = _json_array_ref0 (_tmp11_);
	urls = _tmp12_;
	_tmp13_ = urls;
	_tmp14_ = json_array_get_length (_tmp13_);
	_tmp15_ = g_new0 (CbTextEntity, _tmp14_);
	_data42_->url_list = _tmp15_;
	_data42_->url_list_length1 = _tmp14_;
	_data42_->_url_list_size_ = _data42_->url_list_length1;
	_tmp16_ = urls;
	json_array_foreach_element (_tmp16_, ___lambda102__json_array_foreach, _data42_);
	_tmp17_ = source_text;
	_tmp18_ = _data42_->url_list;
	_tmp18__length1 = _data42_->url_list_length1;
	_tmp19_ = cb_text_transform_text (_tmp17_, _tmp18_, _tmp18__length1, (guint) CB_TEXT_TRANSFORM_EXPAND_LINKS, (gsize) 0, (gint64) 0, (guint) 0);
	text = _tmp19_;
	_tmp20_ = dm_obj;
	_tmp21_ = json_object_get_string_member (_tmp20_, "sender_screen_name");
	_tmp22_ = g_strdup (_tmp21_);
	sender_screen_name = _tmp22_;
	_tmp23_ = dm_obj;
	_tmp24_ = json_object_get_object_member (_tmp23_, "sender");
	_tmp25_ = json_object_get_string_member (_tmp24_, "name");
	_tmp26_ = string_strip (_tmp25_);
	_tmp27_ = _tmp26_;
	_tmp28_ = string_replace (_tmp27_, "&", "&amp;");
	_tmp29_ = _tmp28_;
	_g_free0 (_tmp27_);
	sender_name = _tmp29_;
	thread_user_id = (gint64) 0;
	_tmp30_ = sender_id;
	_tmp31_ = self->priv->account;
	_tmp32_ = _tmp31_->id;
	if (_tmp30_ == _tmp32_) {
		gint64 _tmp33_;
		_tmp33_ = recipient_id;
		thread_user_id = _tmp33_;
	} else {
		gint64 _tmp34_;
		_tmp34_ = sender_id;
		thread_user_id = _tmp34_;
	}
	_tmp35_ = self->priv->threads_model;
	_tmp36_ = thread_user_id;
	_tmp37_ = dm_threads_model_has_thread (_tmp35_, _tmp36_);
	if (!_tmp37_) {
		DMThread* thread = NULL;
		DMThread* _tmp38_;
		DMThread* _tmp39_;
		gint64 _tmp40_;
		DMThread* _tmp41_;
		const gchar* _tmp42_;
		gchar* _tmp43_;
		DMThread* _tmp44_;
		const gchar* _tmp45_;
		gchar* _tmp46_;
		DMThread* _tmp47_;
		const gchar* _tmp48_;
		gchar* _tmp49_;
		DMThread* _tmp50_;
		gint64 _tmp51_;
		DMThreadsModel* _tmp52_;
		DMThread* _tmp53_;
		Account* _tmp54_;
		SqlDatabase* _tmp55_;
		SqlInsertStatement* _tmp56_;
		SqlInsertStatement* _tmp57_;
		gint64 _tmp58_;
		SqlInsertStatement* _tmp59_;
		SqlInsertStatement* _tmp60_;
		const gchar* _tmp61_;
		SqlInsertStatement* _tmp62_;
		SqlInsertStatement* _tmp63_;
		const gchar* _tmp64_;
		SqlInsertStatement* _tmp65_;
		SqlInsertStatement* _tmp66_;
		const gchar* _tmp67_;
		SqlInsertStatement* _tmp68_;
		SqlInsertStatement* _tmp69_;
		gint64 _tmp70_;
		SqlInsertStatement* _tmp71_;
		SqlInsertStatement* _tmp72_;
		_tmp38_ = dm_thread_new ();
		thread = _tmp38_;
		_tmp39_ = thread;
		_tmp40_ = sender_id;
		_tmp39_->user.id = _tmp40_;
		_tmp41_ = thread;
		_tmp42_ = sender_screen_name;
		_tmp43_ = g_strdup (_tmp42_);
		_g_free0 (_tmp41_->user.screen_name);
		_tmp41_->user.screen_name = _tmp43_;
		_tmp44_ = thread;
		_tmp45_ = sender_name;
		_tmp46_ = g_strdup (_tmp45_);
		_g_free0 (_tmp44_->user.user_name);
		_tmp44_->user.user_name = _tmp46_;
		_tmp47_ = thread;
		_tmp48_ = text;
		_tmp49_ = g_strdup (_tmp48_);
		_g_free0 (_tmp47_->last_message);
		_tmp47_->last_message = _tmp49_;
		_tmp50_ = thread;
		_tmp51_ = message_id;
		_tmp50_->last_message_id = _tmp51_;
		_tmp52_ = self->priv->threads_model;
		_tmp53_ = thread;
		dm_threads_model_add (_tmp52_, _tmp53_);
		_tmp54_ = self->priv->account;
		_tmp55_ = _tmp54_->db;
		_tmp56_ = sql_database_insert (_tmp55_, "dm_threads");
		_tmp57_ = _tmp56_;
		_tmp58_ = sender_id;
		_tmp59_ = sql_insert_statement_vali64 (_tmp57_, "user_id", _tmp58_);
		_tmp60_ = _tmp59_;
		_tmp61_ = sender_screen_name;
		_tmp62_ = sql_insert_statement_val (_tmp60_, "screen_name", _tmp61_);
		_tmp63_ = _tmp62_;
		_tmp64_ = sender_name;
		_tmp65_ = sql_insert_statement_val (_tmp63_, "name", _tmp64_);
		_tmp66_ = _tmp65_;
		_tmp67_ = text;
		_tmp68_ = sql_insert_statement_val (_tmp66_, "last_message", _tmp67_);
		_tmp69_ = _tmp68_;
		_tmp70_ = message_id;
		_tmp71_ = sql_insert_statement_vali64 (_tmp69_, "last_message_id", _tmp70_);
		_tmp72_ = _tmp71_;
		sql_insert_statement_run (_tmp72_);
		_g_object_unref0 (_tmp72_);
		_g_object_unref0 (_tmp69_);
		_g_object_unref0 (_tmp66_);
		_g_object_unref0 (_tmp63_);
		_g_object_unref0 (_tmp60_);
		_g_object_unref0 (_tmp57_);
		_g_object_unref0 (thread);
	} else {
		gboolean _tmp73_ = FALSE;
		gint64 _tmp74_;
		Account* _tmp75_;
		gint64 _tmp76_;
		_tmp74_ = sender_id;
		_tmp75_ = self->priv->account;
		_tmp76_ = _tmp75_->id;
		if (_tmp74_ != _tmp76_) {
			_tmp73_ = TRUE;
		} else {
			gint64 _tmp77_;
			Account* _tmp78_;
			gint64 _tmp79_;
			_tmp77_ = recipient_id;
			_tmp78_ = self->priv->account;
			_tmp79_ = _tmp78_->id;
			_tmp73_ = _tmp77_ == _tmp79_;
		}
		if (_tmp73_) {
			DMThread* thread = NULL;
			DMThreadsModel* _tmp80_;
			gint64 _tmp81_;
			DMThread* _tmp82_;
			gint64 _tmp83_;
			DMThread* _tmp84_;
			gint64 _tmp85_;
			_tmp80_ = self->priv->threads_model;
			_tmp81_ = sender_id;
			_tmp82_ = dm_threads_model_get_thread (_tmp80_, _tmp81_);
			thread = _tmp82_;
			_tmp83_ = message_id;
			_tmp84_ = thread;
			_tmp85_ = _tmp84_->last_message_id;
			if (_tmp83_ > _tmp85_) {
				DMThreadsModel* _tmp86_;
				gint64 _tmp87_;
				gint64 _tmp88_;
				const gchar* _tmp89_;
				Account* _tmp90_;
				SqlDatabase* _tmp91_;
				SqlUpdateStatement* _tmp92_;
				SqlUpdateStatement* _tmp93_;
				const gchar* _tmp94_;
				SqlUpdateStatement* _tmp95_;
				SqlUpdateStatement* _tmp96_;
				gint64 _tmp97_;
				SqlUpdateStatement* _tmp98_;
				SqlUpdateStatement* _tmp99_;
				gint64 _tmp100_;
				SqlUpdateStatement* _tmp101_;
				SqlUpdateStatement* _tmp102_;
				DMThread* _tmp103_;
				_tmp86_ = self->priv->threads_model;
				_tmp87_ = sender_id;
				_tmp88_ = message_id;
				_tmp89_ = text;
				dm_threads_model_update_last_message (_tmp86_, _tmp87_, _tmp88_, _tmp89_);
				_tmp90_ = self->priv->account;
				_tmp91_ = _tmp90_->db;
				_tmp92_ = sql_database_update (_tmp91_, "dm_threads");
				_tmp93_ = _tmp92_;
				_tmp94_ = text;
				_tmp95_ = sql_update_statement_val (_tmp93_, "last_message", _tmp94_);
				_tmp96_ = _tmp95_;
				_tmp97_ = message_id;
				_tmp98_ = sql_update_statement_vali64 (_tmp96_, "last_message_id", _tmp97_);
				_tmp99_ = _tmp98_;
				_tmp100_ = sender_id;
				_tmp101_ = sql_update_statement_where_eqi (_tmp99_, "user_id", _tmp100_);
				_tmp102_ = _tmp101_;
				sql_update_statement_run (_tmp102_);
				_g_object_unref0 (_tmp102_);
				_g_object_unref0 (_tmp99_);
				_g_object_unref0 (_tmp96_);
				_g_object_unref0 (_tmp93_);
				_tmp103_ = thread;
				g_signal_emit (self, dm_manager_signals[DM_MANAGER_THREAD_CHANGED_SIGNAL], 0, _tmp103_);
			}
			_g_object_unref0 (thread);
		}
	}
	_tmp104_ = self->priv->account;
	_tmp105_ = _tmp104_->user_counter;
	_tmp106_ = sender_id;
	_tmp107_ = sender_screen_name;
	_tmp108_ = sender_name;
	cb_user_counter_user_seen (_tmp105_, _tmp106_, _tmp107_, _tmp108_);
	_tmp109_ = dm_obj;
	_tmp110_ = initial;
	dm_manager_save_message (self, _tmp109_, _tmp110_);
	_g_free0 (sender_name);
	_g_free0 (sender_screen_name);
	_g_free0 (text);
	_json_array_unref0 (urls);
	_g_free0 (source_text);
	block42_data_unref (_data42_);
	_data42_ = NULL;
}


static Block43Data* block43_data_ref (Block43Data* _data43_) {
	g_atomic_int_inc (&_data43_->_ref_count_);
	return _data43_;
}


static void block43_data_unref (void * _userdata_) {
	Block43Data* _data43_;
	_data43_ = (Block43Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data43_->_ref_count_)) {
		DMManager* self;
		self = _data43_->self;
		_data43_->url_list = (_vala_CbTextEntity_array_free (_data43_->url_list, _data43_->url_list_length1), NULL);
		_g_object_unref0 (self);
		g_slice_free (Block43Data, _data43_);
	}
}


static void ___lambda103_ (Block43Data* _data43_, JsonArray* arr, guint index, JsonNode* node) {
	DMManager* self;
	JsonObject* url = NULL;
	JsonNode* _tmp0_;
	JsonObject* _tmp1_;
	JsonObject* _tmp2_;
	gchar* expanded_url = NULL;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	JsonArray* indices = NULL;
	JsonArray* _tmp5_;
	JsonArray* _tmp6_;
	CbTextEntity* _tmp7_;
	gint _tmp7__length1;
	guint _tmp8_;
	gint64 _tmp9_;
	gint64 _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	CbTextEntity _tmp15_ = {0};
	CbTextEntity _tmp16_;
	self = _data43_->self;
	g_return_if_fail (arr != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = node;
	_tmp1_ = json_node_get_object (_tmp0_);
	_tmp2_ = _json_object_ref0 (_tmp1_);
	url = _tmp2_;
	_tmp3_ = json_object_get_string_member (url, "expanded_url");
	_tmp4_ = g_strdup (_tmp3_);
	expanded_url = _tmp4_;
	_tmp5_ = json_object_get_array_member (url, "indices");
	_tmp6_ = _json_array_ref0 (_tmp5_);
	indices = _tmp6_;
	_tmp7_ = _data43_->url_list;
	_tmp7__length1 = _data43_->url_list_length1;
	_tmp8_ = index;
	_tmp9_ = json_array_get_int_element (indices, (guint) 0);
	_tmp10_ = json_array_get_int_element (indices, (guint) 1);
	_tmp11_ = string_replace (expanded_url, "&", "&amp;");
	_tmp12_ = g_strdup (expanded_url);
	_tmp13_ = json_object_get_string_member (url, "display_url");
	_tmp14_ = g_strdup (_tmp13_);
	memset (&_tmp15_, 0, sizeof (CbTextEntity));
	_tmp15_.from = (guint) _tmp9_;
	_tmp15_.to = (guint) _tmp10_;
	_g_free0 (_tmp15_.target);
	_tmp15_.target = _tmp11_;
	_g_free0 (_tmp15_.tooltip_text);
	_tmp15_.tooltip_text = _tmp12_;
	_g_free0 (_tmp15_.display_text);
	_tmp15_.display_text = _tmp14_;
	cb_text_entity_free (&_tmp7_[_tmp8_]);
	_tmp7_[_tmp8_] = _tmp15_;
	_tmp16_ = _tmp7_[_tmp8_];
	_json_array_unref0 (indices);
	_g_free0 (expanded_url);
	_json_object_unref0 (url);
}


static void ____lambda103__json_array_foreach (JsonArray* array, guint index_, JsonNode* element_node, gpointer self) {
	___lambda103_ (self, array, index_, element_node);
}


static void dm_manager_save_message (DMManager* self, JsonObject* dm_obj, gboolean initial) {
	JsonObject* sender = NULL;
	JsonObject* _tmp0_;
	JsonObject* _tmp1_;
	JsonObject* _tmp2_;
	JsonObject* recipient = NULL;
	JsonObject* _tmp3_;
	JsonObject* _tmp4_;
	JsonObject* _tmp5_;
	gint64 sender_id = 0LL;
	JsonObject* _tmp6_;
	gint64 _tmp7_;
	gint64 dm_id = 0LL;
	JsonObject* _tmp8_;
	gint64 _tmp9_;
	gchar* text = NULL;
	JsonObject* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	JsonObject* _tmp13_;
	gboolean _tmp14_;
	Account* _tmp26_;
	SqlDatabase* _tmp27_;
	SqlInsertStatement* _tmp28_;
	SqlInsertStatement* _tmp29_;
	gint64 _tmp30_;
	SqlInsertStatement* _tmp31_;
	SqlInsertStatement* _tmp32_;
	gint64 _tmp33_;
	SqlInsertStatement* _tmp34_;
	SqlInsertStatement* _tmp35_;
	JsonObject* _tmp36_;
	gint64 _tmp37_;
	SqlInsertStatement* _tmp38_;
	SqlInsertStatement* _tmp39_;
	JsonObject* _tmp40_;
	const gchar* _tmp41_;
	SqlInsertStatement* _tmp42_;
	SqlInsertStatement* _tmp43_;
	JsonObject* _tmp44_;
	const gchar* _tmp45_;
	SqlInsertStatement* _tmp46_;
	SqlInsertStatement* _tmp47_;
	JsonObject* _tmp48_;
	const gchar* _tmp49_;
	SqlInsertStatement* _tmp50_;
	SqlInsertStatement* _tmp51_;
	JsonObject* _tmp52_;
	const gchar* _tmp53_;
	SqlInsertStatement* _tmp54_;
	SqlInsertStatement* _tmp55_;
	JsonObject* _tmp56_;
	const gchar* _tmp57_;
	GDateTime* _tmp58_;
	GDateTime* _tmp59_;
	gint64 _tmp60_;
	SqlInsertStatement* _tmp61_;
	SqlInsertStatement* _tmp62_;
	const gchar* _tmp63_;
	SqlInsertStatement* _tmp64_;
	SqlInsertStatement* _tmp65_;
	gboolean _tmp66_ = FALSE;
	gint64 _tmp67_;
	Account* _tmp68_;
	gint64 _tmp69_;
	g_return_if_fail (IS_DM_MANAGER (self));
	g_return_if_fail (dm_obj != NULL);
	_tmp0_ = dm_obj;
	_tmp1_ = json_object_get_object_member (_tmp0_, "sender");
	_tmp2_ = _json_object_ref0 (_tmp1_);
	sender = _tmp2_;
	_tmp3_ = dm_obj;
	_tmp4_ = json_object_get_object_member (_tmp3_, "recipient");
	_tmp5_ = _json_object_ref0 (_tmp4_);
	recipient = _tmp5_;
	_tmp6_ = dm_obj;
	_tmp7_ = json_object_get_int_member (_tmp6_, "sender_id");
	sender_id = _tmp7_;
	_tmp8_ = dm_obj;
	_tmp9_ = json_object_get_int_member (_tmp8_, "id");
	dm_id = _tmp9_;
	_tmp10_ = dm_obj;
	_tmp11_ = json_object_get_string_member (_tmp10_, "text");
	_tmp12_ = g_strdup (_tmp11_);
	text = _tmp12_;
	_tmp13_ = dm_obj;
	_tmp14_ = json_object_has_member (_tmp13_, "entities");
	if (_tmp14_) {
		Block43Data* _data43_;
		JsonArray* urls = NULL;
		JsonObject* _tmp15_;
		JsonObject* _tmp16_;
		JsonArray* _tmp17_;
		JsonArray* _tmp18_;
		JsonArray* _tmp19_;
		guint _tmp20_;
		CbTextEntity* _tmp21_;
		JsonArray* _tmp22_;
		const gchar* _tmp23_;
		CbTextEntity* _tmp24_;
		gint _tmp24__length1;
		gchar* _tmp25_;
		_data43_ = g_slice_new0 (Block43Data);
		_data43_->_ref_count_ = 1;
		_data43_->self = g_object_ref (self);
		_tmp15_ = dm_obj;
		_tmp16_ = json_object_get_object_member (_tmp15_, "entities");
		_tmp17_ = json_object_get_array_member (_tmp16_, "urls");
		_tmp18_ = _json_array_ref0 (_tmp17_);
		urls = _tmp18_;
		_tmp19_ = urls;
		_tmp20_ = json_array_get_length (_tmp19_);
		_tmp21_ = g_new0 (CbTextEntity, _tmp20_);
		_data43_->url_list = _tmp21_;
		_data43_->url_list_length1 = _tmp20_;
		_data43_->_url_list_size_ = _data43_->url_list_length1;
		_tmp22_ = urls;
		json_array_foreach_element (_tmp22_, ____lambda103__json_array_foreach, _data43_);
		_tmp23_ = text;
		_tmp24_ = _data43_->url_list;
		_tmp24__length1 = _data43_->url_list_length1;
		_tmp25_ = cb_text_transform_text (_tmp23_, _tmp24_, _tmp24__length1, (guint) 0, (gsize) 0, (gint64) 0, (guint) 0);
		_g_free0 (text);
		text = _tmp25_;
		_json_array_unref0 (urls);
		block43_data_unref (_data43_);
		_data43_ = NULL;
	}
	_tmp26_ = self->priv->account;
	_tmp27_ = _tmp26_->db;
	_tmp28_ = sql_database_insert (_tmp27_, "dms");
	_tmp29_ = _tmp28_;
	_tmp30_ = dm_id;
	_tmp31_ = sql_insert_statement_vali64 (_tmp29_, "id", _tmp30_);
	_tmp32_ = _tmp31_;
	_tmp33_ = sender_id;
	_tmp34_ = sql_insert_statement_vali64 (_tmp32_, "from_id", _tmp33_);
	_tmp35_ = _tmp34_;
	_tmp36_ = dm_obj;
	_tmp37_ = json_object_get_int_member (_tmp36_, "recipient_id");
	_tmp38_ = sql_insert_statement_vali64 (_tmp35_, "to_id", _tmp37_);
	_tmp39_ = _tmp38_;
	_tmp40_ = dm_obj;
	_tmp41_ = json_object_get_string_member (_tmp40_, "sender_screen_name");
	_tmp42_ = sql_insert_statement_val (_tmp39_, "from_screen_name", _tmp41_);
	_tmp43_ = _tmp42_;
	_tmp44_ = dm_obj;
	_tmp45_ = json_object_get_string_member (_tmp44_, "recipient_screen_name");
	_tmp46_ = sql_insert_statement_val (_tmp43_, "to_screen_name", _tmp45_);
	_tmp47_ = _tmp46_;
	_tmp48_ = sender;
	_tmp49_ = json_object_get_string_member (_tmp48_, "name");
	_tmp50_ = sql_insert_statement_val (_tmp47_, "from_name", _tmp49_);
	_tmp51_ = _tmp50_;
	_tmp52_ = recipient;
	_tmp53_ = json_object_get_string_member (_tmp52_, "name");
	_tmp54_ = sql_insert_statement_val (_tmp51_, "to_name", _tmp53_);
	_tmp55_ = _tmp54_;
	_tmp56_ = dm_obj;
	_tmp57_ = json_object_get_string_member (_tmp56_, "created_at");
	_tmp58_ = cb_utils_parse_date (_tmp57_);
	_tmp59_ = _tmp58_;
	_tmp60_ = g_date_time_to_unix (_tmp59_);
	_tmp61_ = sql_insert_statement_vali64 (_tmp55_, "timestamp", _tmp60_);
	_tmp62_ = _tmp61_;
	_tmp63_ = text;
	_tmp64_ = sql_insert_statement_val (_tmp62_, "text", _tmp63_);
	_tmp65_ = _tmp64_;
	sql_insert_statement_run (_tmp65_);
	_g_object_unref0 (_tmp65_);
	_g_object_unref0 (_tmp62_);
	_g_date_time_unref0 (_tmp59_);
	_g_object_unref0 (_tmp55_);
	_g_object_unref0 (_tmp51_);
	_g_object_unref0 (_tmp47_);
	_g_object_unref0 (_tmp43_);
	_g_object_unref0 (_tmp39_);
	_g_object_unref0 (_tmp35_);
	_g_object_unref0 (_tmp32_);
	_g_object_unref0 (_tmp29_);
	_tmp67_ = sender_id;
	_tmp68_ = self->priv->account;
	_tmp69_ = _tmp68_->id;
	if (_tmp67_ != _tmp69_) {
		DMThreadsModel* _tmp70_;
		gint64 _tmp71_;
		gboolean _tmp72_;
		_tmp70_ = self->priv->threads_model;
		_tmp71_ = sender_id;
		_tmp72_ = dm_threads_model_has_thread (_tmp70_, _tmp71_);
		_tmp66_ = _tmp72_;
	} else {
		_tmp66_ = FALSE;
	}
	if (_tmp66_) {
		DMThread* thread = NULL;
		DMThreadsModel* _tmp73_;
		gint64 _tmp74_;
		DMThread* _tmp75_;
		DMThreadsModel* _tmp76_;
		gint64 _tmp77_;
		DMThread* _tmp78_;
		const gchar* _tmp79_;
		gboolean _tmp80_;
		DMThread* _tmp81_;
		_tmp73_ = self->priv->threads_model;
		_tmp74_ = sender_id;
		_tmp75_ = dm_threads_model_get_thread (_tmp73_, _tmp74_);
		thread = _tmp75_;
		_tmp76_ = self->priv->threads_model;
		_tmp77_ = sender_id;
		dm_threads_model_increase_unread_count (_tmp76_, _tmp77_, 1);
		_tmp78_ = thread;
		_tmp79_ = text;
		_tmp80_ = initial;
		g_signal_emit (self, dm_manager_signals[DM_MANAGER_MESSAGE_RECEIVED_SIGNAL], 0, _tmp78_, _tmp79_, _tmp80_);
		_tmp81_ = thread;
		g_signal_emit (self, dm_manager_signals[DM_MANAGER_THREAD_CHANGED_SIGNAL], 0, _tmp81_);
		_g_object_unref0 (thread);
	}
	_g_free0 (text);
	_json_object_unref0 (recipient);
	_json_object_unref0 (sender);
}


DMManager* dm_manager_construct (GType object_type) {
	DMManager * self = NULL;
	self = (DMManager*) g_object_new (object_type, NULL);
	return self;
}


DMManager* dm_manager_new (void) {
	return dm_manager_construct (TYPE_DM_MANAGER);
}


gboolean dm_manager_get_empty (DMManager* self) {
	gboolean result;
	DMThreadsModel* _tmp0_;
	guint _tmp1_;
	g_return_val_if_fail (IS_DM_MANAGER (self), FALSE);
	_tmp0_ = self->priv->threads_model;
	_tmp1_ = g_list_model_get_n_items (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, g_list_model_get_type (), GListModel));
	result = _tmp1_ == ((guint) 0);
	return result;
}


static void g_cclosure_user_marshal_VOID__OBJECT_STRING_BOOLEAN (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__OBJECT_STRING_BOOLEAN) (gpointer data1, gpointer arg_1, const char* arg_2, gboolean arg_3, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_STRING_BOOLEAN callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_STRING_BOOLEAN) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_string (param_values + 2), g_value_get_boolean (param_values + 3), data2);
}


static void dm_manager_class_init (DMManagerClass * klass) {
	dm_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DMManagerPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_dm_manager_get_property;
	G_OBJECT_CLASS (klass)->finalize = dm_manager_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DM_MANAGER_EMPTY, g_param_spec_boolean ("empty", "empty", "empty", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	dm_manager_signals[DM_MANAGER_MESSAGE_RECEIVED_SIGNAL] = g_signal_new ("message_received", TYPE_DM_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_STRING_BOOLEAN, G_TYPE_NONE, 3, TYPE_DM_THREAD, G_TYPE_STRING, G_TYPE_BOOLEAN);
	dm_manager_signals[DM_MANAGER_THREAD_CHANGED_SIGNAL] = g_signal_new ("thread_changed", TYPE_DM_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, TYPE_DM_THREAD);
}


static void dm_manager_instance_init (DMManager * self) {
	self->priv = DM_MANAGER_GET_PRIVATE (self);
}


static void dm_manager_finalize (GObject * obj) {
	DMManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DM_MANAGER, DMManager);
	_g_object_unref0 (self->priv->threads_model);
	G_OBJECT_CLASS (dm_manager_parent_class)->finalize (obj);
}


GType dm_manager_get_type (void) {
	static volatile gsize dm_manager_type_id__volatile = 0;
	if (g_once_init_enter (&dm_manager_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DMManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dm_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DMManager), 0, (GInstanceInitFunc) dm_manager_instance_init, NULL };
		GType dm_manager_type_id;
		dm_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "DMManager", &g_define_type_info, 0);
		g_once_init_leave (&dm_manager_type_id__volatile, dm_manager_type_id);
	}
	return dm_manager_type_id__volatile;
}


static void _vala_dm_manager_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DMManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_DM_MANAGER, DMManager);
	switch (property_id) {
		case DM_MANAGER_EMPTY:
		g_value_set_boolean (value, dm_manager_get_empty (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



