/* MediaVideoWidget.c generated by valac 0.34.6, the Vala compiler
 * generated from MediaVideoWidget.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gst/gst.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include "CbMedia.h"
#include <cairo.h>
#include <float.h>
#include <math.h>
#include <libsoup/soup.h>


#define TYPE_MEDIA_VIDEO_WIDGET (media_video_widget_get_type ())
#define MEDIA_VIDEO_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_VIDEO_WIDGET, MediaVideoWidget))
#define MEDIA_VIDEO_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_VIDEO_WIDGET, MediaVideoWidgetClass))
#define IS_MEDIA_VIDEO_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_VIDEO_WIDGET))
#define IS_MEDIA_VIDEO_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_VIDEO_WIDGET))
#define MEDIA_VIDEO_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_VIDEO_WIDGET, MediaVideoWidgetClass))

typedef struct _MediaVideoWidget MediaVideoWidget;
typedef struct _MediaVideoWidgetClass MediaVideoWidgetClass;
typedef struct _MediaVideoWidgetPrivate MediaVideoWidgetPrivate;

#define TYPE_SURFACE_PROGRESS (surface_progress_get_type ())
#define SURFACE_PROGRESS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SURFACE_PROGRESS, SurfaceProgress))
#define SURFACE_PROGRESS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SURFACE_PROGRESS, SurfaceProgressClass))
#define IS_SURFACE_PROGRESS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SURFACE_PROGRESS))
#define IS_SURFACE_PROGRESS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SURFACE_PROGRESS))
#define SURFACE_PROGRESS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SURFACE_PROGRESS, SurfaceProgressClass))

typedef struct _SurfaceProgress SurfaceProgress;
typedef struct _SurfaceProgressClass SurfaceProgressClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block50Data Block50Data;
#define _g_match_info_unref0(var) ((var == NULL) ? NULL : (var = (g_match_info_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
typedef struct _MediaVideoWidgetFetchRealUrlData MediaVideoWidgetFetchRealUrlData;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _MediaVideoWidget {
	GtkStack parent_instance;
	MediaVideoWidgetPrivate * priv;
};

struct _MediaVideoWidgetClass {
	GtkStackClass parent_class;
};

struct _MediaVideoWidgetPrivate {
	GstElement* src;
	GstElement* sink;
	GtkWidget* area;
	GCancellable* cancellable;
	GtkLabel* error_label;
	GtkProgressBar* video_progress;
	guint video_progress_id;
	SurfaceProgress* surface_progress;
	gchar* media_url;
};

struct _Block50Data {
	int _ref_count_;
	MediaVideoWidget* self;
	SoupMessage* msg;
	gchar* regex_str;
	gpointer _async_data_;
};

struct _MediaVideoWidgetFetchRealUrlData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	MediaVideoWidget* self;
	gchar* first_url;
	gchar* regex_str;
	Block50Data* _data50_;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	SoupMessage* _tmp2_;
	GCancellable* _tmp3_;
	SoupSession* _tmp4_;
	SoupMessage* _tmp5_;
};


static gpointer media_video_widget_parent_class = NULL;
extern SoupSession* SOUP_SESSION;

GType media_video_widget_get_type (void) G_GNUC_CONST;
GType surface_progress_get_type (void) G_GNUC_CONST;
#define MEDIA_VIDEO_WIDGET_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_MEDIA_VIDEO_WIDGET, MediaVideoWidgetPrivate))
enum  {
	MEDIA_VIDEO_WIDGET_DUMMY_PROPERTY
};
MediaVideoWidget* media_video_widget_new (CbMedia* media);
MediaVideoWidget* media_video_widget_construct (GType object_type, CbMedia* media);
static void media_video_widget_fetch_real_url (MediaVideoWidget* self, const gchar* first_url, const gchar* regex_str, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void media_video_widget_fetch_real_url_finish (MediaVideoWidget* self, GAsyncResult* _res_);
SurfaceProgress* surface_progress_new (void);
SurfaceProgress* surface_progress_construct (GType object_type);
void surface_progress_set_surface (SurfaceProgress* self, cairo_surface_t* value);
static gboolean media_video_widget_progress_timeout_cb (MediaVideoWidget* self);
static void media_video_widget_start_progress_timeout (MediaVideoWidget* self);
static gboolean _media_video_widget_progress_timeout_cb_gsource_func (gpointer self);
static void media_video_widget_start_video (MediaVideoWidget* self);
void media_video_widget_init (MediaVideoWidget* self);
static void media_video_widget_show_error (MediaVideoWidget* self, const gchar* error_message);
static gboolean media_video_widget_watch_cb (MediaVideoWidget* self, GstBus* bus, GstMessage* msg);
static gboolean _media_video_widget_watch_cb_gst_bus_func (GstBus* bus, GstMessage* message, gpointer self);
static gboolean media_video_widget_real_button_press_event (GtkWidget* base, GdkEventButton* evt);
static void media_video_widget_stop (MediaVideoWidget* self);
static gboolean media_video_widget_real_key_press_event (GtkWidget* base, GdkEventKey* evt);
static void media_video_widget_real_destroy (GtkWidget* base);
gdouble surface_progress_get_progress (SurfaceProgress* self);
void surface_progress_set_progress (SurfaceProgress* self, gdouble value);
static void media_video_widget_fetch_real_url_data_free (gpointer _data);
static gboolean media_video_widget_fetch_real_url_co (MediaVideoWidgetFetchRealUrlData* _data_);
static Block50Data* block50_data_ref (Block50Data* _data50_);
static void block50_data_unref (void * _userdata_);
static void __lambda60_ (Block50Data* _data50_);
static void ___lambda60__g_cancellable_cancelled (GCancellable* _sender, gpointer self);
static void __lambda61_ (Block50Data* _data50_, SoupSession* s, SoupMessage* _msg);
static void ___lambda61__soup_session_callback (SoupSession* session, SoupMessage* msg, gpointer self);
static void media_video_widget_finalize (GObject* obj);


static gpointer _cairo_surface_reference0 (gpointer self) {
	return self ? cairo_surface_reference (self) : NULL;
}


MediaVideoWidget* media_video_widget_construct (GType object_type, CbMedia* media) {
	MediaVideoWidget * self = NULL;
	GCancellable* _tmp0_ = NULL;
	CbMedia* _tmp1_ = NULL;
	cairo_surface_t* _tmp2_ = NULL;
	cairo_surface_t* image_surface = NULL;
	CbMedia* _tmp3_ = NULL;
	cairo_surface_t* _tmp4_ = NULL;
	cairo_surface_t* _tmp5_ = NULL;
	GtkProgressBar* _tmp6_ = NULL;
	gint h = 0;
	GtkProgressBar* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	cairo_surface_t* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	cairo_surface_t* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
	CbMedia* _tmp14_ = NULL;
	CbMediaType _tmp15_ = 0;
	CbMedia* _tmp16_ = NULL;
	CbMediaType _tmp17_ = 0;
	GtkLabel* _tmp25_ = NULL;
	GtkLabel* _tmp26_ = NULL;
	GtkLabel* _tmp27_ = NULL;
	GtkLabel* _tmp28_ = NULL;
	SurfaceProgress* _tmp29_ = NULL;
	SurfaceProgress* _tmp30_ = NULL;
	CbMedia* _tmp31_ = NULL;
	cairo_surface_t* _tmp32_ = NULL;
	SurfaceProgress* _tmp33_ = NULL;
	SurfaceProgress* _tmp34_ = NULL;
	GtkLabel* _tmp35_ = NULL;
	SurfaceProgress* _tmp36_ = NULL;
	g_return_val_if_fail (CB_IS_MEDIA (media), NULL);
	self = (MediaVideoWidget*) g_object_new (object_type, NULL);
	_tmp0_ = g_cancellable_new ();
	_g_object_unref0 (self->priv->cancellable);
	self->priv->cancellable = _tmp0_;
	_tmp1_ = media;
	_tmp2_ = _tmp1_->surface;
	_vala_assert (_tmp2_ != NULL, "media.surface != null");
	_tmp3_ = media;
	_tmp4_ = _tmp3_->surface;
	_tmp5_ = _cairo_surface_reference0 ((cairo_surface_t*) _tmp4_);
	image_surface = _tmp5_;
	_tmp6_ = self->priv->video_progress;
	gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_widget_get_type (), GtkWidget));
	_tmp7_ = self->priv->video_progress;
	gtk_widget_get_preferred_height (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_widget_get_type (), GtkWidget), &_tmp8_, NULL);
	h = _tmp8_;
	_tmp9_ = image_surface;
	_tmp10_ = cairo_image_surface_get_width (_tmp9_);
	_tmp11_ = image_surface;
	_tmp12_ = cairo_image_surface_get_height (_tmp11_);
	_tmp13_ = h;
	gtk_widget_set_size_request (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), _tmp10_, _tmp12_ + _tmp13_);
	_tmp14_ = media;
	_tmp15_ = _tmp14_->type;
	g_debug ("MediaVideoWidget.vala:42: Media type: %d", (gint) _tmp15_);
	_tmp16_ = media;
	_tmp17_ = _tmp16_->type;
	switch (_tmp17_) {
		case CB_MEDIA_TYPE_TWITTER_VIDEO:
		case CB_MEDIA_TYPE_INSTAGRAM_VIDEO:
		{
			CbMedia* _tmp18_ = NULL;
			const gchar* _tmp19_ = NULL;
			gchar* _tmp20_ = NULL;
			_tmp18_ = media;
			_tmp19_ = _tmp18_->url;
			_tmp20_ = g_strdup (_tmp19_);
			_g_free0 (self->priv->media_url);
			self->priv->media_url = _tmp20_;
			break;
		}
		case CB_MEDIA_TYPE_VINE:
		{
			CbMedia* _tmp21_ = NULL;
			const gchar* _tmp22_ = NULL;
			_tmp21_ = media;
			_tmp22_ = _tmp21_->url;
			media_video_widget_fetch_real_url (self, _tmp22_, "<meta property=\"twitter:player:stream\" content=\"(.*?)\"", NULL, NULL);
			break;
		}
		case CB_MEDIA_TYPE_ANIMATED_GIF:
		{
			CbMedia* _tmp23_ = NULL;
			const gchar* _tmp24_ = NULL;
			_tmp23_ = media;
			_tmp24_ = _tmp23_->url;
			media_video_widget_fetch_real_url (self, _tmp24_, "<source video-src=\"(.*?)\" type=\"video/mp4\"", NULL, NULL);
			break;
		}
		default:
		{
			g_warn_if_reached ();
			break;
		}
	}
	_tmp25_ = self->priv->error_label;
	g_object_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, gtk_widget_get_type (), GtkWidget), "margin", 20, NULL);
	_tmp26_ = self->priv->error_label;
	g_object_set (_tmp26_, "wrap", TRUE, NULL);
	_tmp27_ = self->priv->error_label;
	gtk_label_set_selectable (_tmp27_, TRUE);
	_tmp28_ = self->priv->error_label;
	gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, gtk_widget_get_type (), GtkWidget));
	_tmp29_ = surface_progress_new ();
	g_object_ref_sink (_tmp29_);
	_g_object_unref0 (self->priv->surface_progress);
	self->priv->surface_progress = _tmp29_;
	_tmp30_ = self->priv->surface_progress;
	_tmp31_ = media;
	_tmp32_ = _tmp31_->surface;
	surface_progress_set_surface (_tmp30_, _tmp32_);
	_tmp33_ = self->priv->surface_progress;
	gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp33_, gtk_widget_get_type (), GtkWidget));
	_tmp34_ = self->priv->surface_progress;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, gtk_widget_get_type (), GtkWidget));
	_tmp35_ = self->priv->error_label;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp35_, gtk_widget_get_type (), GtkWidget));
	_tmp36_ = self->priv->surface_progress;
	gtk_stack_set_visible_child (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_stack_get_type (), GtkStack), G_TYPE_CHECK_INSTANCE_CAST (_tmp36_, gtk_widget_get_type (), GtkWidget));
	_cairo_surface_destroy0 (image_surface);
	return self;
}


MediaVideoWidget* media_video_widget_new (CbMedia* media) {
	return media_video_widget_construct (TYPE_MEDIA_VIDEO_WIDGET, media);
}


static gboolean media_video_widget_progress_timeout_cb (MediaVideoWidget* self) {
	gboolean result = FALSE;
	gint64 duration_ns = 0LL;
	gint64 position_ns = 0LL;
	GstElement* _tmp0_ = NULL;
	gint64 _tmp1_ = 0LL;
	gint64 _tmp2_ = 0LL;
	g_return_val_if_fail (IS_MEDIA_VIDEO_WIDGET (self), FALSE);
	_tmp0_ = self->priv->src;
	gst_element_query_duration (_tmp0_, GST_FORMAT_TIME, &_tmp1_);
	duration_ns = _tmp1_;
	_tmp2_ = duration_ns;
	if (_tmp2_ > ((gint64) 0)) {
		GstElement* _tmp3_ = NULL;
		gint64 _tmp4_ = 0LL;
		gdouble fraction = 0.0;
		gint64 _tmp5_ = 0LL;
		gint64 _tmp6_ = 0LL;
		GtkProgressBar* _tmp7_ = NULL;
		gdouble _tmp8_ = 0.0;
		_tmp3_ = self->priv->src;
		gst_element_query_position (_tmp3_, GST_FORMAT_TIME, &_tmp4_);
		position_ns = _tmp4_;
		_tmp5_ = position_ns;
		_tmp6_ = duration_ns;
		fraction = ((gdouble) _tmp5_) / ((gdouble) _tmp6_);
		_tmp7_ = self->priv->video_progress;
		_tmp8_ = fraction;
		gtk_progress_bar_set_fraction (_tmp7_, _tmp8_);
	}
	result = G_SOURCE_CONTINUE;
	return result;
}


static gboolean _media_video_widget_progress_timeout_cb_gsource_func (gpointer self) {
	gboolean result;
	result = media_video_widget_progress_timeout_cb ((MediaVideoWidget*) self);
	return result;
}


static void media_video_widget_start_progress_timeout (MediaVideoWidget* self) {
	guint _tmp0_ = 0U;
	g_return_if_fail (IS_MEDIA_VIDEO_WIDGET (self));
	_tmp0_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 100, _media_video_widget_progress_timeout_cb_gsource_func, g_object_ref (self), g_object_unref);
	self->priv->video_progress_id = _tmp0_;
}


static void media_video_widget_start_video (MediaVideoWidget* self) {
	const gchar* _tmp0_ = NULL;
	GstElement* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GstElement* _tmp3_ = NULL;
	g_return_if_fail (IS_MEDIA_VIDEO_WIDGET (self));
	_tmp0_ = self->priv->media_url;
	_vala_assert (_tmp0_ != NULL, "this.media_url != null");
	_tmp1_ = self->priv->src;
	_tmp2_ = self->priv->media_url;
	g_object_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, G_TYPE_OBJECT, GObject), "uri", _tmp2_, NULL);
	_tmp3_ = self->priv->src;
	gst_element_set_state (_tmp3_, GST_STATE_PAUSED);
}


static gboolean _media_video_widget_watch_cb_gst_bus_func (GstBus* bus, GstMessage* message, gpointer self) {
	gboolean result;
	result = media_video_widget_watch_cb ((MediaVideoWidget*) self, bus, message);
	return result;
}


void media_video_widget_init (MediaVideoWidget* self) {
	GtkBox* box = NULL;
	GtkBox* _tmp0_ = NULL;
	GstElement* _tmp1_ = NULL;
	GstElement* _tmp2_ = NULL;
	GstElement* _tmp3_ = NULL;
	GstElement* _tmp4_ = NULL;
	GtkWidget* _tmp5_ = NULL;
	GtkWidget* _tmp6_ = NULL;
	GtkWidget* _tmp7_ = NULL;
	GtkWidget* _tmp8_ = NULL;
	GstBus* bus = NULL;
	GstElement* _tmp9_ = NULL;
	GstBus* _tmp10_ = NULL;
	GstBus* _tmp11_ = NULL;
	GstElement* _tmp12_ = NULL;
	GstElement* _tmp13_ = NULL;
	GstElement* _tmp14_ = NULL;
	guint flags = 0U;
	GstElement* _tmp15_ = NULL;
	GstElement* _tmp16_ = NULL;
	guint _tmp17_ = 0U;
	GtkBox* _tmp18_ = NULL;
	GtkWidget* _tmp19_ = NULL;
	GtkProgressBar* _tmp20_ = NULL;
	GtkStyleContext* _tmp21_ = NULL;
	GtkBox* _tmp22_ = NULL;
	GtkProgressBar* _tmp23_ = NULL;
	GtkBox* _tmp24_ = NULL;
	const gchar* _tmp25_ = NULL;
	g_return_if_fail (IS_MEDIA_VIDEO_WIDGET (self));
	_tmp0_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp0_);
	box = _tmp0_;
	_tmp1_ = gst_element_factory_make ("playbin", "video");
	if (_tmp1_ != NULL) {
		g_object_ref_sink (_tmp1_);
	}
	_g_object_unref0 (self->priv->src);
	self->priv->src = _tmp1_;
	_tmp2_ = gst_element_factory_make ("gtksink", "gtksink");
	if (_tmp2_ != NULL) {
		g_object_ref_sink (_tmp2_);
	}
	_g_object_unref0 (self->priv->sink);
	self->priv->sink = _tmp2_;
	_tmp3_ = self->priv->sink;
	if (_tmp3_ == NULL) {
		media_video_widget_show_error (self, "Could not create a gtksink. Need gst-plugins-bad >= 1.6");
		g_critical ("MediaVideoWidget.vala:117: Could not create a gtksink. Need gst-plugin" \
"s-bad >= 1.6");
		_g_object_unref0 (box);
		return;
	}
	_tmp4_ = self->priv->sink;
	g_object_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, G_TYPE_OBJECT, GObject), "widget", &self->priv->area, NULL);
	_tmp5_ = self->priv->area;
	_vala_assert (_tmp5_ != NULL, "this.area != null");
	_tmp6_ = self->priv->area;
	_vala_assert (G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, gtk_drawing_area_get_type ()), "this.area is Gtk.DrawingArea");
	_tmp7_ = self->priv->area;
	gtk_widget_set_hexpand (_tmp7_, TRUE);
	_tmp8_ = self->priv->area;
	gtk_widget_set_vexpand (_tmp8_, TRUE);
	_tmp9_ = self->priv->src;
	_tmp10_ = gst_element_get_bus (_tmp9_);
	bus = _tmp10_;
	_tmp11_ = bus;
	gst_bus_add_watch_full (_tmp11_, G_PRIORITY_DEFAULT, _media_video_widget_watch_cb_gst_bus_func, g_object_ref (self), g_object_unref);
	_tmp12_ = self->priv->src;
	_tmp13_ = self->priv->sink;
	g_object_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, G_TYPE_OBJECT, GObject), "video-sink", _tmp13_, NULL);
	_tmp14_ = self->priv->src;
	g_object_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, G_TYPE_OBJECT, GObject), "ring-buffer-max-size", (10 * 1024) * 1024, NULL);
	_tmp15_ = self->priv->src;
	g_object_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, G_TYPE_OBJECT, GObject), "flags", &flags, NULL);
	_tmp16_ = self->priv->src;
	_tmp17_ = flags;
	g_object_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, G_TYPE_OBJECT, GObject), "flags", _tmp17_ | (1 << 7), NULL);
	_tmp18_ = box;
	_tmp19_ = self->priv->area;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, gtk_container_get_type (), GtkContainer), _tmp19_);
	_tmp20_ = self->priv->video_progress;
	_tmp21_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, gtk_widget_get_type (), GtkWidget));
	gtk_style_context_add_class (_tmp21_, "embedded-progress");
	_tmp22_ = box;
	_tmp23_ = self->priv->video_progress;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, gtk_widget_get_type (), GtkWidget));
	_tmp24_ = box;
	gtk_stack_add_named (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_stack_get_type (), GtkStack), G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, gtk_widget_get_type (), GtkWidget), "video");
	_tmp25_ = self->priv->media_url;
	if (_tmp25_ != NULL) {
		media_video_widget_start_video (self);
	}
	_g_object_unref0 (bus);
	_g_object_unref0 (box);
}


static void media_video_widget_show_error (MediaVideoWidget* self, const gchar* error_message) {
	GtkLabel* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GtkLabel* _tmp2_ = NULL;
	g_return_if_fail (IS_MEDIA_VIDEO_WIDGET (self));
	g_return_if_fail (error_message != NULL);
	_tmp0_ = self->priv->error_label;
	_tmp1_ = error_message;
	gtk_label_set_label (_tmp0_, _tmp1_);
	_tmp2_ = self->priv->error_label;
	gtk_stack_set_visible_child (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_stack_get_type (), GtkStack), G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_widget_get_type (), GtkWidget));
}


static gboolean media_video_widget_real_button_press_event (GtkWidget* base, GdkEventButton* evt) {
	MediaVideoWidget * self;
	gboolean result = FALSE;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_MEDIA_VIDEO_WIDGET, MediaVideoWidget);
	g_return_val_if_fail (evt != NULL, FALSE);
	media_video_widget_stop (self);
	result = GDK_EVENT_PROPAGATE;
	return result;
}


static gboolean media_video_widget_real_key_press_event (GtkWidget* base, GdkEventKey* evt) {
	MediaVideoWidget * self;
	gboolean result = FALSE;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_MEDIA_VIDEO_WIDGET, MediaVideoWidget);
	g_return_val_if_fail (evt != NULL, FALSE);
	media_video_widget_stop (self);
	result = GDK_EVENT_STOP;
	return result;
}


static void media_video_widget_stop (MediaVideoWidget* self) {
	GCancellable* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	GstElement* _tmp3_ = NULL;
	g_return_if_fail (IS_MEDIA_VIDEO_WIDGET (self));
	_tmp0_ = self->priv->cancellable;
	g_cancellable_cancel (_tmp0_);
	_tmp1_ = self->priv->video_progress_id;
	if (_tmp1_ != ((guint) 0)) {
		guint _tmp2_ = 0U;
		_tmp2_ = self->priv->video_progress_id;
		g_source_remove (_tmp2_);
		self->priv->video_progress_id = (guint) 0;
	}
	_tmp3_ = self->priv->src;
	gst_element_set_state (_tmp3_, GST_STATE_NULL);
}


static void media_video_widget_real_destroy (GtkWidget* base) {
	MediaVideoWidget * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_MEDIA_VIDEO_WIDGET, MediaVideoWidget);
	media_video_widget_stop (self);
	GTK_WIDGET_CLASS (media_video_widget_parent_class)->destroy (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_stack_get_type (), GtkStack), gtk_widget_get_type (), GtkWidget));
}


static gboolean media_video_widget_watch_cb (MediaVideoWidget* self, GstBus* bus, GstMessage* msg) {
	gboolean result = FALSE;
	GstMessage* _tmp0_ = NULL;
	GstMessageType _tmp1_ = 0;
	g_return_val_if_fail (IS_MEDIA_VIDEO_WIDGET (self), FALSE);
	g_return_val_if_fail (GST_IS_BUS (bus), FALSE);
	g_return_val_if_fail (msg != NULL, FALSE);
	_tmp0_ = msg;
	_tmp1_ = _tmp0_->type;
	switch (_tmp1_) {
		case GST_MESSAGE_BUFFERING:
		{
			gint percent = 0;
			GstMessage* _tmp2_ = NULL;
			gint _tmp3_ = 0;
			gint _tmp4_ = 0;
			SurfaceProgress* _tmp5_ = NULL;
			gint _tmp6_ = 0;
			SurfaceProgress* _tmp7_ = NULL;
			gdouble _tmp8_ = 0.0;
			gdouble _tmp9_ = 0.0;
			gdouble _tmp10_ = 0.0;
			_tmp2_ = msg;
			gst_message_parse_buffering (_tmp2_, &_tmp3_);
			percent = _tmp3_;
			_tmp4_ = percent;
			g_debug ("MediaVideoWidget.vala:189: Buffering: %d%%", _tmp4_);
			_tmp5_ = self->priv->surface_progress;
			_tmp6_ = percent;
			_tmp7_ = self->priv->surface_progress;
			_tmp8_ = surface_progress_get_progress (_tmp7_);
			_tmp9_ = _tmp8_;
			_tmp10_ = MAX (_tmp6_ / 100.0, _tmp9_);
			surface_progress_set_progress (_tmp5_, _tmp10_);
			break;
		}
		case GST_MESSAGE_EOS:
		{
			GstElement* _tmp11_ = NULL;
			_tmp11_ = self->priv->src;
			gst_element_seek (_tmp11_, 1.0, GST_FORMAT_TIME, GST_SEEK_FLAG_FLUSH, GST_SEEK_TYPE_SET, (gint64) 0, GST_SEEK_TYPE_NONE, (gint64) GST_CLOCK_TIME_NONE);
			break;
		}
		case GST_MESSAGE_ASYNC_DONE:
		{
			GstElement* _tmp12_ = NULL;
			g_debug ("MediaVideoWidget.vala:200: ASYNC DONE");
			gtk_stack_set_visible_child_name (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_stack_get_type (), GtkStack), "video");
			media_video_widget_start_progress_timeout (self);
			_tmp12_ = self->priv->src;
			gst_element_set_state (_tmp12_, GST_STATE_PLAYING);
			break;
		}
		case GST_MESSAGE_ERROR:
		{
			GError* _error_ = NULL;
			gchar* debug = NULL;
			GstMessage* _tmp13_ = NULL;
			GError* _tmp14_ = NULL;
			gchar* _tmp15_ = NULL;
			const gchar* _tmp16_ = NULL;
			GError* _tmp17_ = NULL;
			const gchar* _tmp18_ = NULL;
			const gchar* _tmp19_ = NULL;
			_tmp13_ = msg;
			gst_message_parse_error (_tmp13_, &_tmp14_, &_tmp15_);
			_g_error_free0 (_error_);
			_error_ = _tmp14_;
			_g_free0 (debug);
			debug = _tmp15_;
			_tmp16_ = debug;
			media_video_widget_show_error (self, _tmp16_);
			_tmp17_ = _error_;
			_tmp18_ = _tmp17_->message;
			_tmp19_ = debug;
			g_critical ("MediaVideoWidget.vala:211: %s: %s", _tmp18_, _tmp19_);
			_g_free0 (debug);
			_g_error_free0 (_error_);
			break;
		}
		default:
		break;
	}
	result = TRUE;
	return result;
}


static void media_video_widget_fetch_real_url_data_free (gpointer _data) {
	MediaVideoWidgetFetchRealUrlData* _data_;
	_data_ = _data;
	_g_free0 (_data_->first_url);
	_g_object_unref0 (_data_->self);
	g_slice_free (MediaVideoWidgetFetchRealUrlData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void media_video_widget_fetch_real_url (MediaVideoWidget* self, const gchar* first_url, const gchar* regex_str, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	MediaVideoWidgetFetchRealUrlData* _data_;
	MediaVideoWidget* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	_data_ = g_slice_new0 (MediaVideoWidgetFetchRealUrlData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, media_video_widget_fetch_real_url);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, media_video_widget_fetch_real_url_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = first_url;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (_data_->first_url);
	_data_->first_url = _tmp2_;
	_tmp3_ = regex_str;
	_tmp4_ = g_strdup (_tmp3_);
	_g_free0 (_data_->regex_str);
	_data_->regex_str = _tmp4_;
	media_video_widget_fetch_real_url_co (_data_);
}


static void media_video_widget_fetch_real_url_finish (MediaVideoWidget* self, GAsyncResult* _res_) {
	MediaVideoWidgetFetchRealUrlData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static Block50Data* block50_data_ref (Block50Data* _data50_) {
	g_atomic_int_inc (&_data50_->_ref_count_);
	return _data50_;
}


static void block50_data_unref (void * _userdata_) {
	Block50Data* _data50_;
	_data50_ = (Block50Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data50_->_ref_count_)) {
		MediaVideoWidget* self;
		self = _data50_->self;
		_g_object_unref0 (_data50_->msg);
		_g_free0 (_data50_->regex_str);
		_g_object_unref0 (self);
		g_slice_free (Block50Data, _data50_);
	}
}


static void __lambda60_ (Block50Data* _data50_) {
	MediaVideoWidget* self;
	SoupSession* _tmp0_ = NULL;
	self = _data50_->self;
	_tmp0_ = SOUP_SESSION;
	soup_session_cancel_message (_tmp0_, _data50_->msg, (guint) SOUP_STATUS_CANCELLED);
}


static void ___lambda60__g_cancellable_cancelled (GCancellable* _sender, gpointer self) {
	__lambda60_ (self);
}


static void __lambda61_ (Block50Data* _data50_, SoupSession* s, SoupMessage* _msg) {
	MediaVideoWidget* self;
	SoupMessage* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	guint _tmp2_ = 0U;
	const gchar* back = NULL;
	SoupMessage* _tmp18_ = NULL;
	SoupMessageBody* _tmp19_ = NULL;
	guint8* _tmp20_ = NULL;
	gint _tmp20__length1 = 0;
	GError * _inner_error_ = NULL;
	self = _data50_->self;
	g_return_if_fail (SOUP_IS_SESSION (s));
	g_return_if_fail (SOUP_IS_MESSAGE (_msg));
	_tmp0_ = _msg;
	g_object_get (_tmp0_, "status-code", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != ((guint) SOUP_STATUS_OK)) {
		SoupMessage* _tmp3_ = NULL;
		guint _tmp4_ = 0U;
		guint _tmp5_ = 0U;
		_tmp3_ = _msg;
		g_object_get (_tmp3_, "status-code", &_tmp4_, NULL);
		_tmp5_ = _tmp4_;
		if (_tmp5_ != ((guint) SOUP_STATUS_CANCELLED)) {
			SoupMessage* _tmp6_ = NULL;
			guint _tmp7_ = 0U;
			guint _tmp8_ = 0U;
			SoupMessage* _tmp9_ = NULL;
			guint _tmp10_ = 0U;
			guint _tmp11_ = 0U;
			SoupMessage* _tmp12_ = NULL;
			guint _tmp13_ = 0U;
			guint _tmp14_ = 0U;
			const gchar* _tmp15_ = NULL;
			gchar* _tmp16_ = NULL;
			gchar* _tmp17_ = NULL;
			_tmp6_ = _msg;
			g_object_get (_tmp6_, "status-code", &_tmp7_, NULL);
			_tmp8_ = _tmp7_;
			g_warning ("MediaVideoWidget.vala:227: Status Code %u", _tmp8_);
			_tmp9_ = _msg;
			g_object_get (_tmp9_, "status-code", &_tmp10_, NULL);
			_tmp11_ = _tmp10_;
			_tmp12_ = _msg;
			g_object_get (_tmp12_, "status-code", &_tmp13_, NULL);
			_tmp14_ = _tmp13_;
			_tmp15_ = soup_status_get_phrase (_tmp14_);
			_tmp16_ = g_strdup_printf ("%u %s", _tmp11_, _tmp15_);
			_tmp17_ = _tmp16_;
			media_video_widget_show_error (self, _tmp17_);
			_g_free0 (_tmp17_);
		}
		media_video_widget_fetch_real_url_co (_data50_->_async_data_);
		return;
	}
	_tmp18_ = _msg;
	_tmp19_ = _tmp18_->response_body;
	_tmp20_ = _tmp19_->data;
	_tmp20__length1 = (gint) _tmp19_->length;
	back = (const gchar*) _tmp20_;
	{
		GRegex* regex = NULL;
		const gchar* _tmp21_ = NULL;
		GRegex* _tmp22_ = NULL;
		GMatchInfo* info = NULL;
		GRegex* _tmp23_ = NULL;
		const gchar* _tmp24_ = NULL;
		GMatchInfo* _tmp25_ = NULL;
		gchar* real_url = NULL;
		GMatchInfo* _tmp26_ = NULL;
		gchar* _tmp27_ = NULL;
		const gchar* _tmp28_ = NULL;
		const gchar* _tmp29_ = NULL;
		_tmp21_ = _data50_->regex_str;
		_tmp22_ = g_regex_new (_tmp21_, 0, 0, &_inner_error_);
		regex = _tmp22_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch54_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp23_ = regex;
		_tmp24_ = back;
		g_regex_match (_tmp23_, _tmp24_, 0, &_tmp25_);
		_g_match_info_unref0 (info);
		info = _tmp25_;
		_tmp26_ = info;
		_tmp27_ = g_match_info_fetch (_tmp26_, 1);
		real_url = _tmp27_;
		_tmp28_ = real_url;
		g_debug ("MediaVideoWidget.vala:239: Real url: %s", _tmp28_);
		_tmp29_ = real_url;
		if (_tmp29_ == NULL) {
			media_video_widget_show_error (self, "Error: Could not get real URL");
		} else {
			const gchar* _tmp30_ = NULL;
			gchar* _tmp31_ = NULL;
			_tmp30_ = real_url;
			_tmp31_ = g_strdup (_tmp30_);
			_g_free0 (self->priv->media_url);
			self->priv->media_url = _tmp31_;
			media_video_widget_start_video (self);
		}
		_g_free0 (real_url);
		_g_match_info_unref0 (info);
		_g_regex_unref0 (regex);
	}
	goto __finally54;
	__catch54_g_regex_error:
	{
		GError* e = NULL;
		GError* _tmp32_ = NULL;
		const gchar* _tmp33_ = NULL;
		GError* _tmp34_ = NULL;
		const gchar* _tmp35_ = NULL;
		gchar* _tmp36_ = NULL;
		gchar* _tmp37_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp32_ = e;
		_tmp33_ = _tmp32_->message;
		g_warning ("MediaVideoWidget.vala:247: Regex error: %s", _tmp33_);
		_tmp34_ = e;
		_tmp35_ = _tmp34_->message;
		_tmp36_ = g_strdup_printf ("Regex error: %s", _tmp35_);
		_tmp37_ = _tmp36_;
		media_video_widget_show_error (self, _tmp37_);
		_g_free0 (_tmp37_);
		_g_error_free0 (e);
	}
	__finally54:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	media_video_widget_fetch_real_url_co (_data50_->_async_data_);
}


static void ___lambda61__soup_session_callback (SoupSession* session, SoupMessage* msg, gpointer self) {
	__lambda61_ (self, session, msg);
	block50_data_unref (self);
}


static gboolean media_video_widget_fetch_real_url_co (MediaVideoWidgetFetchRealUrlData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data50_ = g_slice_new0 (Block50Data);
	_data_->_data50_->_ref_count_ = 1;
	_data_->_data50_->self = g_object_ref (_data_->self);
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->regex_str;
	_g_free0 (_data_->_data50_->regex_str);
	_data_->_data50_->regex_str = _data_->_tmp0_;
	_data_->_data50_->_async_data_ = _data_;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _data_->first_url;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = soup_message_new ("GET", _data_->_tmp1_);
	_data_->_data50_->msg = _data_->_tmp2_;
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = _data_->self->priv->cancellable;
	g_signal_connect_data (_data_->_tmp3_, "cancelled", (GCallback) ___lambda60__g_cancellable_cancelled, block50_data_ref (_data_->_data50_), (GClosureNotify) block50_data_unref, 0);
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = SOUP_SESSION;
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = _g_object_ref0 (_data_->_data50_->msg);
	soup_session_queue_message (_data_->_tmp4_, _data_->_tmp5_, ___lambda61__soup_session_callback, block50_data_ref (_data_->_data50_));
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	block50_data_unref (_data_->_data50_);
	_data_->_data50_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void media_video_widget_class_init (MediaVideoWidgetClass * klass) {
	media_video_widget_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (MediaVideoWidgetPrivate));
	((GtkWidgetClass *) klass)->button_press_event = (gboolean (*)(GtkWidget*, GdkEventButton*)) media_video_widget_real_button_press_event;
	((GtkWidgetClass *) klass)->key_press_event = (gboolean (*)(GtkWidget*, GdkEventKey*)) media_video_widget_real_key_press_event;
	((GtkWidgetClass *) klass)->destroy = (void (*)(GtkWidget*)) media_video_widget_real_destroy;
	G_OBJECT_CLASS (klass)->finalize = media_video_widget_finalize;
}


static void media_video_widget_instance_init (MediaVideoWidget * self) {
	GtkLabel* _tmp0_ = NULL;
	GtkProgressBar* _tmp1_ = NULL;
	self->priv = MEDIA_VIDEO_WIDGET_GET_PRIVATE (self);
	_tmp0_ = (GtkLabel*) gtk_label_new ("");
	g_object_ref_sink (_tmp0_);
	self->priv->error_label = _tmp0_;
	_tmp1_ = (GtkProgressBar*) gtk_progress_bar_new ();
	g_object_ref_sink (_tmp1_);
	self->priv->video_progress = _tmp1_;
	self->priv->video_progress_id = (guint) 0;
	self->priv->media_url = NULL;
}


static void media_video_widget_finalize (GObject* obj) {
	MediaVideoWidget * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MEDIA_VIDEO_WIDGET, MediaVideoWidget);
	_g_object_unref0 (self->priv->src);
	_g_object_unref0 (self->priv->sink);
	_g_object_unref0 (self->priv->area);
	_g_object_unref0 (self->priv->cancellable);
	_g_object_unref0 (self->priv->error_label);
	_g_object_unref0 (self->priv->video_progress);
	_g_object_unref0 (self->priv->surface_progress);
	_g_free0 (self->priv->media_url);
	G_OBJECT_CLASS (media_video_widget_parent_class)->finalize (obj);
}


GType media_video_widget_get_type (void) {
	static volatile gsize media_video_widget_type_id__volatile = 0;
	if (g_once_init_enter (&media_video_widget_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MediaVideoWidgetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) media_video_widget_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MediaVideoWidget), 0, (GInstanceInitFunc) media_video_widget_instance_init, NULL };
		GType media_video_widget_type_id;
		media_video_widget_type_id = g_type_register_static (gtk_stack_get_type (), "MediaVideoWidget", &g_define_type_info, 0);
		g_once_init_leave (&media_video_widget_type_id__volatile, media_video_widget_type_id);
	}
	return media_video_widget_type_id__volatile;
}



