/* UserEventReceiver.c generated by valac 0.34.6, the Vala compiler
 * generated from UserEventReceiver.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <json-glib/json-glib.h>
#include <rest/oauth-proxy.h>
#include "CbUserCounter.h"
#include "CbFilter.h"
#include <stdlib.h>
#include <string.h>
#include <cairo.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>


#define TYPE_IMESSAGE_RECEIVER (imessage_receiver_get_type ())
#define IMESSAGE_RECEIVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IMESSAGE_RECEIVER, IMessageReceiver))
#define IS_IMESSAGE_RECEIVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IMESSAGE_RECEIVER))
#define IMESSAGE_RECEIVER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_IMESSAGE_RECEIVER, IMessageReceiverIface))

typedef struct _IMessageReceiver IMessageReceiver;
typedef struct _IMessageReceiverIface IMessageReceiverIface;

#define TYPE_STREAM_MESSAGE_TYPE (stream_message_type_get_type ())

#define TYPE_USER_EVENT_RECEIVER (user_event_receiver_get_type ())
#define USER_EVENT_RECEIVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_USER_EVENT_RECEIVER, UserEventReceiver))
#define USER_EVENT_RECEIVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_USER_EVENT_RECEIVER, UserEventReceiverClass))
#define IS_USER_EVENT_RECEIVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_USER_EVENT_RECEIVER))
#define IS_USER_EVENT_RECEIVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_USER_EVENT_RECEIVER))
#define USER_EVENT_RECEIVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_USER_EVENT_RECEIVER, UserEventReceiverClass))

typedef struct _UserEventReceiver UserEventReceiver;
typedef struct _UserEventReceiverClass UserEventReceiverClass;
typedef struct _UserEventReceiverPrivate UserEventReceiverPrivate;

#define TYPE_ACCOUNT (account_get_type ())
#define ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNT, Account))
#define ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ACCOUNT, AccountClass))
#define IS_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNT))
#define IS_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ACCOUNT))
#define ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ACCOUNT, AccountClass))

typedef struct _Account Account;
typedef struct _AccountClass AccountClass;
typedef struct _AccountPrivate AccountPrivate;

#define SQL_TYPE_DATABASE (sql_database_get_type ())
#define SQL_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SQL_TYPE_DATABASE, SqlDatabase))
#define SQL_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SQL_TYPE_DATABASE, SqlDatabaseClass))
#define SQL_IS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SQL_TYPE_DATABASE))
#define SQL_IS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SQL_TYPE_DATABASE))
#define SQL_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SQL_TYPE_DATABASE, SqlDatabaseClass))

typedef struct _SqlDatabase SqlDatabase;
typedef struct _SqlDatabaseClass SqlDatabaseClass;

#define TYPE_USER_STREAM (user_stream_get_type ())
#define USER_STREAM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_USER_STREAM, UserStream))
#define USER_STREAM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_USER_STREAM, UserStreamClass))
#define IS_USER_STREAM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_USER_STREAM))
#define IS_USER_STREAM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_USER_STREAM))
#define USER_STREAM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_USER_STREAM, UserStreamClass))

typedef struct _UserStream UserStream;
typedef struct _UserStreamClass UserStreamClass;

#define TYPE_NOTIFICATION_MANAGER (notification_manager_get_type ())
#define NOTIFICATION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFICATION_MANAGER, NotificationManager))
#define NOTIFICATION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFICATION_MANAGER, NotificationManagerClass))
#define IS_NOTIFICATION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFICATION_MANAGER))
#define IS_NOTIFICATION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFICATION_MANAGER))
#define NOTIFICATION_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFICATION_MANAGER, NotificationManagerClass))

typedef struct _NotificationManager NotificationManager;
typedef struct _NotificationManagerClass NotificationManagerClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))

#define TYPE_COREBIRD (corebird_get_type ())
#define COREBIRD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COREBIRD, Corebird))
#define COREBIRD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COREBIRD, CorebirdClass))
#define IS_COREBIRD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COREBIRD))
#define IS_COREBIRD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COREBIRD))
#define COREBIRD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COREBIRD, CorebirdClass))

typedef struct _Corebird Corebird;
typedef struct _CorebirdClass CorebirdClass;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

typedef enum  {
	STREAM_MESSAGE_TYPE_UNSUPPORTED,
	STREAM_MESSAGE_TYPE_DELETE,
	STREAM_MESSAGE_TYPE_SCRUB_GEO,
	STREAM_MESSAGE_TYPE_LIMIT,
	STREAM_MESSAGE_TYPE_DISCONNECT,
	STREAM_MESSAGE_TYPE_FRIENDS,
	STREAM_MESSAGE_TYPE_EVENT,
	STREAM_MESSAGE_TYPE_WARNING,
	STREAM_MESSAGE_TYPE_DIRECT_MESSAGE,
	STREAM_MESSAGE_TYPE_TWEET,
	STREAM_MESSAGE_TYPE_EVENT_LIST_CREATED,
	STREAM_MESSAGE_TYPE_EVENT_LIST_DESTROYED,
	STREAM_MESSAGE_TYPE_EVENT_LIST_UPDATED,
	STREAM_MESSAGE_TYPE_EVENT_LIST_UNSUBSCRIBED,
	STREAM_MESSAGE_TYPE_EVENT_LIST_SUBSCRIBED,
	STREAM_MESSAGE_TYPE_EVENT_LIST_MEMBER_ADDED,
	STREAM_MESSAGE_TYPE_EVENT_LIST_MEMBER_REMOVED,
	STREAM_MESSAGE_TYPE_EVENT_FAVORITE,
	STREAM_MESSAGE_TYPE_EVENT_UNFAVORITE,
	STREAM_MESSAGE_TYPE_EVENT_FOLLOW,
	STREAM_MESSAGE_TYPE_EVENT_UNFOLLOW,
	STREAM_MESSAGE_TYPE_EVENT_BLOCK,
	STREAM_MESSAGE_TYPE_EVENT_UNBLOCK,
	STREAM_MESSAGE_TYPE_EVENT_MUTE,
	STREAM_MESSAGE_TYPE_EVENT_UNMUTE,
	STREAM_MESSAGE_TYPE_EVENT_USER_UPDATE,
	STREAM_MESSAGE_TYPE_EVENT_QUOTED_TWEET
} StreamMessageType;

struct _IMessageReceiverIface {
	GTypeInterface parent_iface;
	void (*stream_message_received) (IMessageReceiver* self, StreamMessageType type, JsonNode* root_node);
};

struct _UserEventReceiver {
	GObject parent_instance;
	UserEventReceiverPrivate * priv;
};

struct _UserEventReceiverClass {
	GObjectClass parent_class;
};

struct _UserEventReceiverPrivate {
	Account* account;
};

struct _Account {
	GObject parent_instance;
	AccountPrivate * priv;
	gint64 id;
	SqlDatabase* db;
	OAuthProxy* proxy;
	UserStream* user_stream;
	CbUserCounter* user_counter;
	NotificationManager* notifications;
	gint64* friends;
	gint friends_length1;
	gint64* blocked;
	gint blocked_length1;
	gint64* muted;
	gint muted_length1;
	gint64* disabled_rts;
	gint disabled_rts_length1;
	GPtrArray* filters;
};

struct _AccountClass {
	GObjectClass parent_class;
};


static gpointer user_event_receiver_parent_class = NULL;
static IMessageReceiverIface* user_event_receiver_imessage_receiver_parent_iface = NULL;

GType stream_message_type_get_type (void) G_GNUC_CONST;
GType imessage_receiver_get_type (void) G_GNUC_CONST;
GType user_event_receiver_get_type (void) G_GNUC_CONST;
GType account_get_type (void) G_GNUC_CONST;
#define USER_EVENT_RECEIVER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_USER_EVENT_RECEIVER, UserEventReceiverPrivate))
enum  {
	USER_EVENT_RECEIVER_DUMMY_PROPERTY
};
UserEventReceiver* user_event_receiver_new (Account* account);
UserEventReceiver* user_event_receiver_construct (GType object_type, Account* account);
static void user_event_receiver_real_stream_message_received (IMessageReceiver* base, StreamMessageType type, JsonNode* root_node);
void account_follow_id (Account* self, gint64 user_id);
void account_unfollow_id (Account* self, gint64 user_id);
void account_mute_id (Account* self, gint64 id);
void account_unmute_id (Account* self, gint64 id);
void account_block_id (Account* self, gint64 id);
void account_unblock_id (Account* self, gint64 id);
GType sql_database_get_type (void) G_GNUC_CONST;
GType user_stream_get_type (void) G_GNUC_CONST;
GType notification_manager_get_type (void) G_GNUC_CONST;
const gchar* account_get_screen_name (Account* self);
void account_set_name (Account* self, const gchar* value);
void account_set_description (Account* self, const gchar* value);
void account_set_screen_name (Account* self, const gchar* value);
const gchar* account_get_name (Account* self);
cairo_surface_t* account_get_avatar_small (Account* self);
cairo_surface_t* account_get_avatar (Account* self);
void account_save_info (Account* self);
void utils_update_startup_account (const gchar* old_screen_name, const gchar* new_screen_name);
GType corebird_get_type (void) G_GNUC_CONST;
GType main_window_get_type (void) G_GNUC_CONST;
gboolean corebird_is_window_open_for_user_id (Corebird* self, gint64 user_id, MainWindow** window);
gboolean settings_notify_new_dms (void);
gchar* notification_manager_send_dm (NotificationManager* self, gint64 sender_id, const gchar* existing_id, const gchar* summary, const gchar* text);
gchar* utils_unescape_html (const gchar* input);
gboolean settings_notify_new_mentions (void);
gchar* notification_manager_send (NotificationManager* self, const gchar* summary, const gchar* body, const gchar* id_suffix);
static void user_event_receiver_finalize (GObject* obj);


UserEventReceiver* user_event_receiver_construct (GType object_type, Account* account) {
	UserEventReceiver * self = NULL;
	Account* _tmp0_ = NULL;
	g_return_val_if_fail (IS_ACCOUNT (account), NULL);
	self = (UserEventReceiver*) g_object_new (object_type, NULL);
	_tmp0_ = account;
	self->priv->account = _tmp0_;
	return self;
}


UserEventReceiver* user_event_receiver_new (Account* account) {
	return user_event_receiver_construct (TYPE_USER_EVENT_RECEIVER, account);
}


static gpointer _json_object_ref0 (gpointer self) {
	return self ? json_object_ref (self) : NULL;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = needle;
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
	result = _tmp1_ != NULL;
	return result;
}


static void user_event_receiver_real_stream_message_received (IMessageReceiver* base, StreamMessageType type, JsonNode* root_node) {
	UserEventReceiver * self;
	StreamMessageType _tmp0_ = 0;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_USER_EVENT_RECEIVER, UserEventReceiver);
	g_return_if_fail (root_node != NULL);
	_tmp0_ = type;
	switch (_tmp0_) {
		case STREAM_MESSAGE_TYPE_EVENT_FOLLOW:
		{
			gint64 user_id = 0LL;
			JsonNode* _tmp1_ = NULL;
			JsonObject* _tmp2_ = NULL;
			JsonObject* _tmp3_ = NULL;
			gint64 _tmp4_ = 0LL;
			Account* _tmp5_ = NULL;
			gint64 _tmp6_ = 0LL;
			_tmp1_ = root_node;
			_tmp2_ = json_node_get_object (_tmp1_);
			_tmp3_ = json_object_get_object_member (_tmp2_, "target");
			_tmp4_ = json_object_get_int_member (_tmp3_, "id");
			user_id = _tmp4_;
			_tmp5_ = self->priv->account;
			_tmp6_ = user_id;
			account_follow_id (_tmp5_, _tmp6_);
			break;
		}
		case STREAM_MESSAGE_TYPE_EVENT_UNFOLLOW:
		{
			gint64 user_id = 0LL;
			JsonNode* _tmp7_ = NULL;
			JsonObject* _tmp8_ = NULL;
			JsonObject* _tmp9_ = NULL;
			gint64 _tmp10_ = 0LL;
			Account* _tmp11_ = NULL;
			gint64 _tmp12_ = 0LL;
			_tmp7_ = root_node;
			_tmp8_ = json_node_get_object (_tmp7_);
			_tmp9_ = json_object_get_object_member (_tmp8_, "target");
			_tmp10_ = json_object_get_int_member (_tmp9_, "id");
			user_id = _tmp10_;
			_tmp11_ = self->priv->account;
			_tmp12_ = user_id;
			account_unfollow_id (_tmp11_, _tmp12_);
			break;
		}
		case STREAM_MESSAGE_TYPE_EVENT_MUTE:
		{
			gint64 user_id = 0LL;
			JsonNode* _tmp13_ = NULL;
			JsonObject* _tmp14_ = NULL;
			JsonObject* _tmp15_ = NULL;
			gint64 _tmp16_ = 0LL;
			Account* _tmp17_ = NULL;
			gint64 _tmp18_ = 0LL;
			_tmp13_ = root_node;
			_tmp14_ = json_node_get_object (_tmp13_);
			_tmp15_ = json_object_get_object_member (_tmp14_, "target");
			_tmp16_ = json_object_get_int_member (_tmp15_, "id");
			user_id = _tmp16_;
			_tmp17_ = self->priv->account;
			_tmp18_ = user_id;
			account_mute_id (_tmp17_, _tmp18_);
			break;
		}
		case STREAM_MESSAGE_TYPE_EVENT_UNMUTE:
		{
			gint64 user_id = 0LL;
			JsonNode* _tmp19_ = NULL;
			JsonObject* _tmp20_ = NULL;
			JsonObject* _tmp21_ = NULL;
			gint64 _tmp22_ = 0LL;
			Account* _tmp23_ = NULL;
			gint64 _tmp24_ = 0LL;
			_tmp19_ = root_node;
			_tmp20_ = json_node_get_object (_tmp19_);
			_tmp21_ = json_object_get_object_member (_tmp20_, "target");
			_tmp22_ = json_object_get_int_member (_tmp21_, "id");
			user_id = _tmp22_;
			_tmp23_ = self->priv->account;
			_tmp24_ = user_id;
			account_unmute_id (_tmp23_, _tmp24_);
			break;
		}
		case STREAM_MESSAGE_TYPE_EVENT_BLOCK:
		{
			gint64 user_id = 0LL;
			JsonNode* _tmp25_ = NULL;
			JsonObject* _tmp26_ = NULL;
			JsonObject* _tmp27_ = NULL;
			gint64 _tmp28_ = 0LL;
			Account* _tmp29_ = NULL;
			gint64 _tmp30_ = 0LL;
			_tmp25_ = root_node;
			_tmp26_ = json_node_get_object (_tmp25_);
			_tmp27_ = json_object_get_object_member (_tmp26_, "target");
			_tmp28_ = json_object_get_int_member (_tmp27_, "id");
			user_id = _tmp28_;
			_tmp29_ = self->priv->account;
			_tmp30_ = user_id;
			account_block_id (_tmp29_, _tmp30_);
			break;
		}
		case STREAM_MESSAGE_TYPE_EVENT_UNBLOCK:
		{
			gint64 user_id = 0LL;
			JsonNode* _tmp31_ = NULL;
			JsonObject* _tmp32_ = NULL;
			JsonObject* _tmp33_ = NULL;
			gint64 _tmp34_ = 0LL;
			Account* _tmp35_ = NULL;
			gint64 _tmp36_ = 0LL;
			_tmp31_ = root_node;
			_tmp32_ = json_node_get_object (_tmp31_);
			_tmp33_ = json_object_get_object_member (_tmp32_, "target");
			_tmp34_ = json_object_get_int_member (_tmp33_, "id");
			user_id = _tmp34_;
			_tmp35_ = self->priv->account;
			_tmp36_ = user_id;
			account_unblock_id (_tmp35_, _tmp36_);
			break;
		}
		case STREAM_MESSAGE_TYPE_EVENT_USER_UPDATE:
		{
			JsonObject* user_obj = NULL;
			JsonNode* _tmp37_ = NULL;
			JsonObject* _tmp38_ = NULL;
			JsonObject* _tmp39_ = NULL;
			JsonObject* _tmp40_ = NULL;
			JsonObject* _tmp41_ = NULL;
			gint64 _tmp42_ = 0LL;
			Account* _tmp43_ = NULL;
			gint64 _tmp44_ = 0LL;
			_tmp37_ = root_node;
			_tmp38_ = json_node_get_object (_tmp37_);
			_tmp39_ = json_object_get_object_member (_tmp38_, "target");
			_tmp40_ = _json_object_ref0 (_tmp39_);
			user_obj = _tmp40_;
			_tmp41_ = user_obj;
			_tmp42_ = json_object_get_int_member (_tmp41_, "id");
			_tmp43_ = self->priv->account;
			_tmp44_ = _tmp43_->id;
			if (_tmp42_ == _tmp44_) {
				gchar* old_screen_name = NULL;
				Account* _tmp45_ = NULL;
				const gchar* _tmp46_ = NULL;
				const gchar* _tmp47_ = NULL;
				gchar* _tmp48_ = NULL;
				Account* _tmp49_ = NULL;
				JsonObject* _tmp50_ = NULL;
				const gchar* _tmp51_ = NULL;
				Account* _tmp52_ = NULL;
				JsonObject* _tmp53_ = NULL;
				const gchar* _tmp54_ = NULL;
				Account* _tmp55_ = NULL;
				JsonObject* _tmp56_ = NULL;
				const gchar* _tmp57_ = NULL;
				Account* _tmp58_ = NULL;
				Account* _tmp59_ = NULL;
				const gchar* _tmp60_ = NULL;
				const gchar* _tmp61_ = NULL;
				Account* _tmp62_ = NULL;
				const gchar* _tmp63_ = NULL;
				const gchar* _tmp64_ = NULL;
				Account* _tmp65_ = NULL;
				cairo_surface_t* _tmp66_ = NULL;
				cairo_surface_t* _tmp67_ = NULL;
				Account* _tmp68_ = NULL;
				cairo_surface_t* _tmp69_ = NULL;
				cairo_surface_t* _tmp70_ = NULL;
				Account* _tmp71_ = NULL;
				const gchar* _tmp72_ = NULL;
				Account* _tmp73_ = NULL;
				const gchar* _tmp74_ = NULL;
				const gchar* _tmp75_ = NULL;
				_tmp45_ = self->priv->account;
				_tmp46_ = account_get_screen_name (_tmp45_);
				_tmp47_ = _tmp46_;
				_tmp48_ = g_strdup (_tmp47_);
				old_screen_name = _tmp48_;
				_tmp49_ = self->priv->account;
				_tmp50_ = user_obj;
				_tmp51_ = json_object_get_string_member (_tmp50_, "name");
				account_set_name (_tmp49_, _tmp51_);
				_tmp52_ = self->priv->account;
				_tmp53_ = user_obj;
				_tmp54_ = json_object_get_string_member (_tmp53_, "description");
				account_set_description (_tmp52_, _tmp54_);
				_tmp55_ = self->priv->account;
				_tmp56_ = user_obj;
				_tmp57_ = json_object_get_string_member (_tmp56_, "screen_name");
				account_set_screen_name (_tmp55_, _tmp57_);
				_tmp58_ = self->priv->account;
				_tmp59_ = self->priv->account;
				_tmp60_ = account_get_screen_name (_tmp59_);
				_tmp61_ = _tmp60_;
				_tmp62_ = self->priv->account;
				_tmp63_ = account_get_name (_tmp62_);
				_tmp64_ = _tmp63_;
				_tmp65_ = self->priv->account;
				_tmp66_ = account_get_avatar_small (_tmp65_);
				_tmp67_ = _tmp66_;
				_tmp68_ = self->priv->account;
				_tmp69_ = account_get_avatar (_tmp68_);
				_tmp70_ = _tmp69_;
				g_signal_emit_by_name (_tmp58_, "info-changed", _tmp61_, _tmp64_, _tmp67_, _tmp70_);
				_tmp71_ = self->priv->account;
				account_save_info (_tmp71_);
				_tmp72_ = old_screen_name;
				_tmp73_ = self->priv->account;
				_tmp74_ = account_get_screen_name (_tmp73_);
				_tmp75_ = _tmp74_;
				utils_update_startup_account (_tmp72_, _tmp75_);
				_g_free0 (old_screen_name);
			} else {
				g_warning ("UserEventReceiver.vala:78: USER_UPDATE: ids don't match");
			}
			_json_object_unref0 (user_obj);
			break;
		}
		case STREAM_MESSAGE_TYPE_DIRECT_MESSAGE:
		{
			Corebird* cb = NULL;
			GApplication* _tmp76_ = NULL;
			Corebird* _tmp77_ = NULL;
			gboolean _tmp78_ = FALSE;
			Corebird* _tmp79_ = NULL;
			Account* _tmp80_ = NULL;
			gint64 _tmp81_ = 0LL;
			gboolean _tmp82_ = FALSE;
			_tmp76_ = g_application_get_default ();
			_tmp77_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp76_, TYPE_COREBIRD, Corebird));
			cb = _tmp77_;
			_tmp79_ = cb;
			_tmp80_ = self->priv->account;
			_tmp81_ = _tmp80_->id;
			_tmp82_ = corebird_is_window_open_for_user_id (_tmp79_, _tmp81_, NULL);
			if (!_tmp82_) {
				gboolean _tmp83_ = FALSE;
				_tmp83_ = settings_notify_new_dms ();
				_tmp78_ = _tmp83_;
			} else {
				_tmp78_ = FALSE;
			}
			if (_tmp78_) {
				JsonObject* dm_obj = NULL;
				JsonNode* _tmp84_ = NULL;
				JsonObject* _tmp85_ = NULL;
				JsonObject* _tmp86_ = NULL;
				JsonObject* _tmp87_ = NULL;
				JsonObject* sender_obj = NULL;
				JsonObject* _tmp88_ = NULL;
				JsonObject* _tmp89_ = NULL;
				JsonObject* _tmp90_ = NULL;
				gint64 sender_id = 0LL;
				JsonObject* _tmp91_ = NULL;
				gint64 _tmp92_ = 0LL;
				gchar* sender_name = NULL;
				JsonObject* _tmp93_ = NULL;
				const gchar* _tmp94_ = NULL;
				gchar* _tmp95_ = NULL;
				gchar* dm_text = NULL;
				JsonObject* _tmp96_ = NULL;
				const gchar* _tmp97_ = NULL;
				gchar* _tmp98_ = NULL;
				Account* _tmp99_ = NULL;
				NotificationManager* _tmp100_ = NULL;
				gint64 _tmp101_ = 0LL;
				const gchar* _tmp102_ = NULL;
				const gchar* _tmp103_ = NULL;
				gchar* _tmp104_ = NULL;
				gchar* _tmp105_ = NULL;
				const gchar* _tmp106_ = NULL;
				gchar* _tmp107_ = NULL;
				gchar* _tmp108_ = NULL;
				gchar* _tmp109_ = NULL;
				gchar* _tmp110_ = NULL;
				_tmp84_ = root_node;
				_tmp85_ = json_node_get_object (_tmp84_);
				_tmp86_ = json_object_get_object_member (_tmp85_, "direct_message");
				_tmp87_ = _json_object_ref0 (_tmp86_);
				dm_obj = _tmp87_;
				_tmp88_ = dm_obj;
				_tmp89_ = json_object_get_object_member (_tmp88_, "sender");
				_tmp90_ = _json_object_ref0 (_tmp89_);
				sender_obj = _tmp90_;
				_tmp91_ = sender_obj;
				_tmp92_ = json_object_get_int_member (_tmp91_, "id");
				sender_id = _tmp92_;
				_tmp93_ = sender_obj;
				_tmp94_ = json_object_get_string_member (_tmp93_, "name");
				_tmp95_ = g_strdup (_tmp94_);
				sender_name = _tmp95_;
				_tmp96_ = dm_obj;
				_tmp97_ = json_object_get_string_member (_tmp96_, "text");
				_tmp98_ = g_strdup (_tmp97_);
				dm_text = _tmp98_;
				_tmp99_ = self->priv->account;
				_tmp100_ = _tmp99_->notifications;
				_tmp101_ = sender_id;
				_tmp102_ = _ ("New direct message from %s");
				_tmp103_ = sender_name;
				_tmp104_ = g_strdup_printf (_tmp102_, _tmp103_);
				_tmp105_ = _tmp104_;
				_tmp106_ = dm_text;
				_tmp107_ = utils_unescape_html (_tmp106_);
				_tmp108_ = _tmp107_;
				_tmp109_ = notification_manager_send_dm (_tmp100_, _tmp101_, NULL, _tmp105_, _tmp108_);
				_tmp110_ = _tmp109_;
				_g_free0 (_tmp110_);
				_g_free0 (_tmp108_);
				_g_free0 (_tmp105_);
				_g_free0 (dm_text);
				_g_free0 (sender_name);
				_json_object_unref0 (sender_obj);
				_json_object_unref0 (dm_obj);
			}
			_g_object_unref0 (cb);
			break;
		}
		case STREAM_MESSAGE_TYPE_TWEET:
		{
			Corebird* cb = NULL;
			GApplication* _tmp111_ = NULL;
			Corebird* _tmp112_ = NULL;
			gboolean _tmp113_ = FALSE;
			Corebird* _tmp114_ = NULL;
			Account* _tmp115_ = NULL;
			gint64 _tmp116_ = 0LL;
			gboolean _tmp117_ = FALSE;
			_tmp111_ = g_application_get_default ();
			_tmp112_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp111_, TYPE_COREBIRD, Corebird));
			cb = _tmp112_;
			_tmp114_ = cb;
			_tmp115_ = self->priv->account;
			_tmp116_ = _tmp115_->id;
			_tmp117_ = corebird_is_window_open_for_user_id (_tmp114_, _tmp116_, NULL);
			if (!_tmp117_) {
				gboolean _tmp118_ = FALSE;
				_tmp118_ = settings_notify_new_mentions ();
				_tmp113_ = _tmp118_;
			} else {
				_tmp113_ = FALSE;
			}
			if (_tmp113_) {
				JsonObject* tweet_obj = NULL;
				JsonNode* _tmp119_ = NULL;
				JsonObject* _tmp120_ = NULL;
				JsonObject* _tmp121_ = NULL;
				gchar* text = NULL;
				JsonObject* _tmp122_ = NULL;
				const gchar* _tmp123_ = NULL;
				gchar* _tmp124_ = NULL;
				const gchar* _tmp125_ = NULL;
				Account* _tmp126_ = NULL;
				const gchar* _tmp127_ = NULL;
				const gchar* _tmp128_ = NULL;
				gchar* _tmp129_ = NULL;
				gchar* _tmp130_ = NULL;
				gboolean _tmp131_ = FALSE;
				gboolean _tmp132_ = FALSE;
				_tmp119_ = root_node;
				_tmp120_ = json_node_get_object (_tmp119_);
				_tmp121_ = _json_object_ref0 (_tmp120_);
				tweet_obj = _tmp121_;
				_tmp122_ = tweet_obj;
				_tmp123_ = json_object_get_string_member (_tmp122_, "text");
				_tmp124_ = g_strdup (_tmp123_);
				text = _tmp124_;
				_tmp125_ = text;
				_tmp126_ = self->priv->account;
				_tmp127_ = account_get_screen_name (_tmp126_);
				_tmp128_ = _tmp127_;
				_tmp129_ = g_strconcat ("@", _tmp128_, NULL);
				_tmp130_ = _tmp129_;
				_tmp131_ = string_contains (_tmp125_, _tmp130_);
				_tmp132_ = _tmp131_;
				_g_free0 (_tmp130_);
				if (_tmp132_) {
					JsonObject* author_obj = NULL;
					JsonObject* _tmp133_ = NULL;
					JsonObject* _tmp134_ = NULL;
					JsonObject* _tmp135_ = NULL;
					gchar* author_name = NULL;
					JsonObject* _tmp136_ = NULL;
					const gchar* _tmp137_ = NULL;
					gchar* _tmp138_ = NULL;
					gchar* summary = NULL;
					const gchar* _tmp139_ = NULL;
					const gchar* _tmp140_ = NULL;
					Account* _tmp141_ = NULL;
					const gchar* _tmp142_ = NULL;
					const gchar* _tmp143_ = NULL;
					gchar* _tmp144_ = NULL;
					Account* _tmp145_ = NULL;
					NotificationManager* _tmp146_ = NULL;
					const gchar* _tmp147_ = NULL;
					const gchar* _tmp148_ = NULL;
					gchar* _tmp149_ = NULL;
					gchar* _tmp150_ = NULL;
					_tmp133_ = tweet_obj;
					_tmp134_ = json_object_get_object_member (_tmp133_, "user");
					_tmp135_ = _json_object_ref0 (_tmp134_);
					author_obj = _tmp135_;
					_tmp136_ = author_obj;
					_tmp137_ = json_object_get_string_member (_tmp136_, "name");
					_tmp138_ = g_strdup (_tmp137_);
					author_name = _tmp138_;
					_tmp139_ = _ ("%s mentioned %s");
					_tmp140_ = author_name;
					_tmp141_ = self->priv->account;
					_tmp142_ = account_get_name (_tmp141_);
					_tmp143_ = _tmp142_;
					_tmp144_ = g_strdup_printf (_tmp139_, _tmp140_, _tmp143_);
					summary = _tmp144_;
					_tmp145_ = self->priv->account;
					_tmp146_ = _tmp145_->notifications;
					_tmp147_ = summary;
					_tmp148_ = text;
					_tmp149_ = notification_manager_send (_tmp146_, _tmp147_, _tmp148_, NULL);
					_tmp150_ = _tmp149_;
					_g_free0 (_tmp150_);
					_g_free0 (summary);
					_g_free0 (author_name);
					_json_object_unref0 (author_obj);
				}
				_g_free0 (text);
				_json_object_unref0 (tweet_obj);
			}
			_g_object_unref0 (cb);
			break;
		}
		default:
		break;
	}
}


static void user_event_receiver_class_init (UserEventReceiverClass * klass) {
	user_event_receiver_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UserEventReceiverPrivate));
	G_OBJECT_CLASS (klass)->finalize = user_event_receiver_finalize;
}


static void user_event_receiver_imessage_receiver_interface_init (IMessageReceiverIface * iface) {
	user_event_receiver_imessage_receiver_parent_iface = g_type_interface_peek_parent (iface);
	iface->stream_message_received = (void (*)(IMessageReceiver*, StreamMessageType, JsonNode*)) user_event_receiver_real_stream_message_received;
}


static void user_event_receiver_instance_init (UserEventReceiver * self) {
	self->priv = USER_EVENT_RECEIVER_GET_PRIVATE (self);
}


static void user_event_receiver_finalize (GObject* obj) {
	UserEventReceiver * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_USER_EVENT_RECEIVER, UserEventReceiver);
	G_OBJECT_CLASS (user_event_receiver_parent_class)->finalize (obj);
}


GType user_event_receiver_get_type (void) {
	static volatile gsize user_event_receiver_type_id__volatile = 0;
	if (g_once_init_enter (&user_event_receiver_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UserEventReceiverClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) user_event_receiver_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UserEventReceiver), 0, (GInstanceInitFunc) user_event_receiver_instance_init, NULL };
		static const GInterfaceInfo imessage_receiver_info = { (GInterfaceInitFunc) user_event_receiver_imessage_receiver_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType user_event_receiver_type_id;
		user_event_receiver_type_id = g_type_register_static (G_TYPE_OBJECT, "UserEventReceiver", &g_define_type_info, 0);
		g_type_add_interface_static (user_event_receiver_type_id, TYPE_IMESSAGE_RECEIVER, &imessage_receiver_info);
		g_once_init_leave (&user_event_receiver_type_id__volatile, user_event_receiver_type_id);
	}
	return user_event_receiver_type_id__volatile;
}



