; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; This test makes sure that memmove instructions are properly eliminated.
;
; RUN: opt < %s -passes=instcombine -S | FileCheck %s

@S = internal constant [33 x i8] c"panic: restorelist inconsistency\00"		; <ptr> [#uses=1]
@h = constant [2 x i8] c"h\00"		; <ptr> [#uses=1]
@hel = constant [4 x i8] c"hel\00"		; <ptr> [#uses=1]
@hello_u = constant [8 x i8] c"hello_u\00"		; <ptr> [#uses=1]

define void @test1(ptr %A, ptr %B, i32 %N) {
; CHECK-LABEL: @test1(
; CHECK-NEXT:    ret void
;
  call void @llvm.memmove.p0.p0.i32(ptr %A, ptr %B, i32 0, i1 false)
  ret void
}

define void @test2(ptr %A, i32 %N) {
  ;; dest can't alias source since we can't write to source!
; CHECK-LABEL: @test2(
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i32(ptr align 1 [[A:%.*]], ptr nonnull align 16 @S, i32 [[N:%.*]], i1 false)
; CHECK-NEXT:    ret void
;
  call void @llvm.memmove.p0.p0.i32(ptr %A, ptr @S, i32 %N, i1 false)
  ret void
}

define i32 @test3(ptr %target) { ; arg: ptr> [#uses=1]
; CHECK-LABEL: @test3(
; CHECK-NEXT:    store i16 104, ptr [[TARGET:%.*]], align 2
; CHECK-NEXT:    store i32 7103848, ptr [[TARGET]], align 4
; CHECK-NEXT:    store i64 33037504440198504, ptr [[TARGET]], align 8
; CHECK-NEXT:    ret i32 0
;
  %h_p = getelementptr [2 x i8], ptr @h, i32 0, i32 0		; <ptr> [#uses=1]
  %hel_p = getelementptr [4 x i8], ptr @hel, i32 0, i32 0		; <ptr> [#uses=1]
  %hello_u_p = getelementptr [8 x i8], ptr @hello_u, i32 0, i32 0		; <ptr> [#uses=1]
  %target_p = getelementptr [1024 x i8], ptr %target, i32 0, i32 0		; <ptr> [#uses=3]
  call void @llvm.memmove.p0.p0.i32(ptr align 2 %target_p, ptr align 2 %h_p, i32 2, i1 false)
  call void @llvm.memmove.p0.p0.i32(ptr align 4 %target_p, ptr align 4 %hel_p, i32 4, i1 false)
  call void @llvm.memmove.p0.p0.i32(ptr align 8 %target_p, ptr align 8 %hello_u_p, i32 8, i1 false)
  ret i32 0
}

; PR2370
define void @test4(ptr %a) {
; CHECK-LABEL: @test4(
; CHECK-NEXT:    ret void
;
  tail call void @llvm.memmove.p0.p0.i32(ptr %a, ptr %a, i32 100, i1 false)
  ret void
}

@UnknownConstant = external constant i128

define void @memmove_to_constant(ptr %src) {
; CHECK-LABEL: @memmove_to_constant(
; CHECK-NEXT:    ret void
;
  call void @llvm.memmove.p0.p0.i32(ptr @UnknownConstant, ptr %src, i32 16, i1 false)
  ret void
}


declare void @llvm.memmove.p0.p0.i32(ptr nocapture, ptr nocapture readonly, i32, i1) argmemonly nounwind
