; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --scrub-attributes --version 2
; RUN: opt -S -mtriple=amdgcn-amd-amdhsa -passes=instcombine < %s | FileCheck --check-prefixes=DEFAULT,CHECK %s
; RUN: opt -S -mtriple=amdgcn-amd-amdhsa -mattr=+wavefrontsize32 -passes=instcombine < %s | FileCheck --check-prefixes=WAVE32,CHECK %s
; RUN: opt -S -mtriple=amdgcn-amd-amdhsa -mattr=+wavefrontsize64 -passes=instcombine < %s | FileCheck --check-prefixes=WAVE64,CHECK %s
; RUN: opt -S -mtriple=amdgcn-amd-amdhsa -mcpu=gfx1030 -passes=instcombine < %s | FileCheck --check-prefixes=WAVE32,CHECK %s
; RUN: opt -S -mtriple=amdgcn-amd-amdhsa -mcpu=gfx1030 -mattr=+wavefrontsize64 -passes=instcombine < %s | FileCheck --check-prefixes=WAVE64,CHECK %s

declare i32 @llvm.amdgcn.mbcnt.lo(i32, i32)
declare i32 @llvm.amdgcn.mbcnt.hi(i32, i32)

define i32 @mbcnt_lo(i32 %x, i32 %y) {
; DEFAULT-LABEL: define i32 @mbcnt_lo
; DEFAULT-SAME: (i32 [[X:%.*]], i32 [[Y:%.*]]) {
; DEFAULT-NEXT:    [[LO:%.*]] = call i32 @llvm.amdgcn.mbcnt.lo(i32 [[X]], i32 [[Y]])
; DEFAULT-NEXT:    ret i32 [[LO]]
;
; WAVE32-LABEL: define i32 @mbcnt_lo
; WAVE32-SAME: (i32 [[X:%.*]], i32 [[Y:%.*]]) #[[ATTR1:[0-9]+]] {
; WAVE32-NEXT:    [[LO:%.*]] = call i32 @llvm.amdgcn.mbcnt.lo(i32 [[X]], i32 [[Y]])
; WAVE32-NEXT:    ret i32 [[LO]]
;
; WAVE64-LABEL: define i32 @mbcnt_lo
; WAVE64-SAME: (i32 [[X:%.*]], i32 [[Y:%.*]]) #[[ATTR1:[0-9]+]] {
; WAVE64-NEXT:    [[LO:%.*]] = call i32 @llvm.amdgcn.mbcnt.lo(i32 [[X]], i32 [[Y]])
; WAVE64-NEXT:    ret i32 [[LO]]
;
  %lo = call i32 @llvm.amdgcn.mbcnt.lo(i32 %x, i32 %y)
  ret i32 %lo
}

define i32 @mbcnt_hi(i32 %x, i32 %y) {
; DEFAULT-LABEL: define i32 @mbcnt_hi
; DEFAULT-SAME: (i32 [[X:%.*]], i32 [[Y:%.*]]) {
; DEFAULT-NEXT:    [[HI:%.*]] = call i32 @llvm.amdgcn.mbcnt.hi(i32 [[X]], i32 [[Y]])
; DEFAULT-NEXT:    ret i32 [[HI]]
;
; WAVE32-LABEL: define i32 @mbcnt_hi
; WAVE32-SAME: (i32 [[X:%.*]], i32 [[Y:%.*]]) #[[ATTR1]] {
; WAVE32-NEXT:    ret i32 [[Y]]
;
; WAVE64-LABEL: define i32 @mbcnt_hi
; WAVE64-SAME: (i32 [[X:%.*]], i32 [[Y:%.*]]) #[[ATTR1]] {
; WAVE64-NEXT:    [[HI:%.*]] = call i32 @llvm.amdgcn.mbcnt.hi(i32 [[X]], i32 [[Y]])
; WAVE64-NEXT:    ret i32 [[HI]]
;
  %hi = call i32 @llvm.amdgcn.mbcnt.hi(i32 %x, i32 %y)
  ret i32 %hi
}

define i32 @mbcnt_lo_hi(i32 %x, i32 %y, i32 %z) {
; DEFAULT-LABEL: define i32 @mbcnt_lo_hi
; DEFAULT-SAME: (i32 [[X:%.*]], i32 [[Y:%.*]], i32 [[Z:%.*]]) {
; DEFAULT-NEXT:    [[LO:%.*]] = call i32 @llvm.amdgcn.mbcnt.lo(i32 [[X]], i32 [[Y]])
; DEFAULT-NEXT:    [[HI:%.*]] = call i32 @llvm.amdgcn.mbcnt.hi(i32 [[Z]], i32 [[LO]])
; DEFAULT-NEXT:    ret i32 [[HI]]
;
; WAVE32-LABEL: define i32 @mbcnt_lo_hi
; WAVE32-SAME: (i32 [[X:%.*]], i32 [[Y:%.*]], i32 [[Z:%.*]]) #[[ATTR1]] {
; WAVE32-NEXT:    [[LO:%.*]] = call i32 @llvm.amdgcn.mbcnt.lo(i32 [[X]], i32 [[Y]])
; WAVE32-NEXT:    ret i32 [[LO]]
;
; WAVE64-LABEL: define i32 @mbcnt_lo_hi
; WAVE64-SAME: (i32 [[X:%.*]], i32 [[Y:%.*]], i32 [[Z:%.*]]) #[[ATTR1]] {
; WAVE64-NEXT:    [[LO:%.*]] = call i32 @llvm.amdgcn.mbcnt.lo(i32 [[X]], i32 [[Y]])
; WAVE64-NEXT:    [[HI:%.*]] = call i32 @llvm.amdgcn.mbcnt.hi(i32 [[Z]], i32 [[LO]])
; WAVE64-NEXT:    ret i32 [[HI]]
;
  %lo = call i32 @llvm.amdgcn.mbcnt.lo(i32 %x, i32 %y)
  %hi = call i32 @llvm.amdgcn.mbcnt.hi(i32 %z, i32 %lo)
  ret i32 %hi
}

define i32 @ockl_lane_u32() {
; DEFAULT-LABEL: define i32 @ockl_lane_u32() {
; DEFAULT-NEXT:    [[LO:%.*]] = call i32 @llvm.amdgcn.mbcnt.lo(i32 -1, i32 0)
; DEFAULT-NEXT:    [[HI:%.*]] = call i32 @llvm.amdgcn.mbcnt.hi(i32 -1, i32 [[LO]])
; DEFAULT-NEXT:    ret i32 [[HI]]
;
; WAVE32-LABEL: define i32 @ockl_lane_u32
; WAVE32-SAME: () #[[ATTR1]] {
; WAVE32-NEXT:    [[LO:%.*]] = call i32 @llvm.amdgcn.mbcnt.lo(i32 -1, i32 0)
; WAVE32-NEXT:    ret i32 [[LO]]
;
; WAVE64-LABEL: define i32 @ockl_lane_u32
; WAVE64-SAME: () #[[ATTR1]] {
; WAVE64-NEXT:    [[LO:%.*]] = call i32 @llvm.amdgcn.mbcnt.lo(i32 -1, i32 0)
; WAVE64-NEXT:    [[HI:%.*]] = call i32 @llvm.amdgcn.mbcnt.hi(i32 -1, i32 [[LO]])
; WAVE64-NEXT:    ret i32 [[HI]]
;
  %lo = call i32 @llvm.amdgcn.mbcnt.lo(i32 -1, i32 0)
  %hi = call i32 @llvm.amdgcn.mbcnt.hi(i32 -1, i32 %lo)
  ret i32 %hi
}

;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; CHECK: {{.*}}
