; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -mtriple=riscv32 -mattr=+zfinx -target-abi=ilp32 -verify-machineinstrs < %s \
; RUN:   | FileCheck -check-prefix=RV32FINX %s
; RUN: llc -mtriple=riscv64 -mattr=+zfinx -target-abi=lp64 -verify-machineinstrs < %s \
; RUN:   | FileCheck -check-prefix=RV64FINX %s

@gf = external global float

define float @constraint_r_float(float %a) nounwind {
; RV32FINX-LABEL: constraint_r_float:
; RV32FINX:       # %bb.0:
; RV32FINX-NEXT:    lui a1, %hi(gf)
; RV32FINX-NEXT:    lw a1, %lo(gf)(a1)
; RV32FINX-NEXT:    #APP
; RV32FINX-NEXT:    fadd.s a0, a0, a1
; RV32FINX-NEXT:    #NO_APP
; RV32FINX-NEXT:    ret
;
; RV64FINX-LABEL: constraint_r_float:
; RV64FINX:       # %bb.0:
; RV64FINX-NEXT:    lui a1, %hi(gf)
; RV64FINX-NEXT:    lw a1, %lo(gf)(a1)
; RV64FINX-NEXT:    #APP
; RV64FINX-NEXT:    fadd.s a0, a0, a1
; RV64FINX-NEXT:    #NO_APP
; RV64FINX-NEXT:    ret
  %1 = load float, ptr @gf
  %2 = tail call float asm "fadd.s $0, $1, $2", "=r,r,r"(float %a, float %1)
  ret float %2
}

define float @constraint_cr_float(float %a) nounwind {
; RV32FINX-LABEL: constraint_cr_float:
; RV32FINX:       # %bb.0:
; RV32FINX-NEXT:    lui a1, %hi(gf)
; RV32FINX-NEXT:    lw a1, %lo(gf)(a1)
; RV32FINX-NEXT:    #APP
; RV32FINX-NEXT:    fadd.s a0, a0, a1
; RV32FINX-NEXT:    #NO_APP
; RV32FINX-NEXT:    ret
;
; RV64FINX-LABEL: constraint_cr_float:
; RV64FINX:       # %bb.0:
; RV64FINX-NEXT:    lui a1, %hi(gf)
; RV64FINX-NEXT:    lw a1, %lo(gf)(a1)
; RV64FINX-NEXT:    #APP
; RV64FINX-NEXT:    fadd.s a0, a0, a1
; RV64FINX-NEXT:    #NO_APP
; RV64FINX-NEXT:    ret
  %1 = load float, ptr @gf
  %2 = tail call float asm "fadd.s $0, $1, $2", "=^cr,cr,cr"(float %a, float %1)
  ret float %2
}

define float @constraint_float_abi_name(float %a) nounwind {
; RV32FINX-LABEL: constraint_float_abi_name:
; RV32FINX:       # %bb.0:
; RV32FINX-NEXT:    addi sp, sp, -16
; RV32FINX-NEXT:    sw s0, 12(sp) # 4-byte Folded Spill
; RV32FINX-NEXT:    lui a1, %hi(gf)
; RV32FINX-NEXT:    lw s0, %lo(gf)(a1)
; RV32FINX-NEXT:    # kill: def $x10_w killed $x10_w def $x10
; RV32FINX-NEXT:    #APP
; RV32FINX-NEXT:    fadd.s t0, a0, s0
; RV32FINX-NEXT:    #NO_APP
; RV32FINX-NEXT:    mv a0, t0
; RV32FINX-NEXT:    lw s0, 12(sp) # 4-byte Folded Reload
; RV32FINX-NEXT:    addi sp, sp, 16
; RV32FINX-NEXT:    ret
;
; RV64FINX-LABEL: constraint_float_abi_name:
; RV64FINX:       # %bb.0:
; RV64FINX-NEXT:    addi sp, sp, -16
; RV64FINX-NEXT:    sd s0, 8(sp) # 8-byte Folded Spill
; RV64FINX-NEXT:    lui a1, %hi(gf)
; RV64FINX-NEXT:    lw s0, %lo(gf)(a1)
; RV64FINX-NEXT:    # kill: def $x10_w killed $x10_w def $x10
; RV64FINX-NEXT:    #APP
; RV64FINX-NEXT:    fadd.s t0, a0, s0
; RV64FINX-NEXT:    #NO_APP
; RV64FINX-NEXT:    mv a0, t0
; RV64FINX-NEXT:    ld s0, 8(sp) # 8-byte Folded Reload
; RV64FINX-NEXT:    addi sp, sp, 16
; RV64FINX-NEXT:    ret
  %1 = load float, ptr @gf
  %2 = tail call float asm "fadd.s $0, $1, $2", "={t0},{a0},{s0}"(float %a, float %1)
  ret float %2
}

define float @constraint_f_float(float %a) nounwind {
; RV32FINX-LABEL: constraint_f_float:
; RV32FINX:       # %bb.0:
; RV32FINX-NEXT:    lui a1, %hi(gf)
; RV32FINX-NEXT:    lw a1, %lo(gf)(a1)
; RV32FINX-NEXT:    #APP
; RV32FINX-NEXT:    fadd.s a0, a0, a1
; RV32FINX-NEXT:    #NO_APP
; RV32FINX-NEXT:    ret
;
; RV64FINX-LABEL: constraint_f_float:
; RV64FINX:       # %bb.0:
; RV64FINX-NEXT:    lui a1, %hi(gf)
; RV64FINX-NEXT:    lw a1, %lo(gf)(a1)
; RV64FINX-NEXT:    #APP
; RV64FINX-NEXT:    fadd.s a0, a0, a1
; RV64FINX-NEXT:    #NO_APP
; RV64FINX-NEXT:    ret
  %1 = load float, ptr @gf
  %2 = tail call float asm "fadd.s $0, $1, $2", "=f,f,f"(float %a, float %1)
  ret float %2
}

define float @constraint_cf_float(float %a) nounwind {
; RV32FINX-LABEL: constraint_cf_float:
; RV32FINX:       # %bb.0:
; RV32FINX-NEXT:    lui a1, %hi(gf)
; RV32FINX-NEXT:    lw a1, %lo(gf)(a1)
; RV32FINX-NEXT:    #APP
; RV32FINX-NEXT:    fadd.s a0, a0, a1
; RV32FINX-NEXT:    #NO_APP
; RV32FINX-NEXT:    ret
;
; RV64FINX-LABEL: constraint_cf_float:
; RV64FINX:       # %bb.0:
; RV64FINX-NEXT:    lui a1, %hi(gf)
; RV64FINX-NEXT:    lw a1, %lo(gf)(a1)
; RV64FINX-NEXT:    #APP
; RV64FINX-NEXT:    fadd.s a0, a0, a1
; RV64FINX-NEXT:    #NO_APP
; RV64FINX-NEXT:    ret
  %1 = load float, ptr @gf
  %2 = tail call float asm "fadd.s $0, $1, $2", "=^cf,cf,cf"(float %a, float %1)
  ret float %2
}
