/*
  Copyright Dave Bone 1998 - 2014 
  All Rights Reserved. 
  No part of this document may be reproduced without written consent from the author.
	
FILE:		  T_enum_phrase.lex
Dates:		  15 Mar 2004
Purpose:	  T-enumeration construct
              Monolithic grammar that launches its thread.
              Properly handles threads and errors. Starts
              from a procedure using another parser's
              token stream from a specific point.
Note: Use of ||| |+| phrase to catch other returned terminals 
      or errors. In this case, it is errors. 
      One can be selective within various contexts:
         1) within arbitration
         2) sub-rule level
      The symbol's enumerated id is the fodder to filter on.
Grammar being parsed:
T-enumeration       
(file-name yacco2_T_enumeration
,name-space NS_yacco2_T_enum) 
  zero-or-one { constant-defs ...C++ constant declarations ... *** }
*/
/@
@i "/yacco2/copyright.w"
@** |T_enum_phrase| grammar.\fbreak
Dispatcher to parse T-enumeration construct.\fbreak
Note: Use of \PARshift{} \QUEshift{} phrase to catch 
other returned terminals
or errors from called threads. 
In this case, it is errors so its r\^aison d'\^etre instead of
\ALLshift{} as a ``catch all''. 
One can be selective within various contexts:\fbreak
\INDENT{.5in}{1) within arbitration}
\INDENT{.5in}{2) sub-rule level}
The symbol's enumerated id is the fodder to filter on.
 @/
fsm	
(fsm-id "T_enum_phrase.lex"
,fsm-filename T_enum_phrase
,fsm-namespace NS_T_enum_phrase
,fsm-class CT_enum_phrase{
  user-prefix-declaration
#include "T_enum_phrase_th.h"
#include "o2_externs.h"
  ***
  user-declaration
   public: yacco2::AST* cweb_marker__;
  ***
  op
   if(CWEB_MARKER != 0){
     cweb_marker__ = CWEB_MARKER;
     CWEB_MARKER=0;
   }
  ***
  constructor
   cweb_marker__ = 0;
  ***
}
,fsm-version "1.0",fsm-date "18 mar 2004",fsm-debug "false"
,fsm-comments "Dispatcher to parse T-enumeration construct.")
@"/yacco2/compiler/grammars/yacco2_T_includes.T"

rules{
RT_enum_phrase (){
  -> Rphrase
}

Rphrase (){
  ->  ||| "T-enum-phrase" 
      NS_T_enum_phrase_th::TH_T_enum_phrase_th {
  op
    ADD_TOKEN_TO_PRODUCER_QUEUE(*sf->p2__);
  ***
  } 
  ->  ||| |?| NULL {
  op
    ADD_TOKEN_TO_ERROR_QUEUE(*sf->p2__);
  ***
  }
  ->  |?| { // error due to no first set to start thread
  op
    CAbs_lr1_sym* sym = new Err_no_open_parenthesis;
    sym->set_rc(*rule_info__.parser__->current_token(),__FILE__,__LINE__);
    ADD_TOKEN_TO_ERROR_QUEUE(*sym);
  ***
  }
}
}// end of rules
