% This file is part of CWEB.
% This program by Silvio Levy is based on a program by D. E. Knuth.
% ANSI-C conforming changes and Turbo-C++ implementation are made by
% Hans-Hermann Bode.
% The program is distributed WITHOUT ANY WARRANTY, express or implied.
% Version 2.1 -- Don Knuth, January 1992
% Version 2.1 [p5] --- Hans-Hermann Bode, July 1992
% Version 2.1 [p5a] --- Klaus Guntermann, July 1992
% Version 2.1 [p5b] --- Hans-Hermann Bode, July 1992
% Version 2.1 [p6] --- Hans-Hermann Bode, September 1992

% Copyright (C) 1987,1990 Silvio Levy and Donald E. Knuth

% Changes conforming to ANSI C and Turbo C++ are
% Copyright (C) 1991, 1992 Hans-Hermann Bode
% See the changefile COMMON.HCH for more information.

% Permission is granted to make and distribute verbatim copies of this
% document provided that the copyright notice and this permission notice
% are preserved on all copies.

% Permission is granted to copy and distribute modified versions of this
% document under the conditions for verbatim copying, provided that the
% entire resulting derived work is distributed under the terms of a
% permission notice identical to this one.

% Please send comments, suggestions, etc. to levy@@math.berkeley.edu.

% The next few sections contain stuff from the file |"common.w"| that has
% to be included in both |"tangle.w"| and |"weave.w"|. It appears in this
% file |"common.h"|, which needs to be updated when |"common.w"| changes.

First comes general stuff.
In {\mc Turbo~C}, we use |huge| pointers instead of large arrays.

@d tangle 0
@d weave 1
@#
@f far int
@f huge int
@f HUGE int
@^system dependencies@>

@<Common code for \.{WEAVE} and \.{TANGLE}@>=
typedef short boolean;
typedef char unsigned eight_bits;
extern boolean program; /* \.{WEAVE} or \.{TANGLE}? */
extern int phase; /* which phase are we in? */
extern void common_init(void);
extern void print_stats(void);
#ifdef __TURBOC__
#define HUGE huge
#else
#define HUGE
#endif

@ @<Include files@>=
#include <stdio.h>
#ifdef __TURBOC__
#include <io.h>
#endif

@ Code related to the character set:
@^ASCII code dependencies@>

@d and_and 04 /* `\.{\&\&}'; this corresponds to MIT's {\tentex\char'4} */
@d lt_lt 020 /* `\.{<<}';  this corresponds to MIT's {\tentex\char'20} */
@d gt_gt 021 /* `\.{>>}';  this corresponds to MIT's {\tentex\char'21} */
@d plus_plus 013 /* `\.{++}';  this corresponds to MIT's {\tentex\char'13} */
@d minus_minus 01 /* `\.{--}';  this corresponds to MIT's {\tentex\char'1} */
@d minus_gt 031 /* `\.{->}';  this corresponds to MIT's {\tentex\char'31} */
@d not_eq 032 /* `\.{!=}';  this corresponds to MIT's {\tentex\char'32} */
@d lt_eq 034 /* `\.{<=}';  this corresponds to MIT's {\tentex\char'34} */
@d gt_eq 035 /* `\.{>=}';  this corresponds to MIT's {\tentex\char'35} */
@d eq_eq 036 /* `\.{==}';  this corresponds to MIT's {\tentex\char'36} */
@d or_or 037 /* `\.{\v\v}';  this corresponds to MIT's {\tentex\char'37} */
@d colon_colon 06 /* `\.{::}';  this corresponds to MIT's {\tentex\char'6} */
@d period_ast 026 /* `\.{.*}';  this corresponds to MIT's {\tentex\char'26} */
@d minus_gt_ast 027 /* `\.{->*}';  this corresponds to MIT's {\tentex\char'27}
    */
@d dot_dot_dot 016 /* `\.{...}';  this corresponds to MIT's {\tentex\char'16}
    */

@<Common code...@>=
char mod_text[longest_name+1]; /* name being sought for */
char *mod_text_end = mod_text+longest_name; /* end of |mod_text| */
char *id_first; /* where the current identifier begins in the buffer */
char *id_loc; /* just after the current identifier in the buffer */

@ Code related to input routines:

@<Common code...@>=
extern char buffer[]; /* where each line of input goes */
extern char *buffer_end; /* end of |buffer| */
extern char *loc; /* points to the next character to be read from the buffer*/
extern char *limit; /* points to the last character in the buffer */

@ Code related to identifier and module name storage:
@d length(c) (c+1)->byte_start-(c)->byte_start /* the length of a name */
@d print_id(c) term_write((c)->byte_start,length((c)))
  /* print identifier or module name */
@d llink link /* left link in binary search tree for module names */
@d rlink dummy.Rlink /* right link in binary search tree for module names */
@d root name_dir->rlink /* the root of the binary search tree
  for module names */

@<Common code...@>=
typedef struct name_info {
  char HUGE *byte_start; /* beginning of the name in |byte_mem| */
  struct name_info HUGE *link;
  union {
    struct name_info HUGE *Rlink; /* right link in binary search tree for module
      names */
    char Ilk; /* used by identifiers in \.{WEAVE} only */
  } dummy;
  char HUGE *equiv_or_xref; /* info corresponding to names */
} name_info; /* contains information about an identifier or module name */
typedef name_info HUGE *name_pointer; /* pointer into array of |name_info|s */
typedef name_pointer *hash_pointer;
#ifdef __TURBOC__
extern char HUGE *byte_mem; /* characters of names */
extern name_info HUGE *name_dir; /* information about names */
#else
extern char byte_mem[]; /* characters of names */
extern name_info name_dir[]; /* information about names */
#endif
extern char HUGE *byte_mem_end; /* end of |byte_mem| */
extern name_pointer name_dir_end; /* end of |name_dir| */
extern name_pointer name_ptr; /* first unused position in |byte_start| */
extern char HUGE *byte_ptr; /* first unused position in |byte_mem| */
#ifdef __TURBOC__
void far *allocsafe(unsigned long nunits,unsigned long unitsz);
#endif
extern name_pointer hash[]; /* heads of hash lists */
extern hash_pointer hash_end; /* end of |hash| */
extern hash_pointer h; /* index into hash-head array */
extern name_pointer id_lookup(char *first,char *last,char t);
	/* looks up a string in the identifier table */
extern name_pointer mod_lookup(char *k,char *l); /* finds module name */
extern name_pointer prefix_lookup(char *k,char *l); /* finds module name given a prefix */
extern boolean names_match(name_pointer p, char *first, int l, eight_bits t);
extern void init_p(name_pointer p, eight_bits t);
extern void init_node(name_pointer p);

@ Code related to error handling:
@d spotless 0 /* |history| value for normal jobs */
@d harmless_message 1 /* |history| value when non-serious info was printed */
@d error_message 2 /* |history| value when an error was noted */
@d fatal_message 3 /* |history| value when we had to stop prematurely */
@d mark_harmless {if (history==spotless) history=harmless_message;}
@d mark_error history=error_message
@d confusion(s) fatal("! This can't happen: ",s)
@d fatal(s,t) {
  printf(s); err_print(t);
  history=fatal_message; wrap_up();
}
@d overflow(t) {
  printf("\n! Sorry, %s capacity exceeded",t); fatal("","");
}

@<Common...@>=
extern history; /* indicates how bad this run was */
extern void err_print(char *s); /* prints error message and context */
extern void wrap_up(void); /* indicate |history| and exit */

@ Code related to file handling:
@f line x /* make |line| an unreserved word */
@d max_file_name_length 60
@d cur_file file[include_depth] /* current file */
@d cur_file_name file_name[include_depth] /* current file name */
@d web_file_name file_name[0] /* main source file name */
@d cur_line line[include_depth] /* number of current line in current file */

@<Common code...@>=
extern include_depth; /* current level of nesting */
extern FILE *file[]; /* stack of non-change files */
extern FILE *change_file; /* change file */
extern char C_file_name[]; /* name of |C_file| */
extern char tex_file_name[]; /* name of |tex_file| */
extern char file_name[][max_file_name_length];
  /* stack of non-change file names */
extern char change_file_name[]; /* name of change file */
extern line[]; /* number of current line in the stacked files */
extern change_line; /* number of current line in change file */
extern boolean input_has_ended; /* if there is no more input */
extern boolean changing; /* if the current line is from |change_file| */
extern boolean web_file_open; /* if the web file is being read */
extern void reset_input(void); /* initialize to read the web file and change file */
extern boolean get_line(void); /* inputs the next line */
extern void check_complete(void); /* checks that all changes were picked up */

@ Code related to module numbers:
@<Common code...@>=
typedef unsigned short sixteen_bits;
extern sixteen_bits module_count; /* the current module number */
extern boolean changed_module[]; /* is the module changed? */
extern boolean change_pending; /* is a decision about change still unclear? */
extern boolean print_where; /* tells \.{TANGLE} to print line and file info */

@ Code related to command line arguments:
@d show_banner flags['b'] /* should the banner line be printed? */
@d show_progress flags['p'] /* should progress reports be printed? */
@d show_happiness flags['h'] /* should lack of errors be announced? */

@<Common code...@>=
extern int argc; /* copy of |ac| parameter to |main| */
extern char **argv; /* copy of |av| parameter to |main| */
extern boolean flags[]; /* an option for each 8-bit code */

@ Code relating to output:
@d update_terminal fflush(stdout) /* empty the terminal output buffer */
@d new_line putchar('\n') @d putxchar putchar
@d term_write(a,b) fflush(stdout), write(1,a,b) /* write on the standard output */
@d line_write(c) write(fileno(C_file),c) /* write on the C output file */
@d C_printf(c,a) fprintf(C_file,c,a)
@d C_putc(c) putc(c,C_file)

@<Common code...@>=
extern FILE *C_file; /* where output of \.{TANGLE} goes */
extern FILE *tex_file; /* where output of \.{WEAVE} goes */
