/*
 * Decompiled with CFR 0.152.
 */
package korlibs.io.lang;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import korlibs.io.lang.Charset;
import korlibs.io.lang.CharsetKt;
import korlibs.io.lang.StringExtKt;
import korlibs.io.lang.UTF8Kt;
import korlibs.io.util.NumberExtKt;
import korlibs.io.util.StringEscapeKt;
import korlibs.memory.ByteArrayBuilder;
import korlibs.memory.NumbersKt;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.ranges.IntRange;
import kotlin.text.CharsKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0084\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\f\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u001a\"\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u000f\u001a\"\u0010\u0011\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u00122\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u000f\u001a0\u0010\u0013\u001a\u00020\b*\u00020\b2!\u0010\u0014\u001a\u001d\u0012\b\u0012\u00060\u0016j\u0002`\u0017\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\u0015\u00a2\u0006\u0002\b\u001aH\u0086\b\u001a#\u0010\u001b\u001a\u00020\b*\u00020\b2\u0012\u0010\u001c\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001e0\u001d\"\u00020\u001e\u00a2\u0006\u0002\u0010\u001f\u001a#\u0010 \u001a\u0004\u0018\u00010\u000f*\u00020\b2\u0006\u0010!\u001a\u00020\u00182\b\b\u0002\u0010\"\u001a\u00020\u000f\u00a2\u0006\u0002\u0010#\u001a)\u0010$\u001a\u00020\b*\u00020%2\u0006\u0010\f\u001a\u00020\u00122\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u000fH\u0086\u0002\u001a#\u0010&\u001a\u0004\u0018\u00010\u000f*\u00020\b2\u0006\u0010!\u001a\u00020\u00182\b\b\u0002\u0010\"\u001a\u00020\u000f\u00a2\u0006\u0002\u0010#\u001a\n\u0010'\u001a\u00020\u000f*\u00020\b\u001a\u0014\u0010(\u001a\u00020\b*\u00020\b2\b\b\u0002\u0010)\u001a\u00020\b\u001a\u0018\u0010*\u001a\b\u0012\u0004\u0012\u00020\b0+*\u00020\b2\u0006\u0010\u0010\u001a\u00020\u000f\u001a\u0018\u0010,\u001a\b\u0012\u0004\u0012\u00020\b0+*\u00020\b2\u0006\u0010-\u001a\u00020\u0001\u001a\u0012\u0010.\u001a\u00020\b*\u00020\b2\u0006\u0010/\u001a\u00020\u000f\u001a\u001a\u0010.\u001a\u00020\b*\u00020\b2\u0006\u0010/\u001a\u00020\u000f2\u0006\u00100\u001a\u00020\u000f\u001a2\u00101\u001a\u000202*\u00020%2\u0006\u00103\u001a\u00020\b2\u0006\u00104\u001a\u00020\u000f2\u0006\u00105\u001a\u00020\b2\u0006\u00106\u001a\u00020\u000f2\u0006\u00107\u001a\u00020\u000f\u001a\u0014\u00108\u001a\u000209*\u00020\b2\b\b\u0002\u0010:\u001a\u00020;\u001a\u001c\u00108\u001a\u000209*\u00020\b2\u0006\u0010<\u001a\u00020\u000f2\b\b\u0002\u0010:\u001a\u00020;\u001a\n\u0010=\u001a\u00020\r*\u00020\b\u001a!\u0010\u0014\u001a\u00020\b*\u00020\b2\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\b0>H\u0086\b\u001a\u001a\u0010?\u001a\u00020\b*\u00020\b2\u0006\u0010@\u001a\u00020\u000f2\u0006\u0010A\u001a\u00020\b\u001a\u0012\u0010B\u001a\u00020\b*\u00020\b2\u0006\u0010@\u001a\u00020\u000f\u001a\u0012\u0010C\u001a\u00020\b*\u00020\b2\u0006\u0010D\u001a\u00020E\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001b\u0010\u0002\u001a\u00020\u00018BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0015\u0010\u0007\u001a\u00020\b*\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006F"}, d2={"formatRegex", "Lkotlin/text/Regex;", "replaceNonPrintableCharactersRegex", "getReplaceNonPrintableCharactersRegex", "()Lkotlin/text/Regex;", "replaceNonPrintableCharactersRegex$delegate", "Lkotlin/Lazy;", "quoted", "", "getQuoted", "(Ljava/lang/String;)Ljava/lang/String;", "String_fromCharArray", "arrays", "", "offset", "", "size", "String_fromIntArray", "", "eachBuilder", "transform", "Lkotlin/Function2;", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "", "", "Lkotlin/ExtensionFunctionType;", "format", "params", "", "", "(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;", "indexOfOrNull", "char", "startIndex", "(Ljava/lang/String;CI)Ljava/lang/Integer;", "invoke", "Lkotlin/String$Companion;", "lastIndexOfOrNull", "parseInt", "replaceNonPrintableCharacters", "replacement", "splitInChunks", "", "splitKeep", "regex", "substr", "start", "length", "substringEquals", "", "a", "aIndex", "b", "bIndex", "count", "toBytez", "", "charset", "Lkorlibs/io/lang/Charset;", "len", "toCharArray", "Lkotlin/Function1;", "withInsertion", "index", "insertedText", "withoutIndex", "withoutRange", "range", "Lkotlin/ranges/IntRange;", "korio"})
@SourceDebugExtension(value={"SMAP\nStringExt.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StringExt.kt\nkorlibs/io/lang/StringExtKt\n+ 2 ByteArrayBuilder.kt\nkorlibs/memory/ByteArrayBuilder\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,151:1\n59#2,2:152\n59#2,2:154\n1#3:156\n*S KotlinDebug\n*F\n+ 1 StringExt.kt\nkorlibs/io/lang/StringExtKt\n*L\n80#1:152,2\n87#1:154,2\n*E\n"})
public final class StringExtKt {
    @NotNull
    private static final Regex formatRegex = new Regex("%([-]?\\d+)?(\\w)");
    @NotNull
    private static final Lazy replaceNonPrintableCharactersRegex$delegate = LazyKt.lazy(replaceNonPrintableCharactersRegex.2.INSTANCE);

    @NotNull
    public static final String invoke(@NotNull StringCompanionObject $this$invoke, @NotNull int[] arrays, int offset, int size2) {
        StringBuilder sb = new StringBuilder();
        int n = offset + size2;
        for (int n2 = offset; n2 < n; ++n2) {
            sb.append((char)arrays[n2]);
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    public static /* synthetic */ String invoke$default(StringCompanionObject stringCompanionObject, int[] nArray, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = nArray.length - n;
        }
        return StringExtKt.invoke(stringCompanionObject, nArray, n, n2);
    }

    @NotNull
    public static final String String_fromIntArray(@NotNull int[] arrays, int offset, int size2) {
        return StringExtKt.invoke(StringCompanionObject.INSTANCE, arrays, offset, size2);
    }

    public static /* synthetic */ String String_fromIntArray$default(int[] nArray, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = nArray.length - n;
        }
        return StringExtKt.String_fromIntArray(nArray, n, n2);
    }

    @NotNull
    public static final String String_fromCharArray(@NotNull char[] arrays, int offset, int size2) {
        return StringsKt.concatToString(arrays, offset, offset + size2);
    }

    public static /* synthetic */ String String_fromCharArray$default(char[] cArray, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = cArray.length - n;
        }
        return StringExtKt.String_fromCharArray(cArray, n, n2);
    }

    @NotNull
    public static final String format(@NotNull String $this$format, Object ... params) {
        Ref.IntRef paramIndex = new Ref.IntRef();
        return formatRegex.replace((CharSequence)$this$format, (Function1<? super MatchResult, ? extends CharSequence>)new Function1<MatchResult, CharSequence>(params, paramIndex){
            final /* synthetic */ Object[] $params;
            final /* synthetic */ Ref.IntRef $paramIndex;
            {
                this.$params = $params;
                this.$paramIndex = $paramIndex;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull MatchResult mr) {
                String string;
                String type;
                int n = this.$paramIndex.element;
                this.$paramIndex.element = n + 1;
                Object param = this.$params[n];
                String size2 = mr.getGroupValues().get(1);
                switch (type = mr.getGroupValues().get(2)) {
                    case "d": {
                        Intrinsics.checkNotNull(param, "null cannot be cast to non-null type kotlin.Number");
                        string = String.valueOf(((Number)param).longValue());
                        break;
                    }
                    case "X": 
                    case "x": {
                        String res;
                        String string2;
                        if (param instanceof Integer) {
                            string2 = NumberExtKt.toStringUnsigned(((Number)param).intValue(), 16);
                        } else {
                            Intrinsics.checkNotNull(param, "null cannot be cast to non-null type kotlin.Number");
                            string2 = res = NumberExtKt.toStringUnsigned(((Number)param).longValue(), 16);
                        }
                        if (Intrinsics.areEqual(type, "X")) {
                            String string3 = res.toUpperCase();
                            string = string3;
                            Intrinsics.checkNotNullExpressionValue(string3, "this as java.lang.String).toUpperCase()");
                            break;
                        }
                        String string4 = res.toLowerCase();
                        string = string4;
                        Intrinsics.checkNotNullExpressionValue(string4, "this as java.lang.String).toLowerCase()");
                        break;
                    }
                    default: {
                        string = String.valueOf(param);
                    }
                }
                String str = string;
                char prefix = StringsKt.startsWith$default((CharSequence)size2, '0', false, 2, null) ? (char)'0' : ' ';
                Integer asize = StringsKt.toIntOrNull(size2);
                String str2 = str;
                if (asize != null) {
                    while (str2.length() < asize) {
                        char c = prefix;
                        str2 = c + str2;
                    }
                }
                return str2;
            }
        });
    }

    @NotNull
    public static final List<String> splitKeep(@NotNull String $this$splitKeep, @NotNull Regex regex) {
        String str = $this$splitKeep;
        ArrayList out = new ArrayList();
        int lastPos = 0;
        Iterator iterator2 = Regex.findAll$default(regex, $this$splitKeep, 0, 2, null).iterator();
        while (iterator2.hasNext()) {
            MatchResult part = (MatchResult)iterator2.next();
            IntRange prange = part.getRange();
            if (lastPos != prange.getStart()) {
                Collection collection = out;
                String string = str.substring(lastPos, prange.getStart());
                Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String\u2026ing(startIndex, endIndex)");
                collection.add(string);
            }
            ((Collection)out).add(StringsKt.substring(str, prange));
            lastPos = prange.getEndInclusive() + 1;
        }
        if (lastPos != str.length()) {
            Collection collection = out;
            String string = str.substring(lastPos);
            Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String).substring(startIndex)");
            collection.add(string);
        }
        return out;
    }

    private static final Regex getReplaceNonPrintableCharactersRegex() {
        Lazy lazy = replaceNonPrintableCharactersRegex$delegate;
        return (Regex)lazy.getValue();
    }

    @NotNull
    public static final String replaceNonPrintableCharacters(@NotNull String $this$replaceNonPrintableCharacters, @NotNull String replacement) {
        CharSequence charSequence = $this$replaceNonPrintableCharacters;
        return StringExtKt.getReplaceNonPrintableCharactersRegex().replace(charSequence, replacement);
    }

    public static /* synthetic */ String replaceNonPrintableCharacters$default(String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = "?";
        }
        return StringExtKt.replaceNonPrintableCharacters(string, string2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final byte[] toBytez(@NotNull String $this$toBytez, int len, @NotNull Charset charset) {
        ByteArrayBuilder out = new ByteArrayBuilder(0, 1, null);
        ByteArrayBuilder.append$default(out, CharsetKt.toByteArray$default($this$toBytez, charset, 0, 0, 6, null), 0, 0, 6, null);
        while (out.getSize() < len) {
            void this_$iv;
            ByteArrayBuilder byteArrayBuilder = out;
            byte v$iv = 0;
            boolean $i$f$append = false;
            this_$iv.appendFast(v$iv);
        }
        return out.toByteArray();
    }

    public static /* synthetic */ byte[] toBytez$default(String string, int n, Charset charset, int n2, Object object) {
        if ((n2 & 2) != 0) {
            charset = UTF8Kt.getUTF8();
        }
        return StringExtKt.toBytez(string, n, charset);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final byte[] toBytez(@NotNull String $this$toBytez, @NotNull Charset charset) {
        void this_$iv;
        ByteArrayBuilder out = new ByteArrayBuilder(0, 1, null);
        ByteArrayBuilder.append$default(out, CharsetKt.toByteArray$default($this$toBytez, charset, 0, 0, 6, null), 0, 0, 6, null);
        ByteArrayBuilder byteArrayBuilder = out;
        byte v$iv = 0;
        boolean $i$f$append = false;
        this_$iv.appendFast(v$iv);
        return out.toByteArray();
    }

    public static /* synthetic */ byte[] toBytez$default(String string, Charset charset, int n, Object object) {
        if ((n & 1) != 0) {
            charset = UTF8Kt.getUTF8();
        }
        return StringExtKt.toBytez(string, charset);
    }

    @Nullable
    public static final Integer indexOfOrNull(@NotNull String $this$indexOfOrNull, char c, int startIndex) {
        Integer n = StringsKt.indexOf$default((CharSequence)$this$indexOfOrNull, c, startIndex, false, 4, null);
        int it = ((Number)n).intValue();
        boolean bl = false;
        return it >= 0 ? n : null;
    }

    public static /* synthetic */ Integer indexOfOrNull$default(String string, char c, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return StringExtKt.indexOfOrNull(string, c, n);
    }

    @Nullable
    public static final Integer lastIndexOfOrNull(@NotNull String $this$lastIndexOfOrNull, char c, int startIndex) {
        Integer n = StringsKt.lastIndexOf$default((CharSequence)$this$lastIndexOfOrNull, c, startIndex, false, 4, null);
        int it = ((Number)n).intValue();
        boolean bl = false;
        return it >= 0 ? n : null;
    }

    public static /* synthetic */ Integer lastIndexOfOrNull$default(String string, char c, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = StringsKt.getLastIndex(string);
        }
        return StringExtKt.lastIndexOfOrNull(string, c, n);
    }

    @NotNull
    public static final List<String> splitInChunks(@NotNull String $this$splitInChunks, int size2) {
        ArrayList out = new ArrayList();
        for (int pos = 0; pos < $this$splitInChunks.length(); pos += size2) {
            Collection collection = out;
            String string = $this$splitInChunks.substring(pos, Math.min($this$splitInChunks.length(), pos + size2));
            Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String\u2026ing(startIndex, endIndex)");
            collection.add(string);
        }
        return out;
    }

    @NotNull
    public static final String substr(@NotNull String $this$substr, int start) {
        return StringExtKt.substr($this$substr, start, $this$substr.length());
    }

    @NotNull
    public static final String substr(@NotNull String $this$substr, int start, int length) {
        String string;
        int low = NumbersKt.clamp(start >= 0 ? start : $this$substr.length() + start, 0, $this$substr.length());
        int high = NumbersKt.clamp(length >= 0 ? low + length : $this$substr.length() + length, 0, $this$substr.length());
        if (high >= low) {
            String string2 = $this$substr.substring(low, high);
            string = string2;
            Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String\u2026ing(startIndex, endIndex)");
        } else {
            string = "";
        }
        return string;
    }

    @NotNull
    public static final String eachBuilder(@NotNull String $this$eachBuilder, @NotNull Function2<? super StringBuilder, ? super Character, Unit> transform2) {
        StringBuilder stringBuilder;
        boolean $i$f$eachBuilder = false;
        StringBuilder $this$eachBuilder_u24lambda_u242 = stringBuilder = new StringBuilder();
        boolean bl = false;
        int n = $this$eachBuilder.length();
        for (int n2 = 0; n2 < n; ++n2) {
            transform2.invoke($this$eachBuilder_u24lambda_u242, Character.valueOf($this$eachBuilder.charAt(n2)));
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "StringBuilder().apply(builderAction).toString()");
        return string;
    }

    @NotNull
    public static final String transform(@NotNull String $this$transform, @NotNull Function1<? super Character, String> transform2) {
        StringBuilder stringBuilder;
        boolean $i$f$transform = false;
        StringBuilder $this$transform_u24lambda_u243 = stringBuilder = new StringBuilder();
        boolean bl = false;
        int n = $this$transform.length();
        for (int n2 = 0; n2 < n; ++n2) {
            $this$transform_u24lambda_u243.append(transform2.invoke(Character.valueOf($this$transform.charAt(n2))));
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "StringBuilder().apply(builderAction).toString()");
        return string;
    }

    public static final int parseInt(@NotNull String $this$parseInt) {
        int n;
        if (StringsKt.startsWith($this$parseInt, "0x", true)) {
            String string = $this$parseInt.substring(2);
            Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String).substring(startIndex)");
            n = (int)Long.parseLong(string, CharsKt.checkRadix(16));
        } else if (StringsKt.startsWith($this$parseInt, "0o", true)) {
            String string = $this$parseInt.substring(2);
            Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String).substring(startIndex)");
            n = (int)Long.parseLong(string, CharsKt.checkRadix(8));
        } else if (StringsKt.startsWith($this$parseInt, "0b", true)) {
            String string = $this$parseInt.substring(2);
            Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String).substring(startIndex)");
            n = (int)Long.parseLong(string, CharsKt.checkRadix(2));
        } else {
            n = Integer.parseInt($this$parseInt);
        }
        return n;
    }

    @NotNull
    public static final String getQuoted(@NotNull String $this$quoted) {
        return StringEscapeKt.quote($this$quoted);
    }

    @NotNull
    public static final char[] toCharArray(@NotNull String $this$toCharArray) {
        int n = 0;
        int n2 = $this$toCharArray.length();
        char[] cArray = new char[n2];
        while (n < n2) {
            int n3 = n++;
            cArray[n3] = $this$toCharArray.charAt(n3);
        }
        return cArray;
    }

    @NotNull
    public static final String withoutRange(@NotNull String $this$withoutRange, @NotNull IntRange range) {
        return StringExtKt.substr($this$withoutRange, 0, range.getFirst()) + StringExtKt.substr($this$withoutRange, range.getLast() + 1);
    }

    @NotNull
    public static final String withoutIndex(@NotNull String $this$withoutIndex, int index) {
        return StringExtKt.substr($this$withoutIndex, 0, index) + StringExtKt.substr($this$withoutIndex, index + 1);
    }

    @NotNull
    public static final String withInsertion(@NotNull String $this$withInsertion, int index, @NotNull String insertedText) {
        String before = StringExtKt.substr($this$withInsertion, 0, index);
        String after = StringExtKt.substr($this$withInsertion, index, $this$withInsertion.length());
        return before + insertedText + after;
    }

    public static final boolean substringEquals(@NotNull StringCompanionObject $this$substringEquals, @NotNull String a, int aIndex, @NotNull String b, int bIndex, int count2) {
        if (count2 == 0) {
            return true;
        }
        if (aIndex < 0 || bIndex < 0) {
            return false;
        }
        if (aIndex + count2 > a.length()) {
            return false;
        }
        if (bIndex + count2 > b.length()) {
            return false;
        }
        for (int n = 0; n < count2; ++n) {
            if (a.charAt(aIndex + n) == b.charAt(bIndex + n)) continue;
            return false;
        }
        return true;
    }
}

