/*
 * Font definitions.
 *
 * Both halves of the Symbol fonts are assumed always to be used in
 * math mode, while the others are assumed _not_ to be in math mode
 * unless the first character is a $ (which is discarded).
 *
 * I have invented a few TeX definitions, namely:
 *	\def\therefore{}		% three dots in a triangle
 *	\def\pound/{{\it\$\/}}		% Pound Sterling
 *	\def\ppercent/{\%_\circ}	% ppm
 *	\def\reg/{}			% registered (R)
 *	\def\trade/{}			% Trade mark
 *	\def\yen/{}			% Yen symbol
 * Which are also in TeX_defs.tex
 */
typedef char *FONT[128];

/*****************************************************************************/
/*
 * This is the mac's Symbol font
 */
static FONT symbol = {
/* ^@ -- ^G */    "",		"",		"",		"",
		  "",		"",		"",		"",
/* ^H -- ^O */    "",		"",		"",		"",
		  "",		"",		"",		"",
/* ^P -- ^W */    "",		"",		"",		"",
		  "",		"",		"",		"",
/* ^X -- ^] */    "",		"",		"",		"",
		  "",		"",		"",		"",
/*  !"#$%&' */    " ",		"!",		"\\forall",	"\\#",
		  "\\exists",	"\\%",		"\\&",		"\\ni",
/* ()*+,-./ */    "(",		")",		"\\ast",	"+",
		  ",",		"-",		".",		"/",
/* 01234567 */    "0",		"1",		"2",		"3",
		  "4",		"5",		"6",		"7",
/* 89:;<=>? */    "8",		"9",		":",		";",
		  "<",		"=",		">",		"?",
/* @ABCDEFG */    "\\cong",	"A",		"B",		"\\Chi",
		  "\\Delta",	"E",		"\\Phi",	"\\Gamma",
/* HIJKLMNO */    "E",		"I",		"\\vartheta",	"K",
		  "\\Lambda",	"M",		"N",		"O",
/* PQRSTUVW */    "\\Pi",	"\\Theta",	"P",		"\\Sigma",
		  "T",		"Y",		"\\varsigma",	"\\Omega",
/* XYZ[\]^_ */    "\\Xi",	"\\Psi",	"Z",		"[",
		  "\\therefore", "]",		"\\bot",	"\\_",
/* `abcdefg */    "^{--}",	"\\alpha",	"\\beta",	"\\chi",
		  "\\delta",	"\\epsilon",	"\\phi",	"\\gamma",
/* hijklmno */    "\\eta",	"\\iota",	"\\varphi",	"\\kappa",
		  "\\lambda",	"\\mu",		"\\nu",		"\\omicron",
/* pqrstuvw */    "\\pi",	"\\theta",	"\\rho",	"\\sigma",
		  "\\tau",	"\\upsilon",	"\\varpi",	"\\omega",
/* xyz{|}~^? */   "\\xi",	"\\psi",	"\\zeta",	"\\{",
		  "|",		"\\}",		"\\sim",	" ",
};    

/*****************************************************************************/
/*
 * This is the high half of the mac Symbol font with the high bit stripped
 */
static FONT symbol8 = {
/* ^@ -- ^G */    "",		"",		"",		"",
		  "",		"",		"",		"",
/* ^H -- ^O */    "",		"",		"",		"",
		  "",		"",		"",		"",
/* ^P -- ^W */    "",		"",		"",		"",
		  "",		"",		"",		"",
/* ^X -- ^] */    "",		"",		"",		"",
		  "",		"",		"",		"",
/*  !"#$%&' */    " ",		"\\Upsilon",	"'",		"\\le",
		  "/",		"\\infty",	"f",		"\\clubsuit",
/* ()*+,-./ */    "\\diamondsuit", "\\heartsuit", "\\spadesuit",
		  					    "\\leftrightarrow",
		  "\\leftarrow", "\\uparrow",	"\\rightarrow",	"\\downarrow",
/* 01234567 */    "^\\circ",	"\\pm", 	"''",		"\\ge",
		  "\\times",	"\\propto",	"\\partial",	"\\bullet",
/* 89:;<=>? */    "\\div",	"\\ne",		"\\equiv",	"\\approx",
		  "\\dots",	"|",		"--",		"",
/* @ABCDEFG */    "\\aleph",	"\\Im",		"\\Re",		"\\wp",
		  "\\otimes",	"\\oplus",	"\\emptyset",	"\\cap",
/* HIJKLMNO */    "\\cup",	"\\supset",	"\\supseteq",  "\\not\\subset",
		  "\\subset",	"\\subseteq",	"\\in",		"\\not\\in",
/* PQRSTUVW */    "\\angle",	"\\nabla",	"\\reg/",	"\\copyright",
		  "\\trade/",	"\\prod",	"\\sqrt",	".",
/* XYZ[\]^_ */    "\\neg",	"\\wedge",	"\\vee",    "\\Leftrightarrow",
		  "\\Leftarrow", "\\Uparrow",	"\\Rightarrow",	"\\Downarrow",
/* `abcdefg */    "\\diamond",	"\\langle",	"\\reg/",	"\\copyright",
		  "\\trade/",	"\\sum",	"",		"",
/* hijklmno */    "",		"",		"",		"",
		  "",		"",		"",		"",
/* pqrstuvw */    "",		"\\rangle",	"\\int",	"",
		  "",		"",		"",		"",
/* xyz{|}~^? */   "",		"",		"",		"",
		  "",		"",		"",		" ",
};    

/*****************************************************************************/
/*
 * This is the high half of the mac Times or Helvetica font with
 * the high bit stripped. They are pretty similar to the
 * Chicago/NewYork/Geneva fonts, except that those fonts are less complete.
 */
static FONT times8 = {
/* ^@ -- ^G */    "\\\"{A}",	"\\AA{}",	"\\c{C}",	"\\'{E}",
		  "\\~{N}",	"\\\"{O}",	"\\\"{U}",	"\\'{a}",
/* ^H -- ^O */    "\\`{a}",	"\\^{a}",	"\\\"{a}",	"\\~{a}",
		  "\\aa{}",	"\\c{c}",	"\\'{e}",	"\\`{e}",
/* ^P -- ^W */    "\\^{e}",	"\\\"{e}",	"\\'{\\i}",	"\\`{\\i}",
		  "\\^{\\i}",	"\\\"{\\i}",	"\\~{n}",	"\\'{o}",
/* ^X -- ^] */    "\\`{o}",	"\\^{o}",	"\\\"{o}",	"\\~{o}",
		  "\\'{u}",	"\\`{u}",	"\\^{u}",	"\\\"{u}",
/*  !"#$%&' */    "\\dagger",	"$^\\circ",	"\\cents{}",	"\\pound/",
		  "\\S{}",	"$\\bullet",	"\\P{}",	"\\ss{}",
/* ()*+,-./ */    "\\reg/",	"\\copyright{}", "\\trade/",	"'",
		  "",		"$\\ne",	"\\AE{}",	"\\O{}",
/* 01234567 */    "$\\infty",	"$\\pm",	"$\\le",	"$\\ge",
		  "\\yen/",	"$\\mu",	"$\\partial",	"$\\Sigma",
/* 89:;<=>? */    "$\\Pi",	"$\\Pi",	"$\\int",	"\\b{a}",
		  "\\b{o}",	"$\\Omega",	"\\ae{}",	"\\o{}",
/* @ABCDEFG */    "?`",		"!'",		"\\neg",	"$\\sqrt",
		  "$f",		"$\\approx",	"$\\Delta",	"$\\ll",
/* HIJKLMNO */    "$\\gg",	"...",		" ",		"\\`{A}",
		  "\\~{A}",	"\\~{O}",	"\\OE{}",	"\\oe{}",
/* PQRSTUVW */    "--",		"---",		"``",		"''",
		  "`",		"'",		"$\\div",	"$\\diamond",
/* XYZ[\]^_ */    "\\\"{y}",	"\\\"{Y}",	"/",		"",
		  "$<",		"$>",		"fi",		"fl",
/* `abcdefg */    "\\ddagger{}", "$\\cdot",	",",		"''",
		  "$\\ppercent/", "\\^{A}",	"\\^{E}",	"\\'{A}",
/* hijklmno */    "\\\"{E}",	"\\`{E}",	"\\'{I}",	"\\^{I}",
		  "\\\"{I}",	"\\`{I}",	"\\'{O}",	"\\^{O}",
/* pqrstuvw */    "",		 "\\`{O}",	"\\'{U}",	"\\^{U}",
		  "\\`{U}",	"{\\oldstyle1}", "\\^{ }",	"\\~{ }",
/* xyz{|}~^? */   "\\={ }",	"\\u{ }",	"\\.{ }",	"",
		  "\\c{ }",	"\\H{ }",	"",		"\\v{ }",
};    
