/*
    REFERENCES -- bibliographic software
    Copyright (C) 1995-2007  Volker Kiefel

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
    USA
*/


#ifndef INTERF_H
#define INTERF_H

#define INPUT_BU_LEN 2048

#define VTXTLINE_LEN 80
#define VTXTFILELINE_LEN 32000

#define TEXTZEILE_LEN 62000L

#define ANHALTEN_PROMPTTEXT "Text editor with file(s) closed? Please continue with [ENTER]"

typedef struct 
{
   char screenline[VTXTLINE_LEN + 1];
} text_rec;

int menu_wahl(char * eingabe, char * menuoptionen);
int wrtxt(char * zeile);
int ein_zeile(char * inzeile, char * text, int stlaenge);
int vtxt_var(char * dateiname, char * message_text, int trcode);
int vtxt_external_pager(char * dateiname, char * message_text, int openmode);
int vtxt(char * dateiname, char * message_text);
int dateivornamen_holen(char * name, char * eingabeaufforderung);
int do_delete_yn(void);
int do_overwrite_yn(void);
int do_overwrite_append_oa(void);
void anhalten(void);
void anhalten_mit_text(char * prompttext);
void schreibfehler(void);
void shell_ausfuehren(void);
int load_file_yn(char * dname);
int copy_textfile_utf8_to_latin1(char * outfile, char * infile);
int copy_textfile_latin1_to_utf8(char * outfile, char * infile);
int textdatei_darf_editiert_werden(char * textd);
int textdatei_editieren(char * textdatei_l1);
int textdatei_anlegen(char * dname);
int drei_textdateien_editieren(char * textdatei1_l1,
                               char * textdatei2_l1,
                               char * textdatei3_l1);

#if defined(REFS_USES_LINUXGCC)
int wrtxt_hl_sq_brackets(char * zeile);
#endif

#endif
