// Copyright John Maddock 2019.

// Use, modification and distribution are subject to the
// Boost Software License, Version 1.0.
// (See accompanying file LICENSE_1_0.txt
// or copy at http://www.boost.org/LICENSE_1_0.txt)

#ifndef SC_
#  define SC_(x) static_cast<T>(BOOST_JOIN(x, L))
#endif
   static const boost::array<boost::array<T, 4>, 152> hypergeometric_2F0_half = {{
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(-1.9500000000000000000000000000000000000000e+01), SC_(-3.7301321029663085937500000000000000000000e+00), SC_(-5.2032157897563382410160422580627156030356e+27) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(-1.9500000000000000000000000000000000000000e+01), SC_(-3.6452302932739257812500000000000000000000e+00), SC_(-5.8552438403993540075445057576807515425389e+25) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(-1.9500000000000000000000000000000000000000e+01), SC_(-2.7896595001220703125000000000000000000000e+00), SC_(1.8536215342403860903873766878985845837896e+26) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(-1.9500000000000000000000000000000000000000e+01), SC_(3.1472368240356445312500000000000000000000e+00), SC_(1.8933877135654357862948257668990833347521e+29) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(-1.9500000000000000000000000000000000000000e+01), SC_(3.3500852584838867187500000000000000000000e+00), SC_(5.7029786962671797374410568316289974479955e+29) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(-1.9500000000000000000000000000000000000000e+01), SC_(4.0579185485839843750000000000000000000000e+00), SC_(1.7256686022877808381153517416629897065172e+31) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(-1.9500000000000000000000000000000000000000e+01), SC_(4.1337585449218750000000000000000000000000e+00), SC_(2.4036795852930798689268880646401742536618e+31) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(-1.9500000000000000000000000000000000000000e+01), SC_(4.6886768341064453125000000000000000000000e+00), SC_(2.3108208371013991143749750060686093879128e+32) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(-1.8500000000000000000000000000000000000000e+01), SC_(-3.7301321029663085937500000000000000000000e+00), SC_(2.2261151553219849602774257441342943187279e+26) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(-1.8500000000000000000000000000000000000000e+01), SC_(-3.6452302932739257812500000000000000000000e+00), SC_(1.0026668728373103856616637520545354803538e+26) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(-1.8500000000000000000000000000000000000000e+01), SC_(-2.7896595001220703125000000000000000000000e+00), SC_(-2.8013886214392444940744423533118582725931e+24) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(-1.8500000000000000000000000000000000000000e+01), SC_(3.1472368240356445312500000000000000000000e+00), SC_(2.7177660267742394310298032400362721880877e+27) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(-1.8500000000000000000000000000000000000000e+01), SC_(3.3500852584838867187500000000000000000000e+00), SC_(7.7204232467149010826926166227567951910332e+27) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(-1.8500000000000000000000000000000000000000e+01), SC_(4.0579185485839843750000000000000000000000e+00), SC_(1.9504360238237116536694663721570401400599e+29) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(-1.8500000000000000000000000000000000000000e+01), SC_(4.1337585449218750000000000000000000000000e+00), SC_(2.6696655078411082966297611860612782820774e+29) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(-1.8500000000000000000000000000000000000000e+01), SC_(4.6886768341064453125000000000000000000000e+00), SC_(2.2781486793724450077029730324854395951302e+30) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(-1.7500000000000000000000000000000000000000e+01), SC_(-3.7301321029663085937500000000000000000000e+00), SC_(-5.4272935692950617393840572649372043642952e+24) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(-1.7500000000000000000000000000000000000000e+01), SC_(-3.6452302932739257812500000000000000000000e+00), SC_(-2.9787739478244595838217239400633538236065e+24) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(-1.7500000000000000000000000000000000000000e+01), SC_(-2.7896595001220703125000000000000000000000e+00), SC_(4.1203884870112705735322844015795179077841e+22) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(-1.7500000000000000000000000000000000000000e+01), SC_(3.1472368240356445312500000000000000000000e+00), SC_(4.0982653063176939702943800803111332996020e+25) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(-1.7500000000000000000000000000000000000000e+01), SC_(3.3500852584838867187500000000000000000000e+00), SC_(1.0980973817736626660092561815773194839184e+26) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(-1.7500000000000000000000000000000000000000e+01), SC_(4.0579185485839843750000000000000000000000e+00), SC_(2.3168428306151719631431027465873901688692e+27) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(-1.7500000000000000000000000000000000000000e+01), SC_(4.1337585449218750000000000000000000000000e+00), SC_(3.1163030502892933547565652782161859863147e+27) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(-1.7500000000000000000000000000000000000000e+01), SC_(4.6886768341064453125000000000000000000000e+00), SC_(2.3609113476752708339828643717700228941000e+28) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(-1.6500000000000000000000000000000000000000e+01), SC_(-3.7301321029663085937500000000000000000000e+00), SC_(1.1656421121187607877342422140840569562187e+23) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(-1.6500000000000000000000000000000000000000e+01), SC_(-3.6452302932739257812500000000000000000000e+00), SC_(7.0021320491460322117459022932692503370530e+22) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(-1.6500000000000000000000000000000000000000e+01), SC_(-2.7896595001220703125000000000000000000000e+00), SC_(-5.5188743519606794936065870728126281186279e+20) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(-1.6500000000000000000000000000000000000000e+01), SC_(3.1472368240356445312500000000000000000000e+00), SC_(6.5095979752995215016570532743100421867381e+23) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(-1.6500000000000000000000000000000000000000e+01), SC_(3.3500852584838867187500000000000000000000e+00), SC_(1.6453391563790413040691524808609928654394e+24) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(-1.6500000000000000000000000000000000000000e+01), SC_(4.0579185485839843750000000000000000000000e+00), SC_(2.9001316875918613337076485266403316938733e+25) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(-1.6500000000000000000000000000000000000000e+01), SC_(4.1337585449218750000000000000000000000000e+00), SC_(3.8334681731758122408642315689935298949643e+25) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(-1.6500000000000000000000000000000000000000e+01), SC_(4.6886768341064453125000000000000000000000e+00), SC_(2.5788906438618455324686375468189779687535e+26) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(-1.5500000000000000000000000000000000000000e+01), SC_(-3.7301321029663085937500000000000000000000e+00), SC_(-2.4230373655872434697755011822115451271442e+21) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(-1.5500000000000000000000000000000000000000e+01), SC_(-3.6452302932739257812500000000000000000000e+00), SC_(-1.5446221588026610617256990311676009383263e+21) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(-1.5500000000000000000000000000000000000000e+01), SC_(-2.7896595001220703125000000000000000000000e+00), SC_(5.2039179437873750251202282607115305564081e+18) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(-1.5500000000000000000000000000000000000000e+01), SC_(3.1472368240356445312500000000000000000000e+00), SC_(1.0923380584793642789134552475058686982130e+22) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(-1.5500000000000000000000000000000000000000e+01), SC_(3.3500852584838867187500000000000000000000e+00), SC_(2.6047856302255220301623013289534164418422e+22) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(-1.5500000000000000000000000000000000000000e+01), SC_(4.0579185485839843750000000000000000000000e+00), SC_(3.8370314351121905972658449085955230994730e+23) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(-1.5500000000000000000000000000000000000000e+01), SC_(4.1337585449218750000000000000000000000000e+00), SC_(4.9844221333558154795317249715123383281341e+23) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(-1.5500000000000000000000000000000000000000e+01), SC_(4.6886768341064453125000000000000000000000e+00), SC_(2.9781830965740745910605500904767647560904e+24) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-1.4500000000000000000000000000000000000000e+01), SC_(-3.7301321029663085937500000000000000000000e+00), SC_(5.0644424342158487881294138597841454452924e+19) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-1.4500000000000000000000000000000000000000e+01), SC_(-3.6452302932739257812500000000000000000000e+00), SC_(3.3812918660147447256197677418883785024773e+19) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-1.4500000000000000000000000000000000000000e+01), SC_(-2.7896595001220703125000000000000000000000e+00), SC_(4.4188764950171470672253965759049069766095e+16) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-1.4500000000000000000000000000000000000000e+01), SC_(3.1472368240356445312500000000000000000000e+00), SC_(1.9428885513822720141998689138316087746558e+20) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-1.4500000000000000000000000000000000000000e+01), SC_(3.3500852584838867187500000000000000000000e+00), SC_(4.3715437031599573901556906633979022383166e+20) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-1.4500000000000000000000000000000000000000e+01), SC_(4.0579185485839843750000000000000000000000e+00), SC_(5.3838018759613374642581052449641152006731e+21) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-1.4500000000000000000000000000000000000000e+01), SC_(4.1337585449218750000000000000000000000000e+00), SC_(6.8733673969699012600949680367789763452754e+21) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-1.4500000000000000000000000000000000000000e+01), SC_(4.6886768341064453125000000000000000000000e+00), SC_(3.6484269996513679951673558951935416684194e+22) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(-1.3500000000000000000000000000000000000000e+01), SC_(-3.7301321029663085937500000000000000000000e+00), SC_(-1.0865141223223570120139754116109481302512e+18) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(-1.3500000000000000000000000000000000000000e+01), SC_(-3.6452302932739257812500000000000000000000e+00), SC_(-7.5460625499065463274884794689243893020987e+17) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(-1.3500000000000000000000000000000000000000e+01), SC_(-2.7896595001220703125000000000000000000000e+00), SC_(-5.2696224103158161978709203372409976182064e+15) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(-1.3500000000000000000000000000000000000000e+01), SC_(3.1472368240356445312500000000000000000000e+00), SC_(3.6766552609030091557087821231880259491913e+18) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(-1.3500000000000000000000000000000000000000e+01), SC_(3.3500852584838867187500000000000000000000e+00), SC_(7.8068587233309904250155139526295672804466e+18) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(-1.3500000000000000000000000000000000000000e+01), SC_(4.0579185485839843750000000000000000000000e+00), SC_(8.0417261866112233532612611189738295611745e+19) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(-1.3500000000000000000000000000000000000000e+01), SC_(4.1337585449218750000000000000000000000000e+00), SC_(1.0090396036034582600949451074840239676639e+20) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(-1.3500000000000000000000000000000000000000e+01), SC_(4.6886768341064453125000000000000000000000e+00), SC_(4.7594765663508724443483507541111761433157e+20) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(-1.2500000000000000000000000000000000000000e+01), SC_(-3.7301321029663085937500000000000000000000e+00), SC_(2.4251604814618160012826816940036497312336e+16) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(-1.2500000000000000000000000000000000000000e+01), SC_(-3.6452302932739257812500000000000000000000e+00), SC_(1.7451712329169837695116150808848215233858e+16) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(-1.2500000000000000000000000000000000000000e+01), SC_(-2.7896595001220703125000000000000000000000e+00), SC_(2.5122076500229365069547526690121458782018e+14) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(-1.2500000000000000000000000000000000000000e+01), SC_(3.1472368240356445312500000000000000000000e+00), SC_(7.4340407355700938554121213329335429229979e+16) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(-1.2500000000000000000000000000000000000000e+01), SC_(3.3500852584838867187500000000000000000000e+00), SC_(1.4898981004933029132659563224941770192732e+17) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(-1.2500000000000000000000000000000000000000e+01), SC_(4.0579185485839843750000000000000000000000e+00), SC_(1.2842739825299535508488413184480942059033e+18) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(-1.2500000000000000000000000000000000000000e+01), SC_(4.1337585449218750000000000000000000000000e+00), SC_(1.5838516471694005715058654642976476087237e+18) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(-1.2500000000000000000000000000000000000000e+01), SC_(4.6886768341064453125000000000000000000000e+00), SC_(6.6406307987120982994591227578030194224229e+18) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-1.1500000000000000000000000000000000000000e+01), SC_(-3.7301321029663085937500000000000000000000e+00), SC_(-5.6898072119164321122419168372018837227839e+14) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-1.1500000000000000000000000000000000000000e+01), SC_(-3.6452302932739257812500000000000000000000e+00), SC_(-4.2318039277775492649236087876812754141650e+14) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-1.1500000000000000000000000000000000000000e+01), SC_(-2.7896595001220703125000000000000000000000e+00), SC_(-1.0320116752292687244792088051052615762343e+13) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-1.1500000000000000000000000000000000000000e+01), SC_(3.1472368240356445312500000000000000000000e+00), SC_(1.6139671540149398267495152704824434098589e+15) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-1.1500000000000000000000000000000000000000e+01), SC_(3.3500852584838867187500000000000000000000e+00), SC_(3.0536207892575778823959917105346115226548e+15) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-1.1500000000000000000000000000000000000000e+01), SC_(4.0579185485839843750000000000000000000000e+00), SC_(2.2038398526358615407436591645827778714282e+16) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-1.1500000000000000000000000000000000000000e+01), SC_(4.1337585449218750000000000000000000000000e+00), SC_(2.6715090620038393105603895018667196718682e+16) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-1.1500000000000000000000000000000000000000e+01), SC_(4.6886768341064453125000000000000000000000e+00), SC_(9.9595772133831924719423921552386695581699e+16) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(-1.0500000000000000000000000000000000000000e+01), SC_(-3.7301321029663085937500000000000000000000e+00), SC_(1.4154122126853155945577811325670848477986e+13) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(-1.0500000000000000000000000000000000000000e+01), SC_(-3.6452302932739257812500000000000000000000e+00), SC_(1.0862479081146393292799907385813507795891e+13) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(-1.0500000000000000000000000000000000000000e+01), SC_(-2.7896595001220703125000000000000000000000e+00), SC_(4.1324758456988467160422473202003867414016e+11) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(-1.0500000000000000000000000000000000000000e+01), SC_(3.1472368240356445312500000000000000000000e+00), SC_(3.7838957515407207740379345721280023762909e+13) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(-1.0500000000000000000000000000000000000000e+01), SC_(3.3500852584838867187500000000000000000000e+00), SC_(6.7598920795975059747258762337154107453545e+13) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(-1.0500000000000000000000000000000000000000e+01), SC_(4.0579185485839843750000000000000000000000e+00), SC_(4.0872998176655425140145321867866930830268e+14) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(-1.0500000000000000000000000000000000000000e+01), SC_(4.1337585449218750000000000000000000000000e+00), SC_(4.8703244486916368158388739794502721684023e+14) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(-1.0500000000000000000000000000000000000000e+01), SC_(4.6886768341064453125000000000000000000000e+00), SC_(1.6150934244860007952300272469725237564601e+15) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(-9.5000000000000000000000000000000000000000e+00), SC_(-3.7301321029663085937500000000000000000000e+00), SC_(-3.7633583628848855858742607787522176489744e+11) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(-9.5000000000000000000000000000000000000000e+00), SC_(-3.6452302932739257812500000000000000000000e+00), SC_(-2.9768919517046365752540700523609482301232e+11) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(-9.5000000000000000000000000000000000000000e+00), SC_(-2.7896595001220703125000000000000000000000e+00), SC_(-1.6916266731008513700869003868895119781012e+10) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(-9.5000000000000000000000000000000000000000e+00), SC_(3.1472368240356445312500000000000000000000e+00), SC_(9.6443863153054077145883707423260701294555e+11) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(-9.5000000000000000000000000000000000000000e+00), SC_(3.3500852584838867187500000000000000000000e+00), SC_(1.6272728994812492448699130727658039618347e+12) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(-9.5000000000000000000000000000000000000000e+00), SC_(4.0579185485839843750000000000000000000000e+00), SC_(8.2489293930895362411741621232110145488759e+12) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(-9.5000000000000000000000000000000000000000e+00), SC_(4.1337585449218750000000000000000000000000e+00), SC_(9.6625685685699442281237404709084612134588e+12) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(-9.5000000000000000000000000000000000000000e+00), SC_(4.6886768341064453125000000000000000000000e+00), SC_(2.8515422111273708603540792828810907696205e+13) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-8.5000000000000000000000000000000000000000e+00), SC_(-3.7301321029663085937500000000000000000000e+00), SC_(1.0778389168061340651810750040862126637568e+10) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-8.5000000000000000000000000000000000000000e+00), SC_(-3.6452302932739257812500000000000000000000e+00), SC_(8.7816193749596460384199262435373980739239e+09) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-8.5000000000000000000000000000000000000000e+00), SC_(-2.7896595001220703125000000000000000000000e+00), SC_(7.2668388442359385684841423173858861831245e+08) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-8.5000000000000000000000000000000000000000e+00), SC_(3.1472368240356445312500000000000000000000e+00), SC_(2.6939312999497495242149406739744925219583e+10) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-8.5000000000000000000000000000000000000000e+00), SC_(3.3500852584838867187500000000000000000000e+00), SC_(4.2941770896707497998252766995944780840817e+10) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-8.5000000000000000000000000000000000000000e+00), SC_(4.0579185485839843750000000000000000000000e+00), SC_(1.8264951951879394379786762349490784728033e+11) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-8.5000000000000000000000000000000000000000e+00), SC_(4.1337585449218750000000000000000000000000e+00), SC_(2.1033954221348849241814566443048178204305e+11) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-8.5000000000000000000000000000000000000000e+00), SC_(4.6886768341064453125000000000000000000000e+00), SC_(5.5268905200729555040502771942754538570464e+11) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(-7.5000000000000000000000000000000000000000e+00), SC_(-3.7301321029663085937500000000000000000000e+00), SC_(-3.3509090429946490314166502901251155283312e+08) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(-7.5000000000000000000000000000000000000000e+00), SC_(-3.6452302932739257812500000000000000000000e+00), SC_(-2.8109249368886471946664299565578836521517e+08) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(-7.5000000000000000000000000000000000000000e+00), SC_(-2.7896595001220703125000000000000000000000e+00), SC_(-3.3359621234069439619672436130446187994499e+07) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(-7.5000000000000000000000000000000000000000e+00), SC_(3.1472368240356445312500000000000000000000e+00), SC_(8.3275522110622326526114758458825617455579e+08) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(-7.5000000000000000000000000000000000000000e+00), SC_(3.3500852584838867187500000000000000000000e+00), SC_(1.2544803445331205230251643650197216183111e+09) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(-7.5000000000000000000000000000000000000000e+00), SC_(4.0579185485839843750000000000000000000000e+00), SC_(4.4816066056852443570788602988748912766349e+09) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(-7.5000000000000000000000000000000000000000e+00), SC_(4.1337585449218750000000000000000000000000e+00), SC_(5.0743899277240404858846774065746699613537e+09) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(-7.5000000000000000000000000000000000000000e+00), SC_(4.6886768341064453125000000000000000000000e+00), SC_(1.1879159175832840303827240125104891074801e+10) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(-6.5000000000000000000000000000000000000000e+00), SC_(-3.7301321029663085937500000000000000000000e+00), SC_(1.1392001208943510381762156002916509632004e+07) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(-6.5000000000000000000000000000000000000000e+00), SC_(-3.6452302932739257812500000000000000000000e+00), SC_(9.8386217358082562990875543779099810855139e+06) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(-6.5000000000000000000000000000000000000000e+00), SC_(-2.7896595001220703125000000000000000000000e+00), SC_(1.6607969096364758188367886351545696453813e+06) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(-6.5000000000000000000000000000000000000000e+00), SC_(3.1472368240356445312500000000000000000000e+00), SC_(2.8836875570397924223515261855419960937594e+07) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(-6.5000000000000000000000000000000000000000e+00), SC_(3.3500852584838867187500000000000000000000e+00), SC_(4.1069974908084040155705066878832894873968e+07) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(-6.5000000000000000000000000000000000000000e+00), SC_(4.0579185485839843750000000000000000000000e+00), SC_(1.2338130461278287096870160733417864174266e+08) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(-6.5000000000000000000000000000000000000000e+00), SC_(4.1337585449218750000000000000000000000000e+00), SC_(1.3737142513329898680081725034887063270122e+08) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(-6.5000000000000000000000000000000000000000e+00), SC_(4.6886768341064453125000000000000000000000e+00), SC_(2.8672732947829204445581568931578268263072e+08) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-5.5000000000000000000000000000000000000000e+00), SC_(-3.7301321029663085937500000000000000000000e+00), SC_(-4.2597229176559225229173681538199524764980e+05) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-5.5000000000000000000000000000000000000000e+00), SC_(-3.6452302932739257812500000000000000000000e+00), SC_(-3.7893000843148324533298922673882421935618e+05) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-5.5000000000000000000000000000000000000000e+00), SC_(-2.7896595001220703125000000000000000000000e+00), SC_(-9.0821292506594406365998773091361183602171e+04) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-5.5000000000000000000000000000000000000000e+00), SC_(3.1472368240356445312500000000000000000000e+00), SC_(1.1361681382824054437470379817966262854350e+06) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-5.5000000000000000000000000000000000000000e+00), SC_(3.3500852584838867187500000000000000000000e+00), SC_(1.5306272986618510606325724065022515911987e+06) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-5.5000000000000000000000000000000000000000e+00), SC_(4.0579185485839843750000000000000000000000e+00), SC_(3.8726279289398788314505250284684260914604e+06) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-5.5000000000000000000000000000000000000000e+00), SC_(4.1337585449218750000000000000000000000000e+00), SC_(4.2404459105947512158538019392657605245112e+06) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-5.5000000000000000000000000000000000000000e+00), SC_(4.6886768341064453125000000000000000000000e+00), SC_(7.8989218155251750717207142528716543147018e+06) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(-4.5000000000000000000000000000000000000000e+00), SC_(-3.7301321029663085937500000000000000000000e+00), SC_(1.7518336001693997538340668531918579831917e+04) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(-4.5000000000000000000000000000000000000000e+00), SC_(-3.6452302932739257812500000000000000000000e+00), SC_(1.6074413575504564218173195220682646614606e+04) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(-4.5000000000000000000000000000000000000000e+00), SC_(-2.7896595001220703125000000000000000000000e+00), SC_(5.5113642905663726516154101071181938732553e+03) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(-4.5000000000000000000000000000000000000000e+00), SC_(3.1472368240356445312500000000000000000000e+00), SC_(5.1998528910295846582479794748030830924804e+04) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(-4.5000000000000000000000000000000000000000e+00), SC_(3.3500852584838867187500000000000000000000e+00), SC_(6.6306329480714211398108307509517183727513e+04) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(-4.5000000000000000000000000000000000000000e+00), SC_(4.0579185485839843750000000000000000000000e+00), SC_(1.4156470856746085501914758099263963132904e+05) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(-4.5000000000000000000000000000000000000000e+00), SC_(4.1337585449218750000000000000000000000000e+00), SC_(1.5247536367974922715188894871107516041956e+05) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(-4.5000000000000000000000000000000000000000e+00), SC_(4.6886768341064453125000000000000000000000e+00), SC_(2.5379040326974464784088283914266954125033e+05) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(-3.5000000000000000000000000000000000000000e+00), SC_(-3.7301321029663085937500000000000000000000e+00), SC_(-7.7505086074813695626216247543931112537646e+02) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(-3.5000000000000000000000000000000000000000e+00), SC_(-3.6452302932739257812500000000000000000000e+00), SC_(-7.3666248159817680162539616034410031859889e+02) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(-3.5000000000000000000000000000000000000000e+00), SC_(-2.7896595001220703125000000000000000000000e+00), SC_(-3.7180605620003190817904218733470339051223e+02) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(-3.5000000000000000000000000000000000000000e+00), SC_(3.1472368240356445312500000000000000000000e+00), SC_(2.8455514245734394717253071570948100619178e+03) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(-3.5000000000000000000000000000000000000000e+00), SC_(3.3500852584838867187500000000000000000000e+00), SC_(3.4376152883582122096849656439800678131068e+03) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(-3.5000000000000000000000000000000000000000e+00), SC_(4.0579185485839843750000000000000000000000e+00), SC_(6.2098280865713890922564506096723298636010e+03) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(-3.5000000000000000000000000000000000000000e+00), SC_(4.1337585449218750000000000000000000000000e+00), SC_(6.5806985090357272669679710754009338558035e+03) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(-3.5000000000000000000000000000000000000000e+00), SC_(4.6886768341064453125000000000000000000000e+00), SC_(9.8037346475329638709663654034010352754174e+03) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-2.5000000000000000000000000000000000000000e+00), SC_(-3.7301321029663085937500000000000000000000e+00), SC_(3.2241538037974137030183645336034459205621e+01) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-2.5000000000000000000000000000000000000000e+00), SC_(-3.6452302932739257812500000000000000000000e+00), SC_(3.2328552665090841278434409533648619117230e+01) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-2.5000000000000000000000000000000000000000e+00), SC_(-2.7896595001220703125000000000000000000000e+00), SC_(2.6921639207798673220674301465038524838747e+01) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-2.5000000000000000000000000000000000000000e+00), SC_(3.1472368240356445312500000000000000000000e+00), SC_(1.9448732377376600337739228491207299498456e+02) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-2.5000000000000000000000000000000000000000e+00), SC_(3.3500852584838867187500000000000000000000e+00), SC_(2.2288190121561674587240351602668297914533e+02) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-2.5000000000000000000000000000000000000000e+00), SC_(4.0579185485839843750000000000000000000000e+00), SC_(3.4197330849701113209687663996305673208553e+02) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-2.5000000000000000000000000000000000000000e+00), SC_(4.1337585449218750000000000000000000000000e+00), SC_(3.5668804728066476528169914672616869211197e+02) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-2.5000000000000000000000000000000000000000e+00), SC_(4.6886768341064453125000000000000000000000e+00), SC_(4.7674613167674945293002947144245240451710e+02) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(-1.5000000000000000000000000000000000000000e+00), SC_(-3.7301321029663085937500000000000000000000e+00), SC_(2.4501782028596608142834156751632690429688e-01) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(-1.5000000000000000000000000000000000000000e+00), SC_(-3.6452302932739257812500000000000000000000e+00), SC_(3.0087038429655876825563609600067138671875e-02) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(-1.5000000000000000000000000000000000000000e+00), SC_(-2.7896595001220703125000000000000000000000e+00), SC_(-1.5323284054002215270884335041046142578125e+00) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(-1.5000000000000000000000000000000000000000e+00), SC_(3.1472368240356445312500000000000000000000e+00), SC_(1.7870535192031411497737281024456024169922e+01) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(-1.5000000000000000000000000000000000000000e+00), SC_(3.3500852584838867187500000000000000000000e+00), SC_(1.9467559204784947723965160548686981201172e+01) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(-1.5000000000000000000000000000000000000000e+00), SC_(4.0579185485839843750000000000000000000000e+00), SC_(2.5523782855958415893837809562683105468750e+01) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(-1.5000000000000000000000000000000000000000e+00), SC_(4.1337585449218750000000000000000000000000e+00), SC_(2.6217245415551587939262390136718750000000e+01) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(-1.5000000000000000000000000000000000000000e+00), SC_(4.6886768341064453125000000000000000000000e+00), SC_(3.1553798343334165110718458890914916992188e+01) }
   }};
//#undef SC_
