/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.nodes.stats;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class JvmClasses
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, JvmClasses> {
    @Nullable
    private final Long currentLoadedCount;
    @Nullable
    private final Long totalLoadedCount;
    @Nullable
    private final Long totalUnloadedCount;
    public static final JsonpDeserializer<JvmClasses> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, JvmClasses::setupJvmClassesDeserializer);

    private JvmClasses(Builder builder) {
        this.currentLoadedCount = builder.currentLoadedCount;
        this.totalLoadedCount = builder.totalLoadedCount;
        this.totalUnloadedCount = builder.totalUnloadedCount;
    }

    public static JvmClasses of(Function<Builder, ObjectBuilder<JvmClasses>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Long currentLoadedCount() {
        return this.currentLoadedCount;
    }

    @Nullable
    public final Long totalLoadedCount() {
        return this.totalLoadedCount;
    }

    @Nullable
    public final Long totalUnloadedCount() {
        return this.totalUnloadedCount;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.currentLoadedCount != null) {
            generator.writeKey("current_loaded_count");
            generator.write(this.currentLoadedCount.longValue());
        }
        if (this.totalLoadedCount != null) {
            generator.writeKey("total_loaded_count");
            generator.write(this.totalLoadedCount.longValue());
        }
        if (this.totalUnloadedCount != null) {
            generator.writeKey("total_unloaded_count");
            generator.write(this.totalUnloadedCount.longValue());
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupJvmClassesDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::currentLoadedCount, JsonpDeserializer.longDeserializer(), "current_loaded_count");
        op.add(Builder::totalLoadedCount, JsonpDeserializer.longDeserializer(), "total_loaded_count");
        op.add(Builder::totalUnloadedCount, JsonpDeserializer.longDeserializer(), "total_unloaded_count");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.currentLoadedCount);
        result = 31 * result + Objects.hashCode(this.totalLoadedCount);
        result = 31 * result + Objects.hashCode(this.totalUnloadedCount);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JvmClasses other = (JvmClasses)o;
        return Objects.equals(this.currentLoadedCount, other.currentLoadedCount) && Objects.equals(this.totalLoadedCount, other.totalLoadedCount) && Objects.equals(this.totalUnloadedCount, other.totalUnloadedCount);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, JvmClasses> {
        @Nullable
        private Long currentLoadedCount;
        @Nullable
        private Long totalLoadedCount;
        @Nullable
        private Long totalUnloadedCount;

        public Builder() {
        }

        private Builder(JvmClasses o) {
            this.currentLoadedCount = o.currentLoadedCount;
            this.totalLoadedCount = o.totalLoadedCount;
            this.totalUnloadedCount = o.totalUnloadedCount;
        }

        private Builder(Builder o) {
            this.currentLoadedCount = o.currentLoadedCount;
            this.totalLoadedCount = o.totalLoadedCount;
            this.totalUnloadedCount = o.totalUnloadedCount;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder currentLoadedCount(@Nullable Long value) {
            this.currentLoadedCount = value;
            return this;
        }

        @Nonnull
        public final Builder totalLoadedCount(@Nullable Long value) {
            this.totalLoadedCount = value;
            return this;
        }

        @Nonnull
        public final Builder totalUnloadedCount(@Nullable Long value) {
            this.totalUnloadedCount = value;
            return this;
        }

        @Override
        @Nonnull
        public JvmClasses build() {
            this._checkSingleUse();
            return new JvmClasses(this);
        }
    }
}

