/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.ling.CategoryWordTagFactory;
import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.parser.KBestViterbiParser;
import edu.stanford.nlp.parser.lexparser.ExhaustivePCFGParser;
import edu.stanford.nlp.parser.lexparser.GrammarProjection;
import edu.stanford.nlp.parser.lexparser.IntDependency;
import edu.stanford.nlp.parser.lexparser.MLEDependencyGrammar;
import edu.stanford.nlp.parser.lexparser.NullGrammarProjection;
import edu.stanford.nlp.parser.lexparser.Options;
import edu.stanford.nlp.parser.lexparser.Test;
import edu.stanford.nlp.trees.HeadFinder;
import edu.stanford.nlp.trees.LabeledScoredTreeFactory;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.util.Beam;
import edu.stanford.nlp.util.ScoredObject;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FastFactoredParser
implements KBestViterbiParser {
    protected static final boolean VERBOSE = false;
    protected ExhaustivePCFGParser pparser;
    protected GrammarProjection projection;
    protected MLEDependencyGrammar dg;
    protected Options op;
    private int numToFind;
    private List<ScoredObject<Tree>> nGoodTrees = new ArrayList<ScoredObject<Tree>>();
    private final HeadFinder binHeadFinder = new BinaryHeadFinder();

    protected int project(int state) {
        return this.projection.project(state);
    }

    @Override
    public Tree getBestParse() {
        return this.nGoodTrees.get(0).object();
    }

    @Override
    public double getBestScore() {
        return this.nGoodTrees.get(0).score();
    }

    @Override
    public boolean hasParse() {
        return !this.nGoodTrees.isEmpty();
    }

    @Override
    public List<ScoredObject<Tree>> getKGoodParses(int k) {
        if (k <= this.nGoodTrees.size()) {
            return this.nGoodTrees.subList(0, k);
        }
        throw new UnsupportedOperationException("FastFactoredParser: cannot provide " + k + " good parses.");
    }

    private double depScoreTree(Tree tr) {
        Tree cwtTree = tr.deepCopy(new LabeledScoredTreeFactory(), new CategoryWordTagFactory());
        cwtTree.percolateHeads(this.binHeadFinder);
        List<IntDependency> deps = MLEDependencyGrammar.treeToDependencyList(cwtTree);
        return this.dg.scoreAll(deps);
    }

    @Override
    public boolean parse(List<? extends HasWord> words) {
        this.nGoodTrees.clear();
        int numParsesToConsider = this.numToFind * Test.fastFactoredCandidateMultiplier + Test.fastFactoredCandidateAddend;
        if (this.pparser.hasParse()) {
            List<ScoredObject<Tree>> pcfgBest = this.pparser.getKBestParses(numParsesToConsider);
            Beam<ScoredObject<Tree>> goodParses = new Beam<ScoredObject<Tree>>(this.numToFind);
            for (ScoredObject<Tree> candidate : pcfgBest) {
                double depScore = this.depScoreTree(candidate.object());
                ScoredObject<Tree> x = new ScoredObject<Tree>(candidate.object(), candidate.score() + depScore);
                goodParses.add(x);
            }
            this.nGoodTrees = goodParses.asSortedList();
        }
        return !this.nGoodTrees.isEmpty();
    }

    @Override
    public List<ScoredObject<Tree>> getKBestParses(int k) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<ScoredObject<Tree>> getBestParses() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<ScoredObject<Tree>> getKSampledParses(int k) {
        throw new UnsupportedOperationException();
    }

    FastFactoredParser(ExhaustivePCFGParser pparser, MLEDependencyGrammar dg, Options op, int numToFind) {
        this(pparser, dg, op, numToFind, new NullGrammarProjection(null, null));
    }

    FastFactoredParser(ExhaustivePCFGParser pparser, MLEDependencyGrammar dg, Options op, int numToFind, GrammarProjection projection) {
        this.pparser = pparser;
        this.projection = projection;
        this.dg = dg;
        this.op = op;
        this.numToFind = numToFind;
    }

    private static class BinaryHeadFinder
    implements HeadFinder {
        private static final long serialVersionUID = 4794072338791804184L;

        private BinaryHeadFinder() {
        }

        public Tree determineHead(Tree t) {
            if (t.numChildren() == 1) {
                return t.firstChild();
            }
            String lval = t.firstChild().label().value();
            if (lval != null && lval.startsWith("@")) {
                return t.firstChild();
            }
            String rval = t.lastChild().label().value();
            if (rval.startsWith("@") || rval.equals(".$$.")) {
                return t.lastChild();
            }
            throw new IllegalStateException("BinaryHeadFinder: unexpected tree: " + t);
        }

        public Tree determineHead(Tree t, Tree parent) {
            return this.determineHead(t);
        }
    }
}

