/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.storage.internals.log;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.util.Optional;
import org.apache.kafka.common.errors.InvalidOffsetException;
import org.apache.kafka.storage.internals.log.AbstractIndex;
import org.apache.kafka.storage.internals.log.CorruptIndexException;
import org.apache.kafka.storage.internals.log.IndexSearchType;
import org.apache.kafka.storage.internals.log.OffsetPosition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OffsetIndex
extends AbstractIndex {
    private static final Logger log = LoggerFactory.getLogger(OffsetIndex.class);
    private static final int ENTRY_SIZE = 8;
    private volatile long lastOffset;

    public OffsetIndex(File file, long baseOffset) throws IOException {
        this(file, baseOffset, -1);
    }

    public OffsetIndex(File file, long baseOffset, int maxIndexSize) throws IOException {
        this(file, baseOffset, maxIndexSize, true);
    }

    public OffsetIndex(File file, long baseOffset, int maxIndexSize, boolean writable) throws IOException {
        super(file, baseOffset, maxIndexSize, writable);
        this.lastOffset = this.lastEntry().offset;
        log.debug("Loaded index file {} with maxEntries = {}, maxIndexSize = {}, entries = {}, lastOffset = {}, file position = {}", new Object[]{file.getAbsolutePath(), this.maxEntries(), maxIndexSize, this.entries(), this.lastOffset, this.mmap().position()});
    }

    @Override
    public void sanityCheck() {
        if (this.entries() != 0 && this.lastOffset < this.baseOffset()) {
            throw new CorruptIndexException("Corrupt index found, index file " + this.file().getAbsolutePath() + " has non-zero size but the last offset is " + this.lastOffset + " which is less than the base offset " + this.baseOffset());
        }
        if (this.length() % (long)this.entrySize() != 0L) {
            throw new CorruptIndexException("Index file " + this.file().getAbsolutePath() + " is corrupt, found " + this.length() + " bytes which is neither positive nor a multiple of 8");
        }
    }

    public OffsetPosition lookup(long targetOffset) {
        return (OffsetPosition)this.inRemapReadLock(() -> {
            MappedByteBuffer idx = this.mmap().duplicate();
            int slot = this.largestLowerBoundSlotFor(idx, targetOffset, IndexSearchType.KEY);
            if (slot == -1) {
                return new OffsetPosition(this.baseOffset(), 0);
            }
            return this.parseEntry(idx, slot);
        });
    }

    public OffsetPosition entry(int n) {
        return (OffsetPosition)this.inRemapReadLock(() -> {
            if (n >= this.entries()) {
                throw new IllegalArgumentException("Attempt to fetch the " + n + "th entry from index " + this.file().getAbsolutePath() + ", which has size " + this.entries());
            }
            return this.parseEntry(this.mmap(), n);
        });
    }

    public Optional<OffsetPosition> fetchUpperBoundOffset(OffsetPosition fetchOffset, int fetchSize) {
        return (Optional)this.inRemapReadLock(() -> {
            MappedByteBuffer idx = this.mmap().duplicate();
            int slot = this.smallestUpperBoundSlotFor(idx, fetchOffset.position + fetchSize, IndexSearchType.VALUE);
            if (slot == -1) {
                return Optional.empty();
            }
            return Optional.of(this.parseEntry(idx, slot));
        });
    }

    public void append(long offset, int position) {
        this.inLock(() -> {
            if (this.isFull()) {
                throw new IllegalArgumentException("Attempt to append to a full index (size = " + this.entries() + ").");
            }
            if (this.entries() == 0 || offset > this.lastOffset) {
                log.trace("Adding index entry {} => {} to {}", new Object[]{offset, position, this.file().getAbsolutePath()});
                this.mmap().putInt(this.relativeOffset(offset));
                this.mmap().putInt(position);
                this.incrementEntries();
                this.lastOffset = offset;
                if (this.entries() * 8 != this.mmap().position()) {
                    throw new IllegalStateException(this.entries() + " entries but file position in index is " + this.mmap().position());
                }
            } else {
                throw new InvalidOffsetException("Attempt to append an offset " + offset + " to position " + this.entries() + " no larger than the last offset appended (" + this.lastOffset + ") to " + this.file().getAbsolutePath());
            }
        });
    }

    @Override
    public void truncateTo(long offset) {
        this.inLock(() -> {
            MappedByteBuffer idx = this.mmap().duplicate();
            int slot = this.largestLowerBoundSlotFor(idx, offset, IndexSearchType.KEY);
            int newEntries = slot < 0 ? 0 : ((long)this.relativeOffset(idx, slot) == offset - this.baseOffset() ? slot : slot + 1);
            this.truncateToEntries(newEntries);
        });
    }

    public long lastOffset() {
        return this.lastOffset;
    }

    @Override
    public void truncate() {
        this.truncateToEntries(0);
    }

    @Override
    protected int entrySize() {
        return 8;
    }

    @Override
    protected OffsetPosition parseEntry(ByteBuffer buffer, int n) {
        return new OffsetPosition(this.baseOffset() + (long)this.relativeOffset(buffer, n), this.physical(buffer, n));
    }

    private int relativeOffset(ByteBuffer buffer, int n) {
        return buffer.getInt(n * 8);
    }

    private int physical(ByteBuffer buffer, int n) {
        return buffer.getInt(n * 8 + 4);
    }

    private void truncateToEntries(int entries) {
        this.inLock(() -> {
            super.truncateToEntries0(entries);
            this.lastOffset = this.lastEntry().offset;
            log.debug("Truncated index {} to {} entries; position is now {} and last offset is now {}", new Object[]{this.file().getAbsolutePath(), entries, this.mmap().position(), this.lastOffset});
        });
    }

    private OffsetPosition lastEntry() {
        return (OffsetPosition)this.inRemapReadLock(() -> {
            int entries = this.entries();
            if (entries == 0) {
                return new OffsetPosition(this.baseOffset(), 0);
            }
            return this.parseEntry(this.mmap(), entries - 1);
        });
    }
}

