/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.List;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.StateStoreContext;
import org.apache.kafka.streams.query.KeyQuery;
import org.apache.kafka.streams.query.Position;
import org.apache.kafka.streams.query.PositionBound;
import org.apache.kafka.streams.query.Query;
import org.apache.kafka.streams.query.QueryConfig;
import org.apache.kafka.streams.query.QueryResult;
import org.apache.kafka.streams.query.RangeQuery;
import org.apache.kafka.streams.query.TimestampedKeyQuery;
import org.apache.kafka.streams.query.TimestampedRangeQuery;
import org.apache.kafka.streams.query.internals.InternalQueryResultUtil;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.TimestampedBytesStore;
import org.apache.kafka.streams.state.internals.KeyValueToTimestampedKeyValueIteratorAdapter;
import org.apache.kafka.streams.state.internals.ManagedKeyValueIterator;
import org.apache.kafka.streams.state.internals.RocksDbIterator;
import org.apache.kafka.streams.state.internals.ValueAndTimestampDeserializer;

public class KeyValueToTimestampedKeyValueByteStoreAdapter
implements KeyValueStore<Bytes, byte[]> {
    final KeyValueStore<Bytes, byte[]> store;

    KeyValueToTimestampedKeyValueByteStoreAdapter(KeyValueStore<Bytes, byte[]> store) {
        if (!store.persistent()) {
            throw new IllegalArgumentException("Provided store must be a persistent store, but it is not.");
        }
        this.store = store;
    }

    @Override
    public void put(Bytes key, byte[] valueWithTimestamp) {
        this.store.put(key, ValueAndTimestampDeserializer.rawValue(valueWithTimestamp));
    }

    @Override
    public byte[] putIfAbsent(Bytes key, byte[] valueWithTimestamp) {
        return TimestampedBytesStore.convertToTimestampedFormat(this.store.putIfAbsent(key, ValueAndTimestampDeserializer.rawValue(valueWithTimestamp)));
    }

    @Override
    public void putAll(List<KeyValue<Bytes, byte[]>> entries) {
        for (KeyValue<Bytes, byte[]> entry : entries) {
            byte[] valueWithTimestamp = (byte[])entry.value;
            this.store.put((Bytes)entry.key, ValueAndTimestampDeserializer.rawValue(valueWithTimestamp));
        }
    }

    @Override
    public byte[] delete(Bytes key) {
        return TimestampedBytesStore.convertToTimestampedFormat(this.store.delete(key));
    }

    @Override
    public String name() {
        return this.store.name();
    }

    @Override
    public void init(StateStoreContext stateStoreContext, StateStore root) {
        this.store.init(stateStoreContext, root);
    }

    @Override
    public void flush() {
        this.store.flush();
    }

    @Override
    public void close() {
        this.store.close();
    }

    @Override
    public boolean persistent() {
        return true;
    }

    @Override
    public boolean isOpen() {
        return this.store.isOpen();
    }

    @Override
    public <R> QueryResult<R> query(Query<R> query, PositionBound positionBound, QueryConfig config) {
        long start = config.isCollectExecutionInfo() ? System.nanoTime() : -1L;
        QueryResult<Object> result = this.store.query(query, positionBound, config);
        if (result.isSuccess()) {
            if (query instanceof KeyQuery || query instanceof TimestampedKeyQuery) {
                byte[] plainValue = (byte[])result.getResult();
                byte[] valueWithTimestamp = TimestampedBytesStore.convertToTimestampedFormat(plainValue);
                result = InternalQueryResultUtil.copyAndSubstituteDeserializedResult(result, valueWithTimestamp);
            } else if (query instanceof RangeQuery || query instanceof TimestampedRangeQuery) {
                KeyValueToTimestampedKeyValueAdapterIterator wrappedRocksDBRangeIterator = new KeyValueToTimestampedKeyValueAdapterIterator((RocksDbIterator)result.getResult());
                result = InternalQueryResultUtil.copyAndSubstituteDeserializedResult(result, wrappedRocksDBRangeIterator);
            } else {
                throw new IllegalArgumentException("Unsupported query type: " + String.valueOf(query.getClass()));
            }
        }
        if (config.isCollectExecutionInfo()) {
            long end = System.nanoTime();
            result.addExecutionInfo("Handled in " + String.valueOf(this.getClass()) + " in " + (end - start) + "ns");
        }
        return result;
    }

    @Override
    public Position getPosition() {
        return this.store.getPosition();
    }

    @Override
    public byte[] get(Bytes key) {
        return TimestampedBytesStore.convertToTimestampedFormat((byte[])this.store.get(key));
    }

    @Override
    public KeyValueIterator<Bytes, byte[]> range(Bytes from, Bytes to) {
        return new KeyValueToTimestampedKeyValueIteratorAdapter<Bytes>(this.store.range(from, to));
    }

    @Override
    public KeyValueIterator<Bytes, byte[]> reverseRange(Bytes from, Bytes to) {
        return new KeyValueToTimestampedKeyValueIteratorAdapter<Bytes>(this.store.reverseRange(from, to));
    }

    @Override
    public KeyValueIterator<Bytes, byte[]> all() {
        return new KeyValueToTimestampedKeyValueIteratorAdapter<Bytes>(this.store.all());
    }

    @Override
    public KeyValueIterator<Bytes, byte[]> reverseAll() {
        return new KeyValueToTimestampedKeyValueIteratorAdapter<Bytes>(this.store.reverseAll());
    }

    @Override
    public <PS extends Serializer<P>, P> KeyValueIterator<Bytes, byte[]> prefixScan(P prefix, PS prefixKeySerializer) {
        return new KeyValueToTimestampedKeyValueIteratorAdapter<Bytes>(this.store.prefixScan(prefix, prefixKeySerializer));
    }

    @Override
    public long approximateNumEntries() {
        return this.store.approximateNumEntries();
    }

    private static class KeyValueToTimestampedKeyValueAdapterIterator
    implements ManagedKeyValueIterator<Bytes, byte[]> {
        private final RocksDbIterator rocksDbIterator;

        public KeyValueToTimestampedKeyValueAdapterIterator(RocksDbIterator rocksDbIterator) {
            this.rocksDbIterator = rocksDbIterator;
        }

        @Override
        public void close() {
            this.rocksDbIterator.close();
        }

        @Override
        public Bytes peekNextKey() {
            return this.rocksDbIterator.peekNextKey();
        }

        @Override
        public void onClose(Runnable closeCallback) {
            this.rocksDbIterator.onClose(closeCallback);
        }

        @Override
        public boolean hasNext() {
            return this.rocksDbIterator.hasNext();
        }

        @Override
        public KeyValue<Bytes, byte[]> next() {
            KeyValue next = (KeyValue)this.rocksDbIterator.next();
            if (next == null) {
                return null;
            }
            return KeyValue.pair((Bytes)next.key, TimestampedBytesStore.convertToTimestampedFormat((byte[])next.value));
        }
    }
}

