/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.oauthbearer.internals.secured.assertion;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.security.oauthbearer.internals.secured.assertion.AssertionJwtTemplate;
import org.apache.kafka.common.utils.Utils;

public class LayeredAssertionJwtTemplate
implements AssertionJwtTemplate {
    private final List<AssertionJwtTemplate> templates;

    public LayeredAssertionJwtTemplate(AssertionJwtTemplate ... templates) {
        this.templates = Arrays.asList(templates);
    }

    public LayeredAssertionJwtTemplate(List<AssertionJwtTemplate> templates) {
        this.templates = Collections.unmodifiableList(templates);
    }

    @Override
    public Map<String, Object> header() {
        HashMap<String, Object> header = new HashMap<String, Object>();
        for (AssertionJwtTemplate template : this.templates) {
            header.putAll(template.header());
        }
        return Collections.unmodifiableMap(header);
    }

    @Override
    public Map<String, Object> payload() {
        HashMap<String, Object> payload = new HashMap<String, Object>();
        for (AssertionJwtTemplate template : this.templates) {
            payload.putAll(template.payload());
        }
        return Collections.unmodifiableMap(payload);
    }

    @Override
    public void close() {
        for (AssertionJwtTemplate template : this.templates) {
            Utils.closeQuietly(template, "JWT assertion template");
        }
    }
}

