/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.streams.topics;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.SortedMap;
import org.apache.kafka.common.message.CreateTopicsRequestData;
import org.apache.kafka.common.message.StreamsGroupDescribeResponseData;
import org.apache.kafka.coordinator.group.streams.topics.ConfiguredSubtopology;
import org.apache.kafka.coordinator.group.streams.topics.TopicConfigurationException;

public record ConfiguredTopology(int topologyEpoch, long metadataHash, Optional<SortedMap<String, ConfiguredSubtopology>> subtopologies, Map<String, CreateTopicsRequestData.CreatableTopic> internalTopicsToBeCreated, Optional<TopicConfigurationException> topicConfigurationException) {
    public ConfiguredTopology {
        if (topologyEpoch < 0) {
            throw new IllegalArgumentException("Topology epoch must be non-negative.");
        }
        if (topicConfigurationException.isEmpty() && subtopologies.isEmpty()) {
            throw new IllegalArgumentException("Subtopologies must be present if topicConfigurationException is empty.");
        }
        Objects.requireNonNull(subtopologies, "subtopologies can't be null");
        Objects.requireNonNull(internalTopicsToBeCreated, "internalTopicsToBeCreated can't be null");
        Objects.requireNonNull(topicConfigurationException, "topicConfigurationException can't be null");
    }

    public boolean isReady() {
        return this.topicConfigurationException.isEmpty();
    }

    public StreamsGroupDescribeResponseData.Topology asStreamsGroupDescribeTopology() {
        return new StreamsGroupDescribeResponseData.Topology().setEpoch(this.topologyEpoch).setSubtopologies(this.subtopologies.map(stringConfiguredSubtopologyMap -> stringConfiguredSubtopologyMap.entrySet().stream().map(entry -> ((ConfiguredSubtopology)entry.getValue()).asStreamsGroupDescribeSubtopology((String)entry.getKey())).toList()).orElse(List.of()));
    }
}

