/*
 * Decompiled with CFR 0.152.
 */
package org.itk.simple;

import org.itk.simple.Image;
import org.itk.simple.ImageFilter;
import org.itk.simple.SimpleITKJNI;
import org.itk.simple.VectorUInt32;

public class CropImageFilter
extends ImageFilter {
    private transient long swigCPtr;

    protected CropImageFilter(long l, boolean bl) {
        super(SimpleITKJNI.CropImageFilter_SWIGUpcast(l), bl);
        this.swigCPtr = l;
    }

    protected static long getCPtr(CropImageFilter cropImageFilter) {
        return cropImageFilter == null ? 0L : cropImageFilter.swigCPtr;
    }

    protected static long swigRelease(CropImageFilter cropImageFilter) {
        long l = 0L;
        if (cropImageFilter != null) {
            if (!cropImageFilter.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            l = cropImageFilter.swigCPtr;
            cropImageFilter.swigCMemOwn = false;
            cropImageFilter.delete();
        }
        return l;
    }

    @Override
    protected void finalize() {
        this.delete();
    }

    @Override
    public void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                SimpleITKJNI.delete_CropImageFilter(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public CropImageFilter() {
        this(SimpleITKJNI.new_CropImageFilter(), true);
    }

    public void setLowerBoundaryCropSize(VectorUInt32 vectorUInt32) {
        SimpleITKJNI.CropImageFilter_setLowerBoundaryCropSize(this.swigCPtr, this, VectorUInt32.getCPtr(vectorUInt32), vectorUInt32);
    }

    public VectorUInt32 getLowerBoundaryCropSize() {
        return new VectorUInt32(SimpleITKJNI.CropImageFilter_getLowerBoundaryCropSize(this.swigCPtr, this), true);
    }

    public void setUpperBoundaryCropSize(VectorUInt32 vectorUInt32) {
        SimpleITKJNI.CropImageFilter_setUpperBoundaryCropSize(this.swigCPtr, this, VectorUInt32.getCPtr(vectorUInt32), vectorUInt32);
    }

    public VectorUInt32 getUpperBoundaryCropSize() {
        return new VectorUInt32(SimpleITKJNI.CropImageFilter_getUpperBoundaryCropSize(this.swigCPtr, this), true);
    }

    @Override
    public String getName() {
        return SimpleITKJNI.CropImageFilter_getName(this.swigCPtr, this);
    }

    @Override
    public String toString() {
        return SimpleITKJNI.CropImageFilter_toString(this.swigCPtr, this);
    }

    public Image execute(Image image) {
        return new Image(SimpleITKJNI.CropImageFilter_execute(this.swigCPtr, this, Image.getCPtr(image), image), true);
    }
}

