/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.scan;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import org.apache.tomcat.Jar;
import org.apache.tomcat.util.compat.JreCompat;
import org.apache.tomcat.util.scan.NonClosingJarInputStream;

public abstract class AbstractInputStreamJar
implements Jar {
    private final URL jarFileURL;
    private NonClosingJarInputStream jarInputStream = null;
    private JarEntry entry = null;
    private Boolean multiRelease = null;
    private Map<String, String> mrMap = null;

    public AbstractInputStreamJar(URL uRL) {
        this.jarFileURL = uRL;
    }

    public URL getJarFileURL() {
        return this.jarFileURL;
    }

    public void nextEntry() {
        if (this.jarInputStream == null) {
            try {
                this.reset();
            }
            catch (IOException iOException) {
                this.entry = null;
                return;
            }
        }
        try {
            this.entry = this.jarInputStream.getNextJarEntry();
            if (this.multiRelease.booleanValue()) {
                while (this.entry != null && (this.mrMap.containsKey(this.entry.getName()) || this.entry.getName().startsWith("META-INF/versions/") && !this.mrMap.containsValue(this.entry.getName()))) {
                    this.entry = this.jarInputStream.getNextJarEntry();
                }
            } else {
                while (this.entry != null && this.entry.getName().startsWith("META-INF/versions/")) {
                    this.entry = this.jarInputStream.getNextJarEntry();
                }
            }
        }
        catch (IOException iOException) {
            this.entry = null;
        }
    }

    public String getEntryName() {
        if (this.entry == null) {
            return null;
        }
        return this.entry.getName();
    }

    public InputStream getEntryInputStream() throws IOException {
        return this.jarInputStream;
    }

    @Deprecated
    public boolean entryExists(String string) throws IOException {
        return false;
    }

    public InputStream getInputStream(String string) throws IOException {
        this.gotoEntry(string);
        if (this.entry == null) {
            return null;
        }
        this.entry = null;
        return this.jarInputStream;
    }

    public long getLastModified(String string) throws IOException {
        this.gotoEntry(string);
        if (this.entry == null) {
            return -1L;
        }
        return this.entry.getTime();
    }

    public boolean exists(String string) throws IOException {
        this.gotoEntry(string);
        return this.entry != null;
    }

    public String getURL(String string) {
        StringBuilder stringBuilder = new StringBuilder("jar:");
        stringBuilder.append(this.getJarFileURL().toExternalForm());
        stringBuilder.append("!/");
        stringBuilder.append(string);
        return stringBuilder.toString();
    }

    public Manifest getManifest() throws IOException {
        this.reset();
        return this.jarInputStream.getManifest();
    }

    public void reset() throws IOException {
        this.closeStream();
        this.entry = null;
        this.jarInputStream = this.createJarInputStream();
        if (this.multiRelease == null) {
            String string;
            Manifest manifest;
            this.multiRelease = JreCompat.isJre9Available() ? ((manifest = this.jarInputStream.getManifest()) == null ? Boolean.FALSE : ((string = manifest.getMainAttributes().getValue("Multi-Release")) == null ? Boolean.FALSE : Boolean.valueOf(string))) : Boolean.FALSE;
            if (this.multiRelease.booleanValue() && this.mrMap == null) {
                this.populateMrMap();
            }
        }
    }

    protected void closeStream() {
        if (this.jarInputStream != null) {
            try {
                this.jarInputStream.reallyClose();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected abstract NonClosingJarInputStream createJarInputStream() throws IOException;

    private void gotoEntry(String string) throws IOException {
        Object object;
        boolean bl = true;
        if (this.multiRelease == null) {
            this.reset();
            bl = false;
        }
        if (this.multiRelease.booleanValue()) {
            object = this.mrMap.get(string);
            if (object != null) {
                string = object;
            }
        } else if (string.startsWith("META-INF/versions/")) {
            this.entry = null;
            return;
        }
        if (this.entry != null && string.equals(this.entry.getName())) {
            return;
        }
        if (bl) {
            this.reset();
        }
        object = this.jarInputStream.getNextJarEntry();
        while (object != null) {
            if (string.equals(((ZipEntry)object).getName())) {
                this.entry = object;
                break;
            }
            object = this.jarInputStream.getNextJarEntry();
        }
    }

    private void populateMrMap() throws IOException {
        int n = JreCompat.getInstance().jarFileRuntimeMajorVersion();
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        JarEntry jarEntry = this.jarInputStream.getNextJarEntry();
        while (jarEntry != null) {
            int n2;
            String string = jarEntry.getName();
            if (string.startsWith("META-INF/versions/") && string.endsWith(".class") && (n2 = string.indexOf(47, 18)) > 0) {
                String string2 = string.substring(n2 + 1);
                int n3 = Integer.parseInt(string.substring(18, n2));
                if (n3 <= n) {
                    Integer n4 = (Integer)hashMap.get(string2);
                    if (n4 == null) {
                        hashMap.put(string2, n3);
                    } else if (n3 > n4) {
                        hashMap.put(string2, n3);
                    }
                }
            }
            jarEntry = this.jarInputStream.getNextJarEntry();
        }
        this.mrMap = new HashMap<String, String>();
        for (Map.Entry entry : hashMap.entrySet()) {
            this.mrMap.put((String)entry.getKey(), "META-INF/versions/" + ((Integer)entry.getValue()).toString() + "/" + (String)entry.getKey());
        }
        this.closeStream();
        this.jarInputStream = this.createJarInputStream();
    }
}

