/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.diagnostics;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.lang.reflect.Executable;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Base64;
import java.util.logging.Logger;
import javax.crypto.Cipher;

public class LogDecryptor {
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;

    public static void main(String[] arg) throws Exception {
        String keyFileName = arg[0];
        String logFileName = arg[1];
        String decryptFileName = arg[2];
        System.out.println("Key File : " + keyFileName);
        System.out.println("Log File : " + logFileName);
        LogDecryptor dl = new LogDecryptor();
        dl.decrypt(keyFileName, logFileName, decryptFileName);
    }

    private void decrypt(String keyFileName, String logFileName, String decryptFileName) throws Exception {
        PrivateKey privateKey = this.getPrivateKey(keyFileName, "RSA");
        Cipher rsaCipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
        rsaCipher.init(2, privateKey);
        DataInputStream dis = new DataInputStream(new FileInputStream(logFileName));
        byte[][] header = this.readSessionAndIV(dis);
        byte[] sessionKey = rsaCipher.doFinal(Base64.getDecoder().decode(header[0]));
        byte[] iv = rsaCipher.doFinal(Base64.getDecoder().decode(header[1]));
        this.decryptLog(dis, sessionKey, iv, decryptFileName);
    }

    private void decryptLog(DataInputStream dis, byte[] sessionKey, byte[] iv, String decryptFileName) throws Exception {
        throw new Error("LogDecryptor not supported");
    }

    private byte[][] readSessionAndIV(DataInputStream fis) throws Exception {
        byte[] key = new byte[fis.readInt()];
        byte[] iv = new byte[fis.readInt()];
        fis.read(key);
        fis.read(iv);
        return new byte[][]{key, iv};
    }

    private PrivateKey getPrivateKey(String filename, String algorithm) throws Exception {
        File f2 = new File(filename);
        DataInputStream dis = new DataInputStream(new FileInputStream(f2));
        byte[] keyBytes = new byte[(int)f2.length()];
        dis.readFully(keyBytes);
        dis.close();
        String temp = new String(keyBytes);
        String privKeyPEM = temp.replace("-----BEGIN PRIVATE KEY-----\n", "");
        privKeyPEM = privKeyPEM.replace("-----END PRIVATE KEY-----", "");
        byte[] decoded = Base64.getMimeDecoder().decode(privKeyPEM);
        PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(decoded);
        KeyFactory kf = KeyFactory.getInstance("RSA");
        return kf.generatePrivate(spec);
    }

    static {
        try {
            $$$methodRef$$$5 = LogDecryptor.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = LogDecryptor.class.getDeclaredMethod("getPrivateKey", String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = LogDecryptor.class.getDeclaredMethod("readSessionAndIV", DataInputStream.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = LogDecryptor.class.getDeclaredMethod("decryptLog", DataInputStream.class, byte[].class, byte[].class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = LogDecryptor.class.getDeclaredMethod("decrypt", String.class, String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = LogDecryptor.class.getDeclaredMethod("main", String[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

