/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.shadowed.com.ibm.icu.impl.number;

import java.math.BigDecimal;
import java.util.List;
import org.graalvm.shadowed.com.ibm.icu.impl.number.DecimalQuantity;
import org.graalvm.shadowed.com.ibm.icu.impl.number.MicroProps;
import org.graalvm.shadowed.com.ibm.icu.impl.number.MicroPropsGenerator;
import org.graalvm.shadowed.com.ibm.icu.impl.units.ComplexUnitsConverter;
import org.graalvm.shadowed.com.ibm.icu.impl.units.MeasureUnitImpl;
import org.graalvm.shadowed.com.ibm.icu.impl.units.UnitsRouter;
import org.graalvm.shadowed.com.ibm.icu.util.MeasureUnit;
import org.graalvm.shadowed.com.ibm.icu.util.ULocale;

public class UsagePrefsHandler
implements MicroPropsGenerator {
    private final MicroPropsGenerator fParent;
    private UnitsRouter fUnitsRouter;

    public UsagePrefsHandler(ULocale locale, MeasureUnit inputUnit, String usage, MicroPropsGenerator parent) {
        assert (parent != null);
        this.fParent = parent;
        this.fUnitsRouter = new UnitsRouter(MeasureUnitImpl.forIdentifier(inputUnit.getIdentifier()), locale, usage);
    }

    protected static void mixedMeasuresToMicros(ComplexUnitsConverter.ComplexConverterResult complexConverterResult, DecimalQuantity quantity, MicroProps outMicros) {
        outMicros.mixedMeasures = complexConverterResult.measures;
        outMicros.indexOfQuantity = complexConverterResult.indexOfQuantity;
        quantity.setToBigDecimal((BigDecimal)outMicros.mixedMeasures.get(outMicros.indexOfQuantity).getNumber());
    }

    public List<MeasureUnit> getOutputUnits() {
        return this.fUnitsRouter.getOutputUnits();
    }

    @Override
    public MicroProps processQuantity(DecimalQuantity quantity) {
        MicroProps micros = this.fParent.processQuantity(quantity);
        quantity.roundToInfinity();
        UnitsRouter.RouteResult routed = this.fUnitsRouter.route(quantity.toBigDecimal(), micros);
        micros.outputUnit = routed.outputUnit.build();
        UsagePrefsHandler.mixedMeasuresToMicros(routed.complexConverterResult, quantity, micros);
        return micros;
    }
}

