/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.data.text.impl;

import com.oracle.labs.mlrg.olcut.config.Configurable;
import com.oracle.labs.mlrg.olcut.provenance.ConfiguredObjectProvenance;
import com.oracle.labs.mlrg.olcut.provenance.impl.ConfiguredObjectProvenanceImpl;
import java.util.logging.Logger;
import org.tribuo.data.text.DocumentPreprocessor;

public class NewsPreprocessor
implements DocumentPreprocessor {
    private static final Logger logger = Logger.getLogger(NewsPreprocessor.class.getName());
    private static final String subjHeader = "Subject: ";

    @Override
    public String processDoc(String doc) {
        int sepInd = doc.indexOf("\n\n");
        if (sepInd < 0) {
            return doc;
        }
        int subjInd = doc.indexOf(subjHeader);
        if (subjInd < 0 || subjInd > sepInd) {
            return doc.substring(sepInd + 2);
        }
        int subjEnd = doc.indexOf(10, subjInd);
        if (subjEnd < 0 || subjEnd > sepInd) {
            return doc.substring(sepInd + 2);
        }
        return doc.substring(subjInd + subjHeader.length(), subjEnd) + '\n' + doc.substring(sepInd + 2);
    }

    public ConfiguredObjectProvenance getProvenance() {
        return new ConfiguredObjectProvenanceImpl((Configurable)this, "DocumentPreprocessor");
    }
}

