"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.resolutionOptions = exports.VISUALIZATION = exports.SPAN_RESOLUTION_REGEX = exports.SAVED_VISUALIZATION = exports.REDUX_SLICE_METRICS = exports.PPL_DATASOURCES_REQUEST = exports.OPEN_TELEMETRY = exports.OBSERVABILITY_CUSTOM_METRIC = exports.METRIC_EXPLORER_BASE_PATH = exports.METRICS_ANALYTICS_DATA_PREPPER_INDICES_ROUTE = exports.INDEX_DOCUMENT_NAME_PATTERN = exports.DATA_PREPPER_INDEX_NAME = exports.DATASOURCE_OPTIONS = exports.AGGREGATION_OPTIONS = void 0;
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const METRIC_EXPLORER_BASE_PATH = exports.METRIC_EXPLORER_BASE_PATH = 'observability-metrics#/';

// requests constants
const VISUALIZATION = exports.VISUALIZATION = 'viz';
const SAVED_VISUALIZATION = exports.SAVED_VISUALIZATION = 'savedVisualization';
const PPL_DATASOURCES_REQUEST = exports.PPL_DATASOURCES_REQUEST = 'show datasources | where CONNECTOR_TYPE="PROMETHEUS" | fields DATASOURCE_NAME';

// redux

const OBSERVABILITY_CUSTOM_METRIC = exports.OBSERVABILITY_CUSTOM_METRIC = 'CUSTOM_METRICS';
const OPEN_TELEMETRY = exports.OPEN_TELEMETRY = 'OpenTelemetry';
const REDUX_SLICE_METRICS = exports.REDUX_SLICE_METRICS = 'metrics';
const resolutionOptions = exports.resolutionOptions = [{
  value: 's',
  text: 'seconds'
}, {
  value: 'm',
  text: 'minutes'
}, {
  value: 'h',
  text: 'hours'
}, {
  value: 'd',
  text: 'days'
},
// { value: 'M', text: 'Months' }, // commenting it here as prometheus doesn't have support
// { value: 'q', text: 'quarters' },
{
  value: 'y',
  text: 'years'
}];
const AGGREGATION_OPTIONS = exports.AGGREGATION_OPTIONS = [{
  value: 'avg',
  text: 'avg()'
}, {
  value: 'sum',
  text: 'sum()'
}, {
  value: 'count',
  text: 'count()'
}, {
  value: 'min',
  text: 'min()'
}, {
  value: 'max',
  text: 'max()'
}];
const DATASOURCE_OPTIONS = exports.DATASOURCE_OPTIONS = [{
  label: 'Prometheus',
  'data-test-subj': 'prometheusOption'
}, {
  label: 'OpenTelemetry',
  'data-test-subj': 'openTelemetryOption'
}];
const DATA_PREPPER_INDEX_NAME = exports.DATA_PREPPER_INDEX_NAME = 'ss4o_metrics-*-*';
const METRICS_ANALYTICS_DATA_PREPPER_INDICES_ROUTE = exports.METRICS_ANALYTICS_DATA_PREPPER_INDICES_ROUTE = '/api/observability/metrics_analytics/data_prepper_indices';

// Regex pattens
const INDEX_DOCUMENT_NAME_PATTERN = exports.INDEX_DOCUMENT_NAME_PATTERN = /\[Otel Metric\]\s(\S+?-\S+?)\.(\S+)/;
const SPAN_RESOLUTION_REGEX = exports.SPAN_RESOLUTION_REGEX = /'(\d+)([smhdwMy])'/;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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