/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.functional.impl;

import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.infinispan.commons.util.ByRef;
import org.infinispan.commons.util.Experimental;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.commons.util.concurrent.CompletionStages;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.MVCCEntry;
import org.infinispan.container.impl.InternalEntryFactory;
import org.infinispan.context.impl.ImmutableContext;
import org.infinispan.expiration.impl.InternalExpirationManager;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.functional.EntryView;
import org.infinispan.functional.Traversable;
import org.infinispan.functional.impl.EntryViews;
import org.infinispan.functional.impl.FunctionalMapImpl;
import org.infinispan.functional.impl.Params;
import org.infinispan.functional.impl.ReadWriteMapImpl;
import org.infinispan.functional.impl.SimpleFunctionalMap;
import org.infinispan.functional.impl.SimpleWriteNotifierHelper;
import org.infinispan.functional.impl.Traversables;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryExpired;

@Experimental
public class SimpleReadWriteMapImpl<K, V>
extends ReadWriteMapImpl<K, V>
implements SimpleFunctionalMap<K, V> {
    private static final String KEY_CANNOT_BE_NULL = "Key cannot be null";
    private static final String FUNCTION_CANNOT_BE_NULL = "Function cannot be null";
    private final InternalExpirationManager<K, V> expirationManager;
    private final CacheNotifier<K, V> notifier;

    public SimpleReadWriteMapImpl(Params params, FunctionalMapImpl<K, V> functionalMap) {
        super(params, functionalMap);
        this.expirationManager = ComponentRegistry.componentOf(functionalMap.cache, InternalExpirationManager.class);
        this.notifier = ComponentRegistry.componentOf(functionalMap.cache, CacheNotifier.class);
    }

    @Override
    public <R> CompletableFuture<R> eval(K key, Function<EntryView.ReadWriteEntryView<K, V>, R> f) {
        return this.eval(key, null, (ignore, v) -> f.apply((EntryView.ReadWriteEntryView)v));
    }

    @Override
    public <T, R> CompletableFuture<R> eval(K key, T argument, BiFunction<T, EntryView.ReadWriteEntryView<K, V>, R> f) {
        int segment;
        CompletionStage<Boolean> expiration;
        K storageKey = this.toStorageKey(key);
        InternalCacheEntry ice = this.fmap.cache.getDataContainer().peek(storageKey);
        boolean expired = false;
        if (ice != null && ice.canExpire() && (expired = this.toLocalExecution((expiration = this.expirationManager.handlePossibleExpiration(ice, segment = this.fmap.keyPartitioner.getSegment(storageKey), true)).toCompletableFuture()).booleanValue()) && this.notifier.hasListener(CacheEntryExpired.class)) {
            CompletionStages.join(this.notifier.notifyCacheEntryExpired(ice.getKey(), ice.getValue(), ice.getMetadata(), ImmutableContext.INSTANCE));
        }
        try {
            InternalCacheEntry entry = !expired ? ice : null;
            R result = this.evalInternal(storageKey, argument, f, entry);
            return result == null ? CompletableFutures.completedNull() : CompletableFuture.completedFuture(result);
        }
        catch (Throwable t) {
            return CompletableFuture.failedFuture(t);
        }
    }

    @Override
    public <T, R> Traversable<R> evalMany(Map<? extends K, ? extends T> arguments, BiFunction<T, EntryView.ReadWriteEntryView<K, V>, R> f) {
        ArrayList<R> results = new ArrayList<R>(arguments.size());
        for (Map.Entry<K, T> me : arguments.entrySet()) {
            CompletableFuture<R> cf = this.eval(me.getKey(), me.getValue(), f);
            results.add(this.toLocalExecution(cf));
        }
        return Traversables.of(results.stream());
    }

    @Override
    public <R> Traversable<R> evalMany(Set<? extends K> keys, Function<EntryView.ReadWriteEntryView<K, V>, R> f) {
        ArrayList<Object> results = new ArrayList<Object>(keys.size());
        BiFunction<Object, EntryView.ReadWriteEntryView, Object> bf = (ignore, v) -> f.apply((EntryView.ReadWriteEntryView)v);
        for (K key : keys) {
            results.add(this.toLocalExecution(this.eval(key, null, bf)));
        }
        return Traversables.of(results.stream());
    }

    @Override
    public <R> Traversable<R> evalAll(Function<EntryView.ReadWriteEntryView<K, V>, R> f) {
        return this.evalMany((Set<? extends K>)((Object)this.fmap.cache.keySet()), f);
    }

    private <R, T> R evalInternal(K key, T argument, BiFunction<T, EntryView.ReadWriteEntryView<K, V>, R> f, InternalCacheEntry<K, V> override) {
        Objects.requireNonNull(key, KEY_CANNOT_BE_NULL);
        Objects.requireNonNull(f, FUNCTION_CANNOT_BE_NULL);
        ByRef result = new ByRef(null);
        ByRef holder = new ByRef(null);
        this.fmap.cache.getDataContainer().compute(key, (k, ignore, factory) -> this.compute(key, argument, f, override, factory, result, holder));
        SimpleWriteNotifierHelper.handleNotification(this.notifier, this.fmap.notifier, key, (SimpleWriteNotifierHelper.EntryHolder)holder.get(), false);
        return (R)result.get();
    }

    private <R, T> InternalCacheEntry<K, V> compute(K key, T argument, BiFunction<T, EntryView.ReadWriteEntryView<K, V>, R> f, InternalCacheEntry<K, V> oldEntry, InternalEntryFactory factory, ByRef<R> result, ByRef<SimpleWriteNotifierHelper.EntryHolder<K, V>> holder) {
        MVCCEntry<K, V> e = this.readCacheEntry(key, oldEntry);
        EntryViews.AccessLoggingReadWriteView view = EntryViews.readWrite(e, this.fmap.cache.getKeyDataConversion(), this.fmap.cache.getValueDataConversion());
        result.set(EntryViews.snapshot(f.apply(argument, view)));
        if (!e.isChanged()) {
            return oldEntry;
        }
        SimpleWriteNotifierHelper.EntryHolder<K, V> eh = oldEntry == null ? SimpleWriteNotifierHelper.create(null, e) : SimpleWriteNotifierHelper.create(factory.copy(oldEntry), e);
        holder.set(eh);
        SimpleWriteNotifierHelper.handleNotification(this.notifier, this.fmap.notifier, key, eh, true);
        if (e.isRemoved()) {
            return null;
        }
        return oldEntry == null ? factory.create(e) : factory.update(oldEntry, e.getValue(), e.getMetadata());
    }
}

