
####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was KDevelop-PG-QtConfig.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

# Use original install prefix when loaded through a "/usr move"
# cross-prefix symbolic link such as /lib -> /usr/lib.
get_filename_component(_realCurr "${CMAKE_CURRENT_LIST_DIR}" REALPATH)
get_filename_component(_realOrig "/usr/lib/cmake/KDevelop-PG-Qt" REALPATH)
if(_realCurr STREQUAL _realOrig)
  set(PACKAGE_PREFIX_DIR "/usr")
endif()
unset(_realOrig)
unset(_realCurr)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################

message(DEPRECATION "Since 2.4, use package name KDevelopPGQt and imported targets instead.")

include(CMakeFindDependencyMacro)
find_dependency(KDevelopPGQt "2.4.0")

# BACKWARD COMPATIBILITY

# KDEVPGQT_INCLUDE_DIR         - include dir of kdevelop-pg, for example /usr/include/kdevelop-pg
# KDEVPGQT_EXECUTABLE          - the absolute path to the kdevelop-pg executable
get_target_property(KDEVPGQT_INCLUDE_DIR KDevelopPGQt::Utils INTERFACE_INCLUDE_DIRECTORIES)
get_target_property(KDEVPGQT_EXECUTABLE KDevelopPGQt::kdev-pg-qt LOCATION)
set(KDEVPGQT_INCLUDE_DIR ${KDEVPGQT_INCLUDE_DIR} CACHE PATH "kdevelop-pg-qt include directory containing the headers")
set(KDEVPGQT_EXECUTABLE ${KDEVPGQT_EXECUTABLE} CACHE PATH "executable for kdevelop-pg-qt")

# warn about outdated variables
function(KDEVPGQT_deprecate_KDEVPGQT_INCLUDE_DIR varname access_type)
    if(access_type STREQUAL "READ_ACCESS")
        message(DEPRECATION "The variable KDEVPGQT_INCLUDE_DIR will be gone in future KDevelop-PG-Qt versions.\nSince 2.4, use the imported library target KDevelopPGQt::Utils instead.")
    endif()
endfunction()

function(KDEVPGQT_deprecate_KDEVPGQT_EXECUTABLE varname access_type)
    if(access_type STREQUAL "READ_ACCESS")
        message(DEPRECATION "The variable KDEVPGQT_EXECUTABLE will be gone in future KDevelop-PG-Qt versions.\nSince 2.4, use the imported executable target KDevelopPGQt::kdev-pg-qt instead.")
    endif()
endfunction()

variable_watch(KDEVPGQT_INCLUDE_DIR KDEVPGQT_deprecate_KDEVPGQT_INCLUDE_DIR)
variable_watch(KDEVPGQT_EXECUTABLE KDEVPGQT_deprecate_KDEVPGQT_EXECUTABLE)

macro(KDEVPGQT_GENERATE _srcOrTargetVar _language)
    message(DEPRECATION "The macro KDEVPGQT_GENERATE will be gone in future KDevelop-PG-Qt versions. Use the new name KDEVELOPPGQT_GENERATE instead.")
    kdeveloppgqt_generate(${_srcOrTargetVar} ${_language} ${ARGN})
endmacro()
