/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.net.Socket;
import java.security.AlgorithmConstraints;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.HashSet;
import javax.net.ssl.ExtendedSSLSession;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509TrustManager;
import sun.security.provider.certpath.AlgorithmChecker;
import sun.security.ssl.ProtocolVersion;
import sun.security.ssl.SSLAlgorithmConstraints;
import sun.security.ssl.X509TrustManagerImpl;

final class AbstractTrustManagerWrapper
extends X509ExtendedTrustManager
implements X509TrustManager {
    private final X509TrustManager tm;

    AbstractTrustManagerWrapper(X509TrustManager x509TrustManager) {
        this.tm = x509TrustManager;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        this.tm.checkClientTrusted(x509CertificateArray, string);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        this.tm.checkServerTrusted(x509CertificateArray, string);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.tm.getAcceptedIssuers();
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string, Socket socket) throws CertificateException {
        this.tm.checkClientTrusted(x509CertificateArray, string);
        this.checkAdditionalTrust(x509CertificateArray, string, socket, true);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string, Socket socket) throws CertificateException {
        this.tm.checkServerTrusted(x509CertificateArray, string);
        this.checkAdditionalTrust(x509CertificateArray, string, socket, false);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string, SSLEngine sSLEngine) throws CertificateException {
        this.tm.checkClientTrusted(x509CertificateArray, string);
        this.checkAdditionalTrust(x509CertificateArray, string, sSLEngine, true);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string, SSLEngine sSLEngine) throws CertificateException {
        this.tm.checkServerTrusted(x509CertificateArray, string);
        this.checkAdditionalTrust(x509CertificateArray, string, sSLEngine, false);
    }

    private void checkAdditionalTrust(X509Certificate[] x509CertificateArray, String string, Socket socket, boolean bl) throws CertificateException {
        if (socket != null && socket.isConnected() && socket instanceof SSLSocket) {
            SSLAlgorithmConstraints sSLAlgorithmConstraints;
            SSLSocket sSLSocket = (SSLSocket)socket;
            SSLSession sSLSession = sSLSocket.getHandshakeSession();
            if (sSLSession == null) {
                throw new CertificateException("No handshake session");
            }
            String string2 = sSLSocket.getSSLParameters().getEndpointIdentificationAlgorithm();
            if (string2 != null && !string2.isEmpty()) {
                X509TrustManagerImpl.checkIdentity(sSLSession, x509CertificateArray, string2, bl);
            }
            if (ProtocolVersion.useTLS12PlusSpec(sSLSession.getProtocol())) {
                if (sSLSession instanceof ExtendedSSLSession) {
                    ExtendedSSLSession extendedSSLSession = (ExtendedSSLSession)sSLSession;
                    String[] stringArray = extendedSSLSession.getLocalSupportedSignatureAlgorithms();
                    sSLAlgorithmConstraints = new SSLAlgorithmConstraints(sSLSocket, stringArray, true);
                } else {
                    sSLAlgorithmConstraints = new SSLAlgorithmConstraints(sSLSocket, true);
                }
            } else {
                sSLAlgorithmConstraints = new SSLAlgorithmConstraints(sSLSocket, true);
            }
            this.checkAlgorithmConstraints(x509CertificateArray, sSLAlgorithmConstraints, bl);
        }
    }

    private void checkAdditionalTrust(X509Certificate[] x509CertificateArray, String string, SSLEngine sSLEngine, boolean bl) throws CertificateException {
        if (sSLEngine != null) {
            SSLAlgorithmConstraints sSLAlgorithmConstraints;
            SSLSession sSLSession = sSLEngine.getHandshakeSession();
            if (sSLSession == null) {
                throw new CertificateException("No handshake session");
            }
            String string2 = sSLEngine.getSSLParameters().getEndpointIdentificationAlgorithm();
            if (string2 != null && !string2.isEmpty()) {
                X509TrustManagerImpl.checkIdentity(sSLSession, x509CertificateArray, string2, bl);
            }
            if (ProtocolVersion.useTLS12PlusSpec(sSLSession.getProtocol())) {
                if (sSLSession instanceof ExtendedSSLSession) {
                    ExtendedSSLSession extendedSSLSession = (ExtendedSSLSession)sSLSession;
                    String[] stringArray = extendedSSLSession.getLocalSupportedSignatureAlgorithms();
                    sSLAlgorithmConstraints = new SSLAlgorithmConstraints(sSLEngine, stringArray, true);
                } else {
                    sSLAlgorithmConstraints = new SSLAlgorithmConstraints(sSLEngine, true);
                }
            } else {
                sSLAlgorithmConstraints = new SSLAlgorithmConstraints(sSLEngine, true);
            }
            this.checkAlgorithmConstraints(x509CertificateArray, sSLAlgorithmConstraints, bl);
        }
    }

    private void checkAlgorithmConstraints(X509Certificate[] x509CertificateArray, AlgorithmConstraints algorithmConstraints, boolean bl) throws CertificateException {
        try {
            int n = x509CertificateArray.length - 1;
            HashSet hashSet = new HashSet();
            X509Certificate[] x509CertificateArray2 = this.tm.getAcceptedIssuers();
            if (x509CertificateArray2 != null && x509CertificateArray2.length > 0) {
                Collections.addAll(hashSet, x509CertificateArray2);
            }
            if (hashSet.contains(x509CertificateArray[n])) {
                --n;
            }
            if (n >= 0) {
                AlgorithmChecker algorithmChecker = new AlgorithmChecker(algorithmConstraints, bl ? "tls client" : "tls server");
                algorithmChecker.init(false);
                for (int i = n; i >= 0; --i) {
                    X509Certificate x509Certificate = x509CertificateArray[i];
                    algorithmChecker.check(x509Certificate, Collections.emptySet());
                }
            }
        }
        catch (CertPathValidatorException certPathValidatorException) {
            throw new CertificateException("Certificates do not conform to algorithm constraints", certPathValidatorException);
        }
    }
}

