/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.preview;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphController;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.GraphView;
import org.gephi.graph.api.Node;
import org.gephi.preview.AbstractRenderTarget;
import org.gephi.preview.PreviewModelImpl;
import org.gephi.preview.api.Item;
import org.gephi.preview.api.PreviewController;
import org.gephi.preview.api.PreviewModel;
import org.gephi.preview.api.PreviewMouseEvent;
import org.gephi.preview.api.PreviewProperties;
import org.gephi.preview.api.RenderTarget;
import org.gephi.preview.spi.MouseResponsiveRenderer;
import org.gephi.preview.spi.PreviewMouseListener;
import org.gephi.preview.spi.RenderTargetBuilder;
import org.gephi.preview.spi.Renderer;
import org.gephi.project.api.ProjectController;
import org.gephi.project.api.Workspace;
import org.gephi.project.spi.Controller;
import org.gephi.utils.progress.Progress;
import org.gephi.utils.progress.ProgressTicket;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

public class PreviewControllerImpl
implements PreviewController,
Controller<PreviewModelImpl> {
    private Renderer[] registeredRenderers = null;
    private Boolean anyPluginRendererRegistered = null;
    private boolean mousePressed = false;

    public PreviewModelImpl newModel(Workspace workspace) {
        return new PreviewModelImpl(workspace);
    }

    public Class<PreviewModelImpl> getModelClass() {
        return PreviewModelImpl.class;
    }

    @Override
    public PreviewModelImpl getModel(Workspace workspace) {
        return (PreviewModelImpl)super.getModel(workspace);
    }

    @Override
    public PreviewModelImpl getModel() {
        return (PreviewModelImpl)super.getModel();
    }

    @Override
    public void refreshPreview() {
        this.refreshPreview(this.getModel().getWorkspace());
    }

    @Override
    public synchronized void refreshPreview(Workspace workspace) {
        Renderer[] renderers;
        GraphModel graphModel = ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getGraphModel(workspace);
        PreviewModelImpl previewModel = this.getModel(workspace);
        previewModel.clear();
        previewModel.getProperties().putValue("directed", graphModel.isDirected() || graphModel.isMixed());
        Graph graph = graphModel.getGraphVisible();
        if (previewModel.getProperties().getFloatValue("visibility-ratio") < 1.0f) {
            float visibilityRatio = previewModel.getProperties().getFloatValue("visibility-ratio");
            GraphView reducedView = graphModel.copyView(graph.getView());
            graph = graphModel.getGraph(reducedView);
            Node[] nodes = graph.getNodes().toArray();
            for (int i = 0; i < nodes.length; ++i) {
                float r2 = (float)i / (float)nodes.length;
                if (!(r2 > visibilityRatio)) continue;
                graph.removeNode(nodes[i]);
            }
        }
        if (!this.mousePressed) {
            renderers = previewModel.getManagedEnabledRenderers();
        } else {
            ArrayList<Renderer> renderersList = new ArrayList<Renderer>();
            for (Renderer renderer : previewModel.getManagedEnabledRenderers()) {
                if (!(renderer instanceof MouseResponsiveRenderer)) continue;
                renderersList.add(renderer);
            }
            renderers = renderersList.toArray(new Renderer[0]);
        }
        if (renderers == null) {
            renderers = this.getRegisteredRenderers();
        }
        boolean globalCanvasSize = previewModel.isGlobalCanvasSize() && !graph.getView().isMainView();
        previewModel.buildAndLoadItems(renderers, globalCanvasSize ? graph.getModel().getGraph() : graph);
        Arrays.stream(renderers).forEachOrdered(r -> r.preProcess(previewModel));
        previewModel.updateCanvasSize(renderers);
        if (globalCanvasSize) {
            previewModel.clear();
            previewModel.buildAndLoadItems(renderers, graph);
            Arrays.stream(renderers).forEachOrdered(r -> r.preProcess(previewModel));
        }
        if (previewModel.getProperties().getFloatValue("visibility-ratio") < 1.0f) {
            graphModel.destroyView(graph.getView());
        }
    }

    @Override
    public void render(RenderTarget target) {
        PreviewModelImpl m = this.getModel();
        this.render(target, m.getManagedEnabledRenderers(), m);
    }

    @Override
    public void render(RenderTarget target, Workspace workspace) {
        PreviewModelImpl m = this.getModel(workspace);
        this.render(target, m.getManagedEnabledRenderers(), m);
    }

    @Override
    public void render(RenderTarget target, Renderer[] renderers) {
        this.render(target, renderers, this.getModel());
    }

    @Override
    public void render(RenderTarget target, Renderer[] renderers, Workspace workspace) {
        this.render(target, renderers != null ? renderers : this.getModel(workspace).getManagedEnabledRenderers(), this.getModel(workspace));
    }

    private synchronized void render(RenderTarget target, Renderer[] renderers, PreviewModelImpl previewModel) {
        if (previewModel != null) {
            PreviewProperties properties = previewModel.getProperties();
            ProgressTicket progressTicket = null;
            if (target instanceof AbstractRenderTarget) {
                int tasks = 0;
                Renderer[] rendererArray = renderers;
                int n = rendererArray.length;
                for (int i = 0; i < n; ++i) {
                    Renderer r = rendererArray[i];
                    if (this.mousePressed && !(r instanceof MouseResponsiveRenderer)) continue;
                    ++tasks;
                    String[] stringArray = previewModel.getItemTypes();
                    int n2 = stringArray.length;
                    for (int j = 0; j < n2; ++j) {
                        String type = stringArray[j];
                        Item[] itemArray = previewModel.getItems(type);
                        int n3 = itemArray.length;
                        for (int k = 0; k < n3; ++k) {
                            Item item = itemArray[k];
                            if (!r.isRendererForitem(item, properties)) continue;
                            ++tasks;
                        }
                    }
                }
                progressTicket = ((AbstractRenderTarget)((Object)target)).getProgressTicket();
                Progress.switchToDeterminate((ProgressTicket)progressTicket, (int)tasks);
            }
            for (Renderer r : renderers) {
                if (this.mousePressed && !(r instanceof MouseResponsiveRenderer)) continue;
                for (String type : previewModel.getItemTypes()) {
                    for (Item item : previewModel.getItems(type)) {
                        if (!r.isRendererForitem(item, properties)) continue;
                        try {
                            r.render(item, target, properties);
                        }
                        catch (Exception e) {
                            Exceptions.printStackTrace((Throwable)e);
                        }
                        Progress.progress((ProgressTicket)progressTicket);
                        if (!(target instanceof AbstractRenderTarget) || !((AbstractRenderTarget)((Object)target)).isCancelled()) continue;
                        Progress.finish((ProgressTicket)progressTicket);
                        return;
                    }
                }
                r.postProcess(previewModel, target, properties);
                Progress.progress((ProgressTicket)progressTicket);
            }
            Progress.finish(progressTicket);
        }
    }

    @Override
    public RenderTarget getRenderTarget(String name) {
        return this.getRenderTarget(name, this.getModel());
    }

    @Override
    public RenderTarget getRenderTarget(String name, Workspace workspace) {
        return this.getRenderTarget(name, this.getModel(workspace));
    }

    private synchronized RenderTarget getRenderTarget(String name, PreviewModel m) {
        if (m != null) {
            for (RenderTargetBuilder rtb : Lookup.getDefault().lookupAll(RenderTargetBuilder.class)) {
                if (!rtb.getName().equals(name)) continue;
                return rtb.buildRenderTarget(m);
            }
        }
        return null;
    }

    @Override
    public Renderer[] getRegisteredRenderers() {
        if (this.registeredRenderers == null) {
            LinkedHashMap<String, Renderer> renderers = new LinkedHashMap<String, Renderer>();
            for (Renderer r : Lookup.getDefault().lookupAll(Renderer.class)) {
                renderers.put(r.getClass().getName(), r);
            }
            for (Renderer r : renderers.values().toArray(new Renderer[0])) {
                Class<?> superClass = r.getClass().getSuperclass();
                if (superClass == null || !superClass.getName().startsWith("org.gephi.preview.plugin.renderers.")) continue;
                renderers.remove(superClass.getName());
            }
            this.registeredRenderers = renderers.values().toArray(new Renderer[0]);
        }
        return this.registeredRenderers;
    }

    @Override
    public boolean isAnyPluginRendererRegistered() {
        if (this.anyPluginRendererRegistered == null) {
            this.anyPluginRendererRegistered = false;
            for (Renderer renderer : this.getRegisteredRenderers()) {
                if (renderer.getClass().getName().startsWith("org.gephi.preview.plugin.renderers.")) continue;
                this.anyPluginRendererRegistered = true;
                break;
            }
        }
        return this.anyPluginRendererRegistered;
    }

    @Override
    public boolean sendMouseEvent(PreviewMouseEvent event) {
        return this.sendMouseEvent(event, ((ProjectController)Lookup.getDefault().lookup(ProjectController.class)).getCurrentWorkspace());
    }

    @Override
    public boolean sendMouseEvent(PreviewMouseEvent event, Workspace workspace) {
        if (workspace == null) {
            return false;
        }
        PreviewModelImpl previewModel = this.getModel(workspace);
        if (event.type != PreviewMouseEvent.Type.DRAGGED && event.type != PreviewMouseEvent.Type.RELEASED || this.mousePressed) {
            for (PreviewMouseListener listener : previewModel.getEnabledMouseListeners()) {
                switch (event.type) {
                    case CLICKED: {
                        listener.mouseClicked(event, previewModel.getProperties(), workspace);
                        break;
                    }
                    case PRESSED: {
                        this.mousePressed = true;
                        listener.mousePressed(event, previewModel.getProperties(), workspace);
                        break;
                    }
                    case DRAGGED: {
                        listener.mouseDragged(event, previewModel.getProperties(), workspace);
                        break;
                    }
                    case RELEASED: {
                        this.mousePressed = false;
                        listener.mouseReleased(event, previewModel.getProperties(), workspace);
                    }
                }
                if (!event.isConsumed()) continue;
                return true;
            }
        }
        this.mousePressed = false;
        return false;
    }

    @Override
    public void setGlobalCanvasSize(boolean globalCanvasSize) {
        PreviewModelImpl model = this.getModel();
        if (model != null) {
            model.setGlobalCanvasSize(globalCanvasSize);
        }
    }
}

