﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/networkmonitor/NetworkMonitorRequest.h>
#include <aws/networkmonitor/NetworkMonitor_EXPORTS.h>

#include <utility>

namespace Aws {
namespace NetworkMonitor {
namespace Model {

/**
 */
class UpdateMonitorRequest : public NetworkMonitorRequest {
 public:
  AWS_NETWORKMONITOR_API UpdateMonitorRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "UpdateMonitor"; }

  AWS_NETWORKMONITOR_API Aws::String SerializePayload() const override;

  ///@{
  /**
   * <p>The name of the monitor to update. </p>
   */
  inline const Aws::String& GetMonitorName() const { return m_monitorName; }
  inline bool MonitorNameHasBeenSet() const { return m_monitorNameHasBeenSet; }
  template <typename MonitorNameT = Aws::String>
  void SetMonitorName(MonitorNameT&& value) {
    m_monitorNameHasBeenSet = true;
    m_monitorName = std::forward<MonitorNameT>(value);
  }
  template <typename MonitorNameT = Aws::String>
  UpdateMonitorRequest& WithMonitorName(MonitorNameT&& value) {
    SetMonitorName(std::forward<MonitorNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The aggregation time, in seconds, to change to. This must be either
   * <code>30</code> or <code>60</code>. </p>
   */
  inline long long GetAggregationPeriod() const { return m_aggregationPeriod; }
  inline bool AggregationPeriodHasBeenSet() const { return m_aggregationPeriodHasBeenSet; }
  inline void SetAggregationPeriod(long long value) {
    m_aggregationPeriodHasBeenSet = true;
    m_aggregationPeriod = value;
  }
  inline UpdateMonitorRequest& WithAggregationPeriod(long long value) {
    SetAggregationPeriod(value);
    return *this;
  }
  ///@}
 private:
  Aws::String m_monitorName;
  bool m_monitorNameHasBeenSet = false;

  long long m_aggregationPeriod{0};
  bool m_aggregationPeriodHasBeenSet = false;
};

}  // namespace Model
}  // namespace NetworkMonitor
}  // namespace Aws
