﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/lexv2-models/LexModelsV2_EXPORTS.h>
#include <aws/lexv2-models/model/BotVersionReplicationStatus.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace LexModelsV2 {
namespace Model {

/**
 * <p>Contains summary information for all the version replication statuses
 * applicable for Global resiliency.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/BotVersionReplicaSummary">AWS
 * API Reference</a></p>
 */
class BotVersionReplicaSummary {
 public:
  AWS_LEXMODELSV2_API BotVersionReplicaSummary() = default;
  AWS_LEXMODELSV2_API BotVersionReplicaSummary(Aws::Utils::Json::JsonView jsonValue);
  AWS_LEXMODELSV2_API BotVersionReplicaSummary& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_LEXMODELSV2_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The bot version for the summary information for all the version replication
   * statuses.</p>
   */
  inline const Aws::String& GetBotVersion() const { return m_botVersion; }
  inline bool BotVersionHasBeenSet() const { return m_botVersionHasBeenSet; }
  template <typename BotVersionT = Aws::String>
  void SetBotVersion(BotVersionT&& value) {
    m_botVersionHasBeenSet = true;
    m_botVersion = std::forward<BotVersionT>(value);
  }
  template <typename BotVersionT = Aws::String>
  BotVersionReplicaSummary& WithBotVersion(BotVersionT&& value) {
    SetBotVersion(std::forward<BotVersionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The version replication status for all the replicated bots.</p>
   */
  inline BotVersionReplicationStatus GetBotVersionReplicationStatus() const { return m_botVersionReplicationStatus; }
  inline bool BotVersionReplicationStatusHasBeenSet() const { return m_botVersionReplicationStatusHasBeenSet; }
  inline void SetBotVersionReplicationStatus(BotVersionReplicationStatus value) {
    m_botVersionReplicationStatusHasBeenSet = true;
    m_botVersionReplicationStatus = value;
  }
  inline BotVersionReplicaSummary& WithBotVersionReplicationStatus(BotVersionReplicationStatus value) {
    SetBotVersionReplicationStatus(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The creation date and time of the replication status for all the replicated
   * bots.</p>
   */
  inline const Aws::Utils::DateTime& GetCreationDateTime() const { return m_creationDateTime; }
  inline bool CreationDateTimeHasBeenSet() const { return m_creationDateTimeHasBeenSet; }
  template <typename CreationDateTimeT = Aws::Utils::DateTime>
  void SetCreationDateTime(CreationDateTimeT&& value) {
    m_creationDateTimeHasBeenSet = true;
    m_creationDateTime = std::forward<CreationDateTimeT>(value);
  }
  template <typename CreationDateTimeT = Aws::Utils::DateTime>
  BotVersionReplicaSummary& WithCreationDateTime(CreationDateTimeT&& value) {
    SetCreationDateTime(std::forward<CreationDateTimeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The reasons for replication failure for all the replicated bots.</p>
   */
  inline const Aws::Vector<Aws::String>& GetFailureReasons() const { return m_failureReasons; }
  inline bool FailureReasonsHasBeenSet() const { return m_failureReasonsHasBeenSet; }
  template <typename FailureReasonsT = Aws::Vector<Aws::String>>
  void SetFailureReasons(FailureReasonsT&& value) {
    m_failureReasonsHasBeenSet = true;
    m_failureReasons = std::forward<FailureReasonsT>(value);
  }
  template <typename FailureReasonsT = Aws::Vector<Aws::String>>
  BotVersionReplicaSummary& WithFailureReasons(FailureReasonsT&& value) {
    SetFailureReasons(std::forward<FailureReasonsT>(value));
    return *this;
  }
  template <typename FailureReasonsT = Aws::String>
  BotVersionReplicaSummary& AddFailureReasons(FailureReasonsT&& value) {
    m_failureReasonsHasBeenSet = true;
    m_failureReasons.emplace_back(std::forward<FailureReasonsT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_botVersion;
  bool m_botVersionHasBeenSet = false;

  BotVersionReplicationStatus m_botVersionReplicationStatus{BotVersionReplicationStatus::NOT_SET};
  bool m_botVersionReplicationStatusHasBeenSet = false;

  Aws::Utils::DateTime m_creationDateTime{};
  bool m_creationDateTimeHasBeenSet = false;

  Aws::Vector<Aws::String> m_failureReasons;
  bool m_failureReasonsHasBeenSet = false;
};

}  // namespace Model
}  // namespace LexModelsV2
}  // namespace Aws
