/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.hyphenation;

import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.apache.fop.hyphenation.HyphenationTree;

public class HyphenationTreeCache {
    private Hashtable hyphenTrees = new Hashtable();
    private Set missingHyphenationTrees;

    public HyphenationTree getHyphenationTree(String lang, String country) {
        String key = HyphenationTreeCache.constructLlccKey(lang, country);
        if (this.hyphenTrees.containsKey(key)) {
            return (HyphenationTree)this.hyphenTrees.get(key);
        }
        if (this.hyphenTrees.containsKey(lang)) {
            return (HyphenationTree)this.hyphenTrees.get(lang);
        }
        return null;
    }

    public static String constructLlccKey(String lang, String country) {
        String key = lang;
        if (country != null && !country.equals("none")) {
            key = key + "_" + country;
        }
        return key;
    }

    public static String constructUserKey(String lang, String country, Map hyphPatNames) {
        String userKey = null;
        if (hyphPatNames != null) {
            String key = HyphenationTreeCache.constructLlccKey(lang, country);
            key = key.replace('_', '-');
            userKey = (String)hyphPatNames.get(key);
        }
        return userKey;
    }

    public void cache(String key, HyphenationTree hTree) {
        this.hyphenTrees.put(key, hTree);
    }

    public void noteMissing(String key) {
        if (this.missingHyphenationTrees == null) {
            this.missingHyphenationTrees = new HashSet();
        }
        this.missingHyphenationTrees.add(key);
    }

    public boolean isMissing(String key) {
        return this.missingHyphenationTrees != null && this.missingHyphenationTrees.contains(key);
    }
}

