/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.properties;

import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.expr.PropertyException;
import org.apache.fop.fo.properties.CompoundPropertyMaker;
import org.apache.fop.fo.properties.LengthRangeProperty;
import org.apache.fop.fo.properties.Property;
import org.apache.fop.util.CompareUtil;

public class SpaceProperty
extends LengthRangeProperty {
    private Property precedence;
    private Property conditionality;

    @Override
    public void setComponent(int cmpId, Property cmpnValue, boolean bIsDefault) {
        if (cmpId == 4096) {
            this.setPrecedence(cmpnValue, bIsDefault);
        } else if (cmpId == 1024) {
            this.setConditionality(cmpnValue, bIsDefault);
        } else {
            super.setComponent(cmpId, cmpnValue, bIsDefault);
        }
    }

    @Override
    public Property getComponent(int cmpId) {
        if (cmpId == 4096) {
            return this.getPrecedence();
        }
        if (cmpId == 1024) {
            return this.getConditionality();
        }
        return super.getComponent(cmpId);
    }

    protected void setPrecedence(Property precedence, boolean bIsDefault) {
        this.precedence = precedence;
    }

    protected void setConditionality(Property conditionality, boolean bIsDefault) {
        this.conditionality = conditionality;
    }

    public Property getPrecedence() {
        return this.precedence;
    }

    public Property getConditionality() {
        return this.conditionality;
    }

    public boolean isDiscard() {
        return this.conditionality.getEnum() == 32;
    }

    @Override
    public String toString() {
        return "Space[min:" + this.getMinimum(null).getObject() + ", max:" + this.getMaximum(null).getObject() + ", opt:" + this.getOptimum(null).getObject() + ", precedence:" + this.precedence.getObject() + ", conditionality:" + this.conditionality.getObject() + "]";
    }

    @Override
    public SpaceProperty getSpace() {
        return this;
    }

    @Override
    public LengthRangeProperty getLengthRange() {
        return this;
    }

    @Override
    public Object getObject() {
        return this;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + CompareUtil.getHashCode(this.precedence);
        result = 31 * result + CompareUtil.getHashCode(this.conditionality);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SpaceProperty)) {
            return false;
        }
        SpaceProperty other = (SpaceProperty)obj;
        return super.equals(obj) && CompareUtil.equal(this.precedence, other.precedence) && CompareUtil.equal(this.conditionality, other.conditionality);
    }

    public static class Maker
    extends CompoundPropertyMaker {
        public Maker(int propId) {
            super(propId);
        }

        @Override
        public Property makeNewProperty() {
            return new SpaceProperty();
        }

        @Override
        public Property convertProperty(Property p, PropertyList propertyList, FObj fo) throws PropertyException {
            if (p instanceof SpaceProperty) {
                return p;
            }
            return super.convertProperty(p, propertyList, fo);
        }
    }
}

