/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.apps.rasterizer;

import java.io.IOException;
import java.io.InputStream;
import org.apache.batik.apps.rasterizer.SVGConverterException;
import org.apache.batik.apps.rasterizer.SVGConverterSource;
import org.apache.batik.util.ParsedURL;

public class SVGConverterURLSource
implements SVGConverterSource {
    protected static final String SVG_EXTENSION = ".svg";
    protected static final String SVGZ_EXTENSION = ".svgz";
    public static final String ERROR_INVALID_URL = "SVGConverterURLSource.error.invalid.url";
    ParsedURL purl;
    String name;

    public SVGConverterURLSource(String string) throws SVGConverterException {
        this.purl = new ParsedURL(string);
        String string2 = this.purl.getPath();
        if (string2 == null || !string2.toLowerCase().endsWith(SVG_EXTENSION) && !string2.toLowerCase().endsWith(SVGZ_EXTENSION)) {
            throw new SVGConverterException(ERROR_INVALID_URL, new Object[]{string});
        }
        int n = string2.lastIndexOf("/");
        if (n != -1) {
            string2 = string2.substring(n + 1);
        }
        this.name = string2;
        String string3 = this.purl.getRef();
        if (string3 != null && string3.length() != 0) {
            this.name = this.name + "" + string3.hashCode();
        }
    }

    public String toString() {
        return this.purl.toString();
    }

    public String getURI() {
        return this.toString();
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof SVGConverterURLSource)) {
            return false;
        }
        return this.purl.equals(((SVGConverterURLSource)object).purl);
    }

    public InputStream openStream() throws IOException {
        return this.purl.openStream();
    }

    public boolean isSameAs(String string) {
        return this.toString().equals(string);
    }

    public boolean isReadable() {
        return true;
    }

    public String getName() {
        return this.name;
    }
}

