/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.properties;

import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.Space;
import org.apache.fop.fo.EnumProperty;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.LengthProperty;
import org.apache.fop.fo.NumberProperty;
import org.apache.fop.fo.Property;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.SpaceProperty;

public class GenericSpace
extends SpaceProperty.Maker {
    private static final Property.Maker s_MinimumMaker = new LengthProperty.Maker("generic-space.minimum");
    private static final Property.Maker s_OptimumMaker = new LengthProperty.Maker("generic-space.optimum");
    private static final Property.Maker s_MaximumMaker = new LengthProperty.Maker("generic-space.maximum");
    private static final Property.Maker s_PrecedenceMaker = new SP_PrecedenceMaker("generic-space.precedence");
    private static final Property.Maker s_ConditionalityMaker = new SP_ConditionalityMaker("generic-space.conditionality");
    Property.Maker m_shorthandMaker = this.getSubpropMaker("minimum");
    private Property m_defaultProp = null;

    protected GenericSpace(String name) {
        super(name);
    }

    public Property checkEnumValues(String value) {
        return this.m_shorthandMaker.checkEnumValues(value);
    }

    public Property convertProperty(Property p, PropertyList pList, FObj fo) throws FOPException {
        if (p instanceof SpaceProperty) {
            return p;
        }
        if (!(p instanceof EnumProperty)) {
            p = this.m_shorthandMaker.convertProperty(p, pList, fo);
        }
        if (p != null) {
            Property prop = this.makeCompound(pList, fo);
            Space pval = prop.getSpace();
            pval.setComponent("minimum", p, false);
            pval.setComponent("optimum", p, false);
            pval.setComponent("maximum", p, false);
            return prop;
        }
        return null;
    }

    protected String getDefaultForConditionality() {
        return "discard";
    }

    protected String getDefaultForMaximum() {
        return "0pt";
    }

    protected String getDefaultForMinimum() {
        return "0pt";
    }

    protected String getDefaultForOptimum() {
        return "0pt";
    }

    protected String getDefaultForPrecedence() {
        return "0";
    }

    protected Property.Maker getSubpropMaker(String subprop) {
        if (subprop.equals("minimum")) {
            return s_MinimumMaker;
        }
        if (subprop.equals("optimum")) {
            return s_OptimumMaker;
        }
        if (subprop.equals("maximum")) {
            return s_MaximumMaker;
        }
        if (subprop.equals("precedence")) {
            return s_PrecedenceMaker;
        }
        if (subprop.equals("conditionality")) {
            return s_ConditionalityMaker;
        }
        return super.getSubpropMaker(subprop);
    }

    public Property getSubpropValue(Property baseProp, String subpropName) {
        Space val = baseProp.getSpace();
        return val.getComponent(subpropName);
    }

    protected boolean isCompoundMaker() {
        return true;
    }

    public boolean isInherited() {
        return false;
    }

    public Property make(PropertyList propertyList) throws FOPException {
        if (this.m_defaultProp == null) {
            this.m_defaultProp = this.makeCompound(propertyList, propertyList.getParentFObj());
        }
        return this.m_defaultProp;
    }

    protected Property makeCompound(PropertyList pList, FObj fo) throws FOPException {
        Space p = new Space();
        Property subProp = this.getSubpropMaker("minimum").make(pList, this.getDefaultForMinimum(), fo);
        p.setComponent("minimum", subProp, true);
        subProp = this.getSubpropMaker("optimum").make(pList, this.getDefaultForOptimum(), fo);
        p.setComponent("optimum", subProp, true);
        subProp = this.getSubpropMaker("maximum").make(pList, this.getDefaultForMaximum(), fo);
        p.setComponent("maximum", subProp, true);
        subProp = this.getSubpropMaker("precedence").make(pList, this.getDefaultForPrecedence(), fo);
        p.setComponent("precedence", subProp, true);
        subProp = this.getSubpropMaker("conditionality").make(pList, this.getDefaultForConditionality(), fo);
        p.setComponent("conditionality", subProp, true);
        return new SpaceProperty(p);
    }

    public static Property.Maker maker(String propName) {
        return new GenericSpace(propName);
    }

    protected Property setSubprop(Property baseProp, String subpropName, Property subProp) {
        Space val = baseProp.getSpace();
        val.setComponent(subpropName, subProp, false);
        return baseProp;
    }

    public static interface Enums {

        public static interface Precedence {
            public static final int FORCE = 41;
        }

        public static interface Conditionality {
            public static final int DISCARD = 23;
            public static final int RETAIN = 95;
        }
    }

    private static class SP_PrecedenceMaker
    extends NumberProperty.Maker
    implements Enums.Precedence {
        protected static final EnumProperty s_propFORCE = new EnumProperty(41);

        SP_PrecedenceMaker(String sPropName) {
            super(sPropName);
        }

        public Property checkEnumValues(String value) {
            if (value.equals("force")) {
                return s_propFORCE;
            }
            return super.checkEnumValues(value);
        }
    }

    private static class SP_ConditionalityMaker
    extends EnumProperty.Maker
    implements Enums.Conditionality {
        protected static final EnumProperty s_propDISCARD = new EnumProperty(23);
        protected static final EnumProperty s_propRETAIN = new EnumProperty(95);

        SP_ConditionalityMaker(String sPropName) {
            super(sPropName);
        }

        public Property checkEnumValues(String value) {
            if (value.equals("discard")) {
                return s_propDISCARD;
            }
            if (value.equals("retain")) {
                return s_propRETAIN;
            }
            return super.checkEnumValues(value);
        }
    }
}

