/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.storage.common;

import java.io.File;
import java.util.List;
import org.apache.uniffle.common.util.ByteUnit;
import org.apache.uniffle.shaded.com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShuffleFileInfo {
    private static final Logger LOG = LoggerFactory.getLogger(ShuffleFileInfo.class);
    private final List<File> dataFiles = Lists.newLinkedList();
    private final List<File> indexFiles = Lists.newLinkedList();
    private final List<Integer> partitions = Lists.newLinkedList();
    private String key;
    private long size;

    public boolean isValid() {
        if (this.key == null || this.key.isEmpty()) {
            LOG.error("Shuffle key is null or empty");
            return false;
        }
        if (this.size <= 0L) {
            LOG.error("Total size of shuffle [{}]", (Object)this.key);
            return false;
        }
        if (this.dataFiles.isEmpty() || this.indexFiles.isEmpty() || this.partitions.isEmpty()) {
            LOG.error("Data files num {}, index files num {} and partition files num {} is invalid", new Object[]{this.dataFiles.size(), this.indexFiles.size(), this.partitions.size()});
            return false;
        }
        if (this.dataFiles.size() != this.indexFiles.size() || this.dataFiles.size() != this.partitions.size()) {
            LOG.error("Data files num {}, index files num {} and partition files num {} are not the same", new Object[]{this.dataFiles.size(), this.indexFiles.size(), this.partitions.size()});
            return false;
        }
        return true;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public List<File> getDataFiles() {
        return this.dataFiles;
    }

    public List<File> getIndexFiles() {
        return this.indexFiles;
    }

    public List<Integer> getPartitions() {
        return this.partitions;
    }

    public long getSize() {
        return this.size;
    }

    public boolean shouldCombine(long uploadCombineThresholdMB) {
        return ByteUnit.BYTE.toMiB(this.size / (long)this.dataFiles.size()) < uploadCombineThresholdMB;
    }

    public boolean isEmpty() {
        return this.dataFiles.isEmpty();
    }

    public String getKey() {
        return this.key;
    }
}

