/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common.storage;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.apache.uniffle.common.storage.StorageInfo;
import org.apache.uniffle.common.storage.StorageMedia;
import org.apache.uniffle.common.storage.StorageStatus;
import org.apache.uniffle.proto.RssProtos;

public class StorageInfoUtils {
    public static Map<String, RssProtos.StorageInfo> toProto(Map<String, StorageInfo> info) {
        HashMap result = Maps.newHashMapWithExpectedSize((int)info.size());
        info.forEach((k, v) -> result.put(k, v.toProto()));
        return result;
    }

    public static Map<String, StorageInfo> fromProto(Map<String, RssProtos.StorageInfo> info) {
        HashMap result = Maps.newHashMapWithExpectedSize((int)info.size());
        for (Map.Entry<String, RssProtos.StorageInfo> entry : info.entrySet()) {
            String key = entry.getKey();
            RssProtos.StorageInfo val = entry.getValue();
            StorageInfo storageInfo = new StorageInfo(val.getMountPoint(), StorageMedia.fromProto(val.getStorageMedia()), val.getCapacity(), val.getUsedBytes(), StorageStatus.fromProto(val.getStatus()));
            result.put(key, storageInfo);
        }
        return result;
    }
}

