/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.internal.util;

import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.uima.resource.ResourceManager;

public class Class_TCCL {
    public static <T> Class<T> forName(String className) throws ClassNotFoundException {
        return Class_TCCL.forName(className, null, true);
    }

    public static <T> Class<T> forName(String className, ResourceManager rm) throws ClassNotFoundException {
        return Class_TCCL.forName(className, rm, true);
    }

    public static <T> Class<T> forName(String className, ResourceManager rm, boolean resolve) throws ClassNotFoundException {
        ClassLoader tccl;
        ClassLoader excl;
        ArrayList<ClassLoader> clsTried = new ArrayList<ClassLoader>();
        ArrayList<ClassNotFoundException> suppressedExceptions = new ArrayList<ClassNotFoundException>();
        if (rm != null && (excl = rm.getExtensionClassLoader()) != null) {
            try {
                return Class.forName(className, resolve, excl);
            }
            catch (ClassNotFoundException e) {
                clsTried.add(excl);
                suppressedExceptions.add(e);
            }
        }
        if ((tccl = Thread.currentThread().getContextClassLoader()) != null) {
            try {
                return Class.forName(className, resolve, tccl);
            }
            catch (ClassNotFoundException e) {
                clsTried.add(tccl);
                suppressedExceptions.add(e);
            }
        }
        try {
            return Class.forName(className, resolve, Class_TCCL.class.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            clsTried.add(tccl);
            suppressedExceptions.add(e);
            e = new ClassNotFoundException("Class [" + className + "] not found in any of the accessible classloaders " + clsTried.stream().map(Objects::toString).collect(Collectors.joining(", ")));
            suppressedExceptions.forEach(e::addSuppressed);
            throw e;
        }
    }

    public static <T> Class<T> forName(String className, Map<String, Object> additionalParams) throws ClassNotFoundException {
        ResourceManager rm = additionalParams != null ? (ResourceManager)additionalParams.get("RESOURCE_MANAGER") : null;
        return Class_TCCL.forName(className, rm);
    }

    @Deprecated
    public static ClassLoader get_cl(ResourceManager rm) {
        ClassLoader cl;
        ClassLoader classLoader = cl = rm == null ? null : rm.getExtensionClassLoader();
        if (cl == null) {
            cl = Class_TCCL.get_parent_cl();
        }
        return cl;
    }

    @Deprecated
    public static ClassLoader get_parent_cl() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        return cl == null ? Class_TCCL.class.getClassLoader() : cl;
    }
}

