/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.trans;

import java.io.Serializable;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.SequenceIterable;
import net.sf.saxon.instruct.InstructionDetails;
import net.sf.saxon.instruct.Procedure;
import net.sf.saxon.instruct.SlotManager;
import net.sf.saxon.pattern.PatternFinder;
import net.sf.saxon.sort.StringCollator;
import net.sf.saxon.trace.InstructionInfo;
import net.sf.saxon.trace.InstructionInfoProvider;
import net.sf.saxon.type.BuiltInAtomicType;

public class KeyDefinition
extends Procedure
implements Serializable,
InstructionInfoProvider {
    private PatternFinder match;
    private SequenceIterable use;
    private BuiltInAtomicType useType;
    private StringCollator collation;
    private String collationName;
    private boolean backwardsCompatible = false;
    private boolean strictComparison = false;
    private boolean convertUntypedToOther = false;

    public KeyDefinition(PatternFinder patternFinder, SequenceIterable sequenceIterable, String string, StringCollator stringCollator) {
        this.setHostLanguage(50);
        this.match = patternFinder;
        this.use = sequenceIterable;
        if (sequenceIterable instanceof Expression) {
            this.setBody((Expression)sequenceIterable);
        }
        this.collation = stringCollator;
        this.collationName = string;
    }

    public void setIndexedItemType(BuiltInAtomicType builtInAtomicType) {
        this.useType = builtInAtomicType;
    }

    public BuiltInAtomicType getIndexedItemType() {
        if (this.useType == null) {
            return BuiltInAtomicType.ANY_ATOMIC;
        }
        return this.useType;
    }

    public void setBackwardsCompatible(boolean bl) {
        this.backwardsCompatible = bl;
    }

    public boolean isBackwardsCompatible() {
        return this.backwardsCompatible;
    }

    public void setStrictComparison(boolean bl) {
        this.strictComparison = bl;
    }

    public boolean isStrictComparison() {
        return this.strictComparison;
    }

    public void setConvertUntypedToOther(boolean bl) {
        this.convertUntypedToOther = bl;
    }

    public boolean isConvertUntypedToOther() {
        return this.convertUntypedToOther;
    }

    public void setStackFrameMap(SlotManager slotManager) {
        if (slotManager != null && slotManager.getNumberOfVariables() > 0) {
            super.setStackFrameMap(slotManager);
        }
    }

    public void setLocation(String string, int n) {
        this.setSystemId(string);
        this.setLineNumber(n);
    }

    public PatternFinder getMatch() {
        return this.match;
    }

    public SequenceIterable getUse() {
        return this.use;
    }

    public String getCollationName() {
        return this.collationName;
    }

    public StringCollator getCollation() {
        return this.collation;
    }

    public InstructionInfo getInstructionInfo() {
        InstructionDetails instructionDetails = new InstructionDetails();
        instructionDetails.setConstructType(154);
        instructionDetails.setSystemId(this.getSystemId());
        instructionDetails.setLineNumber(this.getLineNumber());
        instructionDetails.setProperty("key", this);
        return instructionDetails;
    }
}

