/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.UnaryExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.SequenceType;

public class NegateExpression
extends UnaryExpression {
    private boolean backwardsCompatible;

    public NegateExpression(Expression expression) {
        super(expression);
    }

    public void setBackwardsCompatible(boolean bl) {
        this.backwardsCompatible = bl;
    }

    public Expression typeCheck(StaticContext staticContext, ItemType itemType) throws XPathException {
        Expression expression = this.operand;
        RoleLocator roleLocator = new RoleLocator(9, "-", 0, null);
        roleLocator.setSourceLocator(this);
        this.operand = TypeChecker.staticTypeCheck(this.operand, SequenceType.OPTIONAL_NUMERIC, this.backwardsCompatible, roleLocator, staticContext);
        if (this.operand != expression) {
            this.adoptChildExpression(this.operand);
        }
        return this;
    }

    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        return this.operand.getItemType(typeHierarchy);
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        NumericValue numericValue = (NumericValue)this.operand.evaluateItem(xPathContext);
        if (numericValue == null) {
            return this.backwardsCompatible ? DoubleValue.NaN : null;
        }
        return numericValue.negate();
    }

    protected String displayOperator(Configuration configuration) {
        return "-";
    }
}

