/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.conceptMapper.support.tokens;

import java.util.HashSet;
import java.util.Set;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.annotator.AnnotatorConfigurationException;
import org.apache.uima.analysis_engine.annotator.AnnotatorContextException;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.conceptMapper.Logger;
import org.apache.uima.conceptMapper.support.dictionaryResource.DictionaryToken;
import org.apache.uima.conceptMapper.support.tokens.TokenNormalizer;
import org.apache.uima.conceptMapper.support.tokens.UnknownTypeException;

public class TokenFilter {
    private String tokenClassFeatureName;
    private Feature tokenClassFeature = null;
    private String tokenTypeFeatureName;
    private Feature tokenTypeFeature = null;
    private Logger logger;
    public static final String PARAM_INCLUDEDTOKENCLASSES = "IncludedTokenClasses";
    protected HashSet<String> includedTokenClasses;
    public static final String PARAM_EXCLUDEDTOKENCLASSES = "ExcludedTokenClasses";
    protected HashSet<String> excludedTokenClasses;
    public static final String PARAM_INCLUDEDTOKENTYPES = "IncludedTokenTypes";
    protected HashSet<Integer> includedTokenTypes;
    public static final String PARAM_EXCLUDEDTOKENTYPES = "ExcludedTokenTypes";
    protected HashSet<Integer> excludedTokenTypes;
    public static final String PARAM_STOPWORDS = "StopWords";
    private Set<String> stopWords = null;
    public static final String PARAM_TOKENANNOTATION = "TokenAnnotation";
    String tokenAnnotationName = null;

    public TokenFilter(String tokenAnnotationName, String tokenTypeFeatureName, String tokenClassFeatureName, Logger logger) {
        this.tokenAnnotationName = tokenAnnotationName;
        this.tokenTypeFeatureName = tokenTypeFeatureName;
        this.tokenClassFeatureName = tokenClassFeatureName;
        this.logger = logger;
    }

    public String getTokenClassFeatureName() {
        return this.tokenClassFeatureName;
    }

    public void setTokenClassFeatureName(String tokenClassFeatureName) {
        this.tokenClassFeatureName = tokenClassFeatureName;
    }

    public Feature getTokenClassFeature() {
        return this.tokenClassFeature;
    }

    public void setTokenClassFeature(Feature tokenClassFeature) {
        this.tokenClassFeature = tokenClassFeature;
    }

    public String getTokenTypeFeatureName() {
        return this.tokenTypeFeatureName;
    }

    public void setTokenTypeFeatureName(String tokenTypeFeatureName) {
        this.tokenTypeFeatureName = tokenTypeFeatureName;
    }

    public Feature getTokenTypeFeature() {
        return this.tokenTypeFeature;
    }

    public void setTokenTypeFeature(Feature tokenTypeFeature) {
        this.tokenTypeFeature = tokenTypeFeature;
    }

    public String getTokenAnnotationName() {
        return this.tokenAnnotationName;
    }

    public void setTokenAnnotationName(String tokenAnnotationName) {
        this.tokenAnnotationName = tokenAnnotationName;
    }

    public void initConfig(UimaContext uimaContext) throws AnnotatorConfigurationException {
        String[] stopWordList = null;
        String[] includedTokenClassStrings = null;
        String[] excludedTokenClassStrings = null;
        Integer[] includedTokenTypeInts = null;
        Integer[] excludedTokenTypeInts = null;
        try {
            int j;
            stopWordList = (String[])uimaContext.getConfigParameterValue(PARAM_STOPWORDS);
            includedTokenClassStrings = (String[])uimaContext.getConfigParameterValue(PARAM_INCLUDEDTOKENCLASSES);
            excludedTokenClassStrings = (String[])uimaContext.getConfigParameterValue(PARAM_EXCLUDEDTOKENCLASSES);
            includedTokenTypeInts = (Integer[])uimaContext.getConfigParameterValue(PARAM_INCLUDEDTOKENTYPES);
            excludedTokenTypeInts = (Integer[])uimaContext.getConfigParameterValue(PARAM_EXCLUDEDTOKENTYPES);
            if (includedTokenClassStrings == null || includedTokenClassStrings.length == 0) {
                this.includedTokenClasses = null;
            } else {
                this.includedTokenClasses = new HashSet();
                for (j = 0; j < includedTokenClassStrings.length; ++j) {
                    this.includedTokenClasses.add(includedTokenClassStrings[j]);
                }
            }
            if (excludedTokenClassStrings == null || excludedTokenClassStrings.length == 0) {
                this.excludedTokenClasses = null;
            } else {
                this.excludedTokenClasses = new HashSet();
                for (j = 0; j < excludedTokenClassStrings.length; ++j) {
                    this.excludedTokenClasses.add(excludedTokenClassStrings[j]);
                }
            }
            if (includedTokenTypeInts == null || includedTokenTypeInts.length == 0) {
                this.includedTokenTypes = null;
            } else {
                this.includedTokenTypes = new HashSet();
                for (j = 0; j < includedTokenTypeInts.length; ++j) {
                    this.includedTokenTypes.add(includedTokenTypeInts[j]);
                }
            }
            if (excludedTokenTypeInts == null || excludedTokenTypeInts.length == 0) {
                this.excludedTokenTypes = null;
            } else {
                this.excludedTokenTypes = new HashSet();
                for (j = 0; j < excludedTokenTypeInts.length; ++j) {
                    this.excludedTokenTypes.add(excludedTokenTypeInts[j]);
                }
            }
            if ((this.includedTokenClasses != null || this.excludedTokenClasses != null) && this.tokenClassFeatureName == null) {
                throw new AnnotatorConfigurationException();
            }
            if ((this.includedTokenTypes != null || this.excludedTokenTypes != null) && this.tokenTypeFeatureName == null) {
                throw new AnnotatorConfigurationException();
            }
            this.stopWords = TokenFilter.initializeStopWordList(stopWordList);
        }
        catch (AnnotatorContextException ie) {
            throw new AnnotatorConfigurationException((Throwable)ie);
        }
    }

    public static Set<String> initializeStopWordList(String[] stopWordsStrings) throws AnnotatorContextException {
        HashSet<String> retVal = new HashSet<String>();
        if (stopWordsStrings != null) {
            for (int i = 0; i < stopWordsStrings.length; ++i) {
                retVal.add(stopWordsStrings[i].toLowerCase());
            }
        }
        return retVal;
    }

    public boolean checkTokenClass(AnnotationFS token) {
        String tokenClass;
        boolean returnValue = true;
        if (this.tokenClassFeature != null && (tokenClass = token.getStringValue(this.tokenClassFeature)) != null) {
            returnValue = this.isOK_TokenClass(tokenClass);
        }
        return returnValue;
    }

    public boolean checkTokenClass(DictionaryToken token) {
        String tokenClass;
        boolean returnValue = true;
        if (token.isTokenClassFeatureDefined() && (tokenClass = token.getTokenClass()) != null) {
            returnValue = this.isOK_TokenClass(tokenClass);
        }
        return returnValue;
    }

    private boolean isOK_TokenClass(String tokenClass) {
        boolean returnValue = true;
        if (this.includedTokenClasses != null && this.excludedTokenClasses == null) {
            returnValue = this.includedTokenClasses.contains(tokenClass);
        } else if (this.excludedTokenClasses != null) {
            returnValue = !this.excludedTokenClasses.contains(tokenClass);
        }
        return returnValue;
    }

    public static boolean isStopWord(Set<String> stopWords, String tokenText) {
        return stopWords != null && stopWords.contains(tokenText.toLowerCase());
    }

    public boolean isStopWord(String tokenText) {
        return this.stopWords != null && this.stopWords.contains(tokenText.toLowerCase());
    }

    public boolean checkTokenType(AnnotationFS token) {
        Integer tokenType;
        boolean returnValue = true;
        if (this.tokenTypeFeature != null && (tokenType = Integer.valueOf(token.getIntValue(this.tokenTypeFeature))) != null) {
            returnValue = this.isOK_TokenType(tokenType);
        }
        return returnValue;
    }

    public boolean checkTokenType(DictionaryToken token) {
        Integer tokenType;
        boolean returnValue = true;
        if (token.isTokenTypeFeatureDefined() && (tokenType = token.getType()) != null) {
            returnValue = this.isOK_TokenType(tokenType);
        }
        return returnValue;
    }

    private boolean isOK_TokenType(Integer tokenType) {
        boolean returnValue = true;
        if (this.includedTokenTypes != null && this.excludedTokenTypes == null) {
            returnValue = this.includedTokenTypes.contains(tokenType);
        } else if (this.excludedTokenTypes != null) {
            returnValue = !this.excludedTokenTypes.contains(tokenType);
        }
        return returnValue;
    }

    public void initTypes(TypeSystem typeSystem) throws UnknownTypeException {
        this.initTypes(typeSystem, true);
    }

    public void initTypes(TypeSystem typeSystem, boolean requireFeatureExistence) throws UnknownTypeException {
        Type tokenType = typeSystem.getType(this.tokenAnnotationName);
        if (tokenType == null) {
            String message = "TokenFilter.initTypes(), Could not find type: " + this.tokenAnnotationName;
            System.err.println(message);
            throw new UnknownTypeException(message);
        }
        if (this.tokenClassFeatureName == null || this.tokenClassFeatureName.equals("")) {
            this.tokenClassFeature = null;
        } else {
            this.tokenClassFeature = tokenType.getFeatureByBaseName(this.tokenClassFeatureName);
            if (this.tokenClassFeature == null && requireFeatureExistence) {
                String message = "Token class feature name '" + this.tokenClassFeatureName + "' specified, but does not exist for type: " + tokenType.getName();
                this.logger.logError(message);
                throw new UnknownTypeException(message);
            }
        }
        if (this.tokenTypeFeatureName == null || this.tokenTypeFeatureName.equals("")) {
            this.tokenTypeFeature = null;
        } else {
            this.tokenTypeFeature = tokenType.getFeatureByBaseName(this.tokenTypeFeatureName);
            if (this.tokenTypeFeature == null && requireFeatureExistence) {
                String message = "Token type feature name '" + this.tokenTypeFeatureName + "' specified, but does not exist for type: " + tokenType.getName();
                this.logger.logError(message);
                throw new UnknownTypeException(message);
            }
        }
    }

    public boolean isOK_Token(AnnotationFS token, TokenNormalizer tokenNormalizer) {
        return this.checkTokenClass(token) && this.checkTokenType(token) && !this.isStopWord(tokenNormalizer.normalize(token.getCoveredText()));
    }

    public boolean isOK_Token(DictionaryToken token, TokenNormalizer tokenNormalizer) {
        return this.checkTokenClass(token) && this.checkTokenType(token) && !this.isStopWord(tokenNormalizer.normalize(token.getText()));
    }
}

