/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.ide.ui.text;

import java.util.ArrayList;
import java.util.Map;
import org.apache.uima.ruta.ide.core.packages.PackagesManager;
import org.apache.uima.ruta.ide.ui.text.RutaCorrectionAssistant;
import org.apache.uima.ruta.ide.ui.text.RutaRequirePackageMarkerResolution;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.core.CorrectionEngine;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.internal.ui.editor.ScriptEditor;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.ScriptRuntime;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.editor.IScriptAnnotation;
import org.eclipse.dltk.ui.text.MarkerResolutionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.quickassist.IQuickAssistInvocationContext;
import org.eclipse.jface.text.quickassist.IQuickAssistProcessor;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.eclipse.ui.texteditor.SimpleMarkerAnnotation;

public class RutaCorrectionProcessor
implements IQuickAssistProcessor {
    RutaCorrectionAssistant fAssistant;

    public RutaCorrectionProcessor(RutaCorrectionAssistant tclCorrectionAssistant) {
        this.fAssistant = tclCorrectionAssistant;
    }

    public boolean canAssist(IQuickAssistInvocationContext invocationContext) {
        return true;
    }

    public boolean canFix(Annotation annotation) {
        return RutaCorrectionProcessor.hasCorrections(annotation);
    }

    public ICompletionProposal[] computeQuickAssistProposals(IQuickAssistInvocationContext invocationContext) {
        Annotation[] annotations = this.fAssistant.getAnnotationsAtOffset();
        ScriptEditor editor = (ScriptEditor)this.fAssistant.getEditor();
        IAnnotationModel model = DLTKUIPlugin.getDocumentProvider().getAnnotationModel((Object)editor.getEditorInput());
        IModelElement element = editor.getInputModelElement();
        IScriptProject scriptProject = element.getScriptProject();
        ArrayList<MarkerResolutionProposal> proposals = null;
        for (int i = 0; i < annotations.length; ++i) {
            Annotation annotation = annotations[i];
            MarkerResolutionProposal proposal = null;
            if (annotation instanceof MarkerAnnotation) {
                MarkerAnnotation mAnnot = (MarkerAnnotation)annotation;
                IMarker marker = mAnnot.getMarker();
                if (RutaCorrectionProcessor.isFixable(marker)) {
                    String pkgName = CorrectionEngine.getProblemArguments((IMarker)marker)[0];
                    proposal = new MarkerResolutionProposal((IMarkerResolution)new RutaRequirePackageMarkerResolution(pkgName, scriptProject), marker);
                }
            } else if (!(annotation instanceof IScriptAnnotation) || RutaCorrectionProcessor.isFixable((IScriptAnnotation)annotation)) {
                // empty if block
            }
            if (proposal == null) continue;
            if (proposals == null) {
                proposals = new ArrayList<MarkerResolutionProposal>();
            }
            proposals.add(proposal);
        }
        if (proposals != null) {
            return proposals.toArray(new ICompletionProposal[proposals.size()]);
        }
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    public static boolean isQuickFixableType(Annotation annotation) {
        return (annotation instanceof IScriptAnnotation || annotation instanceof SimpleMarkerAnnotation) && !annotation.isMarkedDeleted();
    }

    public static boolean isFixable(IMarker marker) {
        IResource resource;
        IProject project;
        IScriptProject scriptProject;
        String[] args;
        return marker.getAttribute("id", 0) == 0x10000001 && (args = CorrectionEngine.getProblemArguments((IMarker)marker)) != null && args.length != 0 && args[0] != null && RutaCorrectionProcessor.isFixable(args[0], scriptProject = DLTKCore.create((IProject)(project = (resource = marker.getResource()).getProject())));
    }

    public static boolean isFixable(IScriptAnnotation annotation) {
        return false;
    }

    public static boolean isFixable(String pkgName, IScriptProject scriptProject) {
        IDLTKLanguageToolkit toolkit = null;
        toolkit = DLTKLanguageManager.getLanguageToolkit((IModelElement)scriptProject);
        if (toolkit != null && toolkit.getNatureId().equals("org.apache.uima.ruta.ide.nature")) {
            IInterpreterInstall install;
            block6: {
                install = null;
                try {
                    install = ScriptRuntime.getInterpreterInstall((IScriptProject)scriptProject);
                }
                catch (CoreException e) {
                    if (!DLTKCore.DEBUG) break block6;
                    e.printStackTrace();
                }
            }
            if (install != null) {
                PackagesManager manager = PackagesManager.getInstance();
                IPath[] paths = manager.getPathsForPackage(install, pkgName);
                if (paths != null && paths.length > 0) {
                    return true;
                }
                Map dependencies = manager.getDependencies(pkgName, install);
                for (String pkg : dependencies.keySet()) {
                    IPath[] paths2 = manager.getPathsForPackage(install, pkg);
                    if (paths2 == null || paths2.length <= 0) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean hasCorrections(Annotation annotation) {
        if (annotation instanceof MarkerAnnotation) {
            MarkerAnnotation mAnnot = (MarkerAnnotation)annotation;
            IMarker marker = mAnnot.getMarker();
            return RutaCorrectionProcessor.isFixable(marker);
        }
        if (annotation instanceof IScriptAnnotation) {
            return RutaCorrectionProcessor.isFixable((IScriptAnnotation)annotation);
        }
        return false;
    }
}

