/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.caseditor.editor.util;

import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.impl.LowLevelTypeSystem;

public class Primitives {
    public static Class<?> getPrimitiveClass(TypeSystem ts, Type type) {
        if (!type.isPrimitive()) {
            throw new IllegalArgumentException("Type " + type.getName() + " is not primitive!");
        }
        if (ts.getType("uima.cas.Boolean").equals((Object)type)) {
            return Boolean.class;
        }
        if (ts.getType("uima.cas.Byte").equals((Object)type)) {
            return Byte.class;
        }
        if (ts.getType("uima.cas.Short").equals((Object)type)) {
            return Short.class;
        }
        if (ts.getType("uima.cas.Integer").equals((Object)type)) {
            return Integer.class;
        }
        if (ts.getType("uima.cas.Long").equals((Object)type)) {
            return Long.class;
        }
        if (ts.getType("uima.cas.Float").equals((Object)type)) {
            return Float.class;
        }
        if (ts.getType("uima.cas.Double").equals((Object)type)) {
            return Double.class;
        }
        if (ts.getType("uima.cas.String").equals((Object)type) || ts.subsumes(ts.getType("uima.cas.String"), type)) {
            return String.class;
        }
        throw new IllegalStateException("Unexpected primitive type: " + type.getName());
    }

    public static Class<?> getPrimitiveClass(TypeSystem ts, Feature f) {
        return Primitives.getPrimitiveClass(ts, f.getRange());
    }

    public static Object getPrimitive(FeatureStructure structure, Feature feature) {
        Object result;
        TypeSystem ts = structure.getCAS().getTypeSystem();
        Class<?> primitiveClass = Primitives.getPrimitiveClass(ts, feature);
        if (Boolean.class.equals(primitiveClass)) {
            result = structure.getBooleanValue(feature);
        } else if (Byte.class.equals(primitiveClass)) {
            result = structure.getByteValue(feature);
        } else if (Short.class.equals(primitiveClass)) {
            result = structure.getShortValue(feature);
        } else if (Integer.class.equals(primitiveClass)) {
            result = structure.getIntValue(feature);
        } else if (Long.class.equals(primitiveClass)) {
            result = structure.getLongValue(feature);
        } else if (Float.class.equals(primitiveClass)) {
            result = Float.valueOf(structure.getFloatValue(feature));
        } else if (Double.class.equals(primitiveClass)) {
            result = structure.getDoubleValue(feature);
        } else if (String.class.equals(primitiveClass)) {
            result = structure.getStringValue(feature);
            if (result == null) {
                result = "";
            }
        } else {
            throw new IllegalStateException("Unexpected type: " + feature.getRange().getName());
        }
        return result;
    }

    public static boolean isRestrictedByAllowedValues(TypeSystem ts, Type type) {
        if (ts.getType("uima.cas.String").equals((Object)type) || ts.subsumes(ts.getType("uima.cas.String"), type)) {
            int typeCode;
            LowLevelTypeSystem lts = ts.getLowLevelTypeSystem();
            String[] strings = lts.ll_getStringSet(typeCode = lts.ll_getCodeForType(type));
            return strings.length > 0;
        }
        return false;
    }

    public static String[] getRestrictedValues(TypeSystem ts, Type type) {
        if (Primitives.isRestrictedByAllowedValues(ts, type)) {
            throw new IllegalArgumentException("Type " + type.getName() + " does not defines allowed values!");
        }
        LowLevelTypeSystem lts = ts.getLowLevelTypeSystem();
        int typeCode = lts.ll_getCodeForType(type);
        return lts.ll_getStringSet(typeCode);
    }
}

