/*
 * Decompiled with CFR 0.152.
 */
package io.churchkey.pem;

import io.churchkey.Key;
import io.churchkey.asn1.Asn1Object;
import io.churchkey.asn1.Asn1Type;
import io.churchkey.asn1.DerParser;
import io.churchkey.asn1.Oid;
import io.churchkey.ec.Curve;
import io.churchkey.ec.EcPoints;
import io.churchkey.ec.Ecdsa;
import io.churchkey.pem.EcCurveParams;
import io.churchkey.util.Bytes;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECPoint;

public class BeginEcPrivateKey {
    private BeginEcPrivateKey() {
    }

    public static Key decode(byte[] bytes) {
        try {
            Ecdsa.Private.Builder ec = Ecdsa.Private.builder();
            DerParser d1 = new DerParser(bytes);
            Asn1Object d1o1 = d1.readObject().assertType(Asn1Type.SEQUENCE);
            DerParser d2 = new DerParser(d1o1.getValue());
            Asn1Object d2o1 = d2.readObject().assertType(Asn1Type.INTEGER);
            Asn1Object d2o2 = d2.readObject().assertType(Asn1Type.OCTET_STRING);
            Asn1Object d2o3 = d2.readObject().assertType(Asn1Type.ANY);
            DerParser d3 = new DerParser(d2o3.getValue());
            Asn1Object d3o1 = d3.readObject();
            if (d3o1.isType(Asn1Type.OBJECT_IDENTIFIER)) {
                Oid oid = d3o1.asOID();
                Curve curve = Curve.resolve(oid);
                ec.curve(curve);
            } else if (d3o1.isType(Asn1Type.SEQUENCE)) {
                ec.spec(EcCurveParams.parseSequence(d3o1));
            }
            ec.d(d2o2.toInteger());
            Asn1Object d2o4 = d2.readObject();
            if (d2o4 != null && d2o4.isType(Asn1Type.BOOLEAN)) {
                DerParser d32 = new DerParser(d2o4.getValue());
                Asn1Object d3o12 = d32.readObject().assertType(Asn1Type.BIT_STRING);
                byte[] value = Bytes.trim(d3o12.getValue());
                ECPoint ecPoint = EcPoints.fromBytes(value);
                ec.x(ecPoint.getAffineX());
                ec.y(ecPoint.getAffineY());
            }
            Ecdsa.Private build = ec.build();
            ECPrivateKey privateKey = build.toKey();
            ECPublicKey publicKey = build.getX() != null && build.getY() != null ? build.toPublic().toKey() : null;
            return new Key((java.security.Key)privateKey, publicKey, Key.Type.PRIVATE, Key.Algorithm.EC, Key.Format.PEM);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

