/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.library.vertexmanager;

import com.google.common.collect.Lists;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.tez.common.Preconditions;
import org.apache.tez.common.TezUtils;
import org.apache.tez.dag.api.EdgeManagerPluginContext;
import org.apache.tez.dag.api.EdgeManagerPluginDescriptor;
import org.apache.tez.dag.api.EdgeManagerPluginOnDemand;
import org.apache.tez.dag.api.TezUncheckedException;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.dag.api.VertexManagerPluginContext;
import org.apache.tez.dag.api.VertexManagerPluginDescriptor;
import org.apache.tez.dag.library.vertexmanager.ShuffleVertexManagerBase;
import org.apache.tez.runtime.api.TaskAttemptIdentifier;
import org.apache.tez.runtime.api.events.DataMovementEvent;
import org.apache.tez.runtime.api.events.InputReadErrorEvent;
import org.apache.tez.runtime.library.shuffle.impl.ShuffleUserPayloads;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class ShuffleVertexManager
extends ShuffleVertexManagerBase {
    private static final Logger LOG = LoggerFactory.getLogger(ShuffleVertexManager.class);
    public static final String TEZ_SHUFFLE_VERTEX_MANAGER_DESIRED_TASK_INPUT_SIZE = "tez.shuffle-vertex-manager.desired-task-input-size";
    public static final long TEZ_SHUFFLE_VERTEX_MANAGER_DESIRED_TASK_INPUT_SIZE_DEFAULT = 100L * MB;
    public static final String TEZ_SHUFFLE_VERTEX_MANAGER_ENABLE_AUTO_PARALLEL = "tez.shuffle-vertex-manager.enable.auto-parallel";
    public static final boolean TEZ_SHUFFLE_VERTEX_MANAGER_ENABLE_AUTO_PARALLEL_DEFAULT = false;
    public static final String TEZ_SHUFFLE_VERTEX_MANAGER_MIN_TASK_PARALLELISM = "tez.shuffle-vertex-manager.min-task-parallelism";
    public static final int TEZ_SHUFFLE_VERTEX_MANAGER_MIN_TASK_PARALLELISM_DEFAULT = 1;
    public static final String TEZ_SHUFFLE_VERTEX_MANAGER_MIN_SRC_FRACTION = "tez.shuffle-vertex-manager.min-src-fraction";
    public static final float TEZ_SHUFFLE_VERTEX_MANAGER_MIN_SRC_FRACTION_DEFAULT = 0.25f;
    public static final String TEZ_SHUFFLE_VERTEX_MANAGER_MAX_SRC_FRACTION = "tez.shuffle-vertex-manager.max-src-fraction";
    public static final float TEZ_SHUFFLE_VERTEX_MANAGER_MAX_SRC_FRACTION_DEFAULT = 0.75f;
    ShuffleVertexManagerConfig mgrConfig;
    private int[][] targetIndexes;
    private int basePartitionRange;
    private int remainderRangeForLastShuffler;

    public ShuffleVertexManager(VertexManagerPluginContext context) {
        super(context);
    }

    @Override
    ShuffleVertexManagerBase.ShuffleVertexManagerBaseConfig initConfiguration() {
        float slowStartMinFraction = this.conf.getFloat(TEZ_SHUFFLE_VERTEX_MANAGER_MIN_SRC_FRACTION, 0.25f);
        this.mgrConfig = new ShuffleVertexManagerConfig(this.conf.getBoolean(TEZ_SHUFFLE_VERTEX_MANAGER_ENABLE_AUTO_PARALLEL, false), this.conf.getLong(TEZ_SHUFFLE_VERTEX_MANAGER_DESIRED_TASK_INPUT_SIZE, TEZ_SHUFFLE_VERTEX_MANAGER_DESIRED_TASK_INPUT_SIZE_DEFAULT), slowStartMinFraction, this.conf.getFloat(TEZ_SHUFFLE_VERTEX_MANAGER_MAX_SRC_FRACTION, Math.max(slowStartMinFraction, 0.75f)), Math.max(1, this.conf.getInt(TEZ_SHUFFLE_VERTEX_MANAGER_MIN_TASK_PARALLELISM, 1)));
        return this.mgrConfig;
    }

    static int[] createIndices(int partitionRange, int taskIndex, int offSetPerTask) {
        int startIndex = taskIndex * offSetPerTask;
        int[] indices = new int[partitionRange];
        for (int currentIndex = 0; currentIndex < partitionRange; ++currentIndex) {
            indices[currentIndex] = startIndex + currentIndex;
        }
        return indices;
    }

    @Override
    ShuffleVertexManagerBase.ReconfigVertexParams computeRouting() {
        int currentParallelism = this.pendingTasks.size();
        BigInteger expectedTotalSourceTasksOutputSize = this.getExpectedTotalBipartiteSourceTasksOutputSize();
        LOG.info("Expected output: {} based on actual output: {} from {} vertex manager events. desiredTaskInputSize: {} max slow start tasks: {}  num sources completed: {}", new Object[]{expectedTotalSourceTasksOutputSize, this.completedSourceTasksOutputSize, this.numVertexManagerEventsReceived, this.config.getDesiredTaskInputDataSize(), Float.valueOf((float)this.totalNumBipartiteSourceTasks * this.config.getMaxFraction()), this.numBipartiteSourceTasksCompleted});
        BigInteger desiredTaskInputDataSize = BigInteger.valueOf(this.config.getDesiredTaskInputDataSize());
        BigInteger desiredTaskInputDataSizeMinusOne = BigInteger.valueOf(this.config.getDesiredTaskInputDataSize() - 1L);
        BigInteger bigDesiredTaskParallelism = expectedTotalSourceTasksOutputSize.add(desiredTaskInputDataSizeMinusOne).divide(desiredTaskInputDataSize);
        if (bigDesiredTaskParallelism.compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) > 0) {
            LOG.info("Not reducing auto parallelism for vertex: {} since the desired parallelism of {} is greater than or equal to the max parallelism of {}", new Object[]{this.getContext().getVertexName(), bigDesiredTaskParallelism, Integer.MAX_VALUE});
            return null;
        }
        int desiredTaskParallelism = bigDesiredTaskParallelism.intValue();
        if (desiredTaskParallelism < this.mgrConfig.getMinTaskParallelism()) {
            desiredTaskParallelism = this.mgrConfig.getMinTaskParallelism();
        }
        if (desiredTaskParallelism >= currentParallelism) {
            LOG.info("Not reducing auto parallelism for vertex: {} since the desired parallelism of {} is greater than or equal to the current parallelism of {}", new Object[]{this.getContext().getVertexName(), desiredTaskParallelism, this.pendingTasks.size()});
            return null;
        }
        this.basePartitionRange = currentParallelism / desiredTaskParallelism;
        if (this.basePartitionRange <= 1) {
            LOG.info("Not reducing auto parallelism for vertex: {} by less than half since combining two inputs will potentially break the desired task input size of {}", (Object)this.getContext().getVertexName(), (Object)this.config.getDesiredTaskInputDataSize());
            return null;
        }
        int numShufflersWithBaseRange = currentParallelism / this.basePartitionRange;
        this.remainderRangeForLastShuffler = currentParallelism % this.basePartitionRange;
        int finalTaskParallelism = this.remainderRangeForLastShuffler > 0 ? numShufflersWithBaseRange + 1 : numShufflersWithBaseRange;
        LOG.info("Reducing auto parallelism for vertex: {} from {} to {}", new Object[]{this.getContext().getVertexName(), this.pendingTasks.size(), finalTaskParallelism});
        if (finalTaskParallelism >= currentParallelism) {
            return null;
        }
        CustomShuffleEdgeManagerConfig edgeManagerConfig = new CustomShuffleEdgeManagerConfig(currentParallelism, finalTaskParallelism, this.basePartitionRange, this.remainderRangeForLastShuffler > 0 ? this.remainderRangeForLastShuffler : this.basePartitionRange);
        EdgeManagerPluginDescriptor descriptor = EdgeManagerPluginDescriptor.create((String)CustomShuffleEdgeManager.class.getName());
        descriptor.setUserPayload(edgeManagerConfig.toUserPayload());
        Iterable<Map.Entry<String, ShuffleVertexManagerBase.SourceVertexInfo>> bipartiteItr = this.getBipartiteInfo();
        for (Map.Entry<String, ShuffleVertexManagerBase.SourceVertexInfo> entry : bipartiteItr) {
            entry.getValue().newDescriptor = descriptor;
        }
        ShuffleVertexManagerBase.ReconfigVertexParams params = new ShuffleVertexManagerBase.ReconfigVertexParams(finalTaskParallelism, null);
        return params;
    }

    @Override
    void postReconfigVertex() {
        this.configureTargetMapping(this.pendingTasks.size());
    }

    private void configureTargetMapping(int tasks) {
        this.targetIndexes = new int[tasks][];
        for (int idx = 0; idx < tasks; ++idx) {
            int partitionRange = this.basePartitionRange;
            if (idx == tasks - 1) {
                partitionRange = this.remainderRangeForLastShuffler > 0 ? this.remainderRangeForLastShuffler : this.basePartitionRange;
            }
            this.targetIndexes[idx] = ShuffleVertexManager.createIndices(partitionRange, idx, this.basePartitionRange);
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("targetIdx[{}] to {}", (Object)idx, (Object)Arrays.toString(this.targetIndexes[idx]));
        }
    }

    @Override
    List<VertexManagerPluginContext.ScheduleTaskRequest> getTasksToSchedule(TaskAttemptIdentifier completedSourceAttempt) {
        float minSourceVertexCompletedTaskFraction = this.getMinSourceVertexCompletedTaskFraction();
        int numTasksToSchedule = this.getNumOfTasksToScheduleAndLog(minSourceVertexCompletedTaskFraction);
        if (numTasksToSchedule > 0) {
            ArrayList tasksToSchedule = Lists.newArrayListWithCapacity((int)numTasksToSchedule);
            while (!this.pendingTasks.isEmpty() && numTasksToSchedule > 0) {
                --numTasksToSchedule;
                Integer taskIndex = ((ShuffleVertexManagerBase.PendingTaskInfo)this.pendingTasks.get(0)).getIndex();
                tasksToSchedule.add(VertexManagerPluginContext.ScheduleTaskRequest.create((int)taskIndex, null));
                this.pendingTasks.remove(0);
            }
            return tasksToSchedule;
        }
        return null;
    }

    @Override
    void processPendingTasks() {
        if (this.totalNumBipartiteSourceTasks > 0) {
            this.sortPendingTasksBasedOnDataSize();
        }
    }

    private void sortPendingTasksBasedOnDataSize() {
        boolean statsUpdated = this.computePartitionSizes();
        if (statsUpdated) {
            Collections.sort(this.pendingTasks, new Comparator<ShuffleVertexManagerBase.PendingTaskInfo>(){

                @Override
                public int compare(ShuffleVertexManagerBase.PendingTaskInfo left, ShuffleVertexManagerBase.PendingTaskInfo right) {
                    return left.getInputStats() > right.getInputStats() ? -1 : (left.getInputStats() == right.getInputStats() ? 0 : 1);
                }
            });
            if (LOG.isDebugEnabled()) {
                for (ShuffleVertexManagerBase.PendingTaskInfo pendingTask : this.pendingTasks) {
                    LOG.debug("Pending task: {}", (Object)pendingTask.toString());
                }
            }
        }
    }

    private boolean computePartitionSizes() {
        boolean computedPartitionSizes = false;
        for (ShuffleVertexManagerBase.PendingTaskInfo taskInfo : this.pendingTasks) {
            int index = taskInfo.getIndex();
            if (this.targetIndexes != null) {
                Preconditions.checkState((index < this.targetIndexes.length ? 1 : 0) != 0, (Object)("index=" + index + ", targetIndexes length=" + this.targetIndexes.length));
                int[] mapping = this.targetIndexes[index];
                int partitionStats = 0;
                for (int i : mapping) {
                    partitionStats += this.getCurrentlyKnownStatsAtIndex(i);
                }
                computedPartitionSizes |= taskInfo.setInputStats(partitionStats);
                continue;
            }
            computedPartitionSizes |= taskInfo.setInputStats(this.getCurrentlyKnownStatsAtIndex(index));
        }
        return computedPartitionSizes;
    }

    public static ShuffleVertexManagerConfigBuilder createConfigBuilder(@Nullable Configuration conf) {
        return new ShuffleVertexManagerConfigBuilder(conf);
    }

    public static final class ShuffleVertexManagerConfigBuilder {
        private final Configuration conf;

        private ShuffleVertexManagerConfigBuilder(@Nullable Configuration conf) {
            this.conf = conf == null ? new Configuration(false) : conf;
        }

        public ShuffleVertexManagerConfigBuilder setAutoReduceParallelism(boolean enabled) {
            this.conf.setBoolean(ShuffleVertexManager.TEZ_SHUFFLE_VERTEX_MANAGER_ENABLE_AUTO_PARALLEL, enabled);
            return this;
        }

        public ShuffleVertexManagerConfigBuilder setSlowStartMinSrcCompletionFraction(float minFraction) {
            this.conf.setFloat(ShuffleVertexManager.TEZ_SHUFFLE_VERTEX_MANAGER_MIN_SRC_FRACTION, minFraction);
            return this;
        }

        public ShuffleVertexManagerConfigBuilder setSlowStartMaxSrcCompletionFraction(float maxFraction) {
            this.conf.setFloat(ShuffleVertexManager.TEZ_SHUFFLE_VERTEX_MANAGER_MAX_SRC_FRACTION, maxFraction);
            return this;
        }

        public ShuffleVertexManagerConfigBuilder setDesiredTaskInputSize(long desiredTaskInputSize) {
            this.conf.setLong(ShuffleVertexManager.TEZ_SHUFFLE_VERTEX_MANAGER_DESIRED_TASK_INPUT_SIZE, desiredTaskInputSize);
            return this;
        }

        public ShuffleVertexManagerConfigBuilder setMinTaskParallelism(int minTaskParallelism) {
            this.conf.setInt(ShuffleVertexManager.TEZ_SHUFFLE_VERTEX_MANAGER_MIN_TASK_PARALLELISM, minTaskParallelism);
            return this;
        }

        public VertexManagerPluginDescriptor build() {
            VertexManagerPluginDescriptor desc = VertexManagerPluginDescriptor.create((String)ShuffleVertexManager.class.getName());
            try {
                return (VertexManagerPluginDescriptor)desc.setUserPayload(TezUtils.createUserPayloadFromConf((Configuration)this.conf));
            }
            catch (IOException e) {
                throw new TezUncheckedException((Throwable)e);
            }
        }
    }

    private static class CustomShuffleEdgeManagerConfig {
        int numSourceTaskOutputs;
        int numDestinationTasks;
        int basePartitionRange;
        int remainderRangeForLastShuffler;

        private CustomShuffleEdgeManagerConfig(int numSourceTaskOutputs, int numDestinationTasks, int basePartitionRange, int remainderRangeForLastShuffler) {
            this.numSourceTaskOutputs = numSourceTaskOutputs;
            this.numDestinationTasks = numDestinationTasks;
            this.basePartitionRange = basePartitionRange;
            this.remainderRangeForLastShuffler = remainderRangeForLastShuffler;
        }

        public UserPayload toUserPayload() {
            return UserPayload.create((ByteBuffer)ByteBuffer.wrap(ShuffleUserPayloads.ShuffleEdgeManagerConfigPayloadProto.newBuilder().setNumSourceTaskOutputs(this.numSourceTaskOutputs).setNumDestinationTasks(this.numDestinationTasks).setBasePartitionRange(this.basePartitionRange).setRemainderRangeForLastShuffler(this.remainderRangeForLastShuffler).build().toByteArray()));
        }

        public static CustomShuffleEdgeManagerConfig fromUserPayload(UserPayload payload) throws InvalidProtocolBufferException {
            ShuffleUserPayloads.ShuffleEdgeManagerConfigPayloadProto proto = ShuffleUserPayloads.ShuffleEdgeManagerConfigPayloadProto.parseFrom(ByteString.copyFrom((ByteBuffer)payload.getPayload()));
            return new CustomShuffleEdgeManagerConfig(proto.getNumSourceTaskOutputs(), proto.getNumDestinationTasks(), proto.getBasePartitionRange(), proto.getRemainderRangeForLastShuffler());
        }
    }

    public static class CustomShuffleEdgeManager
    extends EdgeManagerPluginOnDemand {
        int numSourceTaskOutputs;
        int numDestinationTasks;
        int basePartitionRange;
        int remainderRangeForLastShuffler;
        int numSourceTasks;
        int[][] sourceIndices;
        int[][] targetIndices;

        public CustomShuffleEdgeManager(EdgeManagerPluginContext context) {
            super(context);
        }

        public void initialize() {
            CustomShuffleEdgeManagerConfig config;
            UserPayload userPayload = this.getContext().getUserPayload();
            if (userPayload == null || userPayload.getPayload() == null || userPayload.getPayload().limit() == 0) {
                throw new RuntimeException("Could not initialize CustomShuffleEdgeManager from provided user payload");
            }
            try {
                config = CustomShuffleEdgeManagerConfig.fromUserPayload(userPayload);
            }
            catch (InvalidProtocolBufferException e) {
                throw new RuntimeException("Could not initialize CustomShuffleEdgeManager from provided user payload", e);
            }
            this.numSourceTaskOutputs = config.numSourceTaskOutputs;
            this.numDestinationTasks = config.numDestinationTasks;
            this.basePartitionRange = config.basePartitionRange;
            this.remainderRangeForLastShuffler = config.remainderRangeForLastShuffler;
            this.numSourceTasks = this.getContext().getSourceVertexNumTasks();
            Preconditions.checkState((this.numDestinationTasks == this.getContext().getDestinationVertexNumTasks() ? 1 : 0) != 0);
        }

        public int getNumDestinationTaskPhysicalInputs(int destinationTaskIndex) {
            int partitionRange = 1;
            partitionRange = destinationTaskIndex < this.numDestinationTasks - 1 ? this.basePartitionRange : this.remainderRangeForLastShuffler;
            return this.numSourceTasks * partitionRange;
        }

        public int getNumSourceTaskPhysicalOutputs(int sourceTaskIndex) {
            return this.numSourceTaskOutputs;
        }

        public void routeDataMovementEventToDestination(DataMovementEvent event, int sourceTaskIndex, int sourceOutputIndex, Map<Integer, List<Integer>> destinationTaskAndInputIndices) {
            int sourceIndex = event.getSourceIndex();
            int destinationTaskIndex = sourceIndex / this.basePartitionRange;
            int partitionRange = 1;
            partitionRange = destinationTaskIndex < this.numDestinationTasks - 1 ? this.basePartitionRange : this.remainderRangeForLastShuffler;
            int targetIndex = sourceTaskIndex * partitionRange + sourceIndex % partitionRange;
            destinationTaskAndInputIndices.put(destinationTaskIndex, Collections.singletonList(targetIndex));
        }

        public EdgeManagerPluginOnDemand.EventRouteMetadata routeDataMovementEventToDestination(int sourceTaskIndex, int sourceOutputIndex, int destTaskIndex) throws Exception {
            int sourceIndex = sourceOutputIndex;
            int destinationTaskIndex = sourceIndex / this.basePartitionRange;
            if (destinationTaskIndex != destTaskIndex) {
                return null;
            }
            int partitionRange = 1;
            partitionRange = destinationTaskIndex < this.numDestinationTasks - 1 ? this.basePartitionRange : this.remainderRangeForLastShuffler;
            int targetIndex = sourceTaskIndex * partitionRange + sourceIndex % partitionRange;
            return EdgeManagerPluginOnDemand.EventRouteMetadata.create((int)1, (int[])new int[]{targetIndex});
        }

        public void prepareForRouting() throws Exception {
            int numSourceTasks = this.getContext().getSourceVertexNumTasks();
            this.targetIndices = new int[numSourceTasks][];
            for (int srcTaskIndex = 0; srcTaskIndex < numSourceTasks; ++srcTaskIndex) {
                this.targetIndices[srcTaskIndex] = ShuffleVertexManager.createIndices(this.basePartitionRange, srcTaskIndex, this.basePartitionRange);
            }
            int numTargetTasks = this.getContext().getDestinationVertexNumTasks();
            this.sourceIndices = new int[numTargetTasks][];
            for (int destTaskIndex = 0; destTaskIndex < numTargetTasks; ++destTaskIndex) {
                int partitionRange = this.basePartitionRange;
                if (destTaskIndex == numTargetTasks - 1) {
                    partitionRange = this.remainderRangeForLastShuffler;
                }
                this.sourceIndices[destTaskIndex] = ShuffleVertexManager.createIndices(partitionRange, destTaskIndex, this.basePartitionRange);
            }
        }

        private int[] createTargetIndicesForRemainder(int srcTaskIndex) {
            return ShuffleVertexManager.createIndices(this.remainderRangeForLastShuffler, srcTaskIndex, this.remainderRangeForLastShuffler);
        }

        @Nullable
        public EdgeManagerPluginOnDemand.CompositeEventRouteMetadata routeCompositeDataMovementEventToDestination(int sourceTaskIndex, int destinationTaskIndex) throws Exception {
            int partitionRange;
            int[] targetIndicesToSend;
            if (destinationTaskIndex == this.numDestinationTasks - 1) {
                targetIndicesToSend = this.remainderRangeForLastShuffler != this.basePartitionRange ? this.createTargetIndicesForRemainder(sourceTaskIndex) : this.targetIndices[sourceTaskIndex];
                partitionRange = this.remainderRangeForLastShuffler;
            } else {
                targetIndicesToSend = this.targetIndices[sourceTaskIndex];
                partitionRange = this.basePartitionRange;
            }
            return EdgeManagerPluginOnDemand.CompositeEventRouteMetadata.create((int)partitionRange, (int)targetIndicesToSend[0], (int)this.sourceIndices[destinationTaskIndex][0]);
        }

        public EdgeManagerPluginOnDemand.EventRouteMetadata routeInputSourceTaskFailedEventToDestination(int sourceTaskIndex, int destinationTaskIndex) throws Exception {
            int partitionRange = this.basePartitionRange;
            if (destinationTaskIndex == this.numDestinationTasks - 1) {
                partitionRange = this.remainderRangeForLastShuffler;
            }
            int startOffset = sourceTaskIndex * partitionRange;
            int[] targetIndices = new int[partitionRange];
            for (int i = 0; i < partitionRange; ++i) {
                targetIndices[i] = startOffset + i;
            }
            return EdgeManagerPluginOnDemand.EventRouteMetadata.create((int)partitionRange, (int[])targetIndices);
        }

        public void routeInputSourceTaskFailedEventToDestination(int sourceTaskIndex, Map<Integer, List<Integer>> destinationTaskAndInputIndices) {
            if (this.remainderRangeForLastShuffler < this.basePartitionRange) {
                int i;
                int startOffset = sourceTaskIndex * this.basePartitionRange;
                ArrayList allIndices = Lists.newArrayListWithCapacity((int)this.basePartitionRange);
                for (int i2 = 0; i2 < this.basePartitionRange; ++i2) {
                    allIndices.add(startOffset + i2);
                }
                List inputIndices = Collections.unmodifiableList(allIndices);
                for (i = 0; i < this.numDestinationTasks - 1; ++i) {
                    destinationTaskAndInputIndices.put(i, inputIndices);
                }
                startOffset = sourceTaskIndex * this.remainderRangeForLastShuffler;
                allIndices = Lists.newArrayListWithCapacity((int)this.remainderRangeForLastShuffler);
                for (i = 0; i < this.remainderRangeForLastShuffler; ++i) {
                    allIndices.add(startOffset + i);
                }
                inputIndices = Collections.unmodifiableList(allIndices);
                destinationTaskAndInputIndices.put(this.numDestinationTasks - 1, inputIndices);
            } else {
                int startOffset = sourceTaskIndex * this.basePartitionRange;
                ArrayList allIndices = Lists.newArrayListWithCapacity((int)this.basePartitionRange);
                for (int i = 0; i < this.basePartitionRange; ++i) {
                    allIndices.add(startOffset + i);
                }
                List inputIndices = Collections.unmodifiableList(allIndices);
                for (int i = 0; i < this.numDestinationTasks; ++i) {
                    destinationTaskAndInputIndices.put(i, inputIndices);
                }
            }
        }

        public int routeInputErrorEventToSource(InputReadErrorEvent event, int destinationTaskIndex, int destinationFailedInputIndex) {
            int partitionRange = 1;
            partitionRange = destinationTaskIndex < this.numDestinationTasks - 1 ? this.basePartitionRange : this.remainderRangeForLastShuffler;
            return destinationFailedInputIndex / partitionRange;
        }

        public int routeInputErrorEventToSource(int destinationTaskIndex, int destinationFailedInputIndex) {
            int partitionRange = 1;
            partitionRange = destinationTaskIndex < this.numDestinationTasks - 1 ? this.basePartitionRange : this.remainderRangeForLastShuffler;
            return destinationFailedInputIndex / partitionRange;
        }

        public int getNumDestinationConsumerTasks(int sourceTaskIndex) {
            return this.numDestinationTasks;
        }
    }

    static class ShuffleVertexManagerConfig
    extends ShuffleVertexManagerBase.ShuffleVertexManagerBaseConfig {
        final int minTaskParallelism;

        public ShuffleVertexManagerConfig(boolean enableAutoParallelism, long desiredTaskInputDataSize, float slowStartMinFraction, float slowStartMaxFraction, int minTaskParallelism) {
            super(enableAutoParallelism, desiredTaskInputDataSize, slowStartMinFraction, slowStartMaxFraction);
            this.minTaskParallelism = minTaskParallelism;
            LOG.info("minTaskParallelism {}", (Object)this.minTaskParallelism);
        }

        int getMinTaskParallelism() {
            return this.minTaskParallelism;
        }
    }
}

